/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.interact.rule;

import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Samples
implements Iterable<Map<String, Object>>,
Iterator<Map<String, Object>> {
    private final Map<String, Set<Object>> columnEnumerates;
    private final String[] subColums;
    private final Set<String> subColumSet;
    private Map<String, Object> currentCartesianSample;
    private Iterator<Object>[] iterators;
    private int cursor;
    private static SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
    private static char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static Map<Character, Integer> rDigits = new HashMap<Character, Integer>(16);

    public Samples(Map<String, Set<Object>> columnEnumerates) {
        this.columnEnumerates = columnEnumerates;
        this.subColums = columnEnumerates.keySet().toArray(new String[columnEnumerates.size()]);
        this.subColumSet = columnEnumerates.keySet();
    }

    public Samples(Map<String, Set<Object>> columnEnumerates, String[] subColumns) {
        this.columnEnumerates = columnEnumerates;
        this.subColums = subColumns;
        this.subColumSet = new HashSet<String>();
        this.subColumSet.addAll(Arrays.asList(subColumns));
        if (this.subColumSet.size() != this.subColums.length) {
            throw new IllegalArgumentException(Arrays.toString(subColumns) + " has duplicate columm");
        }
    }

    public Samples(Set<String> columnNames) {
        this.columnEnumerates = new HashMap<String, Set<Object>>();
        for (String name : columnNames) {
            this.columnEnumerates.put(name, new HashSet(1));
        }
        this.subColums = columnNames.toArray(new String[this.columnEnumerates.size()]);
        this.subColumSet = Collections.unmodifiableSet(columnNames);
    }

    public Samples subSamples(String[] columns) {
        if (columns.length == this.subColums.length) {
            return this;
        }
        return new Samples(this.columnEnumerates, columns);
    }

    public Map<String, Set<Object>> getColumnEnumerates() {
        if (this.columnEnumerates.size() == this.subColums.length) {
            return this.columnEnumerates;
        }
        HashMap<String, Set<Object>> res = new HashMap<String, Set<Object>>(this.subColums.length);
        for (String column : this.subColums) {
            res.put(column, this.columnEnumerates.get(column));
        }
        return res;
    }

    public int size() {
        return this.subColums.length;
    }

    public void addEnumerates(String name, Set<Object> values) {
        if (!this.columnEnumerates.containsKey(name)) {
            throw new IllegalArgumentException(Arrays.toString(this.subColums) + ", Samples not contain key:" + name);
        }
        this.columnEnumerates.get(name).addAll(values);
    }

    public void addSample(Map<String, Object> aCartesianSample) {
        for (Map.Entry<String, Object> e : aCartesianSample.entrySet()) {
            this.columnEnumerates.get(e.getKey()).add(e.getValue());
        }
    }

    @Override
    public Iterator<Map<String, Object>> iterator() {
        this.currentCartesianSample = new HashMap<String, Object>(this.subColums.length);
        this.iterators = new Iterator[this.subColums.length];
        this.cursor = 0;
        int i = 0;
        for (String name : this.subColums) {
            this.iterators[i++] = this.columnEnumerates.get(name).iterator();
        }
        return this;
    }

    @Override
    public boolean hasNext() {
        for (Iterator<Object> it : this.iterators) {
            if (!it.hasNext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<String, Object> next() {
        while (true) {
            if (this.iterators[this.cursor].hasNext()) {
                this.currentCartesianSample.put(this.subColums[this.cursor], this.iterators[this.cursor].next());
                if (this.cursor == this.subColums.length - 1) break;
                ++this.cursor;
                continue;
            }
            if (this.cursor == 0) break;
            this.iterators[this.cursor] = this.columnEnumerates.get(this.subColums[this.cursor]).iterator();
            --this.cursor;
        }
        return this.currentCartesianSample;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException(this.getClass().getName() + ".remove()");
    }

    public Set<Object> getColumnEnumerates(String name) {
        return this.columnEnumerates.get(name);
    }

    public Set<String> getSubColumSet() {
        return this.subColumSet;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Samples{");
        for (String column : this.subColumSet) {
            sb.append(column).append("=[");
            for (Object value : this.columnEnumerates.get(column)) {
                if (value instanceof Calendar) {
                    sb.append(df.format(((Calendar)value).getTime())).append(",");
                    continue;
                }
                sb.append(value).append(",");
            }
            sb.append("]");
        }
        sb.append("}");
        return sb.toString();
    }

    public static String bytes2string(byte[] bt) {
        int l = bt.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = digits[(0xF0 & bt[i]) >>> 4];
            out[j++] = digits[0xF & bt[i]];
        }
        return new String(out);
    }

    public static byte[] string2bytes(String str) {
        if (null == str) {
            throw new NullPointerException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        char[] chs = str.toCharArray();
        byte[] data = new byte[chs.length / 2];
        for (int i = 0; i < data.length; ++i) {
            int h = rDigits.get(Character.valueOf(chs[i * 2]));
            int l = rDigits.get(Character.valueOf(chs[i * 2 + 1]));
            data[i] = (byte)((h & 0xF) << 4 | l & 0xF);
        }
        return data;
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        System.out.println(Samples.bytes2string("crm_scheme_detail".getBytes("utf-8")));
        byte[] bs = Samples.string2bytes("63726D5F736368656D655F64657461696C");
        System.out.println(Samples.bytes2string(bs));
        System.out.println(new String(bs, "utf-8"));
        System.out.println("------------------------------");
        bs = Samples.string2bytes("63726D5F726566756E645F7472616465");
        System.out.println(new String(bs, "utf-8"));
        bs = Samples.string2bytes("63726D5F726566756E645F7472616465");
        System.out.println(new String(bs, "utf-8"));
    }

    static {
        for (int i = 0; i < digits.length; ++i) {
            rDigits.put(Character.valueOf(digits[i]), i);
        }
    }

    public static class SamplesCtx {
        public static final int merge = 0;
        public static final int replace = 1;
        public final Samples samples;
        public final int dealType;

        public SamplesCtx(Samples commonSamples, int dealType) {
            this.samples = commonSamples;
            this.dealType = dealType;
        }
    }
}

