/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.interact.rule;

import com.taobao.tddl.interact.rule.Rule;
import com.taobao.tddl.interact.rule.VirtualTable;
import com.taobao.tddl.interact.rule.ruleimpl.DbVirtualNodeRule;
import com.taobao.tddl.interact.rule.ruleimpl.GroovyRule;
import com.taobao.tddl.interact.rule.ruleimpl.TableVirtualNodeRule;
import com.taobao.tddl.interact.rule.ruleimpl.WrappedGroovyRule;
import com.taobao.tddl.interact.rule.util.SimpleNamedMessageFormat;
import com.taobao.tddl.interact.rule.virtualnode.DBTableMap;
import com.taobao.tddl.interact.rule.virtualnode.TableSlotMap;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TableRule
extends VirtualTable {
    Log logger = LogFactory.getLog(TableRule.class);
    private String[] dbRules;
    private String[] tbRules;
    private List<String> extraPackages;
    private String[] ruleParames;
    private String[] dbRuleParames;
    private String[] tbRuleParames;

    @Override
    public void init() {
        super.setExtraPackagesStr(this.extraPackages);
        this.initDbIndexes();
        this.initVnodeMap();
        TableRule.replaceWithParam(this.dbRules, this.dbRuleParames != null ? this.dbRuleParames : this.ruleParames);
        TableRule.replaceWithParam(this.tbRules, this.tbRuleParames != null ? this.tbRuleParames : this.ruleParames);
        super.setDbShardRules(TableRule.convertToRuleArray(this.dbRules, this.dbNamePattern, this.tableSlotMap, this.dbTableMap, false));
        super.setTbShardRules(TableRule.convertToRuleArray(this.tbRules, this.tbNamePattern, this.tableSlotMap, this.dbTableMap, true));
        super.init();
    }

    protected final void initDbIndexes() {
    }

    protected static void replaceWithParam(Object[] rules, String[] params) {
        if (params == null || rules == null) {
            return;
        }
        for (int i = 0; i < rules.length; ++i) {
            if (!(rules[i] instanceof String)) continue;
            rules[i] = TableRule.replaceWithParam((String)rules[i], params);
        }
    }

    private static String replaceWithParam(String template, String[] params) {
        if (params == null || template == null) {
            return template;
        }
        if (params.length != 0 && params[0].indexOf(":") != -1) {
            return TableRule.replaceWithNamedParam(template, params);
        }
        return new MessageFormat(template).format(params);
    }

    private static String replaceWithNamedParam(String template, String[] params) {
        HashMap<String, String> args = new HashMap<String, String>();
        for (String param : params) {
            int index = param.indexOf(":");
            if (index == -1) {
                throw new IllegalArgumentException("\u4f7f\u7528\u540d\u5b57\u5316\u7684\u5360\u4f4d\u7b26\u66ff\u6362\u5931\u8d25\uff01\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002 params:" + Arrays.asList(params));
            }
            args.put(param.substring(0, index).trim(), param.substring(index + 1).trim());
        }
        return new SimpleNamedMessageFormat(template).format(args);
    }

    protected static List<Rule<String>> convertToRuleArray(Object[] rules, String keyPattern, TableSlotMap tableSlotMap, DBTableMap dbTableMap, boolean isTableRule) {
        ArrayList<Rule<String>> ruleList = new ArrayList<Rule<String>>(1);
        if (null == rules) {
            if (tableSlotMap != null && dbTableMap != null && !isTableRule) {
                ruleList.add(new DbVirtualNodeRule(String.valueOf(""), dbTableMap, extraPackagesStr));
                return ruleList;
            }
            return null;
        }
        for (Object rule : rules) {
            if (keyPattern != null && keyPattern.length() != 0) {
                ruleList.add(new WrappedGroovyRule(String.valueOf(rule), keyPattern, extraPackagesStr));
                continue;
            }
            if (tableSlotMap != null && dbTableMap != null && isTableRule) {
                ruleList.add(new TableVirtualNodeRule(String.valueOf(rule), tableSlotMap, extraPackagesStr));
                continue;
            }
            ruleList.add(new GroovyRule(String.valueOf(rule), extraPackagesStr));
        }
        return ruleList;
    }

    public void setDbRuleArray(List<String> dbRules) {
        dbRules = this.trimRuleString(dbRules);
        this.dbRules = dbRules.toArray(new String[dbRules.size()]);
    }

    public void setTbRuleArray(List<String> tbRules) {
        tbRules = this.trimRuleString(tbRules);
        this.tbRules = tbRules.toArray(new String[tbRules.size()]);
    }

    public void setDbRules(String dbRules) {
        if (this.dbRules == null) {
            this.dbRules = new String[]{dbRules.trim()};
        }
    }

    public void setTbRules(String tbRules) {
        if (this.tbRules == null) {
            this.tbRules = new String[]{tbRules.trim()};
        }
    }

    public void setRuleParames(String ruleParames) {
        this.ruleParames = ruleParames.indexOf(124) != -1 ? ruleParames.split("\\|") : ruleParames.split(",");
    }

    public void setRuleParameArray(String[] ruleParames) {
        this.ruleParames = ruleParames;
    }

    public void setDbRuleParames(String dbRuleParames) {
        this.dbRuleParames = dbRuleParames.split(",");
    }

    public void setDbRuleParameArray(String[] dbRuleParames) {
        this.dbRuleParames = dbRuleParames;
    }

    public void setTbRuleParames(String tbRuleParames) {
        this.tbRuleParames = tbRuleParames.split(",");
    }

    public void setTbRuleParameArray(String[] tbRuleParames) {
        this.tbRuleParames = tbRuleParames;
    }

    public void setExtraPackages(List<String> extraPackages) {
        this.extraPackages = extraPackages;
    }
}

