/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.interact.rule;

import com.taobao.tddl.interact.rule.Rule;
import com.taobao.tddl.interact.rule.Samples;
import com.taobao.tddl.interact.rule.VirtualTableRule;
import com.taobao.tddl.interact.rule.bean.AdvancedParameter;
import com.taobao.tddl.interact.rule.bean.DBType;
import com.taobao.tddl.interact.rule.virtualnode.DBTableMap;
import com.taobao.tddl.interact.rule.virtualnode.TableSlotMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VirtualTable
implements VirtualTableRule<String, String> {
    private static Log logger = LogFactory.getLog(VirtualTable.class);
    protected String virtualTbName;
    private Map<String, Set<String>> actualTopology;
    protected String dbNamePattern;
    protected String tbNamePattern;
    protected List<Rule<String>> dbShardRules;
    protected List<Rule<String>> tbShardRules;
    protected static String extraPackagesStr;
    private Object outerContext;
    private DBType dbType = null;
    private boolean allowReverseOutput;
    private boolean allowFullTableScan;
    private boolean disableFullTableScan = true;
    protected TableSlotMap tableSlotMap;
    protected DBTableMap dbTableMap;
    protected String tableSlotKeyFormat;
    private boolean needRowCopy = false;
    private List<String> uniqueKeys;
    private boolean broadcast = false;
    private String joinGroup = null;
    private static final String tableNameSepInSpring = ",";
    private static final int showColsPerRow = 5;

    public void init() {
        if ((this.tbShardRules == null || this.tbShardRules.size() == 0) && this.tbNamePattern == null) {
            this.tbNamePattern = this.virtualTbName;
        }
        this.initActualTopology();
    }

    protected void initVnodeMap() {
        if (this.tableSlotMap != null) {
            this.tableSlotMap.setTableSlotKeyFormat(this.tableSlotKeyFormat);
            this.tableSlotMap.setLogicTable(this.virtualTbName);
            this.tableSlotMap.init();
        }
        if (this.dbTableMap != null) {
            this.dbTableMap.setTableSlotKeyFormat(this.tableSlotKeyFormat);
            this.dbTableMap.setLogicTable(this.virtualTbName);
            this.dbTableMap.init();
        }
    }

    public void initActualTopology() {
        if (this.actualTopology != null) {
            for (Map.Entry<String, Set<String>> e : this.actualTopology.entrySet()) {
                if (e.getValue().size() != 1) continue;
                LinkedHashSet<String> tables = new LinkedHashSet<String>();
                tables.addAll(Arrays.asList(e.getValue().iterator().next().split(tableNameSepInSpring)));
                e.setValue(tables);
            }
            this.showTopology(false);
            return;
        }
        this.actualTopology = new TreeMap<String, Set<String>>();
        if (!(this.dbShardRules != null && this.dbShardRules.size() != 0 || this.tbShardRules != null && this.tbShardRules.size() != 0)) {
            TreeSet<String> tbs = new TreeSet<String>();
            tbs.add(this.tbNamePattern);
            this.actualTopology.put(this.dbNamePattern, tbs);
        } else if (this.dbShardRules == null || this.dbShardRules.size() == 0) {
            TreeSet<String> tbs = new TreeSet<String>();
            for (Rule<String> tbRule : this.tbShardRules) {
                tbs.addAll(this.vbvRule(tbRule, VirtualTable.getEnumerates(tbRule)));
            }
            this.actualTopology.put(this.dbNamePattern, tbs);
        } else if (this.tbShardRules == null || this.tbShardRules.size() == 0) {
            TreeSet<String> tbs = new TreeSet<String>();
            tbs.add(this.tbNamePattern);
            for (Rule<String> dbRule : this.dbShardRules) {
                for (String dbIndex : this.vbvRule(dbRule, VirtualTable.getEnumerates(dbRule))) {
                    this.actualTopology.put(dbIndex, tbs);
                }
            }
        } else {
            for (Rule<String> dbRule : this.dbShardRules) {
                for (Rule<String> tbRule : this.tbShardRules) {
                    if (this.tableSlotMap != null && this.dbTableMap != null) {
                        VirtualTable.valuebyvalue(this.actualTopology, dbRule, tbRule, true);
                        continue;
                    }
                    VirtualTable.valuebyvalue(this.actualTopology, dbRule, tbRule, false);
                }
            }
        }
        this.showTopology(true);
    }

    private static Set<String> vbvRule(Rule<String> rule, Samples samples) {
        TreeSet<String> tbs = new TreeSet<String>();
        for (Map<String, Object> sample : samples) {
            tbs.add(rule.eval(sample, null));
        }
        return tbs;
    }

    private Set<String> vbvRule(Rule<String> rule, Map<String, Set<Object>> enumerates) {
        TreeSet<String> tbs = new TreeSet<String>();
        for (Map<String, Object> sample : new Samples(enumerates)) {
            tbs.add(rule.eval(sample, null));
        }
        return tbs;
    }

    private static Map<String, Samples> vbvTrace(Rule<String> rule, Map<String, Set<Object>> enumerates) {
        TreeMap<String, Samples> db2Samples = new TreeMap<String, Samples>();
        Samples dbSamples = new Samples(enumerates);
        for (Map<String, Object> sample : dbSamples) {
            String v = rule.eval(sample, null);
            Samples s = (Samples)db2Samples.get(v);
            if (s == null) {
                s = new Samples(sample.keySet());
                db2Samples.put(v, s);
            }
            s.addSample(sample);
        }
        return db2Samples;
    }

    private static void valuebyvalue(Map<String, Set<String>> topology, Rule<String> dbRule, Rule<String> tbRule, boolean isVnode) {
        Map<String, Set<Object>> dbEnumerates = VirtualTable.getEnumerates(dbRule);
        Map<String, Set<Object>> tbEnumerates = VirtualTable.getEnumerates(tbRule);
        Set params = (Set)VirtualTable.cast(tbRule.getRuleColumnSet());
        for (AdvancedParameter tbap : params) {
            if (dbEnumerates.containsKey(tbap.key)) {
                HashSet<Object> tbValuesBasedONdbValue = new HashSet<Object>();
                for (Object dbValue : dbEnumerates.get(tbap.key)) {
                    tbValuesBasedONdbValue.addAll(tbap.enumerateRange(dbValue));
                }
                dbEnumerates.get(tbap.key).addAll(tbValuesBasedONdbValue);
                continue;
            }
            dbEnumerates.put(tbap.key, tbEnumerates.get(tbap.key));
        }
        if (isVnode) {
            Samples tabSamples = new Samples(tbEnumerates);
            TreeSet<String> tbs = new TreeSet<String>();
            for (Map<String, Object> sample : tabSamples) {
                String value = tbRule.eval(sample, null);
                tbs.add(value);
            }
            for (String table : tbs) {
                HashMap<String, Object> sample = new HashMap<String, Object>(1);
                sample.put("REAL_TABLE_NAME", table);
                String db = dbRule.eval(sample, null);
                if (topology.get(db) == null) {
                    HashSet<String> tabs = new HashSet<String>();
                    tabs.add(table);
                    topology.put(db, tabs);
                    continue;
                }
                topology.get(db).add(table);
            }
            return;
        }
        Map<String, Samples> dbs = VirtualTable.vbvTrace(dbRule, dbEnumerates);
        for (Map.Entry<String, Samples> e : dbs.entrySet()) {
            Set<String> tbs = topology.get(e.getKey());
            if (tbs == null) {
                tbs = VirtualTable.vbvRule(tbRule, e.getValue());
                topology.put(e.getKey(), tbs);
                continue;
            }
            tbs.addAll(VirtualTable.vbvRule(tbRule, e.getValue()));
        }
    }

    private static Map<String, Set<Object>> getEnumerates(Rule rule) {
        Set params = (Set)VirtualTable.cast(rule.getRuleColumnSet());
        HashMap<String, Set<Object>> enumerates = new HashMap<String, Set<Object>>(params.size());
        for (AdvancedParameter ap : params) {
            enumerates.put(ap.key, ap.enumerateRange());
        }
        return enumerates;
    }

    private void showTopology(boolean showMap) {
        int maxcolsPerRow = 5;
        int maxtbnlen = 1;
        int maxdbnlen = 1;
        for (Map.Entry<String, Set<String>> e : this.actualTopology.entrySet()) {
            int colsPerRow = this.colsPerRow((Collection<String>)e.getValue(), 5);
            if (colsPerRow > maxcolsPerRow) {
                maxcolsPerRow = colsPerRow;
            }
            if (e.getKey().length() > maxdbnlen) {
                maxdbnlen = e.getKey().length();
            }
            for (String tbn : e.getValue()) {
                if (tbn.length() <= maxtbnlen) continue;
                maxtbnlen = tbn.length();
            }
        }
        int crossIndex = maxdbnlen + 1;
        int endIndex = crossIndex + (maxtbnlen + 1) * maxcolsPerRow + 1;
        StringBuilder sb = new StringBuilder("The topology of the virtual table " + this.virtualTbName);
        this.addLine(sb, crossIndex, endIndex);
        for (Map.Entry<String, Set<String>> e : this.actualTopology.entrySet()) {
            sb.append("\n|");
            sb.append(this.fillAfter(e.getKey(), maxdbnlen)).append("|");
            int i = 0;
            int n = e.getValue().size();
            for (String tb : e.getValue()) {
                sb.append(this.fillAfter(tb, maxtbnlen)).append(tableNameSepInSpring);
                if (++i % maxcolsPerRow != 0 || i >= n) continue;
                sb.append("|\n|").append(this.fillAfter(" ", maxdbnlen)).append("|");
            }
            if (i % maxcolsPerRow != 0) {
                int taillen = (maxcolsPerRow - i % maxcolsPerRow) * (maxtbnlen + 1) + 1;
                sb.append(this.fillBefore("|", taillen));
            } else {
                sb.append("|");
            }
            this.addLine(sb, crossIndex, endIndex);
        }
        sb.append("\n");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)sb.toString());
        }
        if (!showMap) {
            return;
        }
        sb = new StringBuilder("\nYou could add below segement as the actualTopology property to ");
        sb.append(this.virtualTbName + "'s TableRule bean in the rule file\n\n");
        sb.append("        <property name=\"actualTopology\">\n");
        sb.append("          <map>\n");
        for (Map.Entry<String, Set<String>> e : this.actualTopology.entrySet()) {
            sb.append("            <entry key=\"").append(e.getKey()).append("\" value=\"");
            for (String table : e.getValue()) {
                sb.append(table).append(tableNameSepInSpring);
            }
            if (sb.charAt(sb.length() - 1) == tableNameSepInSpring.charAt(0)) {
                sb.deleteCharAt(sb.length() - 1);
            }
            sb.append("\" />\n");
        }
        sb.append("          </map>\n");
        sb.append("        </property>\n");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)sb.toString());
        }
    }

    private int colsPerRow(Collection<String> c, int maxColPerRow) {
        int n = c.size();
        if (n <= maxColPerRow) {
            return n;
        }
        int maxfiti = maxColPerRow;
        int minblank = maxColPerRow;
        for (int i = maxColPerRow; i > 0; --i) {
            int mod = n % i;
            if (mod == 0) {
                if (n / i > i) break;
                return i;
            }
            if (i - mod >= minblank) continue;
            minblank = i - mod;
            maxfiti = i;
        }
        return maxfiti;
    }

    private String fillAfter(String str, int len) {
        if (str.length() < len) {
            int n = len - str.length();
            for (int i = 0; i < n; ++i) {
                str = str + " ";
            }
        }
        return str;
    }

    private String fillBefore(String str, int len) {
        if (str.length() < len) {
            int n = len - str.length();
            for (int i = 0; i < n; ++i) {
                str = " " + str;
            }
        }
        return str;
    }

    private void addLine(StringBuilder sb, int crossIndex, int endIndex) {
        sb.append("\n+");
        for (int i = 1; i <= endIndex; ++i) {
            if (i == crossIndex || i == endIndex) {
                sb.append("+");
                continue;
            }
            sb.append("-");
        }
    }

    public VirtualTable clone() throws CloneNotSupportedException {
        return (VirtualTable)super.clone();
    }

    private static <T> T cast(Object obj) {
        return (T)obj;
    }

    public void setDbNamePattern(String dbKeyPattern) {
        this.dbNamePattern = dbKeyPattern;
    }

    @Override
    public String getTbNamePattern() {
        return this.tbNamePattern;
    }

    public void setTbNamePattern(String tbKeyPattern) {
        this.tbNamePattern = tbKeyPattern;
    }

    @Override
    public List<Rule<String>> getDbShardRules() {
        return this.dbShardRules;
    }

    public void setDbShardRules(List<Rule<String>> dbShardRules) {
        this.dbShardRules = dbShardRules;
    }

    @Override
    public List<Rule<String>> getTbShardRules() {
        return this.tbShardRules;
    }

    public void setTbShardRules(List<Rule<String>> tbShardRules) {
        this.tbShardRules = tbShardRules;
    }

    @Override
    public DBType getDbType() {
        return this.dbType;
    }

    public void setDbType(DBType dbType) {
        this.dbType = dbType;
    }

    @Override
    public boolean isAllowReverseOutput() {
        return this.allowReverseOutput;
    }

    public void setAllowReverseOutput(boolean allowReverseOutput) {
        this.allowReverseOutput = allowReverseOutput;
    }

    public boolean isDisableFullTableScan() {
        return this.disableFullTableScan;
    }

    public void setDisableFullTableScan(boolean disableFullTableScan) {
        this.disableFullTableScan = disableFullTableScan;
    }

    @Override
    public boolean isNeedRowCopy() {
        return this.needRowCopy;
    }

    public void setNeedRowCopy(boolean needRowCopy) {
        this.needRowCopy = needRowCopy;
    }

    @Override
    public List<String> getUniqueKeys() {
        return this.uniqueKeys;
    }

    public void setUniqueKeys(List<String> uniqueKeys) {
        this.uniqueKeys = uniqueKeys;
    }

    @Override
    public boolean isAllowFullTableScan() {
        return this.allowFullTableScan;
    }

    public void setAllowFullTableScan(boolean allowFullTableScan) {
        this.allowFullTableScan = allowFullTableScan;
    }

    @Override
    public Map<String, Set<String>> getActualTopology() {
        return this.actualTopology;
    }

    public void setActualTopology(Map<String, Set<String>> actualTopology) {
        this.actualTopology = actualTopology;
    }

    public String getVirtualTbName() {
        return this.virtualTbName;
    }

    public void setVirtualTbName(String virtualTbName) {
        this.virtualTbName = virtualTbName;
    }

    public void setExtraPackagesStr(List<String> extraPackages) {
        StringBuilder ep = new StringBuilder("");
        if (extraPackages != null) {
            int packNum = extraPackages.size();
            for (int i = 0; i < packNum; ++i) {
                ep.append("import ");
                ep.append(extraPackages.get(i));
                ep.append(";");
            }
        }
        extraPackagesStr = ep.toString();
    }

    protected List<String> trimRuleString(List<String> ruleStrings) {
        ArrayList<String> result = new ArrayList<String>(ruleStrings.size());
        for (String ruleString : ruleStrings) {
            result.add(ruleString.trim());
        }
        return result;
    }

    @Override
    public Object getOuterContext() {
        return this.outerContext;
    }

    public void setOuterContext(Map<Object, Object> outerContext) {
        this.outerContext = outerContext;
    }

    public void setTableSlotMap(TableSlotMap tableSlotMap) {
        this.tableSlotMap = tableSlotMap;
    }

    public void setDbTableMap(DBTableMap dbTableMap) {
        this.dbTableMap = dbTableMap;
    }

    @Override
    public TableSlotMap getTableSlotMap() {
        return this.tableSlotMap;
    }

    @Override
    public DBTableMap getDbTableMap() {
        return this.dbTableMap;
    }

    public void setTableSlotKeyFormat(String tableSlotKeyFormat) {
        this.tableSlotKeyFormat = tableSlotKeyFormat;
    }

    public boolean isBroadcast() {
        return this.broadcast;
    }

    public void setBroadcast(boolean broadcast) {
        this.broadcast = broadcast;
    }

    public String getJoinGroup() {
        return this.joinGroup;
    }

    public void setJoinGroup(String joinGroup) {
        this.joinGroup = joinGroup;
    }
}

