/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.interact.rule;

import com.taobao.tddl.interact.rule.VirtualTable;
import com.taobao.tddl.interact.rule.bean.DBType;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VirtualTableRoot {
    final Log log = LogFactory.getLog(VirtualTableRoot.class);
    protected String dbType = "MYSQL";
    protected Map<String, VirtualTable> virtualTableMap;
    protected String defaultDbIndex;
    protected Map<String, String> dbIndexMap;
    protected boolean needIdInGroup = false;
    protected boolean completeDistinct = false;

    public DBType getDbTypeEnumObj() {
        return DBType.valueOf(this.dbType);
    }

    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public void init() {
        for (Map.Entry<String, VirtualTable> entry : this.virtualTableMap.entrySet()) {
            this.log.warn((Object)("virtual table start to init :" + entry.getKey()));
            VirtualTable vtab = entry.getValue();
            if (vtab.getDbType() == null) {
                vtab.setDbType(this.getDbTypeEnumObj());
            }
            if (vtab.getVirtualTbName() == null) {
                vtab.setVirtualTbName(entry.getKey());
            }
            vtab.init();
            this.log.warn((Object)("virtual table inited :" + entry.getKey()));
        }
    }

    public VirtualTable getVirtualTable(String virtualTableName) {
        if (null != virtualTableName) {
            return this.virtualTableMap.get(virtualTableName.toLowerCase());
        }
        throw new IllegalArgumentException("virtual table name is null");
    }

    public Map<String, VirtualTable> getVirtualTableMap() {
        return this.virtualTableMap;
    }

    public void setVirtualTableMap(Map<String, VirtualTable> virtualTableMap) {
        this.virtualTableMap = virtualTableMap;
    }

    public Map<String, VirtualTable> getTableRules() {
        return this.virtualTableMap;
    }

    public void setTableRules(Map<String, VirtualTable> virtualTableMap) {
        HashMap<String, VirtualTable> lowerKeysLogicTableMap = new HashMap<String, VirtualTable>(virtualTableMap.size());
        for (Map.Entry<String, VirtualTable> entry : virtualTableMap.entrySet()) {
            lowerKeysLogicTableMap.put(entry.getKey().toLowerCase(), entry.getValue());
        }
        this.virtualTableMap = lowerKeysLogicTableMap;
    }

    public String getDefaultDbIndex() {
        return this.defaultDbIndex;
    }

    public void setDefaultDbIndex(String defaultDbIndex) {
        this.defaultDbIndex = defaultDbIndex;
    }

    public Map<String, String> getDbIndexMap() {
        return this.dbIndexMap;
    }

    public void setDbIndexMap(Map<String, String> dbIndexMap) {
        HashMap<String, String> lowerKeysDbIndexMap = new HashMap<String, String>(dbIndexMap.size());
        for (Map.Entry<String, String> entry : dbIndexMap.entrySet()) {
            lowerKeysDbIndexMap.put(entry.getKey().toLowerCase(), entry.getValue());
        }
        this.dbIndexMap = lowerKeysDbIndexMap;
    }

    public boolean isNeedIdInGroup() {
        return this.needIdInGroup;
    }

    public void setNeedIdInGroup(boolean needIdInGroup) {
        this.needIdInGroup = needIdInGroup;
    }

    public boolean isCompleteDistinct() {
        return this.completeDistinct;
    }

    public void setCompleteDistinct(boolean completeDistinct) {
        this.completeDistinct = completeDistinct;
    }
}

