/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.interact.rule;

import com.taobao.tddl.interact.bean.ComparativeMapChoicer;
import com.taobao.tddl.interact.bean.Field;
import com.taobao.tddl.interact.bean.MatcherResult;
import com.taobao.tddl.interact.bean.MatcherResultImp;
import com.taobao.tddl.interact.bean.TargetDB;
import com.taobao.tddl.interact.rule.Rule;
import com.taobao.tddl.interact.rule.Samples;
import com.taobao.tddl.interact.rule.VirtualTableRule;
import com.taobao.tddl.interact.rule.bean.AdvancedParameter;
import com.taobao.tddl.interact.rule.ruleimpl.VirtualNodeGroovyRule;
import com.taobao.tddl.interact.rule.util.RuleUtils;
import com.taobao.tddl.interact.sqljep.Comparative;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VirtualTableRuleMatcher {
    private static final boolean isCrossInto;

    public MatcherResult match(boolean needSourceKey, ComparativeMapChoicer choicer, List<Object> args, VirtualTableRule<String, String> rule) {
        if (needSourceKey) {
            return this.matchWithSourceKey(choicer, args, rule);
        }
        return this.matchNoSourceKey(choicer, args, rule);
    }

    private MatcherResult matchNoSourceKey(ComparativeMapChoicer choicer, List<Object> args, VirtualTableRule<String, String> rule) {
        Map<String, Set<String>> topology;
        HashMap<String, Comparative> allRuleArgs = new HashMap<String, Comparative>(2);
        HashMap<String, Comparative> dbRuleArgs = new HashMap<String, Comparative>(2);
        HashMap<String, Comparative> tbRuleArgs = new HashMap<String, Comparative>(2);
        Object outerCtx = rule.getOuterContext();
        Rule<String> dbRule = VirtualTableRuleMatcher.findMatchedRule(allRuleArgs, rule.getDbShardRules(), dbRuleArgs, choicer, args, rule);
        Rule<String> tbRule = VirtualTableRuleMatcher.findMatchedRule(allRuleArgs, rule.getTbShardRules(), tbRuleArgs, choicer, args, rule);
        if (dbRule == null && tbRule == null) {
            topology = rule.getActualTopology();
        } else if (dbRule == null) {
            Set tbValues = tbRule.calculateNoTrace(tbRuleArgs, null, outerCtx);
            topology = new HashMap<String, Set<String>>(rule.getActualTopology().size());
            for (String dbValue : rule.getActualTopology().keySet()) {
                topology.put(dbValue, tbValues);
            }
        } else if (tbRule == null) {
            if (dbRule instanceof VirtualNodeGroovyRule) {
                topology = rule.getActualTopology();
            } else {
                Set<String> dbValues = dbRule.calculateNoTrace(dbRuleArgs, null, outerCtx);
                topology = new HashMap<String, Set<String>>(dbValues.size());
                for (String dbValue : dbValues) {
                    topology.put(dbValue, rule.getActualTopology().get(dbValue));
                }
            }
        } else {
            String[] commonColumn;
            Set<String> commonSet = VirtualTableRuleMatcher.getCommonColumnSet(dbRule, tbRule);
            String[] stringArray = commonColumn = commonSet == null ? null : commonSet.toArray(new String[commonSet.size()]);
            if (commonColumn == null || commonColumn.length == 0) {
                Set<String> tbValues = tbRule.calculateNoTrace(tbRuleArgs, null, outerCtx);
                Set<String> dbValues = null;
                if (dbRule instanceof VirtualNodeGroovyRule) {
                    topology = new HashMap<String, Set<String>>();
                    for (String tab : tbValues) {
                        String db = dbRule.calculateVnodeNoTrace(tab, null, outerCtx);
                        if (!topology.containsKey(db)) {
                            HashSet<String> tbSet = new HashSet<String>();
                            tbSet.add(tab);
                            topology.put(db, tbSet);
                            continue;
                        }
                        topology.get(db).add(tab);
                    }
                } else {
                    dbValues = dbRule.calculateNoTrace(dbRuleArgs, null, outerCtx);
                    topology = new HashMap<String, Set<String>>(dbValues.size());
                    for (String dbValue : dbValues) {
                        topology.put(dbValue, tbValues);
                    }
                }
            } else {
                topology = !isCrossInto ? this.crossNoSourceKey1(dbRule, dbRuleArgs, tbRule, tbRuleArgs, commonColumn, outerCtx) : this.crossNoSourceKey2(dbRule, dbRuleArgs, tbRule, tbRuleArgs, commonSet, outerCtx);
            }
        }
        return new MatcherResultImp(this.buildTargetDbList(topology), dbRuleArgs, tbRuleArgs);
    }

    private MatcherResult matchWithSourceKey(ComparativeMapChoicer choicer, List<Object> args, VirtualTableRule<String, String> rule) {
        Map<String, Map<String, Field>> topology;
        HashMap<String, Comparative> allRuleArgs = new HashMap<String, Comparative>(2);
        HashMap<String, Comparative> dbRuleArgs = new HashMap<String, Comparative>(2);
        HashMap<String, Comparative> tbRuleArgs = new HashMap<String, Comparative>(2);
        Object outerCtx = rule.getOuterContext();
        Rule<String> dbRule = VirtualTableRuleMatcher.findMatchedRule(allRuleArgs, rule.getDbShardRules(), dbRuleArgs, choicer, args, rule);
        Rule<String> tbRule = VirtualTableRuleMatcher.findMatchedRule(allRuleArgs, rule.getTbShardRules(), tbRuleArgs, choicer, args, rule);
        if (dbRule == null && tbRule == null) {
            topology = new HashMap<String, Map<String, Field>>(rule.getActualTopology().size());
            for (Map.Entry<String, Set<String>> e : rule.getActualTopology().entrySet()) {
                topology.put(e.getKey(), this.toMapField(e.getValue()));
            }
        } else if (dbRule == null) {
            Map tbValues = (Map)VirtualTableRuleMatcher.cast(tbRule.calculate(tbRuleArgs, null, outerCtx));
            topology = new HashMap(rule.getActualTopology().size());
            for (String dbValue : rule.getActualTopology().keySet()) {
                topology.put(dbValue, this.toMapField(tbValues));
            }
        } else if (tbRule == null) {
            if (dbRule instanceof VirtualNodeGroovyRule) {
                topology = new HashMap(rule.getActualTopology().size());
                for (Map.Entry<String, Set<String>> e : rule.getActualTopology().entrySet()) {
                    topology.put(e.getKey(), this.toMapField(e.getValue()));
                }
            } else {
                Set<String> dbValues = dbRule.calculateNoTrace(dbRuleArgs, null, outerCtx);
                topology = new HashMap(dbValues.size());
                for (String dbValue : dbValues) {
                    topology.put(dbValue, this.toMapField(rule.getActualTopology().get(dbValue)));
                }
            }
        } else {
            String[] commonColumn;
            Set<String> commonSet = VirtualTableRuleMatcher.getCommonColumnSet(dbRule, tbRule);
            String[] stringArray = commonColumn = commonSet == null ? null : commonSet.toArray(new String[commonSet.size()]);
            if (commonColumn == null || commonColumn.length == 0) {
                if (dbRule instanceof VirtualNodeGroovyRule) {
                    Map tbValues = (Map)VirtualTableRuleMatcher.cast(tbRule.calculate(tbRuleArgs, null, outerCtx));
                    topology = new HashMap();
                    HashMap templogy = new HashMap();
                    for (Map.Entry entry : tbValues.entrySet()) {
                        String db = dbRule.calculateVnodeNoTrace((String)entry.getKey(), null, outerCtx);
                        if (!topology.containsKey(db)) {
                            HashMap tbSet = new HashMap();
                            tbSet.put(entry.getKey(), entry.getValue());
                            templogy.put(db, tbSet);
                            continue;
                        }
                        ((Map)templogy.get(db)).put(entry.getKey(), entry.getValue());
                    }
                    for (Map.Entry entry : templogy.entrySet()) {
                        topology.put((String)entry.getKey(), this.toMapField((Map)entry.getValue()));
                    }
                } else {
                    Set<String> dbValues = dbRule.calculateNoTrace(dbRuleArgs, null, outerCtx);
                    Map tbValues = (Map)VirtualTableRuleMatcher.cast(tbRule.calculate(tbRuleArgs, null, outerCtx));
                    topology = new HashMap(dbValues.size());
                    for (String dbValue : dbValues) {
                        topology.put(dbValue, this.toMapField(tbValues));
                    }
                }
            } else {
                topology = !isCrossInto ? this.crossWithSourceKey1(dbRule, dbRuleArgs, tbRule, tbRuleArgs, commonColumn, outerCtx) : this.crossWithSourceKey2(dbRule, dbRuleArgs, tbRule, tbRuleArgs, commonSet, outerCtx);
            }
        }
        return new MatcherResultImp(this.buildTargetDbListWithSourceKey(topology), dbRuleArgs, tbRuleArgs);
    }

    private Map<String, Set<String>> crossNoSourceKey1(Rule<String> matchedDbRule, Map<String, Comparative> matchedDbRuleArgs, Rule<String> matchedTbRule, Map<String, Comparative> matchedTbRuleArgs, String[] commonColumn, Object outerCtx) {
        Samples.SamplesCtx dbRuleCtx = null;
        Set<AdvancedParameter> diifTypeInCommon = VirtualTableRuleMatcher.diifTypeInCommon(matchedDbRule, matchedTbRule, commonColumn);
        if (diifTypeInCommon != null && !diifTypeInCommon.isEmpty()) {
            Map<String, Set<Object>> tbTypes = RuleUtils.getSamplingField(matchedTbRuleArgs, diifTypeInCommon);
            dbRuleCtx = new Samples.SamplesCtx(new Samples(tbTypes), 0);
        }
        Map dbValues = (Map)VirtualTableRuleMatcher.cast(matchedDbRule.calculate(matchedDbRuleArgs, dbRuleCtx, outerCtx));
        HashMap<String, Set<String>> topology = new HashMap<String, Set<String>>(dbValues.size());
        for (Map.Entry e : dbValues.entrySet()) {
            Samples.SamplesCtx tbRuleCtx = new Samples.SamplesCtx(((Samples)e.getValue()).subSamples(commonColumn), 1);
            Set<String> tbValues = matchedTbRule.calculateNoTrace(matchedTbRuleArgs, tbRuleCtx, outerCtx);
            topology.put((String)e.getKey(), tbValues);
        }
        return topology;
    }

    private Map<String, Map<String, Field>> crossWithSourceKey1(Rule<String> matchedDbRule, Map<String, Comparative> matchedDbRuleArgs, Rule<String> matchedTbRule, Map<String, Comparative> matchedTbRuleArgs, String[] commonColumn, Object outerCtx) {
        Samples.SamplesCtx dbRuleCtx = null;
        Set<AdvancedParameter> diifTypeInCommon = VirtualTableRuleMatcher.diifTypeInCommon(matchedDbRule, matchedTbRule, commonColumn);
        if (diifTypeInCommon != null && !diifTypeInCommon.isEmpty()) {
            Map<String, Set<Object>> tbTypes = RuleUtils.getSamplingField(matchedTbRuleArgs, diifTypeInCommon);
            dbRuleCtx = new Samples.SamplesCtx(new Samples(tbTypes), 0);
        }
        Map dbValues = (Map)VirtualTableRuleMatcher.cast(matchedDbRule.calculate(matchedDbRuleArgs, dbRuleCtx, outerCtx));
        HashMap<String, Map<String, Field>> topology = new HashMap<String, Map<String, Field>>(dbValues.size());
        for (Map.Entry e : dbValues.entrySet()) {
            Samples.SamplesCtx tbRuleCtx = new Samples.SamplesCtx(((Samples)e.getValue()).subSamples(commonColumn), 1);
            Map tbValues = (Map)VirtualTableRuleMatcher.cast(matchedTbRule.calculate(matchedTbRuleArgs, tbRuleCtx, outerCtx));
            topology.put((String)e.getKey(), this.toMapField(tbValues));
        }
        return topology;
    }

    private Map<String, Set<String>> crossNoSourceKey2(Rule<String> matchedDbRule, Map<String, Comparative> matchedDbRuleArgs, Rule<String> matchedTbRule, Map<String, Comparative> matchedTbRuleArgs, Set<String> commonSet, Object outerCtx) {
        String[] commonColumn = commonSet == null ? null : commonSet.toArray(new String[commonSet.size()]);
        Set dbParams = (Set)VirtualTableRuleMatcher.cast(matchedDbRule.getRuleColumnSet());
        Set tbParams = (Set)VirtualTableRuleMatcher.cast(matchedTbRule.getRuleColumnSet());
        Map<String, Set<Object>> dbEnumerates = RuleUtils.getSamplingField(matchedDbRuleArgs, dbParams);
        Set<AdvancedParameter> diifTypeInCommon = VirtualTableRuleMatcher.diifTypeInCommon(matchedDbRule, matchedTbRule, commonColumn);
        if (diifTypeInCommon != null && !diifTypeInCommon.isEmpty()) {
            Map<String, Set<Object>> diifTypeTbEnumerates = RuleUtils.getSamplingField(matchedTbRuleArgs, diifTypeInCommon);
            for (Map.Entry entry : diifTypeTbEnumerates.entrySet()) {
                dbEnumerates.get(entry.getKey()).addAll((Collection)entry.getValue());
            }
        }
        HashSet<AdvancedParameter> tbOnly = new HashSet<AdvancedParameter>();
        for (AdvancedParameter advancedParameter : tbParams) {
            if (commonSet.contains(advancedParameter.key)) continue;
            tbOnly.add(advancedParameter);
        }
        HashMap<String, Set<String>> topology = new HashMap<String, Set<String>>();
        if (tbOnly.isEmpty()) {
            for (Map<String, Object> dbSample : new Samples(dbEnumerates)) {
                String dbIndex = matchedDbRule.eval(dbSample, outerCtx);
                String tbName = matchedTbRule.eval(dbSample, outerCtx);
                VirtualTableRuleMatcher.addToTopology(dbIndex, tbName, topology);
            }
        } else {
            Map<String, Set<Object>> map = RuleUtils.getSamplingField(matchedTbRuleArgs, tbOnly);
            Samples tbSamples = new Samples(map);
            for (Map<String, Object> dbSample : new Samples(dbEnumerates)) {
                String dbIndex = matchedDbRule.eval(dbSample, outerCtx);
                for (Map<String, Object> tbSample : tbSamples) {
                    dbSample.putAll(tbSample);
                    String tbName = matchedTbRule.eval(dbSample, outerCtx);
                    VirtualTableRuleMatcher.addToTopology(dbIndex, tbName, topology);
                }
            }
        }
        return topology;
    }

    private Map<String, Map<String, Field>> crossWithSourceKey2(Rule<String> matchedDbRule, Map<String, Comparative> matchedDbRuleArgs, Rule<String> matchedTbRule, Map<String, Comparative> matchedTbRuleArgs, Set<String> commonSet, Object outerCtx) {
        String[] commonColumn = commonSet == null ? null : commonSet.toArray(new String[commonSet.size()]);
        Set dbParams = (Set)VirtualTableRuleMatcher.cast(matchedDbRule.getRuleColumnSet());
        Set tbParams = (Set)VirtualTableRuleMatcher.cast(matchedTbRule.getRuleColumnSet());
        Map<String, Set<Object>> dbEnumerates = RuleUtils.getSamplingField(matchedDbRuleArgs, dbParams);
        Set<AdvancedParameter> diifTypeInCommon = VirtualTableRuleMatcher.diifTypeInCommon(matchedDbRule, matchedTbRule, commonColumn);
        if (diifTypeInCommon != null && !diifTypeInCommon.isEmpty()) {
            Map<String, Set<Object>> diifTypeTbEnumerates = RuleUtils.getSamplingField(matchedTbRuleArgs, diifTypeInCommon);
            for (Map.Entry entry : diifTypeTbEnumerates.entrySet()) {
                dbEnumerates.get(entry.getKey()).addAll((Collection)entry.getValue());
            }
        }
        HashSet<AdvancedParameter> tbOnly = new HashSet<AdvancedParameter>();
        for (AdvancedParameter advancedParameter : tbParams) {
            if (commonSet.contains(advancedParameter.key)) continue;
            tbOnly.add(advancedParameter);
        }
        HashMap<String, Map<String, Field>> topology = new HashMap<String, Map<String, Field>>();
        if (tbOnly.isEmpty()) {
            for (Map<String, Object> dbSample : new Samples(dbEnumerates)) {
                String dbIndex = matchedDbRule.eval(dbSample, outerCtx);
                String tbName = matchedTbRule.eval(dbSample, outerCtx);
                VirtualTableRuleMatcher.addToTopologyWithSource(dbIndex, tbName, topology, dbSample, tbParams);
            }
        } else {
            Map<String, Set<Object>> map = RuleUtils.getSamplingField(matchedTbRuleArgs, tbOnly);
            Samples tbSamples = new Samples(map);
            for (Map<String, Object> dbSample : new Samples(dbEnumerates)) {
                String dbIndex = matchedDbRule.eval(dbSample, outerCtx);
                for (Map<String, Object> tbSample : tbSamples) {
                    dbSample.putAll(tbSample);
                    String tbName = matchedTbRule.eval(dbSample, outerCtx);
                    VirtualTableRuleMatcher.addToTopologyWithSource(dbIndex, tbName, topology, dbSample, tbParams);
                }
            }
        }
        return topology;
    }

    private static void addToTopology(String dbIndex, String tbName, Map<String, Set<String>> topology) {
        Set<String> tbNames = topology.get(dbIndex);
        if (tbNames == null) {
            tbNames = new HashSet<String>();
            topology.put(dbIndex, tbNames);
        }
        tbNames.add(tbName);
    }

    private static void addToTopologyWithSource(String dbIndex, String tbName, Map<String, Map<String, Field>> topology, Map<String, Object> tbSample, Set<AdvancedParameter> tbParams) {
        Field f;
        Map<String, Field> tbNames = topology.get(dbIndex);
        if (tbNames == null) {
            tbNames = new HashMap<String, Field>();
            topology.put(dbIndex, tbNames);
        }
        if ((f = tbNames.get(tbName)) == null) {
            f = new Field(tbParams.size());
            tbNames.put(tbName, f);
        }
        for (AdvancedParameter ap : tbParams) {
            Set<Object> set = f.sourceKeys.get(ap.key);
            if (set == null) {
                set = new HashSet<Object>();
            }
            set.add(tbSample.get(ap.key));
        }
    }

    private Map<String, Field> toMapField(Map<String, Samples> values) {
        HashMap<String, Field> res = new HashMap<String, Field>(values.size());
        for (Map.Entry<String, Samples> e : values.entrySet()) {
            Field f = new Field(e.getValue().size());
            f.sourceKeys = e.getValue().getColumnEnumerates();
            res.put(e.getKey(), f);
        }
        return res;
    }

    private Map<String, Field> toMapField(Set<String> values) {
        HashMap<String, Field> res = new HashMap<String, Field>(values.size());
        for (String valule : values) {
            res.put(valule, null);
        }
        return res;
    }

    private List<TargetDB> buildTargetDbList(Map<String, Set<String>> topology) {
        ArrayList<TargetDB> targetDbList = new ArrayList<TargetDB>(topology.size());
        for (Map.Entry<String, Set<String>> e : topology.entrySet()) {
            TargetDB db = new TargetDB();
            HashMap<String, Field> tableNames = new HashMap<String, Field>(e.getValue().size());
            for (String tbName : e.getValue()) {
                tableNames.put(tbName, null);
            }
            db.setDbIndex(e.getKey());
            db.setTableNames(tableNames);
            targetDbList.add(db);
        }
        return targetDbList;
    }

    private List<TargetDB> buildTargetDbListWithSourceKey(Map<String, Map<String, Field>> topology) {
        ArrayList<TargetDB> targetDbList = new ArrayList<TargetDB>(topology.size());
        for (Map.Entry<String, Map<String, Field>> e : topology.entrySet()) {
            TargetDB db = new TargetDB();
            db.setDbIndex(e.getKey());
            db.setTableNames(e.getValue());
            targetDbList.add(db);
        }
        return targetDbList;
    }

    private static <T> Rule<T> findMatchedRule(Map<String, Comparative> allRuleColumnArgs, List<Rule<T>> shardRules, Map<String, Comparative> matchArgs, ComparativeMapChoicer choicer, List<Object> args, VirtualTableRule<String, String> rule) {
        Rule<T> matchedRule = null;
        if (shardRules != null && shardRules.size() != 0 && (matchedRule = VirtualTableRuleMatcher.findMatchedRule(allRuleColumnArgs, shardRules, matchArgs, choicer, args)) == null && !rule.isAllowFullTableScan()) {
            LinkedList shardColumns = new LinkedList();
            for (Rule<T> r : shardRules) {
                LinkedHashSet<String> columnSet = new LinkedHashSet<String>();
                for (Rule.RuleColumn rc : r.getRuleColumnSet()) {
                    columnSet.add(rc.key);
                }
                shardColumns.add(columnSet);
            }
            throw new IllegalArgumentException("sql contain no sharding column:" + shardColumns);
        }
        return matchedRule;
    }

    private static Set<String> getCommonColumnSet(Rule<String> matchedDbRule, Rule<String> matchedTbRule) {
        HashSet<String> res = null;
        for (String key : matchedDbRule.getRuleColumns().keySet()) {
            if (!matchedTbRule.getRuleColumns().containsKey(key)) continue;
            if (res == null) {
                res = new HashSet<String>(1);
            }
            res.add(key);
        }
        return res;
    }

    private static Set<AdvancedParameter> diifTypeInCommon(Rule<String> dbRule, Rule<String> tbRule, String[] commonColumn) {
        HashSet<AdvancedParameter> diifTypeInCommon = null;
        for (String common : commonColumn) {
            AdvancedParameter dbap = (AdvancedParameter)dbRule.getRuleColumns().get(common);
            AdvancedParameter tbap = (AdvancedParameter)tbRule.getRuleColumns().get(common);
            if (dbap.atomicIncreateType == tbap.atomicIncreateType) continue;
            if (diifTypeInCommon == null) {
                diifTypeInCommon = new HashSet<AdvancedParameter>(0);
            }
            diifTypeInCommon.add(tbap);
        }
        return diifTypeInCommon;
    }

    private static <T> Rule<T> findMatchedRule(Map<String, Comparative> allRuleColumnArgs, List<Rule<T>> rules, Map<String, Comparative> matchArgs, ComparativeMapChoicer choicer, List<Object> args) {
        Comparative comparative;
        for (Rule<T> r : rules) {
            matchArgs.clear();
            for (Rule.RuleColumn ruleColumn : r.getRuleColumns().values()) {
                comparative = VirtualTableRuleMatcher.getComparative(ruleColumn.key, allRuleColumnArgs, choicer, args);
                if (comparative == null) break;
                matchArgs.put(ruleColumn.key, comparative);
            }
            if (matchArgs.size() != r.getRuleColumns().size()) continue;
            return r;
        }
        for (Rule<T> r : rules) {
            matchArgs.clear();
            int mandatoryColumnCount = 0;
            for (Rule.RuleColumn ruleColumn : r.getRuleColumns().values()) {
                if (!ruleColumn.needAppear) continue;
                ++mandatoryColumnCount;
                Comparative comparative2 = VirtualTableRuleMatcher.getComparative(ruleColumn.key, allRuleColumnArgs, choicer, args);
                if (comparative2 == null) break;
                matchArgs.put(ruleColumn.key, comparative2);
            }
            if (mandatoryColumnCount == 0 || matchArgs.size() != mandatoryColumnCount) continue;
            return r;
        }
        block4: for (Rule<T> r : rules) {
            matchArgs.clear();
            for (Rule.RuleColumn ruleColumn : r.getRuleColumns().values()) {
                if (ruleColumn.needAppear) continue block4;
                comparative = VirtualTableRuleMatcher.getComparative(ruleColumn.key, allRuleColumnArgs, choicer, args);
                if (comparative == null) continue;
                matchArgs.put(ruleColumn.key, allRuleColumnArgs.get(ruleColumn.key));
            }
            if (matchArgs.size() == 0) continue;
            return r;
        }
        return null;
    }

    private static Comparative getComparative(String colName, Map<String, Comparative> allRuleColumnArgs, ComparativeMapChoicer comparativeMapChoicer, List<Object> args) {
        Comparative comparative = allRuleColumnArgs.get(colName);
        if (comparative == null && (comparative = comparativeMapChoicer.getColumnComparative(args, colName)) != null) {
            allRuleColumnArgs.put(colName, comparative);
        }
        return comparative;
    }

    private static <T> T cast(Object obj) {
        return (T)obj;
    }

    static {
        String str = System.getProperty("com.taobao.tddl.rule.isCrossIntoCalculate", "false");
        isCrossInto = Boolean.parseBoolean(str);
    }
}

