/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.interact.rule.bean;

import com.alibaba.common.lang.StringUtil;
import com.taobao.tddl.interact.rule.Rule;
import com.taobao.tddl.interact.rule.bean.DateEnumerationParameter;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class AdvancedParameter
extends Rule.RuleColumn {
    public final Comparable<?> atomicIncreateValue;
    public final Integer cumulativeTimes;
    public final boolean needMergeValueInCloseInterval;
    public final AtomIncreaseType atomicIncreateType;
    public final Range[] rangeArray;
    public static final String PARAM_SEGMENT_SPLITOR = ",";
    public static final char NEED_APPEAR_SYMBOL = '?';
    public static final String INCREASE_TYPE_SPLITOR = "_";
    public static final String RANGE_SEGMENT_SPLITOR = "|";
    public static final String RANGE_SEGMENT_START_END_SPLITOR = "_";

    public AdvancedParameter(String key, Comparable<?> atomicIncreateValue, Integer cumulativeTimes, boolean needAppear, AtomIncreaseType atomicIncreateType, Range[] rangeObjectArray) {
        super(key, needAppear);
        this.atomicIncreateValue = atomicIncreateValue;
        this.atomicIncreateType = atomicIncreateType;
        this.cumulativeTimes = cumulativeTimes;
        this.rangeArray = rangeObjectArray;
        this.needMergeValueInCloseInterval = atomicIncreateValue != null;
    }

    public Set<Object> enumerateRange() {
        HashSet<Object> values = new HashSet<Object>();
        if (this.atomicIncreateType.isTime()) {
            Calendar c = Calendar.getInstance();
            for (Range ro : this.rangeArray) {
                for (int i = ro.start.intValue(); i <= ro.end; ++i) {
                    values.add(this.evalTime(c, i));
                }
            }
        } else {
            for (Range ro : this.rangeArray) {
                for (int i = ro.start.intValue(); i <= ro.end; ++i) {
                    values.add(i);
                }
            }
        }
        return values;
    }

    public Set<Object> enumerateRange(Object basepoint) {
        if (basepoint instanceof Number) {
            return this.enumerateRange(((Number)basepoint).intValue());
        }
        if (basepoint instanceof Calendar) {
            return this.enumerateRange((Calendar)basepoint);
        }
        if (basepoint instanceof Date) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)basepoint);
            return this.enumerateRange(cal);
        }
        throw new IllegalArgumentException(basepoint + " applies on atomicIncreateType: " + (Object)((Object)this.atomicIncreateType));
    }

    public Set<Object> enumerateRange(int basepoint) {
        HashSet<Object> values = new HashSet<Object>();
        if (AtomIncreaseType.NUMBER.equals((Object)this.atomicIncreateType)) {
            int start = basepoint;
            int end = start + this.cumulativeTimes;
            for (int i = start; i <= end; ++i) {
                values.add(i);
            }
        } else {
            throw new IllegalArgumentException("Number applies on atomicIncreateType: " + (Object)((Object)this.atomicIncreateType));
        }
        return values;
    }

    public Set<Object> enumerateRange(Calendar basepoint) {
        HashSet<Object> values = new HashSet<Object>();
        if (this.atomicIncreateType.isTime()) {
            for (int i = 0; i < this.cumulativeTimes; ++i) {
                values.add(this.evalTime(basepoint, i));
            }
        } else {
            throw new IllegalArgumentException("Calendar applies on atomicIncreateType: " + (Object)((Object)this.atomicIncreateType));
        }
        return values;
    }

    private Object evalTime(Calendar base, int i) {
        Calendar c = (Calendar)base.clone();
        if (AtomIncreaseType.YEAR.equals((Object)this.atomicIncreateType)) {
            c.add(1, i);
        } else if (AtomIncreaseType.MONTH.equals((Object)this.atomicIncreateType)) {
            c.add(2, i);
        } else if (AtomIncreaseType.DATE.equals((Object)this.atomicIncreateType)) {
            c.add(5, i);
        } else if (AtomIncreaseType.HOUR.equals((Object)this.atomicIncreateType)) {
            c.add(11, i);
        } else {
            throw new IllegalArgumentException("atomicIncreateType:" + (Object)((Object)this.atomicIncreateType));
        }
        return c.getTime();
    }

    public String toString() {
        return "AdvancedParameter [atomicIncreateValue=" + this.atomicIncreateValue + ", cumulativeTimes=" + this.cumulativeTimes + ", key=" + this.key + ", needMergeValueInCloseInterval=" + this.needMergeValueInCloseInterval + "needAppear=" + this.needAppear + ", atomicIncreateType=" + (Object)((Object)this.atomicIncreateType) + "]";
    }

    public static AdvancedParameter getAdvancedParamByParamTokenNew(String paramToken, boolean completeConfig) {
        String key;
        boolean[] needAppear = new boolean[1];
        AtomIncreaseType atomicIncreateType = null;
        Comparable<Integer> atomicIncreateValue = null;
        Range[] rangeObjectArray = null;
        Integer cumulativeTimes = null;
        String[] paramTokens = StringUtil.split((String)paramToken, (String)PARAM_SEGMENT_SPLITOR);
        switch (paramTokens.length) {
            case 1: {
                if (completeConfig) {
                    throw new IllegalArgumentException("\u89c4\u5219\u5fc5\u987b\u914d\u7f6e\u5b8c\u5168\uff0c\u683c\u5f0f\u5982\u4e0b:#id,1_number,1024#");
                }
                key = AdvancedParameter.parseKeyPart(paramTokens[0], needAppear);
                break;
            }
            case 2: {
                key = AdvancedParameter.parseKeyPart(paramTokens[0], needAppear);
                atomicIncreateType = AtomIncreaseType.NUMBER;
                atomicIncreateValue = 1;
                try {
                    rangeObjectArray = AdvancedParameter.parseRangeArray(paramTokens[1]);
                    cumulativeTimes = AdvancedParameter.getCumulativeTimes(rangeObjectArray[0]);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("\u8f93\u5165\u7684\u53c2\u6570\u4e0d\u4e3aInteger\u7c7b\u578b,\u53c2\u6570\u4e3a:" + paramToken, e);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
            }
            case 3: {
                key = AdvancedParameter.parseKeyPart(paramTokens[0], needAppear);
                try {
                    atomicIncreateType = AdvancedParameter.getIncreaseType(paramTokens[1]);
                    atomicIncreateValue = AdvancedParameter.getAtomicIncreaseValue(paramTokens[1], atomicIncreateType);
                    rangeObjectArray = AdvancedParameter.parseRangeArray(paramTokens[2]);
                    cumulativeTimes = AdvancedParameter.getCumulativeTimes(rangeObjectArray[0]);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("\u8f93\u5165\u7684\u53c2\u6570\u4e0d\u4e3aInteger\u7c7b\u578b,\u53c2\u6570\u4e3a:" + paramToken, e);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
            }
            default: {
                throw new IllegalArgumentException("\u9519\u8bef\u7684\u53c2\u6570\u4e2a\u6570\uff0c\u5fc5\u987b\u4e3a1\u4e2a\u6216\u80053\u4e2a\uff0c3\u4e2a\u7684\u65f6\u5019\u4e3a\u5141\u8bb8\u4f7f\u7528\u679a\u4e3e\u65f6\u7684\u6570\u636e");
            }
        }
        return new AdvancedParameter(key, atomicIncreateValue, cumulativeTimes, needAppear[0], atomicIncreateType, rangeObjectArray);
    }

    private static String parseKeyPart(String keyPart, boolean[] needAppear) {
        String key;
        int endIndex;
        if ((keyPart = keyPart.trim()).charAt(endIndex = keyPart.length() - 1) == '?') {
            needAppear[0] = true;
            key = keyPart.substring(0, endIndex);
        } else {
            needAppear[0] = false;
            key = keyPart;
        }
        return key;
    }

    private static AtomIncreaseType getIncreaseType(String paramTokenStr) {
        String[] increase = StringUtil.split((String)paramTokenStr.trim(), (String)"_");
        if (increase.length == 1) {
            return AtomIncreaseType.NUMBER;
        }
        if (increase.length == 2) {
            return AtomIncreaseType.valueOf(increase[1].toUpperCase());
        }
        throw new IllegalArgumentException("\u81ea\u589e\u914d\u7f6e\u5b9a\u4e49\u9519\u8bef:" + paramTokenStr);
    }

    private static Comparable<?> getAtomicIncreaseValue(String paramTokenStr, AtomIncreaseType type) {
        String[] increase = StringUtil.split((String)paramTokenStr.trim(), (String)"_");
        if (increase.length == 1) {
            return Integer.valueOf(increase[0]);
        }
        if (increase.length == 2) {
            switch (type) {
                case NUMBER: {
                    return Integer.valueOf(increase[0]);
                }
                case DATE: {
                    return new DateEnumerationParameter(Integer.valueOf(increase[0]), 5);
                }
                case MONTH: {
                    return new DateEnumerationParameter(Integer.valueOf(increase[0]), 2);
                }
                case YEAR: {
                    return new DateEnumerationParameter(Integer.valueOf(increase[0]), 1);
                }
                case HOUR: {
                    return new DateEnumerationParameter(Integer.valueOf(increase[0]), 11);
                }
            }
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u81ea\u589e\u7c7b\u578b\uff1a" + (Object)((Object)type));
        }
        throw new IllegalArgumentException("\u81ea\u589e\u914d\u7f6e\u5b9a\u4e49\u9519\u8bef:" + paramTokenStr);
    }

    private static Range[] parseRangeArray(String paramTokenStr) {
        String[] ranges = StringUtil.split((String)paramTokenStr, (String)RANGE_SEGMENT_SPLITOR);
        Range[] rangeObjArray = new Range[ranges.length];
        for (int i = 0; i < ranges.length; ++i) {
            String range = ranges[i].trim();
            String[] startEnd = StringUtil.split((String)range, (String)"_");
            if (startEnd.length == 1) {
                if (i == 0) {
                    rangeObjArray[i] = new Range(0, Integer.valueOf(startEnd[0]));
                    continue;
                }
                rangeObjArray[i] = new Range(AdvancedParameter.fromReadableInt(startEnd[0]), AdvancedParameter.fromReadableInt(startEnd[0]));
                continue;
            }
            if (startEnd.length == 2) {
                rangeObjArray[i] = new Range(AdvancedParameter.fromReadableInt(startEnd[0]), AdvancedParameter.fromReadableInt(startEnd[1]));
                continue;
            }
            throw new IllegalArgumentException("\u8303\u56f4\u5b9a\u4e49\u9519\u8bef," + paramTokenStr);
        }
        return rangeObjArray;
    }

    private static int fromReadableInt(String readableInt) {
        char c = readableInt.charAt(readableInt.length() - 1);
        if (c == 'm' || c == 'M') {
            return Integer.valueOf(readableInt.substring(0, readableInt.length() - 1)) * 1000000;
        }
        if (c == 'g' || c == 'G') {
            return Integer.valueOf(readableInt.substring(0, readableInt.length() - 1)) * 1000000000;
        }
        return Integer.valueOf(readableInt);
    }

    private static Integer getCumulativeTimes(Range ro) {
        return ro.end - ro.start;
    }

    public static class Range {
        public final Integer start;
        public final Integer end;

        public Range(Integer start, Integer end) {
            this.start = start;
            this.end = end;
        }
    }

    public static enum AtomIncreaseType {
        HOUR,
        DATE,
        MONTH,
        YEAR,
        NUMBER;


        public boolean isTime() {
            return this.ordinal() < NUMBER.ordinal();
        }
    }
}

