/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.interact.rule.enumerator;

import com.taobao.tddl.interact.rule.enumerator.CloseIntervalFieldsEnumeratorHandler;
import com.taobao.tddl.interact.rule.enumerator.DatePartDiscontinousRangeEnumerator;
import com.taobao.tddl.interact.rule.enumerator.DefaultEnumerator;
import com.taobao.tddl.interact.rule.enumerator.EnumerationInterruptException;
import com.taobao.tddl.interact.rule.enumerator.Enumerator;
import com.taobao.tddl.interact.rule.enumerator.EnumeratorUtils;
import com.taobao.tddl.interact.rule.enumerator.IntegerPartDiscontinousRangeEnumerator;
import com.taobao.tddl.interact.rule.enumerator.LongPartDiscontinousRangeEnumerator;
import com.taobao.tddl.interact.rule.exception.NotSupportException;
import com.taobao.tddl.interact.sqljep.Comparative;
import com.taobao.tddl.interact.sqljep.ComparativeAND;
import com.taobao.tddl.interact.sqljep.ComparativeBaseList;
import com.taobao.tddl.interact.sqljep.ComparativeOR;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class EnumeratorImp
implements Enumerator {
    private static final String DEFAULT_ENUMERATOR = "DEFAULT_ENUMERATOR";
    protected static final Map<String, CloseIntervalFieldsEnumeratorHandler> enumeratorMap = new HashMap<String, CloseIntervalFieldsEnumeratorHandler>();
    private boolean isDebug;

    public EnumeratorImp() {
        enumeratorMap.put(Integer.class.getName(), new IntegerPartDiscontinousRangeEnumerator());
        enumeratorMap.put(Long.class.getName(), new LongPartDiscontinousRangeEnumerator());
        enumeratorMap.put(BigDecimal.class.getName(), new LongPartDiscontinousRangeEnumerator());
        enumeratorMap.put(java.util.Date.class.getName(), new DatePartDiscontinousRangeEnumerator());
        enumeratorMap.put(Date.class.getName(), new DatePartDiscontinousRangeEnumerator());
        enumeratorMap.put(Timestamp.class.getName(), new DatePartDiscontinousRangeEnumerator());
        enumeratorMap.put(DEFAULT_ENUMERATOR, new DefaultEnumerator());
        this.isDebug = false;
    }

    private CloseIntervalFieldsEnumeratorHandler getCloseIntervalEnumeratorHandlerByComparative(Comparative comp, boolean needMergeValueInCloseInterval) {
        if (!needMergeValueInCloseInterval) {
            return enumeratorMap.get(DEFAULT_ENUMERATOR);
        }
        if (comp == null) {
            throw new IllegalArgumentException("\u4e0d\u77e5\u9053\u5f53\u524d\u503c\u662f\u4ec0\u4e48\u7c7b\u578b\u7684\uff0c\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u679a\u4e3e\u5668" + comp);
        }
        Comparable value = comp.getValue();
        if (value instanceof ComparativeBaseList) {
            ComparativeBaseList comparativeBaseList = (ComparativeBaseList)value;
            Iterator<Comparative> i$ = comparativeBaseList.getList().iterator();
            if (i$.hasNext()) {
                Comparative comparative = i$.next();
                return this.getCloseIntervalEnumeratorHandlerByComparative(comparative, needMergeValueInCloseInterval);
            }
            throw new IllegalStateException("should not be here");
        }
        if (value instanceof Comparative) {
            return this.getCloseIntervalEnumeratorHandlerByComparative(comp, needMergeValueInCloseInterval);
        }
        CloseIntervalFieldsEnumeratorHandler enumeratorHandler = enumeratorMap.get(value.getClass().getName());
        if (enumeratorHandler != null) {
            return enumeratorHandler;
        }
        return enumeratorMap.get(DEFAULT_ENUMERATOR);
    }

    @Override
    public Set<Object> getEnumeratedValue(Comparable condition, Integer cumulativeTimes, Comparable<?> atomIncrValue, boolean needMergeValueInCloseInterval) {
        AbstractSet retValue = null;
        retValue = !this.isDebug ? new HashSet() : new TreeSet();
        try {
            this.process(condition, retValue, cumulativeTimes, atomIncrValue, needMergeValueInCloseInterval);
        }
        catch (EnumerationInterruptException e) {
            this.processAllPassableFields(e.getComparative(), retValue, cumulativeTimes, atomIncrValue, needMergeValueInCloseInterval);
        }
        return retValue;
    }

    private void process(Comparable<?> condition, Set<Object> retValue, Integer cumulativeTimes, Comparable<?> atomIncrValue, boolean needMergeValueInCloseInterval) {
        if (condition == null) {
            retValue.add(null);
        } else if (condition instanceof ComparativeOR) {
            this.processComparativeOR(condition, retValue, cumulativeTimes, atomIncrValue, needMergeValueInCloseInterval);
        } else if (condition instanceof ComparativeAND) {
            this.processComparativeAnd(condition, retValue, cumulativeTimes, atomIncrValue, needMergeValueInCloseInterval);
        } else if (condition instanceof Comparative) {
            this.processComparativeOne(condition, retValue, cumulativeTimes, atomIncrValue, needMergeValueInCloseInterval);
        } else {
            retValue.add(condition);
        }
    }

    private boolean containsEquvilentRelation(Comparative comp) {
        int comparasion = comp.getComparison();
        return comparasion == 3 || comparasion == 2 || comparasion == 8;
    }

    private void processComparativeAnd(Comparable<?> condition, Set<Object> retValue, Integer cumulativeTimes, Comparable<?> atomIncrValue, boolean needMergeValueInCloseInterval) {
        List<Comparative> andList = ((ComparativeAND)condition).getList();
        if (andList.size() == 2) {
            Comparable arg1 = andList.get(0);
            Comparable arg2 = andList.get(1);
            Comparative compArg1 = this.valid2varableInAndIsNotComparativeBaseList(arg1);
            Comparative compArg2 = this.valid2varableInAndIsNotComparativeBaseList(arg2);
            int compResult = 0;
            try {
                compArg1.setValue(EnumeratorUtils.toPrimaryValue(compArg1.getValue()));
                compArg2.setValue(EnumeratorUtils.toPrimaryValue(compArg2.getValue()));
                compResult = compArg1.getValue().compareTo(compArg2.getValue());
            }
            catch (NullPointerException e) {
                throw new RuntimeException("and\u6761\u4ef6\u4e2d\u6709\u4e00\u4e2a\u503c\u4e3anull", e);
            }
            if (compResult == 0) {
                if (this.containsEquvilentRelation(compArg1) && this.containsEquvilentRelation(compArg2)) {
                    retValue.add(compArg1.getValue());
                }
            } else if (compResult < 0) {
                this.processTwoDifferentArgsInComparativeAnd(retValue, compArg1, compArg2, cumulativeTimes, atomIncrValue, needMergeValueInCloseInterval);
            } else {
                this.processTwoDifferentArgsInComparativeAnd(retValue, compArg2, compArg1, cumulativeTimes, atomIncrValue, needMergeValueInCloseInterval);
            }
        } else {
            throw new IllegalArgumentException("\u76ee\u524d\u53ea\u652f\u6301\u4e00\u4e2aand\u8282\u70b9\u4e0a\u6709\u4e24\u4e2a\u5b50\u8282\u70b9");
        }
    }

    private void processTwoDifferentArgsInComparativeAnd(Set<Object> retValue, Comparative from, Comparative to, Integer cumulativeTimes, Comparable<?> atomIncrValue, boolean needMergeValueInCloseInterval) {
        if (EnumeratorImp.isCloseInterval(from, to)) {
            this.mergeFeildOfDefinitionInCloseInterval(from, to, retValue, cumulativeTimes, atomIncrValue, needMergeValueInCloseInterval);
        } else {
            Comparable temp = EnumeratorImp.compareAndGetIntersactionOneValue(from, to);
            if (temp != null) {
                retValue.add(temp);
            } else if (from.getComparison() == 8 || from.getComparison() == 7) {
                if (to.getComparison() == 8 || to.getComparison() == 7) {
                    this.processAllPassableFields(from, retValue, cumulativeTimes, atomIncrValue, needMergeValueInCloseInterval);
                }
            } else if (to.getComparison() == 2 || to.getComparison() == 1) {
                if (from.getComparison() == 2 || from.getComparison() == 1) {
                    this.processAllPassableFields(to, retValue, cumulativeTimes, atomIncrValue, needMergeValueInCloseInterval);
                }
            } else {
                throw new IllegalArgumentException("should not be here");
            }
        }
    }

    protected static Comparable compareAndGetIntersactionOneValue(Comparative from, Comparative to) {
        if (from.getComparison() == 3 && (to.getComparison() == 7 || to.getComparison() == 8)) {
            return from.getValue();
        }
        if (to.getComparison() == 3 && (from.getComparison() == 1 || from.getComparison() == 2)) {
            return to.getValue();
        }
        return null;
    }

    protected static boolean isCloseInterval(Comparative from, Comparative to) {
        int fromComparasion = from.getComparison();
        int toComparasion = to.getComparison();
        return !(fromComparasion != 1 && fromComparasion != 2 || toComparasion != 7 && toComparasion != 8);
    }

    private Comparative valid2varableInAndIsNotComparativeBaseList(Comparable<?> arg) {
        if (arg instanceof ComparativeBaseList) {
            throw new IllegalArgumentException("\u5728\u4e00\u7ec4and\u6761\u4ef6\u4e2d\u53ea\u652f\u6301\u4e24\u4e2a\u8303\u56f4\u7684\u503c\u5171\u540c\u51b3\u5b9a\u5206\u8868\uff0c\u4e0d\u652f\u63013\u4e2a");
        }
        if (arg instanceof Comparative) {
            Comparative comp = (Comparative)arg;
            int comparison = comp.getComparison();
            if (comparison == 0) {
                return this.valid2varableInAndIsNotComparativeBaseList(comp.getValue());
            }
            return comp;
        }
        throw new IllegalArgumentException("input value is not a comparative: " + arg);
    }

    private void processComparativeOne(Comparable<?> condition, Set<Object> retValue, Integer cumulativeTimes, Comparable<?> atomIncrValue, boolean needMergeValueInCloseInterval) {
        Comparative comp = (Comparative)condition;
        int comparison = comp.getComparison();
        switch (comparison) {
            case 0: {
                this.process(comp.getValue(), retValue, cumulativeTimes, atomIncrValue, needMergeValueInCloseInterval);
                break;
            }
            case 3: {
                retValue.add(EnumeratorUtils.toPrimaryValue(comp.getValue()));
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: {
                throw new EnumerationInterruptException(comp);
            }
            default: {
                throw new NotSupportException("not support yet");
            }
        }
    }

    private void processComparativeOR(Comparable<?> condition, Set<Object> retValue, Integer cumulativeTimes, Comparable<?> atomIncrValue, boolean needMergeValueInCloseInterval) {
        List<Comparative> orList = ((ComparativeOR)condition).getList();
        for (Comparative comp : orList) {
            this.process(comp, retValue, cumulativeTimes, atomIncrValue, needMergeValueInCloseInterval);
        }
    }

    private void mergeFeildOfDefinitionInCloseInterval(Comparative from, Comparative to, Set<Object> retValue, Integer cumulativeTimes, Comparable<?> atomIncrValue, boolean needMergeValueInCloseInterval) {
        if (!needMergeValueInCloseInterval) {
            throw new IllegalArgumentException("\u8bf7\u6253\u5f00\u89c4\u5219\u7684needMergeValueInCloseInterval\u9009\u9879\uff0c\u4ee5\u652f\u6301\u5206\u5e93\u5206\u8868\u6761\u4ef6\u4e2d\u4f7f\u7528> < >= <=");
        }
        CloseIntervalFieldsEnumeratorHandler closeIntervalFieldsEnumeratorHandler = this.getCloseIntervalEnumeratorHandlerByComparative(from, needMergeValueInCloseInterval);
        closeIntervalFieldsEnumeratorHandler.mergeFeildOfDefinitionInCloseInterval(from, to, retValue, cumulativeTimes, atomIncrValue);
    }

    private void processAllPassableFields(Comparative source, Set<Object> retValue, Integer cumulativeTimes, Comparable<?> atomIncrValue, boolean needMergeValueInCloseInterval) {
        if (!needMergeValueInCloseInterval) {
            throw new IllegalArgumentException("\u8bf7\u6253\u5f00\u89c4\u5219\u7684needMergeValueInCloseInterval\u9009\u9879\uff0c\u4ee5\u652f\u6301\u5206\u5e93\u5206\u8868\u6761\u4ef6\u4e2d\u4f7f\u7528> < >= <=");
        }
        CloseIntervalFieldsEnumeratorHandler closeIntervalFieldsEnumeratorHandler = this.getCloseIntervalEnumeratorHandlerByComparative(source, needMergeValueInCloseInterval);
        closeIntervalFieldsEnumeratorHandler.processAllPassableFields(source, retValue, cumulativeTimes, atomIncrValue);
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public void setDebug(boolean isDebug) {
        this.isDebug = isDebug;
    }
}

