/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.interact.rule.ruleimpl;

import com.taobao.tddl.interact.rule.Rule;
import com.taobao.tddl.interact.rule.Samples;
import com.taobao.tddl.interact.rule.bean.AdvancedParameter;
import com.taobao.tddl.interact.rule.ruleimpl.ExpressionRule;
import com.taobao.tddl.interact.rule.util.RuleUtils;
import com.taobao.tddl.interact.sqljep.Comparative;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class EnumerativeRule<T>
extends ExpressionRule<T> {
    public static final String REAL_TABLE_NAME_KEY = "REAL_TABLE_NAME";

    public EnumerativeRule(String expression) {
        super(expression);
    }

    @Override
    protected String parseParam(String paramInDoller, Map<String, Rule.RuleColumn> parameters) {
        Rule.RuleColumn ruleColumn = null;
        if (paramInDoller.indexOf(",") == -1) {
            ruleColumn = parameters.get(paramInDoller.trim().toUpperCase());
        }
        if (ruleColumn == null) {
            ruleColumn = AdvancedParameter.getAdvancedParamByParamTokenNew(paramInDoller, true);
            parameters.put(ruleColumn.key, ruleColumn);
        }
        return this.replace(ruleColumn);
    }

    protected abstract String replace(Rule.RuleColumn var1);

    @Override
    public Map<T, Samples> calculate(Map<String, Comparative> sqlArgs, Object ctx, Object outerCtx) {
        Map<String, Set<Object>> enumerates = this.getEnumerates(sqlArgs, ctx);
        HashMap res = new HashMap(1);
        for (Map<String, Object> sample : new Samples(enumerates)) {
            Object value = this.eval(sample, outerCtx);
            if (value == null) {
                throw new IllegalArgumentException("rule eval resulte is null! rule:" + this.expression);
            }
            Samples evalSamples = (Samples)res.get(value);
            if (evalSamples == null) {
                evalSamples = new Samples(sample.keySet());
                res.put(value, evalSamples);
            }
            evalSamples.addSample(sample);
        }
        return res;
    }

    @Override
    public Set<T> calculateNoTrace(Map<String, Comparative> sqlArgs, Object ctx, Object outerCtx) {
        Map<String, Set<Object>> enumerates = this.getEnumerates(sqlArgs, ctx);
        HashSet res = new HashSet(1);
        for (Map<String, Object> sample : new Samples(enumerates)) {
            Object value = this.eval(sample, outerCtx);
            if (value == null) {
                throw new IllegalArgumentException("rule eval resulte is null! rule:" + this.expression);
            }
            res.add(value);
        }
        return res;
    }

    @Override
    public T calculateVnodeNoTrace(String key, Object ctx, Object outerCtx) {
        HashMap<String, Object> sample = new HashMap<String, Object>(1);
        sample.put(REAL_TABLE_NAME_KEY, key);
        Object value = this.eval(sample, outerCtx);
        if (value == null) {
            throw new IllegalArgumentException("rule eval resulte is null! rule:" + this.expression);
        }
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<String, Set<Object>> getEnumerates(Map<String, Comparative> sqlArgs, Object ctx) {
        Map<String, Set<Object>> enumerates;
        Set thisParam = (Set)EnumerativeRule.cast(this.parameterSet);
        Samples.SamplesCtx samplesCtx = (Samples.SamplesCtx)ctx;
        if (samplesCtx == null) return RuleUtils.getSamplingField(sqlArgs, thisParam);
        Samples commonSamples = samplesCtx.samples;
        if (samplesCtx.dealType == 1) {
            HashSet<AdvancedParameter> withoutCommon = new HashSet<AdvancedParameter>(thisParam.size());
            for (AdvancedParameter p : thisParam) {
                if (commonSamples.getSubColumSet().contains(p.key)) continue;
                withoutCommon.add(p);
            }
            enumerates = RuleUtils.getSamplingField(sqlArgs, withoutCommon);
            Iterator<Object> i$ = commonSamples.getSubColumSet().iterator();
            while (i$.hasNext()) {
                String name = (String)i$.next();
                enumerates.put(name, commonSamples.getColumnEnumerates(name));
            }
            return enumerates;
        }
        if (samplesCtx.dealType != 0) throw new IllegalStateException("Should not happen! SamplesCtx.dealType has a new Enum?");
        enumerates = RuleUtils.getSamplingField(sqlArgs, thisParam);
        Iterator<String> i$ = commonSamples.getSubColumSet().iterator();
        while (i$.hasNext()) {
            String diffType = i$.next();
            enumerates.get(diffType).addAll(commonSamples.getColumnEnumerates(diffType));
        }
        return enumerates;
    }

    private static <T> T cast(Object obj) {
        return (T)obj;
    }
}

