/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.interact.rule.ruleimpl;

import com.taobao.tddl.interact.rule.Rule;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class ExpressionRule<T>
implements Rule<T> {
    private static final Pattern DOLLER_PATTERN;
    protected final Map<String, Rule.RuleColumn> parameters;
    protected final Set<Rule.RuleColumn> parameterSet;
    protected String expression;
    protected final String originExpression;

    public ExpressionRule(String expression) {
        this.originExpression = expression;
        this.expression = expression;
        this.parameters = Collections.unmodifiableMap(this.parse());
        this.parameterSet = new HashSet<Rule.RuleColumn>(this.parameters.size());
        this.parameterSet.addAll(this.parameters.values());
    }

    private Map<String, Rule.RuleColumn> parse() {
        HashMap<String, Rule.RuleColumn> parameters = new HashMap<String, Rule.RuleColumn>();
        Matcher matcher = DOLLER_PATTERN.matcher(this.expression);
        int start = 0;
        StringBuffer sb = new StringBuffer();
        while (matcher.find(start)) {
            String realParam = matcher.group();
            realParam = realParam.substring(1, realParam.length() - 1);
            sb.append(this.expression.substring(start, matcher.start()));
            sb.append(this.parseParam(realParam, parameters));
            start = matcher.end();
        }
        sb.append(this.expression.substring(start));
        this.expression = sb.toString();
        return parameters;
    }

    protected abstract String parseParam(String var1, Map<String, Rule.RuleColumn> var2);

    @Override
    public Map<String, Rule.RuleColumn> getRuleColumns() {
        return this.parameters;
    }

    @Override
    public Set<Rule.RuleColumn> getRuleColumnSet() {
        return this.parameterSet;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExpressionRule other = (ExpressionRule)obj;
        return !(this.originExpression == null ? other.originExpression != null : !this.originExpression.equals(other.originExpression));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.originExpression == null ? 0 : this.originExpression.hashCode());
        return result;
    }

    static {
        String regex = System.getProperty("com.taobao.tddl.rule.columnParamRegex", "#.*?#");
        DOLLER_PATTERN = Pattern.compile(regex);
    }
}

