/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.interact.rule.ruleimpl;

import com.taobao.tddl.interact.rule.Rule;
import com.taobao.tddl.interact.rule.ShardingFunction;
import com.taobao.tddl.interact.rule.ruleimpl.EnumerativeRule;
import groovy.lang.GroovyClassLoader;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.control.CompilationFailedException;

public class GroovyRule<T>
extends EnumerativeRule<T> {
    private static final Log logger = LogFactory.getLog(GroovyRule.class);
    private static final String IMPORT_EXTRA_PARAMETER_CONTEXT = "import com.taobao.tddl.interact.rule.bean.ExtraParameterContext;";
    private static final String IMPORT_STATIC_METHOD = "import static com.taobao.tddl.interact.rule.groovy.GroovyStaticMethod.*;";
    private static final Pattern RETURN_WHOLE_WORD_PATTERN = Pattern.compile("\\breturn\\b", 2);
    private String extraPackagesStr;
    private ShardingFunction shardingFunction;

    public GroovyRule(String expression) {
        this(expression, null);
    }

    public GroovyRule(String expression, String extraPackagesStr) {
        super(expression);
        this.extraPackagesStr = extraPackagesStr == null ? "" : extraPackagesStr;
        this.initGroovy();
    }

    private void initGroovy() {
        Class c_groovy;
        if (this.expression == null) {
            throw new IllegalArgumentException("\u672a\u6307\u5b9a expression");
        }
        GroovyClassLoader loader = new GroovyClassLoader(GroovyRule.class.getClassLoader());
        String groovyRule = GroovyRule.getGroovyRule(this.expression, this.extraPackagesStr);
        try {
            c_groovy = loader.parseClass(groovyRule);
        }
        catch (CompilationFailedException e) {
            throw new IllegalArgumentException(groovyRule, e);
        }
        try {
            Object ruleObj = c_groovy.newInstance();
            if (!(ruleObj instanceof ShardingFunction)) {
                throw new IllegalArgumentException("should not be here");
            }
            this.shardingFunction = (ShardingFunction)ruleObj;
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("\u5b9e\u4f8b\u5316\u89c4\u5219\u5bf9\u8c61\u5931\u8d25", t);
        }
    }

    protected static String getGroovyRule(String expression, String extraPackagesStr) {
        StringBuffer sb = new StringBuffer();
        sb.append(extraPackagesStr);
        sb.append(IMPORT_STATIC_METHOD);
        sb.append(IMPORT_EXTRA_PARAMETER_CONTEXT);
        sb.append("public class RULE implements com.taobao.tddl.interact.rule.ShardingFunction").append("{");
        sb.append("public Object eval(Map map, Object outerCtx) {");
        Matcher returnMarcher = RETURN_WHOLE_WORD_PATTERN.matcher(expression);
        if (!returnMarcher.find()) {
            sb.append("return ");
            sb.append(expression);
            sb.append("+\"\";};}");
        } else {
            sb.append(expression);
            sb.append(";};}");
        }
        logger.debug((Object)sb.toString());
        return sb.toString();
    }

    @Override
    protected String replace(Rule.RuleColumn ruleColumn) {
        return "(map.get(\"" + ruleColumn.key + "\"))";
    }

    @Override
    public T eval(Map<String, Object> columnValues, Object outerCtx) {
        try {
            Object value = this.shardingFunction.eval(columnValues, outerCtx);
            if (value == null) {
                throw new IllegalArgumentException("rule eval resulte is null! rule:" + this.expression);
            }
            return (T)value;
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("\u8c03\u7528\u65b9\u6cd5\u5931\u8d25: " + this.expression, t);
        }
    }

    public String toString() {
        return "GroovyRule{expression=" + this.expression + ", parameters=" + this.parameters + "}";
    }
}

