/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.interact.rule.virtualnode;

import com.taobao.tddl.interact.rule.util.VirturalNodeUtil;
import com.taobao.tddl.interact.rule.virtualnode.VirtualNodeMap;
import com.taobao.tddl.interact.rule.virtualnode.WrappedLogic;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DBTableMap
extends WrappedLogic
implements VirtualNodeMap {
    private ConcurrentHashMap<String, String> dbContext = new ConcurrentHashMap();
    private Map<String, String> dbTableMap = new HashMap<String, String>();
    private String logicTable;
    private volatile boolean isInit = false;

    public synchronized void init() {
        if (this.isInit) {
            return;
        }
        this.isInit = true;
        if (null == this.dbTableMap || this.dbTableMap.size() <= 0) {
            throw new IllegalArgumentException("no dbTableMap config at all");
        }
        this.dbContext = (ConcurrentHashMap)VirturalNodeUtil.extraReverseMap(this.dbTableMap);
        this.addLogicTableAndSplitorToKey();
    }

    public void addLogicTableAndSplitorToKey() {
        if (this.tableSlotKeyFormat != null) {
            ConcurrentHashMap<String, String> reKeyMap = new ConcurrentHashMap<String, String>();
            for (Map.Entry<String, String> entry : this.dbContext.entrySet()) {
                String newKey = super.wrapValue(entry.getKey());
                reKeyMap.put(newKey, entry.getValue());
            }
            this.dbContext.clear();
            this.dbContext = reKeyMap;
        } else if (this.logicTable != null) {
            ConcurrentHashMap<String, String> reKeyMap = new ConcurrentHashMap<String, String>();
            for (Map.Entry<String, String> entry : this.dbContext.entrySet()) {
                StringBuilder sb = new StringBuilder(this.logicTable);
                sb.append("_");
                sb.append(entry.getKey());
                reKeyMap.put(sb.toString(), entry.getValue());
            }
            this.dbContext.clear();
            this.dbContext = reKeyMap;
        } else {
            throw new RuntimeException("TableRule no tableSlotKeyFormat property and logicTable is null");
        }
    }

    @Override
    public String getValue(String tableSuffix) {
        return this.dbContext.get(tableSuffix);
    }

    public void setDbTableMap(Map<String, String> dbTableMap) {
        this.dbTableMap = dbTableMap;
    }

    public void setLogicTable(String logicTable) {
        this.logicTable = logicTable;
    }
}

