/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.rule.le;

import com.taobao.tddl.interact.bean.ComparativeMapChoicer;
import com.taobao.tddl.interact.bean.MatcherResult;
import com.taobao.tddl.interact.bean.TargetDB;
import com.taobao.tddl.interact.rule.Rule;
import com.taobao.tddl.interact.rule.VirtualTable;
import com.taobao.tddl.interact.rule.VirtualTableRoot;
import com.taobao.tddl.interact.rule.VirtualTableRule;
import com.taobao.tddl.interact.rule.VirtualTableRuleMatcher;
import com.taobao.tddl.interact.rule.bean.SqlType;
import com.taobao.tddl.rule.le.TddlRuleExtend;
import com.taobao.tddl.rule.le.TddlRuleInner;
import com.taobao.tddl.rule.le.TddlRuleMetaData;
import com.taobao.tddl.rule.le.bean.TargetDatabase;
import com.taobao.tddl.rule.le.exception.ResultCompareDiffException;
import com.taobao.tddl.rule.le.extend.MatchResultCompare;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TddlRule
extends TddlRuleInner
implements TddlRuleExtend,
TddlRuleMetaData {
    private final VirtualTableRuleMatcher matcher = new VirtualTableRuleMatcher();

    @Override
    public Map<String, Set<String>> getTopologyByVersion(String vtab, String version) {
        VirtualTableRoot root = (VirtualTableRoot)this.vtrs.get(version);
        if (root == null) {
            return null;
        }
        VirtualTable vt = (VirtualTable)root.getTableRules().get(vtab);
        if (vt == null) {
            return this.defaultTopology(vtab, root);
        }
        return vt.getActualTopology();
    }

    @Override
    public Set<String> getTableShardColumn(String logicTable) {
        VirtualTable virtualTable;
        HashSet<String> shardColumn = (HashSet<String>)this.shardColumnCache.get(logicTable);
        if (null != shardColumn && !shardColumn.isEmpty()) {
            return shardColumn;
        }
        shardColumn = new HashSet<String>();
        VirtualTableRoot virtualTableRoot = (VirtualTableRoot)this.vtrs.get(this.versionIndex.get(0));
        if (null != virtualTableRoot && virtualTableRoot.getVirtualTableMap().containsKey(logicTable) && null != (virtualTable = (VirtualTable)virtualTableRoot.getVirtualTableMap().get(logicTable))) {
            Map columRule;
            List dbRules = virtualTable.getDbShardRules();
            List tableRules = virtualTable.getTbShardRules();
            if (null != dbRules) {
                for (Rule rule : dbRules) {
                    columRule = rule.getRuleColumns();
                    if (null == columRule || columRule.isEmpty()) continue;
                    shardColumn.addAll(columRule.keySet());
                }
            }
            if (null != tableRules) {
                for (Rule rule : tableRules) {
                    columRule = rule.getRuleColumns();
                    if (null == columRule || columRule.isEmpty()) continue;
                    shardColumn.addAll(columRule.keySet());
                }
            }
        }
        if (!shardColumn.isEmpty()) {
            this.shardColumnCache.put(logicTable, shardColumn);
        }
        return shardColumn;
    }

    @Override
    public Map<String, VirtualTableRoot> getAllVersionedRule() {
        return this.vtrs;
    }

    @Override
    public VirtualTableRoot getLocalRule() {
        if (this.vtr == null) {
            return null;
        }
        return this.vtr;
    }

    @Override
    public Map<String, Set<String>> getLocalRuleTopology(String vtab) {
        if (this.vtr == null) {
            return null;
        }
        VirtualTable vt = (VirtualTable)this.vtr.getTableRules().get(vtab);
        if (vt == null) {
            return this.defaultTopology(vtab, this.vtr);
        }
        return vt.getActualTopology();
    }

    @Override
    public List<TargetDB> routeWithTargetDbResult(String vtab, ComparativeMapChoicer choicer) {
        return this.route0(vtab, choicer, this.vtr);
    }

    @Override
    public Map<String, List<TargetDatabase>> routeMultiVersion(String vtab, ComparativeMapChoicer choicer) {
        if (this.vtr != null && this.vtrs.size() == 0) {
            throw new RuntimeException("routeWithMulVersion method just support multy version rule,use route method instead or config with multy version style!");
        }
        HashMap<String, List<TargetDatabase>> results = new HashMap<String, List<TargetDatabase>>();
        for (Map.Entry entry : this.vtrs.entrySet()) {
            List dbs;
            VirtualTableRoot virtualTableRoot = (VirtualTableRoot)entry.getValue();
            VirtualTable rule = virtualTableRoot.getVirtualTable(vtab);
            if (rule == null) {
                dbs = this.defaultRoute(vtab, virtualTableRoot);
            } else {
                MatcherResult result = this.matcher.match(true, choicer, null, (VirtualTableRule)rule);
                if (result == null) continue;
                dbs = result.getCalculationResult();
            }
            List<TargetDatabase> re = this.convert2TargetDatabase(dbs);
            results.put((String)entry.getKey(), re);
        }
        return results;
    }

    @Override
    public List<TargetDatabase> route(String vtab, String conditionStr) {
        return this.route(vtab, conditionStr, this.vtr);
    }

    @Override
    public List<TargetDB> routeWithTargetDbResult(String vtab, String conditionStr) {
        return this.route0(vtab, conditionStr, this.vtr);
    }

    @Override
    public Map<String, List<TargetDatabase>> routeMultiVersion(String vtab, String conditionStr) {
        ComparativeMapChoicer choicer = this.generateComparativeMapChoicer(conditionStr);
        return this.routeMultiVersion(vtab, choicer);
    }

    @Override
    public List<TargetDatabase> routeWithSpecifyRuleVersion(String vtab, String conditionStr, String version) {
        if (this.vtr != null && this.vtrs.size() == 0) {
            throw new RuntimeException("routeWithMulVersion method just support multy version rule,use route method instead or config with multy version style!");
        }
        return this.route(vtab, conditionStr, (VirtualTableRoot)this.vtrs.get(version));
    }

    @Override
    public List<TargetDB> routeMultiVersionAndCompareT(SqlType sqlType, String vtab, String conditionStr) throws ResultCompareDiffException {
        return this.routeMultiVersionAndCompareT(sqlType, vtab, conditionStr, null, null);
    }

    @Override
    public List<TargetDB> routeMultiVersionAndCompareT(SqlType sqlType, String vtab, String conditionStr, String oriDb, String oriTable) throws ResultCompareDiffException {
        if (this.vtr != null && this.vtrs.size() == 0) {
            throw new RuntimeException("routeWithMulVersion method just support multy version rule,use route method instead or config with multy version style!");
        }
        if (this.vtrs.size() == 1) {
            return this.route0(vtab, conditionStr, (VirtualTableRoot)this.vtrs.get(this.versionIndex.get(0)));
        }
        if (this.vtrs.size() != 2 || this.versionIndex.size() != 2) {
            throw new RuntimeException("not support more than 2 copy rule compare");
        }
        VirtualTableRoot oldVirtualTableRoot = (VirtualTableRoot)this.vtrs.get(this.versionIndex.get(0));
        VirtualTable oldRule = oldVirtualTableRoot.getVirtualTable(vtab);
        List<TargetDB> oldTarget = null;
        oldTarget = oldRule == null ? this.defaultRoute(vtab, oldVirtualTableRoot) : this.getTargetDb(oldRule, conditionStr);
        if (sqlType.equals((Object)SqlType.SELECT) || sqlType.equals((Object)SqlType.SELECT_FOR_UPDATE)) {
            return oldTarget;
        }
        VirtualTableRoot newVirtualTableRoot = (VirtualTableRoot)this.vtrs.get(this.versionIndex.get(1));
        VirtualTable newRule = newVirtualTableRoot.getVirtualTable(vtab);
        List<TargetDB> newTarget = null;
        newTarget = oldRule == null ? this.defaultRoute(vtab, oldVirtualTableRoot) : this.getTargetDb(newRule, conditionStr);
        boolean compareResult = MatchResultCompare.targetDbCompare(newTarget, oldTarget, oriDb, oriTable);
        if (compareResult) {
            return oldTarget;
        }
        throw new ResultCompareDiffException("sql type is not-select,rule calculate result diff");
    }

    public List<TargetDatabase> convert2TargetDatabase(List<TargetDB> dbs) {
        ArrayList<TargetDatabase> re = new ArrayList<TargetDatabase>();
        for (TargetDB db : dbs) {
            TargetDatabase td = new TargetDatabase();
            td.setDbIndex(db.getDbIndex());
            td.setTableNames(new ArrayList<String>(db.getTableNames()));
            td.setTableNamesWithSourceKeys(db.getTableNameMap());
            re.add(td);
        }
        return re;
    }

    private List<TargetDB> getTargetDb(VirtualTable rule, String conditionStr) {
        ComparativeMapChoicer choicer = this.generateComparativeMapChoicer(conditionStr);
        MatcherResult result = this.matcher.match(true, choicer, null, (VirtualTableRule)rule);
        if (result != null) {
            return result.getCalculationResult();
        }
        return null;
    }

    private List<TargetDatabase> route(String vtab, String conditionStr, VirtualTableRoot vtrCurrent) {
        List<TargetDB> dbs = this.route0(vtab, conditionStr, vtrCurrent);
        if (dbs != null) {
            ArrayList<TargetDatabase> re = new ArrayList<TargetDatabase>();
            for (TargetDB db : dbs) {
                TargetDatabase td = new TargetDatabase();
                td.setDbIndex(db.getDbIndex());
                td.setTableNames(new ArrayList<String>(db.getTableNames()));
                td.setTableNamesWithSourceKeys(db.getTableNameMap());
                re.add(td);
            }
            return re;
        }
        return null;
    }

    private List<TargetDB> route0(String vtab, String conditionStr, VirtualTableRoot vtrCurrent) {
        ComparativeMapChoicer choicer = this.generateComparativeMapChoicer(conditionStr);
        return this.route0(vtab, choicer, vtrCurrent);
    }

    private List<TargetDB> route0(String vtab, ComparativeMapChoicer choicer, VirtualTableRoot vtrCurrent) {
        VirtualTable rule = vtrCurrent.getVirtualTable(vtab);
        if (rule == null) {
            return this.defaultRoute(vtab, vtrCurrent);
        }
        MatcherResult result = this.matcher.match(true, choicer, null, (VirtualTableRule)rule);
        if (result != null) {
            return result.getCalculationResult();
        }
        return null;
    }

    private List<TargetDB> defaultRoute(String vtab, VirtualTableRoot vtrCurrent) {
        ArrayList<TargetDB> result = new ArrayList<TargetDB>(1);
        TargetDB targetDb = new TargetDB();
        targetDb.setDbIndex(this.getDefaultDbIndex(vtab, vtrCurrent));
        HashMap<String, Object> tableNames = new HashMap<String, Object>(1);
        tableNames.put(vtab, null);
        targetDb.setTableNames(tableNames);
        result.add(targetDb);
        return result;
    }

    private Map<String, Set<String>> defaultTopology(String vtab, VirtualTableRoot vtrCurrent) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>(1);
        HashSet<String> tables = new HashSet<String>();
        tables.add(vtab);
        result.put(this.getDefaultDbIndex(vtab, vtrCurrent), tables);
        return result;
    }

    private String getDefaultDbIndex(String vtab, VirtualTableRoot vtrCurrent) {
        Map dbIndexMap = vtrCurrent.getDbIndexMap();
        if (dbIndexMap != null && dbIndexMap.get(vtab) != null) {
            return (String)dbIndexMap.get(vtab);
        }
        return vtrCurrent.getDefaultDbIndex();
    }
}

