/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.rule.le;

import com.taobao.tddl.interact.bean.ComparativeMapChoicer;
import com.taobao.tddl.interact.monitor.TotalStatMonitor;
import com.taobao.tddl.interact.rule.VirtualTableRoot;
import com.taobao.tddl.rule.le.SimpleComparativeMapChoicer;
import com.taobao.tddl.rule.le.bean.RuleChangeListener;
import com.taobao.tddl.rule.le.config.ConfigDataHandler;
import com.taobao.tddl.rule.le.config.ConfigDataHandlerFactory;
import com.taobao.tddl.rule.le.config.ConfigDataListener;
import com.taobao.tddl.rule.le.config.impl.DefaultConfigDataHandlerFactory;
import com.taobao.tddl.rule.le.util.StringXmlApplicationContext;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class TddlRuleConfig {
    protected static Log logger = LogFactory.getLog(TddlRuleConfig.class);
    private static final String NONE_RULE_VERSION = null;
    private static final String TDDL_RULE_LE_PREFIX = "com.taobao.tddl.rule.le.";
    private static final String TDDL_RULE_LE_VERSIONS_FORMAT = "com.taobao.tddl.rule.le.{0}.versions";
    private String appName;
    private volatile ConfigDataHandlerFactory cdhf;
    private String appRuleFile;
    private String appRuleString;
    private ConfigDataHandler versionHandler;
    private Map<String, ConfigDataHandler> ruleHandlers = new HashMap<String, ConfigDataHandler>();
    protected Map<String, VirtualTableRoot> vtrs = new HashMap<String, VirtualTableRoot>();
    protected Map<String, String> ruleStrs = new HashMap<String, String>();
    private List<RuleChangeListener> listeners = new ArrayList<RuleChangeListener>();
    protected Map<Integer, String> versionIndex = new HashMap<Integer, String>();
    private Map<String, AbstractXmlApplicationContext> oldCtxs = new HashMap<String, AbstractXmlApplicationContext>();
    protected VirtualTableRoot vtr = null;
    protected String ruleStr = null;
    private AbstractXmlApplicationContext oldCtx;
    protected volatile Map<String, Set<String>> shardColumnCache = new HashMap<String, Set<String>>();
    public static final TotalStatMonitor statMonitor = TotalStatMonitor.getInstance();
    private ClassLoader outerClassLoader = null;

    public void init() {
        statMonitor.setAppName(this.appName);
        statMonitor.start();
        if (this.appRuleFile != null) {
            String[] rulePaths = this.appRuleFile.split(";");
            if (rulePaths.length == 1 && !rulePaths[0].matches("^V[0-9]*#.+$")) {
                ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext(this.appRuleFile){

                    public ClassLoader getClassLoader() {
                        if (TddlRuleConfig.this.outerClassLoader == null) {
                            return super.getClassLoader();
                        }
                        return TddlRuleConfig.this.outerClassLoader;
                    }
                };
                this.vtr = (VirtualTableRoot)ctx.getBean("vtabroot");
            } else {
                for (int i = 0; i < rulePaths.length; ++i) {
                    if (rulePaths[i].matches("^V[0-9]*#.+$")) continue;
                    throw new RuntimeException("rule file path \"" + rulePaths[i] + " \" does not fit the pattern!");
                }
                HashMap<Integer, String> tempIndexMap = new HashMap<Integer, String>();
                for (int i = 0; i < rulePaths.length; ++i) {
                    String rulePath = rulePaths[i];
                    String[] temp = rulePath.split("#");
                    ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext(temp[1]){

                        public ClassLoader getClassLoader() {
                            if (TddlRuleConfig.this.outerClassLoader == null) {
                                return super.getClassLoader();
                            }
                            return TddlRuleConfig.this.outerClassLoader;
                        }
                    };
                    tempIndexMap.put(i, temp[0]);
                    this.vtrs.put(temp[0], (VirtualTableRoot)ctx.getBean("vtabroot"));
                }
                this.versionIndex = tempIndexMap;
            }
        } else if (this.appRuleString != null) {
            StringXmlApplicationContext ctx = new StringXmlApplicationContext(this.appRuleString, this.outerClassLoader);
            this.vtr = (VirtualTableRoot)ctx.getBean("vtabroot");
            this.ruleStr = this.appRuleString;
        } else if (this.appName != null) {
            String versionsDataId = new MessageFormat(TDDL_RULE_LE_VERSIONS_FORMAT).format(new Object[]{this.appName});
            this.cdhf = new DefaultConfigDataHandlerFactory();
            this.versionHandler = this.cdhf.getConfigDataHandler(versionsDataId, new VersionsConfigListener());
            String versionData = this.versionHandler.getData(10000L, "firstCache");
            if (versionData == null) {
                String dataId = TDDL_RULE_LE_PREFIX + this.appName;
                if (!this.dataSub(dataId, NONE_RULE_VERSION, new SingleRuleConfigListener())) {
                    throw new RuntimeException("subscribe the rule data or init rule error!check the error log!");
                }
            } else {
                String[] versions = versionData.split(",");
                int index = 0;
                HashMap<Integer, String> tempIndexMap = new HashMap<Integer, String>();
                for (String version : versions) {
                    String dataId = TDDL_RULE_LE_PREFIX + this.appName + "." + version;
                    if (!this.dataSub(dataId, version, new SingleRuleConfigListener())) {
                        throw new RuntimeException("subscribe the rule data or init rule error!check the error log! the rule version is:" + version);
                    }
                    tempIndexMap.put(index, version);
                    ++index;
                }
                this.versionIndex = tempIndexMap;
                TotalStatMonitor.recieveRuleLog((String)versionData);
            }
        }
    }

    public void destory() {
        if (this.versionHandler != null) {
            this.versionHandler.closeUnderManager();
        }
        for (ConfigDataHandler ruleListener : this.ruleHandlers.values()) {
            ruleListener.closeUnderManager();
        }
    }

    public String getOldRuleStr() {
        if (this.ruleStrs != null && this.ruleStrs.size() > 0) {
            String ruleStr = this.ruleStrs.get(this.versionIndex.get(0));
            return ruleStr;
        }
        if (this.ruleStr != null) {
            return this.ruleStr;
        }
        throw new RuntimeException("\u89c4\u5219\u5bf9\u8c61\u4e3a\u7a7a!\u8bf7\u68c0\u67e5diamond\u4e0a\u662f\u5426\u5b58\u5728\u52a8\u6001\u89c4\u5219!");
    }

    private boolean dataSub(String dataId, String version, ConfigDataListener listener) {
        ConfigDataHandler ruleHandler = this.cdhf.getConfigDataHandler(dataId, listener);
        String data = null;
        try {
            data = ruleHandler.getData(10000L, "firstCache");
        }
        catch (Exception e) {
            logger.error((Object)"get diamond data error!", (Throwable)e);
            ruleHandler.closeUnderManager();
            return false;
        }
        if (data == null) {
            logger.error((Object)"use diamond rule config,but recieve no config at all!");
            ruleHandler.closeUnderManager();
            return false;
        }
        if (this.configInit(data, version)) {
            if (version != null) {
                this.ruleHandlers.put(version, ruleHandler);
            }
            return true;
        }
        ruleHandler.closeUnderManager();
        return false;
    }

    private synchronized boolean configInit(String data, String version) {
        StringXmlApplicationContext ctx = null;
        try {
            ctx = new StringXmlApplicationContext(data, this.outerClassLoader);
        }
        catch (Exception e) {
            logger.error((Object)"rule content error,can not convert to spring ApplicationContext", (Throwable)e);
            return false;
        }
        VirtualTableRoot tempvtr = (VirtualTableRoot)ctx.getBean("vtabroot");
        if (version != null && tempvtr != null) {
            this.vtrs.put(version, tempvtr);
            this.ruleStrs.put(version, data);
            this.oldCtx = this.oldCtxs.get(version);
            if (this.oldCtx != null) {
                this.oldCtx.close();
            }
            this.oldCtxs.remove(version);
            this.oldCtxs.put(version, ctx);
        } else if (tempvtr != null) {
            this.vtr = tempvtr;
            this.ruleStr = data;
            if (this.oldCtx != null) {
                this.oldCtx.close();
            }
            this.oldCtx = ctx;
        } else {
            logger.error((Object)"rule no vtabroot!!");
            return false;
        }
        return true;
    }

    protected ComparativeMapChoicer generateComparativeMapChoicer(String conditionStr) {
        SimpleComparativeMapChoicer mc = new SimpleComparativeMapChoicer();
        mc.addComparatives(conditionStr);
        return mc;
    }

    public void setAppRuleFile(String appRuleFile) {
        this.appRuleFile = appRuleFile;
    }

    public void setAppRuleString(String appRuleString) {
        this.appRuleString = appRuleString;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setOuterClassLoader(ClassLoader outerClassLoader) {
        this.outerClassLoader = outerClassLoader;
    }

    public void addRuleChangeListener(RuleChangeListener listener) {
        this.listeners.add(listener);
    }

    private class VersionsConfigListener
    implements ConfigDataListener {
        private ReentrantLock lock = new ReentrantLock();

        private VersionsConfigListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDataRecieved(String dataId, String data) {
            try {
                this.lock.lock();
                if (data != null && !data.equals("")) {
                    StringBuilder sb = new StringBuilder("recieve versions data!dataId:");
                    sb.append(dataId);
                    sb.append(" data:");
                    sb.append(data);
                    logger.info((Object)sb.toString());
                    String[] versions = data.split(",");
                    HashMap<String, String> checkMap = new HashMap<String, String>();
                    int index = 0;
                    HashMap<Integer, String> tempIndexMap = new HashMap<Integer, String>();
                    for (String version : versions) {
                        String ruleDataId;
                        if (TddlRuleConfig.this.ruleHandlers.get(version) == null && !TddlRuleConfig.this.dataSub(ruleDataId = TddlRuleConfig.TDDL_RULE_LE_PREFIX + TddlRuleConfig.this.appName + "." + version, version, new SingleRuleConfigListener())) {
                            return;
                        }
                        checkMap.put(version, version);
                        tempIndexMap.put(index, version);
                        ++index;
                    }
                    ArrayList needRemove = new ArrayList();
                    for (Map.Entry handler : TddlRuleConfig.this.ruleHandlers.entrySet()) {
                        if (checkMap.get(handler.getKey()) != null) continue;
                        needRemove.add(handler.getKey());
                    }
                    for (String version : needRemove) {
                        ConfigDataHandler handler = (ConfigDataHandler)TddlRuleConfig.this.ruleHandlers.get(version);
                        handler.closeUnderManager();
                        TddlRuleConfig.this.ruleHandlers.remove(version);
                        TddlRuleConfig.this.vtrs.remove(version);
                        TddlRuleConfig.this.ruleStrs.remove(version);
                        ((AbstractXmlApplicationContext)TddlRuleConfig.this.oldCtxs.get(version)).close();
                        TddlRuleConfig.this.oldCtxs.remove(version);
                    }
                    TddlRuleConfig.this.versionIndex = tempIndexMap;
                    for (RuleChangeListener listener : TddlRuleConfig.this.listeners) {
                        try {
                            listener.onRuleRecieve(TddlRuleConfig.this.getOldRuleStr());
                        }
                        catch (Exception e) {
                            logger.error((Object)"one listener error!", (Throwable)e);
                        }
                    }
                    TddlRuleConfig.this.shardColumnCache.clear();
                }
                TotalStatMonitor.recieveRuleLog((String)data);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private class SingleRuleConfigListener
    implements ConfigDataListener {
        private ReentrantLock lock = new ReentrantLock();

        private SingleRuleConfigListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDataRecieved(String dataId, String data) {
            try {
                this.lock.lock();
                if (data != null && !data.equals("")) {
                    StringBuilder sb = new StringBuilder("recieve data!dataId:");
                    sb.append(dataId);
                    sb.append(" data:");
                    sb.append(data);
                    logger.info((Object)sb.toString());
                    String prefix = TddlRuleConfig.TDDL_RULE_LE_PREFIX + TddlRuleConfig.this.appName + ".";
                    int i = dataId.indexOf(prefix);
                    if (i < 0) {
                        if (TddlRuleConfig.this.configInit(data, null)) {
                            for (RuleChangeListener listener : TddlRuleConfig.this.listeners) {
                                try {
                                    listener.onRuleRecieve(data);
                                }
                                catch (Exception e) {
                                    logger.error((Object)"one listener error!", (Throwable)e);
                                }
                            }
                        }
                    } else {
                        String version = dataId.substring(i + prefix.length());
                        if (TddlRuleConfig.this.configInit(data, version)) {
                            for (RuleChangeListener listener : TddlRuleConfig.this.listeners) {
                                try {
                                    listener.onRuleRecieve(TddlRuleConfig.this.getOldRuleStr());
                                }
                                catch (Exception e) {
                                    logger.error((Object)"one listener error!", (Throwable)e);
                                }
                            }
                        }
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

