/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.rule.le;

import com.taobao.tddl.interact.bean.ComparativeMapChoicer;
import com.taobao.tddl.interact.bean.MatcherResult;
import com.taobao.tddl.interact.rule.VirtualTable;
import com.taobao.tddl.interact.rule.VirtualTableRoot;
import com.taobao.tddl.interact.rule.VirtualTableRule;
import com.taobao.tddl.interact.rule.VirtualTableRuleMatcher;
import com.taobao.tddl.interact.rule.bean.SqlType;
import com.taobao.tddl.rule.le.TddlRuleConfig;
import com.taobao.tddl.rule.le.exception.ResultCompareDiffException;
import com.taobao.tddl.rule.le.extend.MatchResultCompare;
import com.taobao.tddl.rule.le.inter.TddlRuleTddl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TddlRuleInner
extends TddlRuleConfig
implements TddlRuleTddl {
    private final VirtualTableRuleMatcher matcher = new VirtualTableRuleMatcher();

    @Override
    public MatcherResult route(String vtab, ComparativeMapChoicer choicer, List<Object> args, boolean needSourceKey) {
        VirtualTable rule = this.vtr.getVirtualTable(vtab);
        MatcherResult result = this.matcher.match(needSourceKey, choicer, args, (VirtualTableRule)rule);
        return result;
    }

    @Override
    public Map<String, MatcherResult> routeMVer(String vtab, ComparativeMapChoicer choicer, List<Object> args, boolean needSourceKey) {
        if (this.vtr != null && this.vtrs.size() == 0) {
            throw new RuntimeException("routeWithMulVersion method just support multy version rule,use route method instead or config with multy version style!");
        }
        HashMap<String, MatcherResult> results = new HashMap<String, MatcherResult>();
        for (Map.Entry entry : this.vtrs.entrySet()) {
            VirtualTable rule = ((VirtualTableRoot)entry.getValue()).getVirtualTable(vtab);
            MatcherResult result = this.matcher.match(needSourceKey, choicer, args, (VirtualTableRule)rule);
            results.put((String)entry.getKey(), result);
        }
        return results;
    }

    @Override
    public MatcherResult route(String vtab, ComparativeMapChoicer choicer, List<Object> args, boolean needSourceKey, VirtualTableRoot specifyVtr) {
        VirtualTable rule = specifyVtr.getVirtualTable(vtab);
        MatcherResult result = this.matcher.match(needSourceKey, choicer, args, (VirtualTableRule)rule);
        return result;
    }

    @Override
    public MatcherResult routeMVerAndCompare(SqlType sqlType, String vtab, ComparativeMapChoicer choicer, List<Object> args, boolean needSourceKey) throws ResultCompareDiffException {
        return this.routeMVerAndCompare(sqlType, vtab, choicer, args, needSourceKey, null, null);
    }

    @Override
    public MatcherResult routeMVerAndCompare(SqlType sqlType, String vtab, ComparativeMapChoicer choicer, List<Object> args, boolean needSourceKey, String oriDb, String oriTable) throws ResultCompareDiffException {
        if (this.vtr != null && this.vtrs.size() == 0) {
            throw new RuntimeException("routeWithMulVersion method just support multy version rule,use route method instead or config with multy version style!");
        }
        if (this.vtrs.size() == 1) {
            return this.route(vtab, choicer, args, needSourceKey, (VirtualTableRoot)this.vtrs.get(this.versionIndex.get(0)));
        }
        if (this.vtrs.size() != 2 || this.versionIndex.size() != 2) {
            throw new RuntimeException("not support more than 2 copy rule compare");
        }
        MatcherResult oldResult = this.route(vtab, choicer, args, needSourceKey, (VirtualTableRoot)this.vtrs.get(this.versionIndex.get(0)));
        if (sqlType.equals((Object)SqlType.SELECT) || sqlType.equals((Object)SqlType.SELECT_FOR_UPDATE)) {
            return oldResult;
        }
        MatcherResult newResult = this.route(vtab, choicer, args, needSourceKey, (VirtualTableRoot)this.vtrs.get(this.versionIndex.get(1)));
        boolean compareResult = MatchResultCompare.matchResultCompare(newResult, oldResult, oriDb, oriTable);
        if (compareResult) {
            return oldResult;
        }
        throw new ResultCompareDiffException("sql type is not-select,rule calculate result diff");
    }

    @Override
    public boolean isBroadCast(String logicName) {
        if (this.vtrs.size() == 1) {
            return this.isBroadCast(logicName, (VirtualTableRoot)this.vtrs.get(this.versionIndex.get(0)));
        }
        if (this.vtrs.size() != 2 || this.versionIndex.size() != 2) {
            throw new RuntimeException("not support more than 2 copy rule compare");
        }
        return this.isBroadCast(logicName, (VirtualTableRoot)this.vtrs.get(this.versionIndex.get(0)));
    }

    public boolean isBroadCast(String logicName, VirtualTableRoot specifyVtr) {
        VirtualTable rule = specifyVtr.getVirtualTable(logicName);
        return rule.isBroadcast();
    }

    @Override
    public boolean isInTheSameJoinGroup(List<String> logicNames) {
        if (this.vtrs.size() == 1) {
            return this.isInTheSameJoinGroup(logicNames, (VirtualTableRoot)this.vtrs.get(this.versionIndex.get(0)));
        }
        if (this.vtrs.size() != 2 || this.versionIndex.size() != 2) {
            throw new RuntimeException("not support more than 2 copy rule compare");
        }
        return this.isInTheSameJoinGroup(logicNames, (VirtualTableRoot)this.vtrs.get(this.versionIndex.get(0)));
    }

    private boolean isInTheSameJoinGroup(List<String> logicNames, VirtualTableRoot specifyVtr) {
        boolean isInTheSameJoinGroup = true;
        String tempJoinGroup = null;
        boolean firstLoop = true;
        for (String logicName : logicNames) {
            VirtualTable rule = specifyVtr.getVirtualTable(logicName);
            if (rule == null) {
                logger.info((Object)("can't find table or index : " + logicName + ". tables  : " + specifyVtr.getVirtualTableMap()));
                return false;
            }
            if (firstLoop) {
                firstLoop = false;
                tempJoinGroup = rule.getJoinGroup();
                continue;
            }
            if (tempJoinGroup == null) {
                isInTheSameJoinGroup = false;
                break;
            }
            if (tempJoinGroup.equalsIgnoreCase(rule.getJoinGroup())) continue;
            isInTheSameJoinGroup = false;
            break;
        }
        return isInTheSameJoinGroup;
    }

    @Override
    public boolean isInTheSameJoinGroup(String leftLogicName, String rightLogicName) {
        ArrayList<String> logicNames = new ArrayList<String>(2);
        logicNames.add(leftLogicName);
        logicNames.add(rightLogicName);
        return this.isInTheSameJoinGroup(logicNames);
    }
}

