/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.rule.le.config.diamond;

import com.taobao.diamond.manager.DiamondManager;
import com.taobao.diamond.manager.ManagerListener;
import com.taobao.diamond.manager.impl.DefaultDiamondManager;
import com.taobao.tddl.rule.le.config.ConfigDataHandler;
import com.taobao.tddl.rule.le.config.ConfigDataListener;
import com.taobao.tddl.rule.le.config.diamond.DiamondConfig;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DiamondConfigDataHandler
implements ConfigDataHandler {
    private static final Log logger = LogFactory.getLog(DiamondConfigDataHandler.class);
    private DiamondManager diamondManager;
    private String dataId;

    @Override
    public void init(final String dataId, final List<ConfigDataListener> configDataListenerList, final Map<String, Object> config) {
        DiamondConfig.handleConfig(config);
        DefaultDiamondManager.Builder builder = new DefaultDiamondManager.Builder(dataId, new ManagerListener(){

            public void receiveConfigInfo(String date) {
                for (ConfigDataListener configDataListener : configDataListenerList) {
                    configDataListener.onDataRecieved(dataId, date);
                }
            }

            public Executor getExecutor() {
                return (Executor)config.get("executor");
            }
        });
        String group = (String)config.get("group");
        if (null != group) {
            builder.setGroup(group);
        }
        this.diamondManager = builder.build();
        this.dataId = dataId;
    }

    @Override
    public String getData(long timeout, String strategy) {
        if (strategy != null && strategy.equals("firstCache")) {
            return this.diamondManager.getAvailableConfigureInfomation(timeout);
        }
        if (strategy != null && strategy.equals("firstServer")) {
            return this.diamondManager.getConfigureInfomation(timeout);
        }
        return null;
    }

    @Override
    public void addListener(final ConfigDataListener configDataListener, final Executor executor) {
        this.diamondManager.setManagerListener(new ManagerListener(){

            public void receiveConfigInfo(String date) {
                configDataListener.onDataRecieved(DiamondConfigDataHandler.this.dataId, date);
            }

            public Executor getExecutor() {
                return executor;
            }
        });
    }

    @Override
    public void addListeners(final List<ConfigDataListener> configDataListenerList, final Executor executor) {
        this.diamondManager.setManagerListener(new ManagerListener(){

            public void receiveConfigInfo(String date) {
                for (ConfigDataListener configDataListener : configDataListenerList) {
                    try {
                        configDataListener.onDataRecieved(DiamondConfigDataHandler.this.dataId, date);
                    }
                    catch (Exception e) {
                        logger.error((Object)"one of listener failed", (Throwable)e);
                    }
                }
            }

            public Executor getExecutor() {
                return executor;
            }
        });
    }

    @Override
    public void closeUnderManager() {
        this.diamondManager.close();
    }
}

