/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.rule.le.extend;

import com.taobao.tddl.interact.bean.MatcherResult;
import com.taobao.tddl.interact.bean.TargetDB;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MatchResultCompare {
    public static boolean matchResultCompare(MatcherResult resultNew, MatcherResult resultOld) {
        return MatchResultCompare.matchResultCompare(resultNew, resultOld, null, null);
    }

    public static boolean matchResultCompare(MatcherResult resultNew, MatcherResult resultOld, String oriDb, String oriTable) {
        List targetNew = resultNew.getCalculationResult();
        List targetOld = resultOld.getCalculationResult();
        return MatchResultCompare.innerCompare(targetNew, targetOld, oriDb, oriTable);
    }

    public static boolean oriDbTabCompareWithMatchResult(MatcherResult resultNew, String oriDb, String oriTable) {
        List targetNew = resultNew.getCalculationResult();
        Map<String, Map<String, String>> dbTabMap = MatchResultCompare.getTargetMap(targetNew);
        Map<String, String> tables = dbTabMap.get(oriDb);
        if (tables == null) {
            return false;
        }
        return tables.get(oriTable) != null;
    }

    public static boolean targetDbCompare(List<TargetDB> targetNew, List<TargetDB> targetOld) {
        return MatchResultCompare.targetDbCompare(targetNew, targetOld, null, null);
    }

    public static boolean targetDbCompare(List<TargetDB> targetNew, List<TargetDB> targetOld, String oriDb, String oriTable) {
        return MatchResultCompare.innerCompare(targetNew, targetOld, oriDb, oriTable);
    }

    public static boolean oriDbTabCompareWithTargetDb(List<TargetDB> targetNew, String oriDb, String oriTable) {
        Map<String, Map<String, String>> dbTabMap = MatchResultCompare.getTargetMap(targetNew);
        Map<String, String> tables = dbTabMap.get(oriDb);
        if (tables == null) {
            return false;
        }
        return tables.get(oriTable) != null;
    }

    private static boolean innerCompare(List<TargetDB> targetNew, List<TargetDB> targetOld, String oriDb, String oriTable) {
        Map<String, Map<String, String>> newOne = MatchResultCompare.getTargetMap(targetNew);
        Map<String, Map<String, String>> oldOne = MatchResultCompare.getTargetMap(targetOld);
        boolean dbDiff = false;
        boolean tbDiff = false;
        for (Map.Entry<String, Map<String, String>> entry : newOne.entrySet()) {
            Map<String, String> oldTables = oldOne.get(entry.getKey());
            if (oldTables != null) {
                String tb;
                for (Map.Entry<String, String> newTbEntry : entry.getValue().entrySet()) {
                    tb = oldTables.get(newTbEntry.getKey());
                    if (tb != null) continue;
                    tbDiff = true;
                }
                for (Map.Entry<String, String> oldTbEntry : oldTables.entrySet()) {
                    tb = entry.getValue().get(oldTbEntry.getKey());
                    if (tb != null) continue;
                    tbDiff = true;
                }
                continue;
            }
            dbDiff = true;
        }
        for (Map.Entry<String, Map<String, String>> entry : oldOne.entrySet()) {
            Map<String, String> newTables = newOne.get(entry.getKey());
            if (newTables != null) continue;
            dbDiff = true;
        }
        return MatchResultCompare.compareResultAnalyse(newOne, oriDb, oriTable, dbDiff, tbDiff);
    }

    private static boolean compareResultAnalyse(Map<String, Map<String, String>> newResult, String oriDb, String oriTable, boolean dbDiff, boolean tbDiff) {
        if (dbDiff && oriDb != null) {
            Map<String, String> tables = newResult.get(oriDb);
            if (tables != null) {
                return MatchResultCompare.compareResutlAnalyseTable(tables, oriTable, tbDiff);
            }
            return false;
        }
        if (dbDiff && oriDb == null) {
            return false;
        }
        return MatchResultCompare.compareResutlAnalyseTable(newResult.get(oriDb), oriTable, tbDiff);
    }

    private static boolean compareResutlAnalyseTable(Map<String, String> tables, String oriTable, boolean tbDiff) {
        if (tbDiff && oriTable != null) {
            return tables.get(oriTable) != null;
        }
        return !tbDiff || oriTable != null;
    }

    private static Map<String, Map<String, String>> getTargetMap(List<TargetDB> targetDbs) {
        HashMap<String, Map<String, String>> reMap = new HashMap<String, Map<String, String>>();
        for (TargetDB db : targetDbs) {
            HashMap<String, String> tableMap = new HashMap<String, String>();
            Set tables = db.getTableNames();
            for (String table : tables) {
                tableMap.put(table, table);
            }
            reMap.put(db.getDbIndex(), tableMap);
        }
        return reMap;
    }
}

