/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.rule.le.util;

import com.alibaba.common.lang.StringUtil;
import com.taobao.tddl.interact.sqljep.Comparative;
import com.taobao.tddl.interact.sqljep.ComparativeAND;
import com.taobao.tddl.interact.sqljep.ComparativeOR;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;

public class ComparativeStringAnalyser {
    public static Map<String, Comparative> decodeComparativeString2Map(String conditionStr) {
        HashMap<String, Comparative> comparativeMap = new HashMap<String, Comparative>();
        String[] comStrs = conditionStr.split(";");
        for (int i = 0; i < comStrs.length; ++i) {
            String value = comStrs[i].toLowerCase();
            if (!StringUtil.isNotBlank((String)value)) continue;
            boolean containsAnd = StringUtil.contains((String)value, (String)" and ");
            boolean containsOr = StringUtil.contains((String)value, (String)" or ");
            if (containsAnd || containsOr) {
                String op;
                ComparativeOR comparativeBaseList = null;
                if (containsOr) {
                    comparativeBaseList = new ComparativeOR();
                    op = "or";
                } else if (containsAnd) {
                    comparativeBaseList = new ComparativeAND();
                    op = "and";
                } else {
                    throw new RuntimeException("decodeComparative not support ComparativeBaseList value:" + value);
                }
                String[] compValues = ComparativeStringAnalyser.twoPartSplit(value, op);
                String key = null;
                for (String compValue : compValues) {
                    Comparative comparative = ComparativeStringAnalyser.decodeComparativeForOuter(compValue);
                    if (null != comparative) {
                        comparativeBaseList.addComparative(comparative);
                    }
                    String temp = ComparativeStringAnalyser.getComparativeKey(compValue).trim();
                    if (null == key) {
                        key = temp;
                        continue;
                    }
                    if (temp.equals(key)) continue;
                    throw new RuntimeException("decodeComparative not support ComparativeBaseList value:" + value);
                }
                comparativeMap.put(key.toUpperCase(), (Comparative)comparativeBaseList);
                continue;
            }
            String key = ComparativeStringAnalyser.getComparativeKey(value);
            Comparative comparative = ComparativeStringAnalyser.decodeComparativeForOuter(value);
            if (null == comparative) continue;
            comparativeMap.put(key.toUpperCase().trim(), comparative);
        }
        return comparativeMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static Comparative decodeComparativeForOuter(String compValue) {
        boolean containsIn = StringUtil.contains((String)compValue, (String)" in");
        Comparative comparative = null;
        if (!containsIn) {
            int compEnum = Comparative.getComparisonByCompleteString((String)compValue);
            String splitor = Comparative.getComparisonName((int)compEnum);
            int size = splitor.length();
            int index = compValue.indexOf(splitor);
            String valueTypeStr = StringUtil.substring((String)compValue, (int)(index + size));
            int lastColonIndex = valueTypeStr.lastIndexOf(":");
            String value = valueTypeStr.substring(0, lastColonIndex);
            String type = valueTypeStr.substring(lastColonIndex + 1);
            if (null == type) throw new RuntimeException("decodeComparative Error notSupport Comparative valueType value: " + compValue);
            if (null == value) throw new RuntimeException("decodeComparative Error notSupport Comparative valueType value: " + compValue);
            if ("i".equals(type.trim())) {
                return new Comparative(compEnum, (Comparable)Integer.valueOf(value.trim()));
            }
            if ("l".equals(type.trim())) {
                return new Comparative(compEnum, (Comparable)Long.valueOf(value.trim()));
            }
            if ("s".equals(type.trim())) {
                return new Comparative(compEnum, (Comparable)((Object)value.trim()));
            }
            if ("d".equals(type.trim())) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    return new Comparative(compEnum, (Comparable)sdf.parse(value.trim()));
                }
                catch (ParseException e) {
                    throw new RuntimeException("only support 'yyyy-MM-dd',now date string is:" + value.trim());
                }
            }
            if ("int".equals(type.trim())) {
                return new Comparative(compEnum, (Comparable)Integer.valueOf(value.trim()));
            }
            if ("long".equals(type.trim())) {
                return new Comparative(compEnum, (Comparable)Long.valueOf(value.trim()));
            }
            if ("string".equals(type.trim())) {
                return new Comparative(compEnum, (Comparable)((Object)value.trim()));
            }
            if (!"date".equals(type.trim())) throw new RuntimeException("decodeComparative Error notSupport Comparative valueType value: " + compValue);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                return new Comparative(compEnum, (Comparable)sdf.parse(value.trim()));
            }
            catch (ParseException e) {
                throw new RuntimeException("only support 'yyyy-MM-dd',now date string is:" + value.trim());
            }
        }
        String[] compValues = ComparativeStringAnalyser.twoPartSplit(compValue, " in");
        int lastColonIndex = compValues[1].lastIndexOf(":");
        String inValues = compValues[1].substring(0, lastColonIndex);
        String type = compValues[1].substring(lastColonIndex + 1);
        if (null == inValues) return comparative;
        if (null == type) return comparative;
        ComparativeOR comparativeBaseList = new ComparativeOR();
        String[] values = StringUtil.split((String)ComparativeStringAnalyser.getBetween(inValues, "(", ")"), (String)",");
        if ("i".equals(type.trim())) {
            String[] arr$ = values;
            int len$ = arr$.length;
            int i$ = 0;
            while (i$ < len$) {
                String value = arr$[i$];
                Comparative temp = new Comparative(3, (Comparable)Integer.valueOf(value.trim()));
                comparativeBaseList.addComparative(temp);
                ++i$;
            }
            return comparativeBaseList;
        }
        if ("l".equals(type.trim())) {
            String[] arr$ = values;
            int len$ = arr$.length;
            int i$ = 0;
            while (i$ < len$) {
                String value = arr$[i$];
                Comparative temp = new Comparative(3, (Comparable)Long.valueOf(value.trim()));
                comparativeBaseList.addComparative(temp);
                ++i$;
            }
            return comparativeBaseList;
        }
        if ("s".equals(type.trim())) {
            String[] arr$ = values;
            int len$ = arr$.length;
            int i$ = 0;
            while (i$ < len$) {
                String value = arr$[i$];
                Comparative temp = new Comparative(3, (Comparable)((Object)value.trim()));
                comparativeBaseList.addComparative(temp);
                ++i$;
            }
            return comparativeBaseList;
        }
        if ("d".equals(type.trim())) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String[] arr$ = values;
            int len$ = arr$.length;
            int i$ = 0;
            while (i$ < len$) {
                String value = arr$[i$];
                Comparative temp = null;
                try {
                    temp = new Comparative(3, (Comparable)sdf.parse(value.trim()));
                }
                catch (ParseException e) {
                    throw new RuntimeException("only support 'yyyy-MM-dd',now date string is:" + value.trim());
                }
                comparativeBaseList.addComparative(temp);
                ++i$;
            }
            return comparativeBaseList;
        }
        if ("int".equals(type.trim())) {
            String[] arr$ = values;
            int len$ = arr$.length;
            int i$ = 0;
            while (i$ < len$) {
                String value = arr$[i$];
                Comparative temp = new Comparative(3, (Comparable)Integer.valueOf(value.trim()));
                comparativeBaseList.addComparative(temp);
                ++i$;
            }
            return comparativeBaseList;
        }
        if ("long".equals(type.trim())) {
            String[] arr$ = values;
            int len$ = arr$.length;
            int i$ = 0;
            while (i$ < len$) {
                String value = arr$[i$];
                Comparative temp = new Comparative(3, (Comparable)Long.valueOf(value.trim()));
                comparativeBaseList.addComparative(temp);
                ++i$;
            }
            return comparativeBaseList;
        }
        if ("string".equals(type.trim())) {
            String[] arr$ = values;
            int len$ = arr$.length;
            int i$ = 0;
            while (i$ < len$) {
                String value = arr$[i$];
                Comparative temp = new Comparative(3, (Comparable)((Object)value.trim()));
                comparativeBaseList.addComparative(temp);
                ++i$;
            }
            return comparativeBaseList;
        }
        if (!"date".equals(type.trim())) throw new RuntimeException("decodeComparative Error notSupport Comparative valueType value: " + compValue);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String[] arr$ = values;
        int len$ = arr$.length;
        int i$ = 0;
        while (i$ < len$) {
            String value = arr$[i$];
            Comparative temp = null;
            try {
                temp = new Comparative(3, (Comparable)sdf.parse(value.trim()));
            }
            catch (ParseException e) {
                throw new RuntimeException("only support 'yyyy-MM-dd',now date string is:" + value.trim());
            }
            comparativeBaseList.addComparative(temp);
            ++i$;
        }
        return comparativeBaseList;
    }

    private static String[] twoPartSplit(String str, String splitor) {
        if (splitor != null) {
            int index = str.indexOf(splitor);
            String first = str.substring(0, index);
            String sec = str.substring(index + splitor.length());
            return new String[]{first, sec};
        }
        return new String[]{str};
    }

    private static String getComparativeKey(String compValue) {
        boolean containsIn = StringUtil.contains((String)compValue, (String)" in");
        if (containsIn) {
            String[] compValues = ComparativeStringAnalyser.twoPartSplit(compValue, " in");
            return compValues[0];
        }
        int value = Comparative.getComparisonByCompleteString((String)compValue);
        String splitor = Comparative.getComparisonName((int)value);
        int index = compValue.indexOf(splitor);
        return StringUtil.substring((String)compValue, (int)0, (int)index);
    }

    private static String getBetween(String sql, String start, String end) {
        int index0 = sql.indexOf(start);
        if (index0 == -1) {
            return null;
        }
        int index1 = sql.indexOf(end, index0);
        if (index1 == -1) {
            return null;
        }
        return sql.substring(index0 + start.length(), index1).trim();
    }
}

