/*
 * Decompiled with CFR 0.152.
 */
package org.extra.tools;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.extra.tools.ScreenBroadcastReceiver;

public class BroadcastUtil
implements ScreenBroadcastReceiver.ScreenStateListener {
    private static List<WeakReference<ScreenBroadcastReceiver.ScreenStateListener>> mDataList = new ArrayList<WeakReference<ScreenBroadcastReceiver.ScreenStateListener>>();
    private final Object mSync = new Object();
    private ScreenBroadcastReceiver receiver = null;

    public static BroadcastUtil getInstance() {
        return Factory.INSTANCE;
    }

    public void registerScreenBroadcast() {
        if (this.receiver != null) {
            return;
        }
        this.receiver = new ScreenBroadcastReceiver(this);
        this.receiver.register();
    }

    public void unregisterScreenBroadcast() {
        if (this.receiver != null) {
            this.receiver.unregister();
            this.receiver = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerScreenBroadcast(ScreenBroadcastReceiver.ScreenStateListener listener) {
        if (this.receiver == null) {
            return;
        }
        this.removeUnUse();
        if (listener == null) {
            return;
        }
        Object object = this.mSync;
        synchronized (object) {
            for (WeakReference<ScreenBroadcastReceiver.ScreenStateListener> weakReference : mDataList) {
                if (listener != weakReference.get()) continue;
                return;
            }
            WeakReference<ScreenBroadcastReceiver.ScreenStateListener> weakReference = new WeakReference<ScreenBroadcastReceiver.ScreenStateListener>(listener);
            mDataList.add(weakReference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterScreenBroadcast(ScreenBroadcastReceiver.ScreenStateListener listener) {
        if (this.receiver == null) {
            return;
        }
        this.removeUnUse();
        if (listener == null) {
            return;
        }
        Object object = this.mSync;
        synchronized (object) {
            WeakReference<ScreenBroadcastReceiver.ScreenStateListener> remove = null;
            for (WeakReference<ScreenBroadcastReceiver.ScreenStateListener> weakReference : mDataList) {
                if (listener != weakReference.get()) continue;
                remove = weakReference;
            }
            if (remove != null) {
                mDataList.remove(remove);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeUnUse() {
        Object object = this.mSync;
        synchronized (object) {
            ArrayList<WeakReference<ScreenBroadcastReceiver.ScreenStateListener>> removeList = new ArrayList<WeakReference<ScreenBroadcastReceiver.ScreenStateListener>>();
            for (WeakReference<ScreenBroadcastReceiver.ScreenStateListener> weakReference : mDataList) {
                if (weakReference.get() != null) continue;
                removeList.add(weakReference);
            }
            for (WeakReference<ScreenBroadcastReceiver.ScreenStateListener> weakReference : removeList) {
                mDataList.remove(weakReference);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onScreenOff() {
        this.removeUnUse();
        Object object = this.mSync;
        synchronized (object) {
            for (int pos = mDataList.size() - 1; pos >= 0; --pos) {
                ScreenBroadcastReceiver.ScreenStateListener listener = (ScreenBroadcastReceiver.ScreenStateListener)mDataList.get(pos).get();
                if (listener == null) continue;
                listener.onScreenOff();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onScreenOn() {
        this.removeUnUse();
        Object object = this.mSync;
        synchronized (object) {
            for (int pos = mDataList.size() - 1; pos >= 0; --pos) {
                ScreenBroadcastReceiver.ScreenStateListener listener = (ScreenBroadcastReceiver.ScreenStateListener)mDataList.get(pos).get();
                if (listener == null) continue;
                listener.onScreenOn();
            }
        }
    }

    private static class Factory {
        private static final BroadcastUtil INSTANCE = new BroadcastUtil();

        private Factory() {
        }
    }
}

