/*
 * Decompiled with CFR 0.152.
 */
package org.extra.tools;

import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;

public class ScreenBroadcastReceiver
extends BroadcastReceiver {
    private ScreenStateListener listener;

    ScreenBroadcastReceiver(ScreenStateListener listener) {
        this.listener = listener;
    }

    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        if ("android.intent.action.SCREEN_ON".equals(action)) {
            this.listener.onScreenOn();
        } else if ("android.intent.action.SCREEN_OFF".equals(action)) {
            this.listener.onScreenOff();
        }
    }

    public void unregister() {
        try {
            Context context = this.getApplicationContext();
            if (context != null) {
                context.unregisterReceiver((BroadcastReceiver)this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void register() {
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.SCREEN_ON");
        filter.addAction("android.intent.action.SCREEN_OFF");
        try {
            Context context = this.getApplicationContext();
            if (context != null) {
                context.registerReceiver((BroadcastReceiver)this, filter);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Context getApplicationContext() {
        Context context = null;
        try {
            Application app = (Application)Class.forName("android.app.ActivityThread").getMethod("currentApplication", new Class[0]).invoke(null, (Object[])null);
            context = app.getApplicationContext();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return context;
    }

    public static interface ScreenStateListener {
        public void onScreenOn();

        public void onScreenOff();
    }
}

