/*
 * Decompiled with CFR 0.152.
 */
package org.libpag;

import android.graphics.SurfaceTexture;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.view.Surface;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;

public class GPUDecoder
implements SurfaceTexture.OnFrameAvailableListener {
    private static final int SUCCESS = 0;
    private static final int TRY_AGAIN_LATER = -1;
    private static final int ERROR = -2;
    private static final int END_OF_STREAM = -3;
    private static HandlerThread handlerThread;
    private static int HandlerThreadCount;
    private static final Object handlerLock;
    private Surface outputSurface;
    private SurfaceTexture surfaceTexture;
    private final Object frameSyncObject = new Object();
    private boolean frameAvailable = false;
    private MediaCodec decoder;
    private MediaFormat outputFormat = null;
    private int targetWidth = 0;
    private int targetHeight = 0;
    private MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
    private static final int TIMEOUT_US = 1000;
    private int lastOutputBufferIndex = -1;
    private OutputFrame successFrame = new OutputFrame();
    private boolean released = false;

    private static synchronized void StartHandlerThread() {
        ++HandlerThreadCount;
        if (handlerThread == null) {
            handlerThread = new HandlerThread("libpag_GPUDecoder");
            handlerThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static GPUDecoder Create(int textureID) {
        if (GPUDecoder.forceSoftwareDecoder()) {
            return null;
        }
        GPUDecoder decoder = new GPUDecoder();
        Object object = handlerLock;
        synchronized (object) {
            GPUDecoder.StartHandlerThread();
            decoder.surfaceTexture = new SurfaceTexture(textureID);
            if (Build.VERSION.SDK_INT >= 21) {
                decoder.surfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)decoder, new Handler(handlerThread.getLooper()));
            } else {
                decoder.surfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)decoder);
                decoder.reflectLooper();
            }
        }
        decoder.outputSurface = new Surface(decoder.surfaceTexture);
        return decoder;
    }

    private static boolean forceSoftwareDecoder() {
        return Build.VERSION.SDK_INT < 21;
    }

    private void reflectLooper() {
        Class<?>[] innerClassArray = SurfaceTexture.class.getDeclaredClasses();
        Class<?> eventHandlerClass = null;
        for (Class<?> innerC : innerClassArray) {
            if (!innerC.getName().toLowerCase().contains("handler")) continue;
            eventHandlerClass = innerC;
            break;
        }
        if (eventHandlerClass == null) {
            return;
        }
        Class[] paramTypes = new Class[]{SurfaceTexture.class, Looper.class};
        try {
            Constructor<?> eventHandlerConstructor = eventHandlerClass.getConstructor(paramTypes);
            Object eventHandlerObj = eventHandlerConstructor.newInstance(this.surfaceTexture, handlerThread.getLooper());
            Class<?> classType = this.surfaceTexture.getClass();
            Field field = classType.getDeclaredField("mEventHandler");
            field.setAccessible(true);
            field.set(this.surfaceTexture, eventHandlerObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFrameAvailable(SurfaceTexture st) {
        Object object = this.frameSyncObject;
        synchronized (object) {
            if (this.frameAvailable) {
                new RuntimeException("frameAvailable already set, frame could be dropped").printStackTrace();
                return;
            }
            this.frameAvailable = true;
            this.frameSyncObject.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean awaitNewImage() {
        int TIMEOUT_MS = 50;
        int needRetryTimes = 10;
        Object object = this.frameSyncObject;
        synchronized (object) {
            while (!this.frameAvailable && needRetryTimes > 0) {
                try {
                    --needRetryTimes;
                    this.frameSyncObject.wait(50L);
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
            }
            this.frameAvailable = false;
            if (needRetryTimes == 0) {
                return false;
            }
        }
        try {
            this.surfaceTexture.updateTexImage();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private float videoWidth() {
        float[] matrix = new float[16];
        this.surfaceTexture.getTransformMatrix(matrix);
        float scale = Math.abs(matrix[0]);
        if (scale > 0.0f) {
            return (float)this.targetWidth / (scale + matrix[12] * 2.0f);
        }
        return this.targetWidth;
    }

    private float videoHeight() {
        float[] matrix = new float[16];
        this.surfaceTexture.getTransformMatrix(matrix);
        float scale = Math.abs(matrix[5]);
        if (scale > 0.0f) {
            return (float)this.targetHeight / (scale + (matrix[13] - scale) * 2.0f);
        }
        return this.targetHeight;
    }

    private boolean onConfigure(MediaFormat mediaFormat) {
        if (this.outputSurface == null) {
            return false;
        }
        this.targetWidth = mediaFormat.getInteger("width");
        this.targetHeight = mediaFormat.getInteger("height");
        this.outputFormat = mediaFormat;
        try {
            this.decoder = MediaCodec.createDecoderByType((String)mediaFormat.getString("mime"));
            this.decoder.configure(mediaFormat, this.outputSurface, null, 0);
            this.decoder.start();
            return true;
        }
        catch (Exception e) {
            if (this.decoder != null) {
                this.decoder.release();
                this.decoder = null;
            }
            return false;
        }
    }

    private int dequeueOutputBuffer() {
        try {
            return this.decoder.dequeueOutputBuffer(this.bufferInfo, 1000L);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    private int dequeueInputBuffer() {
        try {
            return this.decoder.dequeueInputBuffer(1000L);
        }
        catch (Error | Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    private ByteBuffer getInputBuffer(int inputBufferIndex) {
        try {
            if (Build.VERSION.SDK_INT >= 21) {
                return this.decoder.getInputBuffer(inputBufferIndex);
            }
            return this.decoder.getInputBuffers()[inputBufferIndex];
        }
        catch (Error | Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private int queueInputBuffer(int inputBufferIndex, int offset, int size, long presentationTimeUs, int flag) {
        try {
            this.decoder.queueInputBuffer(inputBufferIndex, offset, size, presentationTimeUs, flag);
            return 0;
        }
        catch (Error | Exception e) {
            e.printStackTrace();
            return -2;
        }
    }

    private void releaseOutputBuffer() {
        if (this.lastOutputBufferIndex != -1) {
            this.releaseOutputBuffer(this.lastOutputBufferIndex, false);
            this.lastOutputBufferIndex = -1;
        }
    }

    private int releaseOutputBuffer(int outputBufferIndex, boolean render) {
        try {
            this.decoder.releaseOutputBuffer(outputBufferIndex, render);
            return 0;
        }
        catch (Error | Exception e) {
            e.printStackTrace();
            return -2;
        }
    }

    private int onSendBytes(ByteBuffer bytes, long frame) {
        int inputBufferIndex = this.dequeueInputBuffer();
        if (inputBufferIndex >= 0) {
            ByteBuffer inputBuffer = this.getInputBuffer(inputBufferIndex);
            if (inputBuffer == null) {
                return -2;
            }
            inputBuffer.clear();
            bytes.position(0);
            inputBuffer.put(bytes);
            return this.queueInputBuffer(inputBufferIndex, 0, bytes.limit(), frame, 0);
        }
        return -1;
    }

    private int onEndOfStream() {
        int inputBufferIndex = this.dequeueInputBuffer();
        if (inputBufferIndex >= 0) {
            return this.queueInputBuffer(inputBufferIndex, 0, 0, 0L, 4);
        }
        return -1;
    }

    private int onDecodeFrame() {
        this.releaseOutputBuffer();
        try {
            int outputBufferIndex = this.dequeueOutputBuffer();
            if ((this.bufferInfo.flags & 4) != 0) {
                if (outputBufferIndex >= 0) {
                    this.lastOutputBufferIndex = outputBufferIndex;
                }
                return -3;
            }
            if (outputBufferIndex >= 0) {
                this.lastOutputBufferIndex = outputBufferIndex;
            } else if (outputBufferIndex == -2) {
                this.outputFormat = this.decoder.getOutputFormat();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return -2;
        }
        return this.lastOutputBufferIndex != -1 ? 0 : -1;
    }

    private void onFlush() {
        try {
            this.decoder.flush();
            this.bufferInfo = new MediaCodec.BufferInfo();
            this.lastOutputBufferIndex = -1;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private long presentationTime() {
        return this.bufferInfo.presentationTimeUs;
    }

    private OutputFrame onRenderFrame() {
        if (this.lastOutputBufferIndex != -1) {
            int success = this.releaseOutputBuffer(this.lastOutputBufferIndex, true);
            this.lastOutputBufferIndex = -1;
            if (success == 0 && this.awaitNewImage()) {
                return this.successFrame;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRelease() {
        if (this.released) {
            return;
        }
        this.released = true;
        this.releaseOutputBuffer();
        Object object = handlerLock;
        synchronized (object) {
            if (--HandlerThreadCount == 0) {
                handlerThread.quit();
                handlerThread = null;
            }
        }
        if (this.decoder != null) {
            try {
                this.decoder.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                this.decoder.release();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.decoder = null;
        }
        if (this.outputSurface != null) {
            this.outputSurface.release();
            this.outputSurface = null;
        }
        if (this.surfaceTexture != null) {
            this.surfaceTexture.release();
            this.surfaceTexture = null;
        }
    }

    private boolean attachToGLContext(int texName) {
        if (this.surfaceTexture == null) {
            return false;
        }
        try {
            this.surfaceTexture.detachFromGLContext();
            this.surfaceTexture.attachToGLContext(texName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    static {
        HandlerThreadCount = 0;
        handlerLock = new Object();
    }

    private static class OutputFrame {
        public long[] data = new long[3];
        public int[] lineSize = new int[3];

        private OutputFrame() {
        }
    }
}

