/*
 * Decompiled with CFR 0.152.
 */
package org.libpag;

import android.content.res.AssetManager;
import org.extra.tools.LibraryLoadUtils;
import org.libpag.PAGComposition;
import org.libpag.PAGFont;
import org.libpag.PAGImage;
import org.libpag.PAGLayer;
import org.libpag.PAGText;

public class PAGFile
extends PAGComposition {
    public static native int MaxSupportedTagLevel();

    public static PAGFile Load(String path) {
        return PAGFile.LoadFromPath(path);
    }

    public static PAGFile Load(byte[] bytes) {
        return PAGFile.LoadFromBytes(bytes, bytes.length);
    }

    public static PAGFile Load(AssetManager manager, String fileName) {
        return PAGFile.LoadFromAssets(manager, fileName);
    }

    private static native PAGFile LoadFromPath(String var0);

    private static native PAGFile LoadFromBytes(byte[] var0, int var1);

    private static native PAGFile LoadFromAssets(AssetManager var0, String var1);

    private PAGFile(long nativeContext) {
        super(nativeContext);
    }

    public native int tagLevel();

    public native int numTexts();

    public native int numImages();

    public native int numVideos();

    public native String path();

    public native PAGText getTextData(int var1);

    public native void replaceText(int var1, PAGText var2);

    public void replaceImage(int editableImageIndex, PAGImage image) {
        if (image == null) {
            this.nativeReplaceImage(editableImageIndex, 0L);
        } else {
            this.nativeReplaceImage(editableImageIndex, image.nativeContext);
        }
    }

    public native void nativeReplaceImage(int var1, long var2);

    public native PAGLayer[] getLayersByEditableIndex(int var1, int var2);

    public native int timeStretchMode();

    public native void setTimeStretchMode(int var1);

    public native void setDuration(long var1);

    public native PAGFile copyOriginal();

    private static final native void nativeInit();

    static {
        LibraryLoadUtils.loadLibrary("libpag");
        PAGFile.nativeInit();
        PAGFont.loadSystemFonts();
    }
}

