/*
 * Decompiled with CFR 0.152.
 */
package org.libpag;

import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.os.Build;
import android.text.TextUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.extra.tools.LibraryLoadUtils;
import org.libpag.PAGFont;

public class PAGImage {
    private static final int AlphaType_Opaque = 1;
    private static final int AlphaType_Premul = 2;
    private static final int AlphaType_Unpremul = 3;
    private static final int ColorType_Alpha_8 = 1;
    private static final int ColorType_RGB_565 = 2;
    private static final int ColorType_ARGB_4444 = 3;
    private static final int ColorType_RGBA_8888 = 4;
    private static final int ColorType_BGRA_8888 = 5;
    private static final int ColorType_Index_8 = 6;
    private static final int ColorType_Gray_8 = 7;
    private static final int ColorType_RGBA_F16 = 8;
    private byte[] pixels = null;
    long nativeContext = 0L;

    public static PAGImage FromBitmap(Bitmap bitmap) {
        int colorType;
        if (Build.VERSION.SDK_INT >= 26 && bitmap.getConfig() == Bitmap.Config.HARDWARE) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.allocate(bitmap.getHeight() * bitmap.getRowBytes());
        bitmap.copyPixelsToBuffer((Buffer)buffer);
        Bitmap.Config config = bitmap.getConfig();
        if (config == null) {
            config = Bitmap.Config.ARGB_8888;
        }
        int alphaType = bitmap.isPremultiplied() ? 2 : 3;
        switch (config) {
            case ALPHA_8: {
                colorType = 1;
                break;
            }
            case RGB_565: {
                colorType = 2;
                alphaType = 1;
                break;
            }
            case ARGB_4444: {
                colorType = 3;
                break;
            }
            case RGBA_F16: {
                colorType = 8;
                break;
            }
            default: {
                colorType = 4;
            }
        }
        long context = PAGImage.LoadFromPixels(buffer.array(), bitmap.getWidth(), bitmap.getHeight(), bitmap.getRowBytes(), colorType, alphaType);
        if (context == 0L) {
            return null;
        }
        PAGImage image = new PAGImage(context);
        image.pixels = buffer.array();
        return image;
    }

    public static PAGImage FromPath(String path) {
        Bitmap bitmap = BitmapFactory.decodeFile((String)path);
        if (bitmap == null) {
            return null;
        }
        return PAGImage.FromBitmap(bitmap);
    }

    public static PAGImage FromBytes(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
        if (bitmap == null) {
            return null;
        }
        return PAGImage.FromBitmap(bitmap);
    }

    public static PAGImage FromAssets(AssetManager manager, String fileName) {
        if (manager == null || TextUtils.isEmpty((CharSequence)fileName)) {
            return null;
        }
        InputStream stream = null;
        try {
            stream = manager.open(fileName);
        }
        catch (IOException e) {
            return null;
        }
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)stream);
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (bitmap == null) {
            return null;
        }
        return PAGImage.FromBitmap(bitmap);
    }

    public static PAGImage FromTexture(int textureID, int textureTarget, int width, int height) {
        return PAGImage.FromTexture(textureID, textureTarget, width, height, false);
    }

    public static PAGImage FromTexture(int textureID, int textureTarget, int width, int height, boolean flipY) {
        long context = PAGImage.LoadFromTexture(textureID, textureTarget, width, height, flipY);
        if (context == 0L) {
            return null;
        }
        return new PAGImage(context);
    }

    private static native long LoadFromPixels(byte[] var0, int var1, int var2, int var3, int var4, int var5);

    private static native long LoadFromPath(String var0);

    private static native long LoadFromBytes(byte[] var0, int var1);

    private static native long LoadFromAssets(AssetManager var0, String var1);

    private static native long LoadFromTexture(int var0, int var1, int var2, int var3, boolean var4);

    PAGImage(long nativeContext) {
        this.nativeContext = nativeContext;
    }

    public native int width();

    public native int height();

    public native int scaleMode();

    public native void setScaleMode(int var1);

    public Matrix matrix() {
        float[] values = new float[9];
        this.nativeGetMatrix(values);
        Matrix matrix = new Matrix();
        matrix.setValues(values);
        return matrix;
    }

    private native void nativeGetMatrix(float[] var1);

    public void setMatrix(Matrix matrix) {
        float[] values = new float[9];
        matrix.getValues(values);
        this.nativeSetMatrix(values[0], values[3], values[1], values[4], values[2], values[5]);
    }

    private native void nativeSetMatrix(float var1, float var2, float var3, float var4, float var5, float var6);

    public void release() {
        this.nativeRelease();
    }

    private final native void nativeRelease();

    private static final native void nativeInit();

    protected void finalize() {
        this.nativeFinalize();
    }

    private native void nativeFinalize();

    static {
        LibraryLoadUtils.loadLibrary("libpag");
        PAGImage.nativeInit();
        PAGFont.loadSystemFonts();
    }
}

