/*
 * Decompiled with CFR 0.152.
 */
package org.libpag;

import android.graphics.Matrix;
import android.graphics.RectF;
import org.extra.tools.LibraryLoadUtils;
import org.libpag.PAGComposition;
import org.libpag.PAGFilter;
import org.libpag.PAGMarker;

public class PAGLayer {
    public static final int LayerTypeUnknown = 0;
    public static final int LayerTypeNull = 1;
    public static final int LayerTypeSolid = 2;
    public static final int LayerTypeText = 3;
    public static final int LayerTypeShape = 4;
    public static final int LayerTypeImage = 5;
    public static final int LayerTypePreCompose = 6;
    protected long nativeContext;

    public PAGLayer(long nativeContext) {
        this.nativeContext = nativeContext;
    }

    public native int layerType();

    public native String layerName();

    public Matrix matrix() {
        float[] data = new float[9];
        this.matrix(data);
        Matrix matrix = new Matrix();
        matrix.setValues(data);
        return matrix;
    }

    public void setMatrix(Matrix matrix) {
        if (matrix == null) {
            return;
        }
        float[] data = new float[9];
        matrix.getValues(data);
        this.setMatrix(data);
    }

    public native void resetMatrix();

    public Matrix getTotalMatrix() {
        float[] data = new float[9];
        this.getTotalMatrix(data);
        Matrix matrix = new Matrix();
        matrix.setValues(data);
        return matrix;
    }

    public native boolean visible();

    public native void setVisible(boolean var1);

    public native int editableIndex();

    public native PAGComposition parent();

    public native PAGMarker[] markers();

    public native long localTimeToGlobal(long var1);

    public native long globalToLocalTime(long var1);

    public native long duration();

    public native float frameRate();

    public native long startTime();

    public native void setStartTime(long var1);

    public native long currentTime();

    public native void setCurrentTime(long var1);

    public native double getProgress();

    public native void setProgress(double var1);

    public native PAGLayer trackMatteLayer();

    public native RectF getBounds();

    public native int numFilters();

    public native void addFilter(PAGFilter var1);

    public native void removeAllFilters();

    public native boolean excludedFromTimeline();

    public native void setExcludedFromTimeline(boolean var1);

    private native void nativeRelease();

    private static native void nativeInit();

    private native void matrix(float[] var1);

    private native void setMatrix(float[] var1);

    private native void getTotalMatrix(float[] var1);

    protected void finalize() {
        this.nativeRelease();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PAGLayer) {
            return this.hashCode() == obj.hashCode();
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 527 + (int)(this.nativeContext ^ this.nativeContext >>> 32);
        return result;
    }

    static {
        LibraryLoadUtils.loadLibrary("libpag");
        PAGLayer.nativeInit();
    }
}

