/*
 * Decompiled with CFR 0.152.
 */
package org.libpag;

import android.graphics.Matrix;
import org.extra.tools.LibraryLoadUtils;
import org.libpag.PAGComposition;
import org.libpag.PAGFile;
import org.libpag.PAGFont;
import org.libpag.PAGImage;
import org.libpag.PAGLayer;
import org.libpag.PAGSurface;
import org.libpag.PAGText;

public class PAGRenderer {
    private PAGSurface pagSurface = null;
    private PAGFile pagFile = null;
    private long nativeContext = 0L;

    public PAGRenderer() {
        this.nativeSetup();
    }

    public PAGFile getFile() {
        return this.pagFile;
    }

    public void setFile(PAGFile file) {
        this.pagFile = file;
        if (file != null) {
            this.nativeSetFile(file.nativeContext);
        } else {
            this.nativeSetFile(0L);
        }
    }

    private native void nativeSetFile(long var1);

    public PAGSurface getSurface() {
        return this.pagSurface;
    }

    public void setSurface(PAGSurface surface) {
        this.pagSurface = surface;
        if (surface == null) {
            this.nativeSetSurface(0L);
        } else {
            this.nativeSetSurface(surface.nativeSurface);
        }
    }

    private native void nativeSetSurface(long var1);

    public native boolean cacheEnabled();

    public native void setCacheEnabled(boolean var1);

    public native float cacheScale();

    public native void setCacheScale(float var1);

    public native float maxFrameRate();

    public native void setMaxFrameRate(float var1);

    public native int scaleMode();

    public native void setScaleMode(int var1);

    public Matrix matrix() {
        float[] values = new float[9];
        this.nativeGetMatrix(values);
        Matrix matrix = new Matrix();
        matrix.setValues(values);
        return matrix;
    }

    private native void nativeGetMatrix(float[] var1);

    public void setMatrix(Matrix matrix) {
        float[] values = new float[9];
        matrix.getValues(values);
        this.nativeSetMatrix(values[0], values[3], values[1], values[4], values[2], values[5]);
    }

    private native void nativeSetMatrix(float var1, float var2, float var3, float var4, float var5, float var6);

    public native void setTextData(int var1, PAGText var2);

    public void replaceImage(int index, PAGImage image) {
        if (image == null) {
            this.nativeReplaceImage(index, 0L);
        } else {
            this.nativeReplaceImage(index, image.nativeContext);
        }
    }

    private native void nativeReplaceImage(int var1, long var2);

    public native double getProgress();

    public native void setProgress(double var1);

    public native void draw();

    public native boolean flush(boolean var1);

    public boolean flush() {
        return this.flush(false);
    }

    public native PAGComposition getRootComposition();

    public native PAGLayer[] getLayersUnderPoint(float var1, float var2);

    public native void reset();

    public void release() {
        this.nativeRelease();
    }

    private final native void nativeRelease();

    protected void finalize() {
        this.nativeFinalize();
    }

    private native void nativeFinalize();

    private final native void nativeSetup();

    private static final native void nativeInit();

    static {
        LibraryLoadUtils.loadLibrary("libpag");
        PAGRenderer.nativeInit();
        PAGFont.loadSystemFonts();
    }
}

