/*
 * Decompiled with CFR 0.152.
 */
package org.libpag;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.graphics.drawable.Drawable;
import android.opengl.EGLContext;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.TextureView;
import android.view.View;
import android.view.animation.LinearInterpolator;
import java.util.ArrayList;
import java.util.List;
import org.extra.tools.BroadcastUtil;
import org.extra.tools.ScreenBroadcastReceiver;
import org.libpag.PAGComposition;
import org.libpag.PAGFile;
import org.libpag.PAGImage;
import org.libpag.PAGLayer;
import org.libpag.PAGPlayer;
import org.libpag.PAGSurface;
import org.libpag.PAGText;

public class PAGView
extends TextureView
implements TextureView.SurfaceTextureListener,
ScreenBroadcastReceiver.ScreenStateListener {
    private TextureView.SurfaceTextureListener mListener;
    private PAGPlayer pagPlayer;
    private PAGSurface pagSurface;
    private PAGFile pagFile;
    private ValueAnimator animator;
    private boolean _isPlaying = false;
    private String filePath = "";
    private boolean isAttachedToWindow = false;
    private EGLContext sharedContext = null;
    private boolean mSaveVisibleState;
    private SparseArray<PAGText> textReplacementMap = new SparseArray();
    private SparseArray<PAGImage> imageReplacementMap = new SparseArray();
    private static final Object g_HandlerLock = new Object();
    private static PAGRendererHandler g_PAGRendererHandler = null;
    private static HandlerThread g_PAGRendererThread = null;
    private static volatile int g_HandlerThreadCount = 0;
    private static final int MSG_FLUSH = 0;
    private static final int MSG_SURFACE_DESTROY = 1;
    private static final int MSG_HANDLER_THREAD_QUITE = 2;
    private static final int ANDROID_SDK_VERSION_O = 26;
    private ArrayList<PAGViewListener> mViewListeners = new ArrayList();
    private ArrayList<PAGFlushListener> mPAGFlushListeners = new ArrayList();
    private float animatorProgress;
    private ValueAnimator.AnimatorUpdateListener mAnimatorUpdateListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator animation) {
            PAGView.this.animatorProgress = ((Float)animation.getAnimatedValue()).floatValue();
            PAGView.NeedsUpdateView(PAGView.this);
        }
    };
    private AnimatorListenerAdapter mAnimatorListenerAdapter = new AnimatorListenerAdapter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onAnimationStart(Animator animator) {
            super.onAnimationStart(animator);
            PAGView pAGView = PAGView.this;
            synchronized (pAGView) {
                for (PAGViewListener listener : PAGView.this.mViewListeners) {
                    listener.onAnimationStart(PAGView.this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onAnimationEnd(Animator animation) {
            super.onAnimationEnd(animation);
            PAGView pAGView = PAGView.this;
            synchronized (pAGView) {
                for (PAGViewListener listener : PAGView.this.mViewListeners) {
                    listener.onAnimationEnd(PAGView.this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onAnimationCancel(Animator animator) {
            super.onAnimationCancel(animator);
            PAGView pAGView = PAGView.this;
            synchronized (pAGView) {
                for (PAGViewListener listener : PAGView.this.mViewListeners) {
                    listener.onAnimationCancel(PAGView.this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onAnimationRepeat(Animator animator) {
            super.onAnimationRepeat(animator);
            PAGView pAGView = PAGView.this;
            synchronized (pAGView) {
                for (PAGViewListener listener : PAGView.this.mViewListeners) {
                    listener.onAnimationRepeat(PAGView.this);
                }
            }
        }
    };
    private Runnable mAnimatorStartRunnable = new Runnable(){

        @Override
        public void run() {
            if (PAGView.this.isAttachedToWindow) {
                PAGView.this.animator.start();
            }
        }
    };
    private Runnable mAnimatorCancelRunnable = new Runnable(){

        @Override
        public void run() {
            PAGView.this.animator.cancel();
        }
    };

    private static synchronized void StartHandlerThread() {
        ++g_HandlerThreadCount;
        if (g_PAGRendererThread == null) {
            g_PAGRendererThread = new HandlerThread("pag-renderer");
            g_PAGRendererThread.start();
        }
        if (g_PAGRendererHandler == null) {
            g_PAGRendererHandler = new PAGRendererHandler(g_PAGRendererThread.getLooper());
        }
    }

    private static synchronized void DestroyHandlerThread() {
        if (--g_HandlerThreadCount != 0) {
            return;
        }
        if (g_PAGRendererHandler == null || g_PAGRendererThread == null) {
            return;
        }
        if (!g_PAGRendererThread.isAlive()) {
            return;
        }
        PAGView.SendMessage(2, null);
    }

    private static void SendMessage(int msgId, Object obj) {
        if (g_PAGRendererHandler == null) {
            return;
        }
        Message message = g_PAGRendererHandler.obtainMessage();
        message.arg1 = msgId;
        if (obj != null) {
            message.obj = obj;
        }
        g_PAGRendererHandler.sendMessage(message);
    }

    private static void NeedsUpdateView(PAGView pagView) {
        if (g_PAGRendererHandler == null) {
            return;
        }
        g_PAGRendererHandler.needsUpdateView(pagView);
    }

    private static void HandlerThreadQuit() {
        if (g_HandlerThreadCount != 0) {
            return;
        }
        if (g_PAGRendererHandler == null || g_PAGRendererThread == null) {
            return;
        }
        if (!g_PAGRendererThread.isAlive()) {
            return;
        }
        g_PAGRendererHandler.removeCallbacksAndMessages(null);
        if (Build.VERSION.SDK_INT > 18) {
            g_PAGRendererThread.quitSafely();
        } else {
            g_PAGRendererThread.quit();
        }
        g_PAGRendererThread = null;
        g_PAGRendererHandler = null;
    }

    public PAGView(Context context) {
        super(context);
        this.setupSurfaceTexture();
    }

    public PAGView(Context context, EGLContext sharedContext) {
        super(context);
        this.sharedContext = sharedContext;
        this.setupSurfaceTexture();
    }

    public PAGView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setupSurfaceTexture();
    }

    public PAGView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setupSurfaceTexture();
    }

    private void setupSurfaceTexture() {
        this.setOpaque(false);
        this.pagPlayer = new PAGPlayer();
        this.setSurfaceTextureListener(this);
        this.animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        this.animator.setRepeatCount(0);
        this.animator.setInterpolator((TimeInterpolator)new LinearInterpolator());
    }

    private void updateView() {
        if (!this.isAttachedToWindow) {
            return;
        }
        this.setProgress(this.animatorProgress);
        this.flush();
        if (!this.mPAGFlushListeners.isEmpty()) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    for (PAGFlushListener listener : PAGView.this.mPAGFlushListeners) {
                        listener.onFlush();
                    }
                }
            });
        }
    }

    public void setSurfaceTextureListener(TextureView.SurfaceTextureListener listener) {
        if (listener == this) {
            super.setSurfaceTextureListener(listener);
        } else {
            this.mListener = listener;
        }
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        if (this.pagSurface != null) {
            this.pagSurface.release();
            this.pagSurface = null;
        }
        this.pagSurface = PAGSurface.FromSurfaceTexture(surface, this.sharedContext);
        this.pagPlayer.setSurface(this.pagSurface);
        if (this.pagSurface == null) {
            return;
        }
        this.animator.addUpdateListener(this.mAnimatorUpdateListener);
        if (!this.mPAGFlushListeners.isEmpty()) {
            PAGView.NeedsUpdateView(this);
        } else {
            this.flush();
        }
        if (this.mListener != null) {
            this.mListener.onSurfaceTextureAvailable(surface, width, height);
        }
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int width, int height) {
        if (this.pagSurface != null) {
            this.pagSurface.updateSize();
            if (!this.mPAGFlushListeners.isEmpty()) {
                PAGView.NeedsUpdateView(this);
            } else {
                this.flush();
            }
        }
        if (this.mListener != null) {
            this.mListener.onSurfaceTextureSizeChanged(surfaceTexture, width, height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        this.pagPlayer.setSurface(null);
        if (this.mListener != null) {
            this.mListener.onSurfaceTextureDestroyed(surface);
        }
        if (this.pagSurface != null) {
            this.pagSurface.freeCache();
        }
        this.animator.removeUpdateListener(this.mAnimatorUpdateListener);
        boolean surfaceDestroy = true;
        if (g_PAGRendererHandler != null && surface != null) {
            PAGView.SendMessage(1, surface);
            surfaceDestroy = false;
        }
        if (Build.VERSION.SDK_INT >= 26) {
            Object object = g_HandlerLock;
            synchronized (object) {
                PAGView.DestroyHandlerThread();
            }
        }
        return surfaceDestroy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onAttachedToWindow() {
        this.isAttachedToWindow = true;
        super.onAttachedToWindow();
        this.animator.addListener((Animator.AnimatorListener)this.mAnimatorListenerAdapter);
        BroadcastUtil.getInstance().registerScreenBroadcast(this);
        Object object = g_HandlerLock;
        synchronized (object) {
            PAGView.StartHandlerThread();
        }
        if (this._isPlaying) {
            this.doPlay();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDetachedFromWindow() {
        this.isAttachedToWindow = false;
        super.onDetachedFromWindow();
        BroadcastUtil.getInstance().unregisterScreenBroadcast(this);
        if (this.pagSurface != null) {
            this.pagSurface.release();
            this.pagSurface = null;
        }
        this._isPlaying = this._isPlaying && this.animator.isRunning();
        this.cancelAnimator();
        if (Build.VERSION.SDK_INT < 26) {
            Object object = g_HandlerLock;
            synchronized (object) {
                PAGView.DestroyHandlerThread();
            }
        }
        this.animator.removeListener((Animator.AnimatorListener)this.mAnimatorListenerAdapter);
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        if (this.mListener != null) {
            this.mListener.onSurfaceTextureUpdated(surface);
        }
    }

    public boolean isPlaying() {
        if (this.animator != null) {
            return this.animator.isRunning();
        }
        return false;
    }

    public void play() {
        this._isPlaying = true;
        this.doPlay();
    }

    private void doPlay() {
        if (!this.isAttachedToWindow) {
            return;
        }
        double currentProgress = this.pagPlayer.getProgress();
        this.animator.setCurrentPlayTime((long)(currentProgress * (double)this.animator.getDuration()));
        this.startAnimator();
    }

    public void stop() {
        this._isPlaying = false;
        this.cancelAnimator();
    }

    private boolean isMainThread() {
        return Looper.getMainLooper().getThread() == Thread.currentThread();
    }

    private void startAnimator() {
        if (this.isMainThread()) {
            this.animator.start();
        } else {
            this.removeCallbacks(this.mAnimatorCancelRunnable);
            this.post(this.mAnimatorStartRunnable);
        }
    }

    private void cancelAnimator() {
        if (this.isMainThread()) {
            this.animator.cancel();
        } else {
            this.removeCallbacks(this.mAnimatorStartRunnable);
            this.post(this.mAnimatorCancelRunnable);
        }
    }

    public void setRepeatCount(int value) {
        if (value < 0) {
            value = 0;
        }
        this.animator.setRepeatCount(value - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(PAGViewListener listener) {
        PAGView pAGView = this;
        synchronized (pAGView) {
            this.mViewListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(PAGViewListener listener) {
        PAGView pAGView = this;
        synchronized (pAGView) {
            this.mViewListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPAGFlushListener(PAGFlushListener listener) {
        PAGView pAGView = this;
        synchronized (pAGView) {
            this.mPAGFlushListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePAGFlushListener(PAGFlushListener listener) {
        PAGView pAGView = this;
        synchronized (pAGView) {
            this.mPAGFlushListeners.remove(listener);
        }
    }

    @Deprecated
    public void addListener(Animator.AnimatorListener listener) {
        this.animator.addListener(listener);
    }

    @Deprecated
    public void removeListener(Animator.AnimatorListener listener) {
        this.animator.removeListener(listener);
    }

    public String getPath() {
        return this.filePath;
    }

    public boolean setPath(String path) {
        PAGFile pagFile = path != null && path.startsWith("assets://") ? PAGFile.Load(this.getContext().getAssets(), path.substring(9)) : PAGFile.Load(path);
        this.setComposition(pagFile);
        this.filePath = path;
        return pagFile != null;
    }

    public PAGComposition getComposition() {
        return this.pagPlayer.getComposition();
    }

    public void setComposition(PAGComposition newComposition) {
        this.filePath = null;
        this.pagFile = null;
        this.pagPlayer.setComposition(newComposition);
        long duration = this.pagPlayer.duration();
        this.animator.setDuration(duration / 1000L);
    }

    public boolean videoEnabled() {
        return this.pagPlayer.videoEnabled();
    }

    public void setVideoEnabled(boolean enable) {
        this.pagPlayer.setVideoEnabled(enable);
    }

    public boolean cacheEnabled() {
        return this.pagPlayer.cacheEnabled();
    }

    public void setCacheEnabled(boolean value) {
        this.pagPlayer.setCacheEnabled(value);
    }

    public float cacheScale() {
        return this.pagPlayer.cacheScale();
    }

    public void setCacheScale(float value) {
        this.pagPlayer.setCacheScale(value);
    }

    public float maxFrameRate() {
        return this.pagPlayer.maxFrameRate();
    }

    public void setMaxFrameRate(float value) {
        this.pagPlayer.setMaxFrameRate(value);
    }

    public int scaleMode() {
        return this.pagPlayer.scaleMode();
    }

    public void setScaleMode(int mode) {
        this.pagPlayer.setScaleMode(mode);
    }

    public Matrix matrix() {
        return this.pagPlayer.matrix();
    }

    public void setMatrix(Matrix matrix) {
        this.pagPlayer.setMatrix(matrix);
    }

    public long duration() {
        return this.pagPlayer.duration();
    }

    public double getProgress() {
        return this.pagPlayer.getProgress();
    }

    public void setProgress(double value) {
        this.pagPlayer.setProgress(value);
    }

    public boolean flush() {
        return this.pagPlayer.flush();
    }

    public PAGLayer[] getLayersUnderPoint(float x, float y) {
        return this.pagPlayer.getLayersUnderPoint(x, y);
    }

    public void freeCache() {
        if (this.pagSurface != null) {
            this.pagSurface.freeCache();
        }
    }

    public PAGFile getFile() {
        return this.pagFile;
    }

    public void setFile(PAGFile file) {
        PAGFile composition = file != null ? file.copyOriginal() : null;
        this.setComposition(composition);
        this.pagFile = file;
        if (this.pagFile != null) {
            this.applyReplacements();
        }
    }

    public PAGComposition getRootComposition() {
        return this.pagPlayer.getComposition();
    }

    public boolean flush(boolean force) {
        return this.flush();
    }

    public void setTextData(int index, PAGText data) {
        PAGComposition composition = this.pagPlayer.getComposition();
        if (composition != null && this.pagFile == null) {
            return;
        }
        if (composition != null) {
            ((PAGFile)composition).replaceText(index, data);
        } else {
            this.textReplacementMap.put(index, (Object)data);
        }
    }

    public void replaceImage(int index, PAGImage image) {
        PAGComposition composition = this.pagPlayer.getComposition();
        if (composition != null && this.pagFile == null) {
            return;
        }
        if (composition != null) {
            ((PAGFile)composition).replaceImage(index, image);
        } else {
            this.imageReplacementMap.put(index, (Object)image);
        }
    }

    private void applyReplacements() {
        int index;
        int i;
        PAGFile file = (PAGFile)this.pagPlayer.getComposition();
        if (file == null) {
            return;
        }
        for (i = 0; i < this.textReplacementMap.size(); ++i) {
            index = this.textReplacementMap.keyAt(i);
            PAGText pagText = (PAGText)this.textReplacementMap.valueAt(i);
            file.replaceText(index, pagText);
        }
        this.textReplacementMap.clear();
        for (i = 0; i < this.imageReplacementMap.size(); ++i) {
            index = this.imageReplacementMap.keyAt(i);
            PAGImage pagImage = (PAGImage)this.imageReplacementMap.valueAt(i);
            file.replaceImage(index, pagImage);
        }
        this.imageReplacementMap.clear();
    }

    @Override
    public void onScreenOff() {
        if (this.getVisibility() == 0) {
            this.mSaveVisibleState = true;
        }
    }

    @Override
    public void onScreenOn() {
        if (this.mSaveVisibleState) {
            if (this.getVisibility() == 0) {
                this.dispatchVisibilityChanged((View)this, this.getVisibility());
            } else {
                this.setVisibility(0);
            }
        }
        this.mSaveVisibleState = false;
    }

    public void setBackgroundDrawable(Drawable background) {
        if (Build.VERSION.SDK_INT < 24 && background != null) {
            super.setBackgroundDrawable(background);
        }
    }

    static {
        BroadcastUtil.getInstance().registerScreenBroadcast();
    }

    public static interface PAGFlushListener {
        public void onFlush();
    }

    public static interface PAGViewListener {
        public void onAnimationStart(PAGView var1);

        public void onAnimationEnd(PAGView var1);

        public void onAnimationCancel(PAGView var1);

        public void onAnimationRepeat(PAGView var1);
    }

    static class PAGRendererHandler
    extends Handler {
        private final Object lock = new Object();
        private List<PAGView> needsUpdateViews = new ArrayList<PAGView>();

        PAGRendererHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void needsUpdateView(PAGView pagView) {
            Object object = this.lock;
            synchronized (object) {
                if (this.needsUpdateViews.isEmpty()) {
                    Message message = this.obtainMessage();
                    message.arg1 = 0;
                    this.sendMessage(message);
                }
                this.needsUpdateViews.add(pagView);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.arg1) {
                case 0: {
                    ArrayList<PAGView> tempList;
                    Object object = this.lock;
                    synchronized (object) {
                        tempList = new ArrayList<PAGView>(this.needsUpdateViews);
                        this.needsUpdateViews.clear();
                    }
                    ArrayList<PAGView> flushedViews = new ArrayList<PAGView>();
                    for (Object e : tempList) {
                        PAGView pagView;
                        if (!(e instanceof PAGView) || flushedViews.contains(pagView = (PAGView)e)) continue;
                        pagView.updateView();
                        flushedViews.add(pagView);
                    }
                    break;
                }
                case 1: {
                    if (!(msg.obj instanceof SurfaceTexture)) {
                        return;
                    }
                    SurfaceTexture surfaceTexture = (SurfaceTexture)msg.obj;
                    surfaceTexture.release();
                    break;
                }
                case 2: {
                    new Handler(Looper.getMainLooper()).post(new Runnable(){

                        @Override
                        public void run() {
                            PAGView.HandlerThreadQuit();
                        }
                    });
                    break;
                }
            }
        }
    }
}

