/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcrgamepad;

import a.g;
import a.j;
import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.google.gson.Gson;
import com.tencent.component.utils.LogUtils;
import com.tencent.tcr.sdk.api.Gamepad;
import com.tencent.tcr.sdk.api.Mouse;
import com.tencent.tcr.sdk.api.TcrSession;
import com.tencent.tcrgamepad.IGamepadTouchDelegate;
import com.tencent.tcrgamepad.button.b;
import com.tencent.tcrgui.R;
import d.e;
import e.b;
import e.c;
import java.util.List;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class GamepadManager
extends RelativeLayout
implements b.c {
    private static final String kVersion = "2.0";
    private static final String TAG = "TCRGamepadManager";
    private boolean isInited;
    private j mGamepad;
    private g mEditor;
    private OnEditListener mEditListener;
    private IGamepadTouchDelegate mGamePadTouchDelegate;
    private TcrSession mSession;

    public GamepadManager(Context context, TcrSession tcrSession) {
        this(context);
        this.mSession = tcrSession;
    }

    public GamepadManager(Context context) {
        this(context, null, 0);
    }

    public GamepadManager(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public GamepadManager(Context context, AttributeSet attributeSet, int n2) {
        GamepadManager gamepadManager = this;
        super(context, attributeSet, n2);
        gamepadManager.isInited = false;
        gamepadManager.setBackgroundColor(0);
    }

    public static String version() {
        return kVersion;
    }

    private void innerShowGamepad(List<b.a> object) {
        RelativeLayout.LayoutParams layoutParams;
        j j2;
        Object object2 = TAG;
        Object object3 = new StringBuilder().append("(Version:2.0) show gamepad with button ");
        Object object4 = object == null ? "null" : Integer.valueOf(object.size());
        LogUtils.i((String)object2, (String)((StringBuilder)object3).append(object4).toString());
        object2 = relativeLayout.mGamepad;
        if (object2 != null) {
            relativeLayout.removeView((View)object2);
            relativeLayout.mGamepad = null;
        }
        GamepadManager gamepadManager = relativeLayout;
        Object object5 = object2 = j2;
        ((j)((Object)object5))(relativeLayout.getContext(), null, 0);
        relativeLayout.mGamepad = object5;
        j2.setOnInstructionListener((b.c)relativeLayout);
        gamepadManager.mGamepad.setGamePadTouchDelegate(relativeLayout.mGamePadTouchDelegate);
        object2 = layoutParams;
        layoutParams = new RelativeLayout.LayoutParams(-1, -1);
        gamepadManager.mGamepad.setLayoutParams((ViewGroup.LayoutParams)object2);
        object2 = gamepadManager.mGamepad;
        gamepadManager.mGamepad.c = object;
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                object3 = (b.a)object.next();
                boolean bl = object3 != null && (object3 = ((b.a)object3).a) != null && (object3 = b.b((String)object3)) != null ? ((e.a)object3).e : false;
                if (!bl) continue;
                ((j)((Object)object2)).b = true;
                break;
            }
        }
        GamepadManager gamepadManager2 = relativeLayout;
        gamepadManager2.addView((View)gamepadManager2.mGamepad, 0);
        RelativeLayout relativeLayout = gamepadManager2.mEditor;
        if (relativeLayout != null) {
            relativeLayout.setVisibility(4);
        }
    }

    private void innerShowEditor(List<b.a> layoutParams) {
        RelativeLayout.LayoutParams layoutParams2;
        Object object = TAG;
        StringBuilder stringBuilder = new StringBuilder().append("(Version:2.0) edit gamepad with button ");
        Object object2 = layoutParams == null ? "null" : Integer.valueOf(layoutParams.size());
        LogUtils.i((String)object, (String)stringBuilder.append(object2).toString());
        object = object3.mEditor;
        if (object != null) {
            object3.removeView((View)object);
            object3.mEditor = null;
        }
        GamepadManager gamepadManager = object3;
        object3.mEditor = new g(object3.getContext(), null, 0);
        object3.mEditor.setOnEditListener(new e.b(){

            @Override
            public void a(boolean bl, List<b.a> list) {
                a a2 = this;
                a2.GamepadManager.this.mEditor.setVisibility(4);
                if (a2.GamepadManager.this.mEditListener != null) {
                    String string = null;
                    if (bl) {
                        string = new Gson().toJson(list);
                    }
                    GamepadManager.this.mEditListener.onFinishEdit(bl, string);
                }
            }
        });
        gamepadManager.mEditor.f = layoutParams;
        layoutParams = layoutParams2;
        layoutParams2 = new RelativeLayout.LayoutParams(-1, -1);
        gamepadManager.mEditor.setBackground(object3.getResources().getDrawable(R.drawable.black_back));
        gamepadManager.addView((View)gamepadManager.mEditor, (ViewGroup.LayoutParams)layoutParams);
        Object object3 = gamepadManager.mGamepad;
        if (object3 != null) {
            object3.setVisibility(4);
        }
    }

    private void handleTriggerEvent(String string, JSONObject jSONObject) {
        GamepadManager gamepadManager = gamepadManager3;
        GamepadManager gamepadManager2 = gamepadManager3;
        GamepadManager gamepadManager3 = Gamepad.KeyType.valueOf((String)string.toUpperCase(Locale.ENGLISH));
        int n2 = (Integer)gamepadManager2.getJsonValue(jSONObject, "x");
        boolean bl = (Boolean)gamepadManager.getJsonValue(jSONObject, "down");
        gamepadManager3.mSession.getGamepad().onGamepadTrigger((Gamepad.KeyType)gamepadManager3, n2, bl);
    }

    private void handleAxisEvent(String string, JSONObject jSONObject) {
        string = string.equals("axisleft") ? Gamepad.KeyType.LS : Gamepad.KeyType.RS;
        int n2 = (Integer)this.getJsonValue(jSONObject, "x");
        this.mSession.getGamepad().onGamepadStick((Gamepad.KeyType)string, n2, ((Integer)this.getJsonValue(jSONObject, "y")).intValue());
    }

    private void handleGamePadKeyEvent(JSONObject jSONObject) {
        int n2 = (Integer)this.getJsonValue(jSONObject, "key");
        this.mSession.getGamepad().onGamepadKey(n2, ((Boolean)this.getJsonValue(jSONObject, "down")).booleanValue());
    }

    private void handleKeyboardEvent(JSONObject jSONObject) {
        int n2 = (Integer)gamepadManager.getJsonValue(jSONObject, "key");
        boolean bl = (Boolean)gamepadManager.getJsonValue(jSONObject, "down");
        String string = (String)gamepadManager.getJsonValue(jSONObject, "name");
        if (n2 != 16 && n2 != 17 && n2 != 18) {
            gamepadManager.mSession.getKeyboard().onKeyboard(n2, bl);
        } else {
            String string2 = string;
            GamepadManager gamepadManager = gamepadManager.mSession.getKeyboard();
            boolean bl2 = string2.charAt(string2.length() - 1) == 'L';
            gamepadManager.onKeyboard(n2, bl, bl2);
        }
    }

    private void handleMouseEvent(String string, JSONObject jSONObject) {
        if (string.startsWith("mouse_scroll")) {
            gamepadManager2.mSession.getMouse().onMouseScroll(((Float)gamepadManager2.getJsonValue(jSONObject, "delta")).floatValue());
        } else {
            GamepadManager gamepadManager = gamepadManager2;
            GamepadManager gamepadManager2 = Mouse.KeyType.valueOf((String)string.substring(5).toUpperCase(Locale.ENGLISH));
            gamepadManager2.mSession.getMouse().onMouseKey((Mouse.KeyType)gamepadManager2, ((Boolean)gamepadManager.getJsonValue(jSONObject, "down")).booleanValue());
        }
    }

    private Object getJsonValue(JSONObject jSONObject, String string) {
        Object object = null;
        try {
            object = jSONObject.get(string);
        }
        catch (JSONException jSONException) {
            LogUtils.e((String)TAG, (String)("parse event failed,Event=" + jSONObject + "\n error=" + jSONException.getMessage()));
        }
        return object;
    }

    public void setEditListener(OnEditListener onEditListener) {
        this.mEditListener = onEditListener;
    }

    public void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        GamepadManager gamepadManager = this;
        super.onLayout(bl, n2, n3, n4, n5);
        if (!gamepadManager.isInited) {
            this.isInited = true;
            if (c.b != (float)this.getWidth()) {
                GamepadManager gamepadManager2 = this;
                c.b = gamepadManager2.getWidth();
                c.a = (float)gamepadManager2.getWidth() / 1920.0f;
            }
        }
    }

    public void showGamepad(String string) {
        this.innerShowGamepad(b.c(string));
    }

    public boolean needConnected() {
        Object object = object.mGamepad;
        if (object == null) {
            return false;
        }
        return ((j)((Object)object)).b;
    }

    public void editGamepad(String string) {
        this.innerShowEditor(b.c(string));
    }

    public void setGamePadTouchDelegate(IGamepadTouchDelegate iGamepadTouchDelegate) {
        j j2 = this.mGamepad;
        if (j2 != null) {
            j2.setGamePadTouchDelegate(iGamepadTouchDelegate);
        } else {
            this.mGamePadTouchDelegate = iGamepadTouchDelegate;
        }
    }

    @Override
    public void onSend(String string) {
        String string2;
        JSONObject jSONObject;
        block16: {
            if (this.mSession == null) {
                LogUtils.w((String)TAG, (String)"onSend() mSession = null");
                return;
            }
            jSONObject = null;
            string2 = "";
            if (!TextUtils.isEmpty((CharSequence)string)) {
                JSONObject jSONObject2;
                JSONObject jSONObject3 = jSONObject2;
                try {
                    jSONObject2 = new JSONObject(string);
                }
                catch (JSONException jSONException) {}
                try {
                    string2 = jSONObject2.getString("type");
                    jSONObject = jSONObject3;
                    break block16;
                }
                catch (JSONException jSONException) {
                    jSONObject = jSONObject3;
                }
                LogUtils.e((String)TAG, (String)("sendClickInstruction() json parse fail. instruction=" + string));
            }
        }
        if (string2.startsWith("mouse")) {
            this.handleMouseEvent(string2, jSONObject);
        } else if (string2.startsWith("keyboard")) {
            this.handleKeyboardEvent(jSONObject);
        } else if (string2.startsWith("gamepad")) {
            this.handleGamePadKeyEvent(jSONObject);
        } else if (string2.startsWith("axis")) {
            this.handleAxisEvent(string2, jSONObject);
        } else if (string2.equals("lt") || string2.equals("rt")) {
            this.handleTriggerEvent(string2, jSONObject);
        }
    }

    public static interface OnEditListener {
        public void onFinishEdit(boolean var1, String var2);
    }
}

