/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.pipes.transform;

import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.GraphQuery;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.pipes.transform.QueryPipe;
import com.tinkerpop.pipes.util.FastNoSuchElementException;
import com.tinkerpop.pipes.util.PipeHelper;

public class GraphQueryPipe<E extends Element>
extends QueryPipe<Graph, E> {
    public GraphQueryPipe(Class<E> elementClass) {
        super.setResultingElementClass(elementClass);
    }

    @Override
    public E processNextStart() {
        while (true) {
            if (this.count >= this.highRange) {
                throw FastNoSuchElementException.instance();
            }
            if (this.currentIterator.hasNext()) {
                ++this.count;
                Element e = (Element)this.currentIterator.next();
                if (this.count <= this.lowRange) continue;
                return (E)e;
            }
            Graph graph = (Graph)this.starts.next();
            GraphQuery query = graph.query();
            if (null != this.hasContainers) {
                for (QueryPipe.HasContainer hasContainer : this.hasContainers) {
                    query = query.has(hasContainer.key, hasContainer.predicate, hasContainer.value);
                }
            }
            if (null != this.intervalContainers) {
                for (QueryPipe.IntervalContainer intervalContainer : this.intervalContainers) {
                    query = query.interval(intervalContainer.key, intervalContainer.startValue, intervalContainer.endValue);
                }
            }
            if (this.highRange != Integer.MAX_VALUE) {
                query = query.limit(this.highRange - this.count);
            }
            this.currentIterator = this.elementClass.equals(Vertex.class) ? query.vertices().iterator() : query.edges().iterator();
        }
    }

    @Override
    public String toString() {
        return PipeHelper.makePipeString(this, super.toString());
    }
}

