/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.protocol;

import com.tongtech.tmqi.io.ReadWritePacket;
import com.tongtech.tmqi.jmsclient.ConnectionHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import javax.jms.JMSException;

public abstract class SocketConnectionHandler
implements ConnectionHandler {
    private static String defaultBufferSize = "2048";
    private boolean debug = true;
    private InputStream is = null;
    private OutputStream os = null;

    protected abstract void closeSocket() throws IOException;

    public boolean isDirectMode() {
        return false;
    }

    public ReadWritePacket readPacket() throws IOException {
        ReadWritePacket pkt = null;
        pkt.readPacket(this.is);
        return pkt;
    }

    public void writePacket(ReadWritePacket pkt) throws IOException {
        pkt.writePacket(this.os);
    }

    public void configure(Properties configuration) throws IOException {
        String bufsize;
        String prop = this.getProperty(configuration, "imqOutputBuffer", "true");
        if (prop.equals("true")) {
            bufsize = this.getProperty(configuration, "imqOutputBufferSize", defaultBufferSize);
            int outSize = Integer.parseInt(bufsize);
            this.os = new BufferedOutputStream(this.getOutputStream(), outSize);
            if (this.debug) {
                System.out.println("buffered output stream, buffer size: " + outSize);
            }
        } else {
            this.os = this.getOutputStream();
        }
        prop = this.getProperty(configuration, "imqInputBuffer", "true");
        if (prop.equals("true")) {
            bufsize = this.getProperty(configuration, "imqInputBufferSize", "2048");
            int inSize = Integer.parseInt(bufsize);
            this.is = new BufferedInputStream(this.getInputStream(), inSize);
            if (this.debug) {
                System.out.println("buffered input stream, buffer size: " + inSize);
            }
        } else {
            this.is = this.getInputStream();
        }
    }

    private String getProperty(Properties configuration, String propname, String propdefault) {
        String propval = (String)configuration.get(propname);
        if (propval == null) {
            propval = System.getProperty(propname);
        }
        return propval == null ? propdefault : propval;
    }

    @Override
    public void close() throws JMSException {
        try {
            this.getInputStream().close();
            if (this.is != null) {
                this.is.close();
            }
            if (this.os != null) {
                this.os.close();
            }
            this.closeSocket();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

