/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.protocol;

import com.tongtech.backport.java.util.concurrent.BlockingQueue;
import com.tongtech.backport.java.util.concurrent.ConcurrentHashMap;
import com.tongtech.jms.FileMessage;
import com.tongtech.jms.IllegalStateException;
import com.tongtech.jms.InvalidDestinationException;
import com.tongtech.jms.InvalidSelectorException;
import com.tongtech.jms.JMSException;
import com.tongtech.jms.JMSSecurityException;
import com.tongtech.jms.ResourceAllocationException;
import com.tongtech.jms.protocol.TlqRemoteReadOnlyPacket;
import com.tongtech.jms.protocol.TlqRemoteReadWritePacket;
import com.tongtech.jms.protocol.io.TlqRemoteConnectionHandler;
import com.tongtech.jms.util.InjectorUtil;
import com.tongtech.jmsclient.PartialMessageSender;
import com.tongtech.jmsclient.TlqRemoteReadChannel;
import com.tongtech.jmsclient.TlqRemoteReadMessageChannel;
import com.tongtech.jmsclient.filemessage.FileMessageSender;
import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.protocol.util.TcpBufferedInputStream;
import com.tongtech.protocol.util.TcpBufferedOutputStream;
import com.tongtech.protocol.util.TlqKnlMessagePropertiesUtil;
import com.tongtech.protocol.wireformat.WireFormatFactory;
import com.tongtech.remote.protocol.OpenWireFormat;
import com.tongtech.remote.protocol.OpenWireFormatFactory;
import com.tongtech.remote.protocol.command.ClientIdInfo;
import com.tongtech.remote.protocol.command.Command;
import com.tongtech.remote.protocol.command.ConnectionControl;
import com.tongtech.remote.protocol.command.ConnectionId;
import com.tongtech.remote.protocol.command.ConnectionInfo;
import com.tongtech.remote.protocol.command.ConsumerId;
import com.tongtech.remote.protocol.command.ConsumerInfo;
import com.tongtech.remote.protocol.command.DataArrayResponse;
import com.tongtech.remote.protocol.command.DataResponse;
import com.tongtech.remote.protocol.command.DataStructure;
import com.tongtech.remote.protocol.command.Destination;
import com.tongtech.remote.protocol.command.DestinationInfo;
import com.tongtech.remote.protocol.command.ExceptionResponse;
import com.tongtech.remote.protocol.command.KeepAliveInfo;
import com.tongtech.remote.protocol.command.LocalTransactionId;
import com.tongtech.remote.protocol.command.LongInfo;
import com.tongtech.remote.protocol.command.MessageAck;
import com.tongtech.remote.protocol.command.MessageId;
import com.tongtech.remote.protocol.command.MessagePull;
import com.tongtech.remote.protocol.command.MonitorInfo;
import com.tongtech.remote.protocol.command.MonitorResponse;
import com.tongtech.remote.protocol.command.PartialMessageAck;
import com.tongtech.remote.protocol.command.ProducerId;
import com.tongtech.remote.protocol.command.ProducerInfo;
import com.tongtech.remote.protocol.command.Redeliver;
import com.tongtech.remote.protocol.command.RemoveFileMessage;
import com.tongtech.remote.protocol.command.RemoveInfo;
import com.tongtech.remote.protocol.command.RemoveSubscriptionInfo;
import com.tongtech.remote.protocol.command.Response;
import com.tongtech.remote.protocol.command.ServerControl;
import com.tongtech.remote.protocol.command.SessionControl;
import com.tongtech.remote.protocol.command.SessionId;
import com.tongtech.remote.protocol.command.SessionInfo;
import com.tongtech.remote.protocol.command.StringInfo;
import com.tongtech.remote.protocol.command.TransactionId;
import com.tongtech.remote.protocol.command.TransactionInfo;
import com.tongtech.remote.protocol.command.WireFormatInfo;
import com.tongtech.remote.protocol.command.XATransactionId;
import com.tongtech.tmqi.AdministeredObject;
import com.tongtech.tmqi.InvalidPropertyValueException;
import com.tongtech.tmqi.Topic;
import com.tongtech.tmqi.Version;
import com.tongtech.tmqi.io.JMQByteArrayOutputStream;
import com.tongtech.tmqi.io.MessageIDGenerator;
import com.tongtech.tmqi.io.PacketType;
import com.tongtech.tmqi.io.ReadOnlyPacket;
import com.tongtech.tmqi.io.ReadWritePacket;
import com.tongtech.tmqi.io.SysMessageID;
import com.tongtech.tmqi.jmsclient.AckQueue;
import com.tongtech.tmqi.jmsclient.BrowserConsumer;
import com.tongtech.tmqi.jmsclient.BytesMessageImpl;
import com.tongtech.tmqi.jmsclient.ConnectionConsumerImpl;
import com.tongtech.tmqi.jmsclient.ConnectionHandler;
import com.tongtech.tmqi.jmsclient.ConnectionImpl;
import com.tongtech.tmqi.jmsclient.ConnectionResult;
import com.tongtech.tmqi.jmsclient.Consumer;
import com.tongtech.tmqi.jmsclient.ExceptionHandler;
import com.tongtech.tmqi.jmsclient.FileMessageImpl;
import com.tongtech.tmqi.jmsclient.MapMessageImpl;
import com.tongtech.tmqi.jmsclient.MessageConsumerImpl;
import com.tongtech.tmqi.jmsclient.MessageImpl;
import com.tongtech.tmqi.jmsclient.MessageProducerImpl;
import com.tongtech.tmqi.jmsclient.ObjectMessageImpl;
import com.tongtech.tmqi.jmsclient.ProtocolHandler;
import com.tongtech.tmqi.jmsclient.RemoteAcknowledgeException;
import com.tongtech.tmqi.jmsclient.SessionImpl;
import com.tongtech.tmqi.jmsclient.StreamMessageImpl;
import com.tongtech.tmqi.jmsclient.TemporaryDestination;
import com.tongtech.tmqi.jmsclient.TextMessageImpl;
import com.tongtech.tmqi.jmsclient.TlqSysMessageID;
import com.tongtech.tmqi.jmsclient.Transaction;
import com.tongtech.tmqi.net.IPAddress;
import com.tongtech.tmqi.util.IdGenerator;
import com.tongtech.tmqi.util.JMQXid;
import com.tongtech.tmqi.util.LongSequenceGenerator;
import com.tongtech.tmqi.util.NextCounter;
import com.tongtech.tmqi.util.TupleInput;
import com.tongtech.tmqi.util.selector.Selector;
import com.tongtech.tmqi.util.selector.SelectorFormatException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.jms.Message;

public class TlqRemoteProtocolHandler
implements ProtocolHandler {
    static Logger logger = LoggerFactory.getLogger(TlqRemoteProtocolHandler.class);
    private volatile boolean sentSetClientID = false;
    private volatile boolean hasConnectionConsumer = false;
    public static String defaultBufferSize = "8192";
    private static final Version version = new Version();
    public int timeout = 0;
    private long nextAckID = 0L;
    private DataInputStream is = null;
    private DataOutputStream os = null;
    private byte[] ipAddress = null;
    private byte[] macAddress = null;
    private int localPort = 0;
    public ConnectionImpl connection = null;
    public Hashtable requestMetaData = null;
    private ConnectionHandler connectionHandler = null;
    private boolean ackEnabled = true;
    private boolean ackEnabledFlag = false;
    private boolean produceAck = false;
    private boolean isClosed = false;
    public int stoppedCount = 0;
    private Object incObj = new Object();
    private boolean ackAck = true;
    public boolean authenticated = false;
    private Thread recoverThread = null;
    private boolean setJMSXAppID = false;
    private boolean setJMSXUserID = false;
    private boolean setJMSXRcvTimestamp = false;
    private String jmsxAppID = null;
    private String jmsxUserID = null;
    private static final String AUTHTYPE_JMQADMINKEY = "jmqadminkey";
    private static final String AUTHTYPE_JMQBASIC = "basic";
    private static final String AUTHTYPE_JMQDIGEST = "digest";
    private boolean timeToPing = false;
    private long nonRespPingTimeStamp = 0L;
    private Object nonResponsiveSyncObj = new Object();
    private boolean isPingTimeStampSet = false;
    private boolean imqAbortOnTimeout = false;
    private boolean enableZip = Boolean.getBoolean("imq.zip.enable");
    private boolean debugInboundPkt = false;
    private boolean debugOutboundPkt = false;
    private String pktFilter = null;
    private static java.util.logging.Logger inpktLogger = null;
    private static java.util.logging.Logger outpktLogger = null;
    protected boolean twoPhaseCommitFlag = false;
    private static boolean turnOffXMLValidation = Boolean.getBoolean("imq.xml.validation.disabled");
    private Hashtable xmlValidationTable = new Hashtable();
    private static WireFormatFactory wireformatFactory = new OpenWireFormatFactory();
    private OpenWireFormat writeWireformat = null;
    private OpenWireFormat readWireformat = null;
    public ConnectionId connectionId = null;
    public Map partialMessageErrorAckMap = null;
    private static final IdGenerator CONNECTION_ID_GENERATOR = new IdGenerator();
    private static final boolean MESSAGEID_DEBUG = Boolean.getBoolean("MsgIdDebug");
    private final LongSequenceGenerator sessionIdGenerator = new LongSequenceGenerator();
    private final LongSequenceGenerator consumerIdGenerator = new LongSequenceGenerator();
    private final LongSequenceGenerator producerIdGenerator = new LongSequenceGenerator();
    private final LongSequenceGenerator tempDestinationIdGenerator = new LongSequenceGenerator();
    private final LongSequenceGenerator localTransactionIdGenerator = new LongSequenceGenerator();
    private final LongSequenceGenerator recvCommandSeqGenerator = new LongSequenceGenerator();
    public final LongSequenceGenerator commandSeqGenerator = new LongSequenceGenerator();
    private String srcNode;
    private String rgsLoc;
    private String tlQmng;
    private MessageIDGenerator messageIDGenerator = null;
    private TcpBufferedOutputStream out;
    private TcpBufferedInputStream in;
    public Map fileSenderMap = new ConcurrentHashMap();
    public static String CONF_DIRNAME = "tongtech";
    public static String TEMP_FILE_DIRNAME = CONF_DIRNAME + File.separator + "tempfiles";
    public static String RECV_FILE_DIRNAME = CONF_DIRNAME + File.separator + "rcvfiles";
    public static String FILEMSG_CONF_DIR;
    public static String RECV_FILE_DIR;
    public static int CONNECTION_NUM;
    public boolean isLocalFile = false;
    private static int EVER_REDELIVER_NUM;
    private PartialMessageSender messageSender;

    private static void cleanTempFilesAndUnCompleteRcvFiles(File tempDir) {
        String[] files = tempDir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".msg") || name.endsWith(".rec");
            }
        });
        for (int i = 0; i < files.length; ++i) {
            File tempFile = new File(FILEMSG_CONF_DIR + File.separator + files[i]);
            long stayTimes = System.currentTimeMillis() - tempFile.lastModified();
            long stayTimesInDay = stayTimes / 86400000L;
            if (stayTimesInDay < 1L) continue;
            if (tempFile.getName().endsWith(".rec")) {
                try {
                    RandomAccessFile raFile = new RandomAccessFile(tempFile, "rw");
                    byte[] lengthBytes = new byte[4];
                    raFile.read(lengthBytes);
                    int length = TlqKnlMessagePropertiesUtil.parseInteger(lengthBytes);
                    byte[] nameBytes = new byte[length];
                    raFile.read(nameBytes);
                    String filename = new String(nameBytes, "UTF-8");
                    raFile.close();
                    File unCompleteFile = new File(filename);
                    if (unCompleteFile.exists()) {
                        unCompleteFile.delete();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            tempFile.delete();
        }
    }

    public static void createDirIfNotExists(File dir) throws Exception {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new Exception("Create dir fail " + FILEMSG_CONF_DIR);
        }
    }

    public Long getNextAckID() {
        Long ackid = NextCounter.getInstance().getNextAckID();
        return ackid;
    }

    public void setTimeToPing(boolean pflag) {
        this.timeToPing = pflag;
    }

    public boolean getTimeToPing() {
        return this.timeToPing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPingTimeStamp() {
        Object object = this.nonResponsiveSyncObj;
        synchronized (object) {
            this.isPingTimeStampSet = true;
            if (this.nonRespPingTimeStamp == 0L) {
                this.nonRespPingTimeStamp = System.currentTimeMillis();
                logger.trace("*** ping time stamp: {}", this.nonRespPingTimeStamp);
            } else {
                long currentTime = System.currentTimeMillis();
                long waitTime = currentTime - this.nonRespPingTimeStamp;
                if (waitTime > (long)this.timeout) {
                    this.connection.readChannel.setBrokerNonResponsive();
                    logger.trace("*** timeout on ping.  wait time: " + waitTime);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetPingTimeStamp() {
        Object object = this.nonResponsiveSyncObj;
        synchronized (object) {
            this.isPingTimeStampSet = false;
            this.nonRespPingTimeStamp = 0L;
            logger.trace("*** ping time stamp reset to 0 ...");
        }
    }

    private void findLocalHostIP() throws Exception {
        String useMac = System.getProperty("imq.useMac", "true");
        try {
            this.ipAddress = InetAddress.getLocalHost().getAddress();
            if (useMac.equalsIgnoreCase("true")) {
                this.macAddress = IPAddress.getRandomMac();
            }
            this.localPort = this.connectionHandler.getLocalPort();
        }
        catch (Exception e) {
            ExceptionHandler.logCaughtException(e);
            this.ipAddress = null;
            this.localPort = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePacketNoAck(ReadWritePacket pkt) throws javax.jms.JMSException {
        this.checkConnectionState(pkt);
        try {
            TlqRemoteProtocolHandler tlqRemoteProtocolHandler = this;
            synchronized (tlqRemoteProtocolHandler) {
                Command command = ((TlqRemoteReadWritePacket)pkt).getCommand();
                this.writeWireformat.marshal(command, this.os);
                this.os.flush();
                logger.debug("sent packet " + command + " to " + this.connection);
                this.setTimeToPing(false);
                if (logger.isTraceEnabled()) {
                    logger.trace("sent packet ... " + command, command);
                    if (command.getDataStructureType() == 10) {
                        logger.trace("connectionId : {},localPort:{}", this.connectionId, (Object)new Integer(this.localPort));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ExceptionHandler.handleException(e, "C4001", true);
        }
    }

    private ReadWritePacket writePacketWithReply(ReadWritePacket pkt, int expectedReplyType) throws javax.jms.JMSException {
        ReadWritePacket ack = this.writePacketWithAck(pkt);
        this.checkReplyType(ack, expectedReplyType);
        return ack;
    }

    private ReadWritePacket writePacketWithReply(ReadWritePacket pkt, int expectedReplyType, int altExpectedReplyType) throws javax.jms.JMSException {
        TlqRemoteReadWritePacket ack = (TlqRemoteReadWritePacket)this.writePacketWithAck(pkt);
        byte packetType = ack.getCommand().getDataStructureType();
        if (packetType != expectedReplyType && packetType != altExpectedReplyType) {
            logger.trace("expected pkt type: {}", expectedReplyType);
            logger.trace("alt expected pkt type: {}", altExpectedReplyType);
            logger.trace("pkt type: {}", packetType);
            String errorString = AdministeredObject.cr.getKString("C4000") + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new JMSException(errorString, "C4000"));
        }
        return ack;
    }

    private ReadWritePacket writePacketWithReply2(ReadWritePacket pkt, int expectedReplyType1, int expectedReplyType2) throws javax.jms.JMSException {
        TlqRemoteReadWritePacket ack = (TlqRemoteReadWritePacket)this.writePacketWithAck(pkt, true, expectedReplyType1);
        if (ack.getCommand().getDataStructureType() != expectedReplyType2) {
            logger.trace("expected pkt type: {}", expectedReplyType2);
            logger.trace("pkt type: {}", ack.getCommand().getDataStructureType());
            String errorString = AdministeredObject.cr.getKString("C4000") + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new JMSException(errorString, "C4000"));
        }
        return ack;
    }

    private void writePacketWithAck(ReadWritePacket pkt, int expectedAckType) throws javax.jms.JMSException {
        ReadWritePacket ack = this.writePacketWithReply(pkt, expectedAckType);
        int statusCode = TlqRemoteProtocolHandler.getReplyStatus(ack);
        if (statusCode != 200) {
            this.throwServerErrorException(ack);
        }
    }

    private ReadWritePacket writePacketWithAck(ReadWritePacket pkt) throws javax.jms.JMSException {
        return this.writePacketWithAck(pkt, false, -1);
    }

    private ReadWritePacket writePacketWithAck(ReadWritePacket pkt, boolean reply2, int expectedAckType1) throws javax.jms.JMSException {
        ReadWritePacket ack = null;
        Long ackId = this.getNextAckID();
        ((TlqRemoteReadWritePacket)pkt).getCommand().setCommandId(ackId.intValue());
        ((TlqRemoteReadWritePacket)pkt).getCommand().setResponseRequired(true);
        AckQueue tmpQ = reply2 ? new AckQueue(true, 2) : new AckQueue(true, 1);
        this.connection.addToAckQTable(ackId, tmpQ);
        this.addMetaData(pkt);
        this.writePacketNoAck(pkt);
        if ((this.connection.connectionIsBroken || this.connection.recoverInProcess) && tmpQ.isEmpty()) {
            ack = null;
        } else {
            logger.trace("writePacketWithAck, ack timeout is : {}, send...{}", this, (Object)new Integer(this.timeout));
            ack = (ReadWritePacket)tmpQ.dequeueWait(this.connection, null, this.timeout);
        }
        if (reply2 && ack != null) {
            try {
                String errorString;
                int statusCode = 0;
                byte packetType = ((TlqRemoteReadOnlyPacket)((Object)ack)).getCommand().getDataStructureType();
                if (packetType != expectedAckType1) {
                    errorString = AdministeredObject.cr.getKString("C4000") + this.getUserBrokerInfo();
                    ExceptionHandler.throwJMSException(new JMSException("packetType=" + packetType + ", expectedAckType1=" + expectedAckType1 + ", " + errorString, "C4000"));
                }
                if (packetType == 11) {
                    if (statusCode == 503) {
                        errorString = AdministeredObject.cr.getKString("C4037") + this.getUserBrokerInfo();
                        ExceptionHandler.throwJMSException((javax.jms.JMSException)((Object)new ResourceAllocationException(errorString, "C4037")));
                    } else if (statusCode == 408) {
                        errorString = AdministeredObject.cr.getKString("C4099") + this.getUserBrokerInfo();
                        ExceptionHandler.throwJMSException((javax.jms.JMSException)((Object)new ResourceAllocationException(errorString, "C4099")));
                    } else if (statusCode == 301) {
                        errorString = AdministeredObject.cr.getKString("C4100") + this.getUserBrokerInfo();
                        ExceptionHandler.throwJMSException((javax.jms.JMSException)((Object)new ResourceAllocationException(errorString, "C4100")));
                    }
                }
                if (statusCode != 200) {
                    this.throwServerErrorException(ack);
                }
                ack = (this.connection.connectionIsBroken || this.connection.recoverInProcess) && tmpQ.isEmpty() ? null : (ReadWritePacket)tmpQ.dequeueWait(this.connection, null, this.timeout);
            }
            catch (Exception e) {
                ExceptionHandler.handleException(e, "C4000", true);
            }
        }
        this.connection.removeFromAckQTable(ackId);
        if (ack == null) {
            String errorString = null;
            errorString = this.connectionId == null ? this.getUserBrokerInfo() + ", connect refused by jms server" : AdministeredObject.cr.getKString("C4000") + this.getUserBrokerInfo() + " Connection id:" + this.connectionId + " Expected AckId:" + ackId + " timeout" + this.timeout;
            ExceptionHandler.throwJMSException(new JMSException(errorString, "C4000"));
        }
        return ack;
    }

    protected void addMetaData(ReadOnlyPacket pkt) throws javax.jms.JMSException {
        TlqRemoteReadOnlyPacket remotePkt = (TlqRemoteReadOnlyPacket)pkt;
        byte pktType = remotePkt.getCommand().getDataStructureType();
        if (pktType == 5 || pktType == 26 || pktType == 6) {
            Hashtable props = remotePkt.getPacketProperties();
            Object consumer = props.get("requestMetaData");
            props.remove("requestMetaData");
            Long ackID = new Long(remotePkt.getCommand().getCommandId());
            this.requestMetaData.put(ackID, consumer);
        }
    }

    private void checkConnectionState(ReadWritePacket pkt) throws javax.jms.JMSException {
        if (this.connection.tmqiReconnect && this.connection.reconnecting && Thread.currentThread() != this.recoverThread && Thread.currentThread() != this.connection.readChannel.getReadChannelThread()) {
            this.connection.checkReconnecting(pkt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(boolean isReconnect) throws javax.jms.JMSException {
        this.isClosed = false;
        try {
            try {
                String bufsize;
                this.setTimeout();
                this.connectionHandler = isReconnect ? this.connection.initiator.reconnect() : this.connection.initiator.createConnection();
                String prop = this.connection.getProperty("imqOutputBuffer", "true");
                if (prop.equals("true")) {
                    bufsize = this.connection.getProperty("imqOutputBufferSize", defaultBufferSize);
                    int outSize = Integer.parseInt(bufsize);
                    this.out = new TcpBufferedOutputStream(this.connectionHandler.getOutputStream(), outSize);
                    this.os = new DataOutputStream(this.out);
                    logger.trace("buffered output stream, buffer size: {}", outSize);
                } else {
                    this.os = new DataOutputStream(this.connectionHandler.getOutputStream());
                }
                prop = this.connection.getProperty("imqInputBuffer", "true");
                if (prop.equals("true")) {
                    bufsize = this.connection.getProperty("imqInputBufferSize", "8192");
                    int inSize = Integer.parseInt(bufsize);
                    this.in = new TcpBufferedInputStream(this.connectionHandler.getInputStream(), inSize);
                    this.is = new DataInputStream(this.in);
                    logger.trace("buffered input stream, buffer size: {}", inSize);
                } else {
                    this.is = new DataInputStream(this.connectionHandler.getInputStream());
                }
                this.findLocalHostIP();
                this.writeWireformat = (OpenWireFormat)wireformatFactory.createWireFormat();
                this.readWireformat = (OpenWireFormat)wireformatFactory.createWireFormat();
                this.writeWireformat.setTightEncodingEnabled(true);
                this.readWireformat.setTightEncodingEnabled(true);
                this.writeWireformat.setVersion(3);
                this.readWireformat.setVersion(3);
                this.partialMessageErrorAckMap = new ConcurrentHashMap();
                this.messageSender = new PartialMessageSender(this.connection);
                this.setJMSXAppID = this.connection.connectionMetaData.setJMSXAppID;
                if (this.setJMSXAppID) {
                    this.jmsxAppID = InetAddress.getLocalHost().getHostAddress() + "-" + this.getLocalPort() + "-" + System.currentTimeMillis();
                }
                this.setJMSXUserID = this.connection.connectionMetaData.setJMSXUserID;
                if (this.setJMSXUserID) {
                    this.jmsxUserID = this.connection.getUserName();
                }
                this.setJMSXRcvTimestamp = this.connection.connectionMetaData.setJMSXRcvTimestamp;
                prop = this.connection.getProperty("imqAbortOnTimeout", "false");
                if ("true".equals(prop)) {
                    this.imqAbortOnTimeout = true;
                }
                this.nonRespPingTimeStamp = 0L;
                this.isPingTimeStampSet = false;
                logger.trace("*** Connected to broker: {}", (Object)this.getUserBrokerInfo());
            }
            catch (javax.jms.JMSException jmse) {
                throw jmse;
            }
            catch (Exception e) {
                ExceptionHandler.handleException(e, "C4038", true);
                Object var6_8 = null;
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            throw throwable;
        }
    }

    public void hello(String name, String password) throws javax.jms.JMSException {
        this.hello(name, password, null);
    }

    public void hello(String name, String password, String connectionID) throws javax.jms.JMSException {
        this.authenticated = false;
        TlqRemoteReadWritePacket pkt = (TlqRemoteReadWritePacket)InjectorUtil.createReadWritePacket(this.connection.getProtocolType());
        boolean isLocal = Boolean.valueOf(this.connection.getTrimmedProperty("tmqiLocalFileConnection"));
        WireFormatInfo wInfo = new WireFormatInfo();
        wInfo.setVersion(20111228);
        wInfo.setLocalFile(isLocal);
        pkt.setCommand(wInfo);
        ReadWritePacket brokerWireformat = this.writePacketWithReply(pkt, 1);
        try {
            WireFormatInfo wireformatinfo = (WireFormatInfo)TlqRemoteProtocolHandler.getOpenWireReplyPacket(brokerWireformat);
            wireformatinfo.setVersion(3);
            if (this.connectionHandler instanceof TlqRemoteConnectionHandler) {
                TlqRemoteConnectionHandler tlqConnectionHandler = (TlqRemoteConnectionHandler)this.connectionHandler;
                tlqConnectionHandler.setTcpNodelay(true);
            }
        }
        catch (IOException e) {
            String errorString = "Deal broker command WIREFORMAT error!";
            ExceptionHandler.throwJMSException((javax.jms.JMSException)((Object)new IllegalStateException(errorString, "C4037")));
        }
        ConnectionInfo cInfo = new ConnectionInfo();
        cInfo.setUserName(name);
        cInfo.setPassword(password);
        if (connectionID != null) {
            cInfo.setConnectionId(new ConnectionId(Short.parseShort(connectionID)));
        } else {
            cInfo.setConnectionId(new ConnectionId(-1));
        }
        pkt.setCommand(cInfo);
        TlqRemoteReadWritePacket cInfoReply = (TlqRemoteReadWritePacket)this.writePacketWithReply(pkt, 33);
        DataArrayResponse response = (DataArrayResponse)cInfoReply.getCommand();
        DataStructure[] data = response.getData();
        this.srcNode = ((StringInfo)data[0]).getInfo();
        this.rgsLoc = ((StringInfo)data[1]).getInfo();
        this.tlQmng = ((StringInfo)data[2]).getInfo();
        this.connectionId = new ConnectionId(new Short(((StringInfo)data[3]).getInfo()));
        logger.trace("SrcNode:{},rgsLoc:{},Qmng:{}", new Object[]{this.srcNode, this.rgsLoc, this.tlQmng});
        this.messageIDGenerator = new MessageIDGenerator(this.srcNode, this.rgsLoc, this.tlQmng);
        this.isLocalFile = isLocal;
        this.connection.connectionID = ((StringInfo)data[3]).getInfo();
        Hashtable<String, String> ht = new Hashtable<String, String>(1);
        ht.put("JMQVersion", version.getProductVersion());
        ht.put("JMQUserAgent", version.getUserAgent());
        logger.trace("send new connection :" + cInfo);
    }

    public void createMessageProducer(MessageProducerImpl producer) throws javax.jms.JMSException {
        com.tongtech.tmqi.Destination dest = (com.tongtech.tmqi.Destination)producer.getDestination();
        this.createMessageProducer(producer, dest);
    }

    public Integer getDestinationType(com.tongtech.tmqi.Destination destination) {
        int type = 0;
        type = destination.isQueue() ? 1 : 2;
        if (destination.isTemporary()) {
            type |= 0x10;
        }
        return new Integer(type);
    }

    protected void getIPFromPacket(ReadOnlyPacket rpkt) throws javax.jms.JMSException {
        try {
            Hashtable properties = rpkt.getProperties();
            Object value = properties.get("JMQIPAddr");
            this.ipAddress = (byte[])value;
            value = properties.get("JMQPort");
            this.localPort = (Integer)value;
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4005", true);
        }
    }

    public void enableWriteAcknowledge(boolean state) {
        this.ackEnabled = state;
        this.ackEnabledFlag = true;
        logger.trace("Producer ack required: " + this.ackEnabled);
    }

    public boolean getAckEnabled() {
        return this.ackEnabled;
    }

    public void setAckAck(boolean state) {
        this.ackAck = state;
        logger.trace("Auto/Client acknowledge require ack from broker: " + this.ackAck);
    }

    public boolean getAckAck() {
        return this.ackAck;
    }

    protected void setTimeout() {
        String prop = this.connection.getTrimmedProperty("tmqiAckTimeout");
        if (prop != null) {
            this.timeout = Integer.parseInt(prop);
        }
        logger.trace("Ack timeout: {}", this.timeout);
    }

    protected void setTimeOut(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public byte[] getIPAddress() {
        return this.ipAddress;
    }

    public byte[] getMacAddress() {
        return this.macAddress;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incStoppedCount() {
        Object object = this.incObj;
        synchronized (object) {
            ++this.stoppedCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decStoppedCount() {
        Object object = this.incObj;
        synchronized (object) {
            --this.stoppedCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStoppedCount() {
        Object object = this.incObj;
        synchronized (object) {
            return this.stoppedCount;
        }
    }

    public ReadWritePacket readPacket() throws javax.jms.JMSException {
        TlqRemoteReadWritePacket pkt = null;
        try {
            pkt = (TlqRemoteReadWritePacket)InjectorUtil.createReadWritePacket(this.connection.getProtocolType());
            Command command = (Command)this.readWireformat.unmarshal(this.is);
            pkt.setCommand(command);
            if (this.isPingTimeStampSet) {
                this.resetPingTimeStamp();
            }
            if (logger.isTraceEnabled()) {
                logger.trace("read packet ... " + pkt.getCommand(), pkt.getCommand());
                if (pkt.getCommand().getDataStructureType() == 10) {
                    logger.trace("connectionId : {},localPort:{}", this.connectionId, (Object)new Integer(this.localPort));
                }
            }
        }
        catch (Exception e) {
            if (!this.isClosed) {
                logger.error("read fail from " + this.connection, e);
                ExceptionHandler.handleException(e, "C4002", true);
            }
            throw new javax.jms.JMSException("ProtocolHandler is closed");
        }
        return pkt;
    }

    public void writeJMSMessage(Message message) throws javax.jms.JMSException {
        com.tongtech.tmqi.Destination dest;
        ReadWritePacket pkt = null;
        MessageImpl messageImpl = null;
        messageImpl = (MessageImpl)message;
        long jmsExpiration = message.getJMSExpiration();
        if (jmsExpiration != 0L) {
            long exprit = (jmsExpiration - 1L) / 1000L + 1L;
            exprit = exprit < 3L ? 3L : exprit;
            message.setJMSExpiration(exprit);
            message.setLongProperty("JMSExpiration", jmsExpiration += System.currentTimeMillis());
        }
        if (this.setJMSXAppID) {
            message.setStringProperty("JMSXAppID", this.jmsxAppID);
        }
        if (this.setJMSXUserID) {
            message.setStringProperty("JMSXUserID", this.jmsxUserID);
        }
        messageImpl.setMessageBodyToPacket();
        if (this.enableZip) {
            messageImpl.compress();
        } else if (messageImpl.shouldCompress) {
            messageImpl.compress();
        } else {
            messageImpl.getPacket().setFlag(1024, false);
        }
        this.addJmsHeaderToUserProperties(messageImpl);
        pkt = messageImpl.getPacket();
        boolean setMsgId = messageImpl.getBooleanProperty("SetMessageID");
        if (!MESSAGEID_DEBUG && !setMsgId) {
            messageImpl.resetJMSMessageID();
            pkt.setMessageID(null);
        }
        MessageId messageId = null;
        String msgid = messageImpl.getJMSMessageID();
        if (msgid != null && !msgid.equals("")) {
            messageId = new MessageId(msgid);
            messageImpl.setIntProperty("tlqmsgidlen", msgid.length());
        } else {
            messageId = new MessageId(this.messageIDGenerator.nextMessageId());
            if (messageId.getValue().length() != 32) {
                logger.warn("Messageid not 32 chars ,check it {}", messageId);
            }
        }
        messageImpl.setPropertiesToPacket();
        if (setMsgId) {
            try {
                pkt.getProperties().remove("SetMessageID");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.xmlValidationTable.containsKey(dest = (com.tongtech.tmqi.Destination)messageImpl.getJMSDestination())) {
            if (pkt.getPacketType() == 1) {
                logger.trace("*** Validating xml message ....");
            }
        } else {
            logger.trace("***** no validation for message ... on dest: " + dest.getName());
        }
        pkt.setDestination(dest.getName());
        pkt.setDestinationClass(dest.getClass().getName());
        pkt.setIsQueue(dest.isQueue());
        Destination destination = Destination.createDestination(dest.getName(), this.getDestinationType(dest));
        MessageProducerImpl producer = this.connection.findMessageProducer(new Long(messageImpl.getProducerID()));
        ProducerId producerId = this.genProducerId(producer, messageImpl);
        this.produceAck = this.ackEnabledFlag ? this.ackEnabled : message.getJMSDeliveryMode() == 2;
        try {
            message.setJMSTimestamp(System.currentTimeMillis() / 1000L);
        }
        catch (Exception e) {
            logger.warn("set JMSTimestamp error !", e);
        }
        if (pkt.getPacketType() == 7) {
            FileMessageSender fileSender = new FileMessageSender(this);
            messageId.setProducerId(producerId);
            fileSender.sendFileMessage(messageImpl, this.os, messageId, this.writeWireformat, this.produceAck, producer);
        } else {
            TlqRemoteReadWritePacket sendPacket = (TlqRemoteReadWritePacket)pkt;
            com.tongtech.remote.protocol.command.Message sendMessage = (com.tongtech.remote.protocol.command.Message)sendPacket.getCommand();
            sendMessage.setMessageId(messageId);
            sendMessage.setProducerId(producerId);
            sendMessage.setDestination(destination);
            sendMessage.setMessageType(pkt.getPacketType());
            sendMessage.setTransactionId(new LocalTransactionId(this.connectionId, (int)messageImpl.getPacket().getTransactionID()));
            sendPacket.setMessageID(messageId.getValue());
            sendMessage.setUsrContext(TlqRemoteProtocolHandler.getUsrContextFromMessage(messageImpl));
            logger.trace("send message, need ack {} ", this.produceAck);
            if (!this.produceAck) {
                pkt.setSendAcknowledge(false);
            }
            this.messageSender.sendWithPartialReply(sendMessage, this.os, this.writeWireformat, this, this.produceAck, producer);
        }
    }

    public static byte[] getUsrContextFromMessage(MessageImpl message) throws javax.jms.JMSException {
        String usrContext = message.getStringProperty("JMS_TONG_UsrContext");
        if (usrContext != null) {
            byte[] usrBytes = null;
            try {
                usrBytes = usrContext.getBytes("GB2312");
            }
            catch (UnsupportedEncodingException e) {
                usrBytes = usrContext.getBytes();
            }
            if (usrBytes.length > 64) {
                throw new javax.jms.JMSException("UsrContext too long !");
            }
            try {
                message.getPacket().getProperties().remove("JMS_TONG_UsrContext");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            return usrBytes;
        }
        return null;
    }

    private ProducerId genProducerId(MessageProducerImpl producer, MessageImpl messageImpl) {
        ProducerId producerId = new ProducerId();
        producerId.setSessionId((int)producer.getSession().getBrokerSessionID());
        producerId.setConnectionId(this.connectionId.getValue());
        producerId.setValue((int)messageImpl.getProducerID());
        return producerId;
    }

    private void addJmsHeaderToUserProperties(MessageImpl msg) throws javax.jms.JMSException {
        TlqRemoteReadWritePacket pkt = (TlqRemoteReadWritePacket)msg.getPacket();
        String correlationId = pkt.operateCommandAsMessage().getCorrelationId();
        if (correlationId == null) {
            try {
                pkt.getProperties().remove("JMSCorrelationID");
            }
            catch (Exception e) {
                logger.debug("clear JMSCorrelationID error", e);
            }
        }
        if (pkt.operateCommandAsMessage().getType() == null) {
            try {
                pkt.getProperties().remove("JMSType");
            }
            catch (Exception e) {
                logger.debug("clear JMSType error", e);
            }
        }
        if (msg.getJMSReplyTo() != null) {
            com.tongtech.tmqi.Destination replyTo = (com.tongtech.tmqi.Destination)msg.getJMSReplyTo();
            pkt.setReplyTo(replyTo.getName());
            pkt.setReplyToClass(replyTo.getClass().getName());
        }
        if (!msg.propertyExists("JMS_TONG_MessageType")) {
            msg.setIntProperty("JMS_TONG_MessageType", pkt.getPacketType());
        }
    }

    public MessageImpl getJMSMessage(ReadOnlyPacket pkt) throws javax.jms.JMSException {
        MessageImpl message = null;
        Command command = ((TlqRemoteReadOnlyPacket)pkt).getCommand();
        com.tongtech.remote.protocol.command.Message msg = (com.tongtech.remote.protocol.command.Message)command;
        Object msgType = msg.getProperties().get("JMS_TONG_MessageType");
        if (msgType == null) {
            if (msg.getMessageType() == 7) {
                msg.setMessageType(7);
            } else {
                msg.setMessageType(2);
                msg.setProperty("JMSExpiration", new Long(msg.getExpiration() == -1L ? 0L : msg.getExpiration() * 1000L + System.currentTimeMillis()));
            }
            msg.setProperty("JMS_TONG_MessageType", new Integer(msg.getMessageType()));
        } else {
            msg.setMessageType((Integer)msgType);
        }
        int protocolType = this.connection.getProtocolType();
        switch (msg.getMessageType()) {
            case 1: {
                message = new TextMessageImpl(protocolType);
                break;
            }
            case 2: {
                message = new BytesMessageImpl(protocolType);
                break;
            }
            case 4: {
                message = new StreamMessageImpl(protocolType);
                break;
            }
            case 3: {
                message = new MapMessageImpl(protocolType);
                break;
            }
            case 5: {
                message = new ObjectMessageImpl(protocolType);
                break;
            }
            case 7: {
                message = new FileMessageImpl(protocolType);
                break;
            }
            case 6: {
                message = new MessageImpl(protocolType);
                break;
            }
            default: {
                throw new JMSException("not implemented.");
            }
        }
        TlqRemoteReadWritePacket tlqPkt = (TlqRemoteReadWritePacket)InjectorUtil.createReadWritePacket(protocolType);
        tlqPkt.setCommand(msg);
        message.setPacket(tlqPkt);
        message.getPropertiesFromPacket();
        if (message instanceof FileMessage) {
            message.setBooleanProperty("JMS_TONG_RENAME_FLAG", msg.isRecievedByDFBridge());
        }
        if (msg.getUsrContext() != null) {
            String usrContext = null;
            try {
                usrContext = new String(msg.getUsrContext(), "GB2312");
            }
            catch (UnsupportedEncodingException e) {
                usrContext = new String(msg.getUsrContext());
            }
            message.setStringProperty("JMS_TONG_UsrContext", usrContext);
        }
        message.getMessageBodyFromPacket();
        if (this.setJMSXRcvTimestamp) {
            message.setStringProperty("JMSXRcvTimestamp", String.valueOf(System.currentTimeMillis()));
        }
        message.setMessageReadMode(true);
        message.setPropertiesReadMode(true);
        message.setMessageID(new TlqSysMessageID(msg.getMessageId().toString()));
        tlqPkt.setMessageID(msg.getMessageId().toString());
        tlqPkt.setConsumerID(msg.getSeqId());
        message.setFixedMessageID(msg.getMessageId().toString());
        message.setInterestID(msg.getTargetConsumerId().getValue());
        message.setJMSMessageID(msg.getMessageId().toString());
        message.setSeqId(msg.getSeqId());
        return message;
    }

    public void resetClientID() throws javax.jms.JMSException {
        if (this.sentSetClientID) {
            this.setClientID(this.connection.clientID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws javax.jms.JMSException {
        if (this.isClosed) {
            return;
        }
        try {
            try {
                this.isClosed = true;
                this.connectionHandler.getInputStream().close();
                this.is.close();
                this.os.close();
                this.connectionHandler.close();
                TlqRemoteReadChannel readMessageChannel = (TlqRemoteReadChannel)this.connection.readChannel;
                this.xmlValidationTable.clear();
            }
            catch (Exception e) {
                ExceptionHandler.handleException(e, "C4004", true);
                Object var3_4 = null;
            }
            Object var3_3 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            throw throwable;
        }
        logger.trace("ConnectionHandler closed ...");
    }

    public long startTransaction(long transactionID, int xaflags, JMQXid xid) throws javax.jms.JMSException {
        return this.startTransaction(transactionID, xaflags, xid, false, 0L);
    }

    public long startTransaction(long transactionID, int xaflags, JMQXid xid, long brokerSessionID) throws javax.jms.JMSException {
        return this.startTransaction(transactionID, xaflags, xid, true, brokerSessionID);
    }

    public JMQXid[] recover(int xaflags) throws javax.jms.JMSException {
        return null;
    }

    public void prepareHATransaction(long transactionID) throws javax.jms.JMSException {
    }

    public void commitHATransaction(long transactionID) throws javax.jms.JMSException {
    }

    public int verifyHATransaction(long transactionID, int tstate) throws javax.jms.JMSException {
        return this.verifyHATransaction(transactionID, tstate, null);
    }

    public int verifyHATransaction(long transactionID, int tstate, JMQXid xid) throws javax.jms.JMSException {
        return 0;
    }

    public void prepare(long transactionID, JMQXid xid) throws javax.jms.JMSException {
        this.prepare(transactionID, xid, false);
    }

    public void prepare(long transactionID, JMQXid xid, boolean onePhase) throws javax.jms.JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("comit TX, IS ONEPHASE " + onePhase);
        }
        TlqRemoteReadWritePacket pkt = (TlqRemoteReadWritePacket)InjectorUtil.createReadWritePacket(this.connection.getProtocolType());
        TransactionInfo tInfo = new TransactionInfo();
        tInfo.setType((byte)1);
        pkt.setCommand(tInfo);
        if (transactionID != -1L) {
            if (onePhase) {
                tInfo.setTransactionId(new LocalTransactionId(this.connectionId, (int)transactionID));
            } else {
                tInfo.setTransactionId(new XATransactionId(xid, (int)transactionID));
            }
        }
        ReadWritePacket ack = this.writePacketWithReply(pkt, 30);
        int statusCode = 200;
        if (statusCode == 200) {
            return;
        }
        if (statusCode == 400) {
            ExceptionHandler.throwJMSException(new JMSException(tInfo.toString(), "C4101"));
        }
        this.checkRemoteFailedStatus(statusCode, ack);
        this.throwServerErrorException(ack);
    }

    public Hashtable getLicense() throws javax.jms.JMSException {
        return null;
    }

    public long generateUID() throws javax.jms.JMSException {
        long globalUID = 0L;
        return globalUID;
    }

    public void rollback(long transactionID, JMQXid xid) throws javax.jms.JMSException {
        this._rollbackXA(transactionID, xid, false, false);
    }

    public void rollback(long transactionID, JMQXid xid, boolean redeliver) throws javax.jms.JMSException {
        this._rollbackXA(transactionID, xid, redeliver, false);
    }

    public void rollback(long transactionID, JMQXid xid, boolean redeliver, boolean setIBit) throws javax.jms.JMSException {
        this._rollbackXA(transactionID, xid, redeliver, setIBit);
    }

    private void _rollbackXA(long transactionID, JMQXid xid, boolean setJMQRedeliver, boolean setIBit) throws javax.jms.JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("rollbackXA.");
        }
        TlqRemoteReadWritePacket pkt = (TlqRemoteReadWritePacket)InjectorUtil.createReadWritePacket(this.connection.getProtocolType());
        TransactionInfo tInfo = new TransactionInfo();
        tInfo.setType((byte)4);
        if (xid == null) {
            if (transactionID != -1L) {
                tInfo.setTransactionId(new LocalTransactionId(this.connectionId, (int)transactionID));
            }
        } else {
            tInfo.setTransactionId(new XATransactionId(xid, (int)transactionID));
        }
        pkt.setCommand(tInfo);
        ReadWritePacket ack = this.writePacketWithReply(pkt, 30);
        int statusCode = 200;
        if (statusCode == 200) {
            return;
        }
        if (statusCode == 400) {
            ExceptionHandler.throwJMSException(new JMSException(tInfo.toString(), "C4101"));
        }
        this.checkRemoteFailedStatus(statusCode, ack);
        this.throwServerErrorException(ack);
    }

    public void commit(long transactionID, int xaflags, JMQXid xid) throws javax.jms.JMSException {
        this.commit(transactionID, xaflags, xid, false);
    }

    public void commit(long transactionID, int xaflags, JMQXid xid, boolean onePhasePropRequired) throws javax.jms.JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("comit TX, IS ONEPHASE " + (xaflags == 0x40000000) + ", XID: " + xid + ",txid:" + transactionID);
        }
        TlqRemoteReadWritePacket pkt = (TlqRemoteReadWritePacket)InjectorUtil.createReadWritePacket(this.connection.getProtocolType());
        TransactionInfo tInfo = new TransactionInfo();
        if (xaflags == 0x40000000) {
            tInfo.setType((byte)2);
        } else {
            tInfo.setType((byte)3);
        }
        pkt.setCommand(tInfo);
        if (xid == null) {
            if (transactionID != -1L) {
                if (logger.isTraceEnabled()) {
                    logger.trace("comit TX, local, txid:" + transactionID);
                }
                tInfo.setTransactionId(new LocalTransactionId(this.connectionId, (int)transactionID));
            }
        } else {
            if (logger.isTraceEnabled()) {
                logger.trace("comit TX, XA, txid:" + transactionID);
            }
            tInfo.setTransactionId(new XATransactionId(xid, (int)transactionID));
        }
        if (onePhasePropRequired) {
            // empty if block
        }
        if (xid != null) {
            // empty if block
        }
        ReadWritePacket ack = this.writePacketWithReply(pkt, 30);
        int statusCode = 200;
        if (statusCode == 200) {
            return;
        }
        if (statusCode == 400) {
            String errorString = AdministeredObject.cr.getKString("C4027", new Long(transactionID)) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new JMSException(errorString, "C4027"));
        }
        this.checkRemoteFailedStatus(statusCode, ack);
        this.throwServerErrorException(ack);
    }

    public void rollback(long transactionID) throws javax.jms.JMSException {
        TlqRemoteReadWritePacket pkt = (TlqRemoteReadWritePacket)InjectorUtil.createReadWritePacket(this.connection.getProtocolType());
        TransactionInfo tInfo = new TransactionInfo();
        tInfo.setType((byte)4);
        tInfo.setConnectionId(this.connectionId);
        tInfo.setTransactionId(new LocalTransactionId(this.connectionId, (int)transactionID));
        pkt.setCommand(tInfo);
        this.writePacketWithReply(pkt, 30);
    }

    public void verifyDestination(javax.jms.Destination destination, String selector, boolean browser) throws javax.jms.JMSException {
        try {
            Selector sel = Selector.compile(selector);
        }
        catch (SelectorFormatException e) {
            throw new javax.jms.InvalidSelectorException(selector + "compile fail, because " + e.getMessage());
        }
    }

    public SysMessageID[] browse(Consumer consumer) throws javax.jms.JMSException {
        DataStructure[] data;
        String errorString;
        com.tongtech.tmqi.Destination dest = (com.tongtech.tmqi.Destination)consumer.getDestination();
        String selector = consumer.getMessageSelector();
        TlqRemoteReadWritePacket pktsend = (TlqRemoteReadWritePacket)InjectorUtil.createReadWritePacket(2);
        ConsumerInfo cInfo = new ConsumerInfo();
        cInfo.setBrowser(true);
        cInfo.setConsumerId(new ConsumerId(new SessionId(this.connectionId, (int)consumer.getSession().getBrokerSessionID()), (int)this.consumerIdGenerator.getNextSequenceId()));
        cInfo.setDestination(Destination.createDestination(dest.getName(), this.getDestinationType(dest)));
        if (selector != null) {
            cInfo.setSelector(selector);
        }
        consumer.setInterestId(new Long(cInfo.getConsumerId().getValue()));
        Hashtable<String, Consumer> props = new Hashtable<String, Consumer>();
        props.put("requestMetaData", consumer);
        pktsend.setCommand(cInfo);
        pktsend.setPacketProperties(props);
        TlqRemoteReadOnlyPacket pktrev = (TlqRemoteReadOnlyPacket)((Object)this.writePacketWithReply(pktsend, 33));
        DataArrayResponse msgIDS = (DataArrayResponse)pktrev.getCommand();
        int statusCode = -1;
        statusCode = 200;
        if (statusCode == 400 && selector != null) {
            errorString = AdministeredObject.cr.getKString("C4022", selector) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException((javax.jms.JMSException)((Object)new InvalidSelectorException(errorString, "C4022")));
        }
        if (statusCode == 404) {
            errorString = AdministeredObject.cr.getKString("C4019", dest.getName()) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException((javax.jms.JMSException)((Object)new InvalidDestinationException(errorString, "C4019")));
        }
        if (statusCode == 403) {
            errorString = AdministeredObject.cr.getKString("C4083", dest.getName()) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException((javax.jms.JMSException)((Object)new JMSSecurityException(errorString, "C4083")));
        }
        if (statusCode != 200) {
            this.throwServerErrorException(pktrev);
        }
        if ((data = msgIDS.getData()) != null && data.length != 0) {
            int numItems = data.length;
            SysMessageID[] ids = new SysMessageID[numItems];
            for (int i = 0; i < numItems; ++i) {
                ids[i] = new TlqSysMessageID(((MessageId)data[i]).getValue());
            }
            return ids;
        }
        SysMessageID[] ids = new SysMessageID[]{};
        return ids;
    }

    public boolean deliver(ByteArrayOutputStream bos, Consumer consumer) throws javax.jms.JMSException {
        TlqRemoteReadWritePacket pkt = (TlqRemoteReadWritePacket)InjectorUtil.createReadWritePacket(2);
        MessagePull pInfo = new MessagePull();
        pInfo.setConsumerId(new ConsumerId(new SessionId(this.connectionId, (int)consumer.getSession().getBrokerSessionID()), (int)consumer.getInterestId().longValue()));
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(bos.toByteArray()));
        ArrayList<MessageId> msgIds = new ArrayList<MessageId>();
        try {
            while (true) {
                MessageId id = new MessageId(is.readUTF());
                msgIds.add(id);
            }
        }
        catch (EOFException e) {
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        pInfo.setMessageId(msgIds.toArray(new MessageId[0]));
        pkt.setCommand(pInfo);
        int statusCode = 200;
        TlqRemoteReadWritePacket ack = null;
        try {
            ack = (TlqRemoteReadWritePacket)this.writePacketWithReply(pkt, 30);
        }
        catch (javax.jms.JMSException e) {
            if (e.getMessage().indexOf("315") > 0) {
                statusCode = 404;
            }
            throw e;
        }
        if (statusCode == 404) {
            return false;
        }
        if (statusCode == 200) {
            return true;
        }
        this.throwServerErrorException(ack);
        return false;
    }

    public void suspendMessageDelivery() throws javax.jms.JMSException {
        this.stop();
    }

    public void resumeMessageDelivery() throws javax.jms.JMSException {
        this.start();
    }

    public void createSession(SessionImpl session) throws javax.jms.JMSException {
        SessionInfo sInfo = new SessionInfo();
        TlqRemoteReadWritePacket pkt = (TlqRemoteReadWritePacket)InjectorUtil.createReadWritePacket(this.connection.getProtocolType());
        if (!session.isTransacted) {
            sInfo.setAcknowledgeMode(session.acknowledgeMode);
        }
        long sessionId = session.getBrokerSessionID() != -1L ? session.getBrokerSessionID() : -1L;
        sInfo.setSessionId(new SessionId(this.connectionId, (int)sessionId));
        pkt.setCommand(sInfo);
        TlqRemoteReadWritePacket reply = (TlqRemoteReadWritePacket)this.writePacketWithReply(pkt, 33);
        DataArrayResponse response = (DataArrayResponse)reply.getCommand();
        DataStructure[] data = response.getData();
        sessionId = Integer.parseInt(((StringInfo)data[0]).getInfo());
        sInfo.setSessionId(new SessionId(this.connectionId, (int)sessionId));
        int statusCode = -1;
        long sessionID = -1L;
        session.setBrokerSessionID(sInfo.getSessionId().getValue());
        logger.trace("Added session, JMQSessionID: {}", session.getBrokerSessionID());
    }

    public void deleteSession(SessionImpl session) throws javax.jms.JMSException {
        logger.trace("removing session ....,{}", session.getBrokerSessionID());
        TlqRemoteReadWritePacket pkt = (TlqRemoteReadWritePacket)InjectorUtil.createReadWritePacket(this.connection.getProtocolType());
        RemoveInfo rInfo = new RemoveInfo();
        rInfo.setObjectId(new SessionId(this.connectionId, (int)session.getBrokerSessionID()));
        pkt.setCommand(rInfo);
        ReadWritePacket ack = this.writePacketWithReply(pkt, 32);
        int statusCode = 200;
        if (statusCode != 200) {
            this.throwServerErrorException(ack);
        }
    }

    protected static Command getOpenWireReplyPacket(ReadWritePacket ack) throws javax.jms.JMSException {
        return ((TlqRemoteReadWritePacket)ack).getCommand();
    }

    protected static int getReplyStatus(ReadWritePacket ack) throws javax.jms.JMSException {
        int statusCode = 200;
        return statusCode;
    }

    protected static Hashtable getReplyProperties(Command ack) throws javax.jms.JMSException {
        Hashtable ackProperties = null;
        return ackProperties;
    }

    protected void checkReplyType(ReadWritePacket ack, int expectedType) throws javax.jms.JMSException {
        Command command = ((TlqRemoteReadWritePacket)ack).getCommand();
        byte receivedType = command.getDataStructureType();
        if (receivedType == 31) {
            String info = ((ExceptionResponse)command).getException().getMessage();
            ExceptionHandler.throwJMSException(new JMSException(info));
        }
        if (receivedType != expectedType) {
            String errorString = AdministeredObject.cr.getKString("C4093", PacketType.getString(expectedType), PacketType.getString(receivedType)) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new JMSException(errorString, "C4093"));
        }
    }

    public void throwServerErrorException(Command ack) throws javax.jms.JMSException {
        String errorString = AdministeredObject.cr.getKString("C4036");
        try {
            Hashtable properties = TlqRemoteProtocolHandler.getReplyProperties(ack);
            String reason = (String)properties.get("JMQReason");
            Integer statusCode = (Integer)properties.get("JMQStatus");
            if (reason != null) {
                byte type = ack.getDataStructureType();
                String pktName = PacketType.getString(type);
                errorString = "[" + pktName + "] " + errorString + " :[" + statusCode + "] " + reason;
            }
            errorString = errorString + this.getUserBrokerInfo();
        }
        catch (Exception e) {
            logger.warn("", e);
        }
        ExceptionHandler.throwJMSException(new JMSException(errorString, "C4036"));
    }

    public void checkRemoteFailedStatus(int statusCode, Response ack) throws javax.jms.JMSException {
        if (statusCode != 410) {
            return;
        }
        Hashtable replyProps = TlqRemoteProtocolHandler.getReplyProperties(ack);
        if (replyProps == null) {
            return;
        }
        Boolean value = (Boolean)replyProps.get("JMQRemote");
        if (value != null && value.booleanValue()) {
            String errorString = AdministeredObject.cr.getKString("C4110");
            RemoteAcknowledgeException raex = new RemoteAcknowledgeException(errorString, "C4110");
            raex.setProperties(replyProps);
            ExceptionHandler.throwJMSException(raex);
        }
    }

    public void abort() {
        try {
            this.is.close();
            this.os.close();
            this.connectionHandler.close();
        }
        catch (Exception e) {
            ExceptionHandler.logCaughtException(e);
            logger.warn("", e);
        }
    }

    public void ping() throws javax.jms.JMSException {
        TlqRemoteReadWritePacket pkt = (TlqRemoteReadWritePacket)InjectorUtil.createReadWritePacket(this.connection.getProtocolType());
        KeepAliveInfo kInfo = new KeepAliveInfo();
        pkt.setCommand(kInfo);
        if (this.imqAbortOnTimeout && this.timeout > 0) {
            pkt.setFlag(16, true);
            this.setPingTimeStamp();
        }
        this.writePacketNoAck(pkt);
    }

    public void pingReply(ReadOnlyPacket ping) throws javax.jms.JMSException {
    }

    public ConnectionHandler getConnectionHandler() {
        return this.connectionHandler;
    }

    public String getUserBrokerInfo() {
        String lname = this.connection.getUserName();
        if (lname == null) {
            lname = "null";
        } else if (lname.length() == 0) {
            lname = "empty/blank";
        }
        String info = null;
        info = this.connectionHandler == null ? "unavailable" : this.connectionHandler.getBrokerAddress();
        return " user=" + lname + ", broker=" + info;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void redirect(String url) throws javax.jms.JMSException {
        logger.info("ProtocolHandler: redirect connection to the URL : {}", (Object)url);
        try {
            this.close();
        }
        catch (Exception e) {
            ExceptionHandler.logCaughtException(e);
            logger.warn("", e);
        }
        this.connection.initiator.setRedirectURL(url);
        this.init(true);
        logger.info("*** ProtocolHandler: connection redirected to the URL: {}", (Object)url);
    }

    public void resend(ReadWritePacket pkt) throws javax.jms.JMSException {
        this.writePacketNoAck(pkt);
    }

    public void setDebugInboundPkt(boolean flag) {
        this.debugInboundPkt = flag;
    }

    public void setDebugOutboundPkt(boolean flag) {
        this.debugOutboundPkt = flag;
    }

    public void setPktFilter(String filterSpec) {
        this.pktFilter = filterSpec;
    }

    public boolean isClientIDsent() {
        return this.sentSetClientID;
    }

    public String toString() {
        if (this.connectionHandler != null) {
            return this.connectionHandler.toString();
        }
        return "";
    }

    private void setXMLValidation(com.tongtech.tmqi.Destination dest, Response ack) throws javax.jms.JMSException {
        if (turnOffXMLValidation) {
            return;
        }
        try {
            Hashtable ackProperties = TlqRemoteProtocolHandler.getReplyProperties(ack);
            Object validateObj = ackProperties.get("JMQValidateXMLSchema");
            boolean shouldValidate = false;
            if (validateObj != null) {
                shouldValidate = (Boolean)validateObj;
            }
            if (shouldValidate) {
                String xsdURIList = null;
                Object uriobj = ackProperties.get("JMQXMLSchemaURIList");
                if (uriobj != null) {
                    xsdURIList = (String)uriobj;
                }
                if (!this.xmlValidationTable.containsKey(dest)) {
                    logger.trace("Adding xml validation entry for destination: {}, uriList: ", (Object)dest.getName(), (Object)xsdURIList);
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4005", true);
        }
    }

    public void setConnection(ConnectionImpl connection) throws javax.jms.JMSException {
        this.connection = connection;
        this.requestMetaData = connection.requestMetaData;
        inpktLogger = java.util.logging.Logger.getLogger("com.tongtech.jms.pkt.in");
        outpktLogger = java.util.logging.Logger.getLogger("com.tongtech.jms.pkt.out");
        this.init(false);
    }

    public void setRecoverThread(Thread thread) {
        this.recoverThread = thread;
    }

    public void setAuthenticated(boolean b) {
        this.authenticated = b;
    }

    public boolean getAuthenticated() {
        return this.authenticated;
    }

    public void setTwoPhaseCommitFlag(boolean b) {
        this.twoPhaseCommitFlag = b;
    }

    public void sendConsumerPause(Consumer consumer) throws javax.jms.JMSException {
    }

    public void checkout() throws javax.jms.JMSException {
    }

    public void checkout(Transaction transcation) throws javax.jms.JMSException {
    }

    public BlockingQueue getCheckinQueue() {
        return null;
    }

    public ReadWritePacket readPacket(int readType) throws javax.jms.JMSException {
        return this.readPacket();
    }

    public ConnectionResult getConnectionResult() throws javax.jms.JMSException {
        return new ConnectionResult("Tcp Connection", 0);
    }

    public void acknowledge(ReadWritePacket pkt) throws javax.jms.JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("TlqRemoteProtocolHandler: acknowledge");
        }
        TupleInput is = new TupleInput(pkt.getMessageBody());
        TlqRemoteReadWritePacket sendPacket = (TlqRemoteReadWritePacket)InjectorUtil.createReadWritePacket(2);
        ArrayList<LongInfo> midList = new ArrayList<LongInfo>();
        ArrayList<ConsumerId> cidList = new ArrayList<ConsumerId>();
        try {
            while (true) {
                long consumerId = is.readLong();
                Consumer consumer = this.connection.interestTable.getConsumer(new Long(consumerId));
                ConsumerId cid = null;
                if (consumer != null) {
                    cid = new ConsumerId(new SessionId(this.connectionId, (int)consumer.getSession().getBrokerSessionID()), (int)consumerId);
                }
                MessageId mid = new MessageId(is.readString());
                long seqId = is.readLong();
                if (consumer == null) continue;
                midList.add(new LongInfo(seqId));
                cidList.add(cid);
                logger.info("Acknowledge messageId:{},consumerId:{},seqId:{}", new Object[]{mid, cid, new Long(seqId)});
            }
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (Exception e) {
            logger.error("", e);
        }
        if (midList.size() == 0) {
            logger.warn("Messageid size is 0! ");
            return;
        }
        MessageAck ackInfo = new MessageAck();
        ackInfo.setConsumerIds(cidList.toArray(new ConsumerId[0]));
        ackInfo.setSeqIds(midList.toArray(new LongInfo[0]));
        ackInfo.setTransactionId(new LocalTransactionId(this.connectionId, (int)pkt.getTransactionID()));
        sendPacket.setCommand(ackInfo);
        logger.trace("Acknowledge TransactionId :{}" + ackInfo.getTransactionId());
        this.ackAck = false;
        if (pkt.getSendAcknowledge() && this.ackAck) {
            ReadWritePacket ack;
            int statusCode;
            if (logger.isTraceEnabled()) {
                logger.trace("need ack back ....");
            }
            if ((statusCode = TlqRemoteProtocolHandler.getReplyStatus(ack = this.writePacketWithReply(sendPacket, 30))) == 200) {
                return;
            }
            this.checkRemoteFailedStatus(statusCode, ack);
            this.throwServerErrorException(ack);
        } else {
            sendPacket.setSendAcknowledge(false);
            this.writePacketNoAck(sendPacket);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("TlqLocalProtocolHandler: end of acknowledge");
        }
    }

    public void acknowledgeUndeliverable(ReadWritePacket pkt, boolean sendToDMQ) throws javax.jms.JMSException {
    }

    public void addInterest(Consumer consumer) throws javax.jms.JMSException, javax.jms.InvalidSelectorException {
        if (consumer instanceof BrowserConsumer) {
            return;
        }
        String messageSelector = consumer.getMessageSelector();
        try {
            Selector sel = Selector.compile(messageSelector);
        }
        catch (SelectorFormatException e) {
            throw new javax.jms.InvalidSelectorException(messageSelector + "compile fail, because " + e.getMessage());
        }
        TlqRemoteReadWritePacket pkt = (TlqRemoteReadWritePacket)InjectorUtil.createReadWritePacket(2);
        ConsumerInfo info = new ConsumerInfo();
        com.tongtech.tmqi.Destination dest = (com.tongtech.tmqi.Destination)consumer.getDestination();
        this.createDestination(dest);
        long consuemrid = consumer.getInterestId() == null ? this.consumerIdGenerator.getNextSequenceId() : consumer.getInterestId().longValue();
        info.setConsumerId(new ConsumerId(new SessionId(this.connectionId, (int)consumer.getSession().getBrokerSessionID()), (int)consuemrid));
        if (consumer.getDurable()) {
            info.setSubscriptionName(consumer.getDurableName());
        }
        info.setDestination(Destination.createDestination(dest.getName(), this.getDestinationType(dest)));
        if (consumer.getMessageSelector() != null) {
            info.setSelector(consumer.getMessageSelector());
        }
        info.setNoLocal(consumer.getNoLocal());
        if (consumer.acknowledgeMode > 0) {
            // empty if block
        }
        info.setPrefetchSize(consumer.getPrefetchMaxMsgCount());
        if (!(consumer instanceof MessageConsumerImpl) && consumer instanceof ConnectionConsumerImpl) {
            this.hasConnectionConsumer = true;
        }
        if (consumer.getInterestId() != null) {
            // empty if block
        }
        consumer.setInterestId(new Long(info.getConsumerId().getValue()));
        Hashtable<String, Consumer> props = new Hashtable<String, Consumer>();
        props.put("requestMetaData", consumer);
        pkt.setPacketProperties(props);
        pkt.setCommand(info);
        ReadWritePacket reply = this.writePacketWithReply(pkt, 30);
        int statusCode = TlqRemoteProtocolHandler.getReplyStatus(reply);
        logger.trace("added interest, JMQConsumerID: {}", consumer.getInterestId());
    }

    public void checkRemoteFailedStatus(int statusCode, ReadOnlyPacket ack) throws javax.jms.JMSException {
    }

    public void createDestination(javax.jms.Destination dest) throws javax.jms.JMSException {
        TemporaryDestination tmpDest;
        com.tongtech.tmqi.Destination destination = (com.tongtech.tmqi.Destination)dest;
        Properties userPro = null;
        userPro = this.getDestinationValue(destination);
        if (destination.isTemporary() && !(tmpDest = (TemporaryDestination)destination).checkSendCreateDest(destination, this.connection)) {
            return;
        }
        TlqRemoteReadWritePacket pkt = (TlqRemoteReadWritePacket)InjectorUtil.createReadWritePacket(2);
        DestinationInfo dInfo = new DestinationInfo();
        dInfo.setConnectionId(this.connectionId);
        Destination desti = Destination.createDestination(destination.getName(), this.getDestinationType(destination));
        desti.setPropertyData(this.getUserDestinationValue(userPro));
        dInfo.setDestination(desti);
        dInfo.setOperationType((byte)0);
        pkt.setCommand(dInfo);
        ReadWritePacket ack = this.writePacketWithReply(pkt, 30);
        int statusCode = TlqRemoteProtocolHandler.getReplyStatus(ack);
        logger.trace("got create destination reply ...");
    }

    private Properties getDestinationValue(com.tongtech.tmqi.Destination destination) throws InvalidPropertyValueException {
        byte s;
        Properties pro = (Properties)destination.getConfiguration().clone();
        boolean isQueue = destination.isQueue();
        int num = 0;
        if (isQueue && !pro.get("LocalQueueName").equals("")) {
            pro.put("QN", pro.get("LocalQueueName"));
        }
        pro.remove("LocalQueueName");
        if (!pro.get("MsgSize").equals("")) {
            num = Integer.parseInt(pro.get("MsgSize").toString());
            pro.put("MS", new Integer(num));
        }
        pro.remove("MsgSize");
        if (!pro.get("MsgNum").equals("")) {
            num = Integer.parseInt(pro.get("MsgNum").toString());
            pro.put("MN", new Integer(num));
        }
        pro.remove("MsgNum");
        if (!pro.get("QueSpaceSize").equals("")) {
            num = Integer.parseInt(pro.get("QueSpaceSize").toString());
            pro.put("QSS", new Integer(num));
        }
        pro.remove("QueSpaceSize");
        if (!pro.get("LocalQueDataBuff").equals("")) {
            num = Integer.parseInt(pro.get("LocalQueDataBuff").toString());
            pro.put("DB", new Integer(num));
        }
        pro.remove("LocalQueDataBuff");
        if (!pro.get("MsgArrangeMode").equals("")) {
            num = Integer.parseInt(pro.get("MsgArrangeMode").toString());
            pro.put("MAM", new Integer(num));
        }
        pro.remove("MsgArrangeMode");
        if (!pro.get("UsageType").equals("")) {
            num = Integer.parseInt(pro.get("UsageType").toString());
            pro.put("UT", new Integer(num));
        }
        pro.remove("UsageType");
        if (!pro.get("DefPriority").equals("")) {
            num = Integer.parseInt(pro.get("DefPriority").toString());
            pro.put("DP", new Integer(num));
        }
        pro.remove("DefPriority");
        if (!pro.get("DefPersistence").equals("")) {
            num = Integer.parseInt(pro.get("DefPersistence").toString());
            pro.put("DPS", new Integer(num));
        }
        pro.remove("DefPersistence");
        if (!pro.get("TrigType").equals("")) {
            s = pro.get("TrigType").toString().getBytes()[0];
            if (s == 65 || s == 78 || s == 70 || s == 69) {
                pro.put("TT", new Byte(s));
            } else {
                throw new InvalidPropertyValueException("TrigType", String.valueOf(s));
            }
        }
        pro.remove("TrigType");
        if (!pro.get("TrigProgId").equals("")) {
            num = Integer.parseInt(pro.get("TrigProgId").toString());
            pro.put("TPI", new Integer(num));
        }
        pro.remove("TrigProgId");
        if (!pro.get("TrigAmount").equals("")) {
            num = Integer.parseInt(pro.get("TrigAmount").toString());
            pro.put("TA", new Integer(num));
        }
        pro.remove("TrigAmount");
        if (!pro.get("TrigPara").equals("")) {
            String s2 = pro.get("TrigPara").toString();
            if (!s2.equals("")) {
                pro.put("TP", s2);
            } else {
                throw new InvalidPropertyValueException("TrigPara", s2);
            }
        }
        pro.remove("TrigPara");
        if (!pro.get("QueueType").equals("")) {
            s = pro.get("QueueType").toString().getBytes()[0];
            if (s == 82 || s == 67 || s == 83 || s == 76 || s == 86) {
                pro.put("QT", new Byte(s));
            } else {
                throw new InvalidPropertyValueException("TrigType", String.valueOf(s));
            }
        }
        pro.remove("QueueType");
        return pro;
    }

    private byte[] getUserDestinationValue(Map pro) {
        JMQByteArrayOutputStream os = new JMQByteArrayOutputStream(new byte[50]);
        TlqKnlMessagePropertiesUtil.getByte(pro, os);
        return os.getBuf();
    }

    public void createMessageProducer(MessageProducerImpl producer, javax.jms.Destination destination) throws javax.jms.JMSException {
        String errorString;
        TlqRemoteReadWritePacket pkt = (TlqRemoteReadWritePacket)InjectorUtil.createReadWritePacket(2);
        com.tongtech.tmqi.Destination dest = (com.tongtech.tmqi.Destination)destination;
        this.createDestination(dest);
        int jmqBytes = Integer.parseInt(this.connection.getTrimmedProperty("tmqiProducerFlowBytesLimit"));
        ProducerInfo pInfo = new ProducerInfo();
        pInfo.setWindowSize(jmqBytes);
        Destination topicDesti = Destination.createDestination(dest.getName(), this.getDestinationType(dest));
        if (destination instanceof Topic) {
            topicDesti.setPropertyData(this.getUserDestinationValue(this.getDestinationValue(dest)));
        }
        pInfo.setDestination(topicDesti);
        pInfo.setProducerId(new ProducerId(new SessionId(this.connectionId, (int)producer.getSession().getBrokerSessionID()), (int)this.producerIdGenerator.getNextSequenceId()));
        producer.addProducerDest = dest;
        Hashtable<String, MessageProducerImpl> ht = new Hashtable<String, MessageProducerImpl>();
        ht.put("requestMetaData", producer);
        pkt.setPacketProperties(ht);
        pkt.setCommand(pInfo);
        ReadWritePacket reply = this.writePacketWithReply(pkt, 30);
        long producerID = pInfo.getProducerId().getValue();
        int statusCode = -1;
        int jmqSize = -1;
        if (statusCode == 404) {
            errorString = AdministeredObject.cr.getKString("C4019", dest.getName()) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException((javax.jms.JMSException)((Object)new InvalidDestinationException(errorString, "C4019")));
        }
        if (statusCode == 403) {
            errorString = AdministeredObject.cr.getKString("C4076", dest.getName()) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException((javax.jms.JMSException)((Object)new JMSSecurityException(errorString, "C4076")));
        }
        if (statusCode == 405) {
            String destString = AdministeredObject.cr.getString(dest.isQueue() ? "L0950" : "L0951");
            String errorString2 = AdministeredObject.cr.getKString("C4088", destString, dest.getName()) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException((javax.jms.JMSException)((Object)new ResourceAllocationException(errorString2, "C4088")));
        }
        producer.setProducerID(dest, pInfo.getProducerId().getValue());
        producer.setFlowBytesLimit(producerID, jmqBytes);
        logger.trace("got create producer reply ...");
    }

    public void deleteDestination(javax.jms.Destination dest) throws javax.jms.JMSException {
        com.tongtech.tmqi.Destination destination = (com.tongtech.tmqi.Destination)dest;
        TlqRemoteReadWritePacket pkt = (TlqRemoteReadWritePacket)InjectorUtil.createReadWritePacket(2);
        DestinationInfo dInfo = new DestinationInfo();
        dInfo.setConnectionId(this.connectionId);
        dInfo.setDestination(Destination.createDestination(destination.getName(), this.getDestinationType(destination)));
        dInfo.setOperationType((byte)1);
        pkt.setCommand(dInfo);
        ReadWritePacket ack = this.writePacketWithReply(pkt, 30);
        int statusCode = TlqRemoteProtocolHandler.getReplyStatus(ack);
        if (statusCode != 200 && statusCode != 404) {
            this.throwServerErrorException(ack);
        }
        logger.trace("got delete destination reply ...");
    }

    public void endHATransaction(long transactionID) throws javax.jms.JMSException {
    }

    public void endTransaction(long transactionID, int xaflags, JMQXid xid) throws javax.jms.JMSException {
        TlqRemoteReadWritePacket pkt = (TlqRemoteReadWritePacket)InjectorUtil.createReadWritePacket(this.connection.getProtocolType());
        TransactionInfo tInfo = new TransactionInfo();
        tInfo.setType((byte)7);
        pkt.setCommand(tInfo);
        tInfo.setTransactionId(new XATransactionId(xid, (int)transactionID));
        ReadWritePacket ack = this.writePacketWithReply(pkt, 30);
        int statusCode = 200;
        if (statusCode == 200) {
            return;
        }
        if (statusCode == 400) {
            ExceptionHandler.throwJMSException(new JMSException(tInfo.toString(), "C4101"));
        }
        this.checkRemoteFailedStatus(statusCode, ack);
        this.throwServerErrorException(ack);
    }

    public long getInterestId(ReadWritePacket pkt) {
        return 0L;
    }

    public void goodBye(boolean reply) throws javax.jms.JMSException {
        logger.trace("start call goodbye ....,{}" + this.connectionId);
        try {
            TlqRemoteReadWritePacket pkt = (TlqRemoteReadWritePacket)InjectorUtil.createReadWritePacket(2);
            RemoveInfo rInfo = new RemoveInfo();
            rInfo.setObjectId(this.connectionId);
            pkt.setCommand(rInfo);
            if (reply) {
                this.writePacketWithAck(pkt, 32);
            } else {
                this.writePacketNoAck(pkt);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4001", true);
        }
    }

    public void redeliver(ReadWritePacket pkt, boolean flag, boolean isTransacted) throws javax.jms.JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("TlqRemoteProtocolHandler: redeliver");
        }
        TupleInput is = new TupleInput(pkt.getMessageBody());
        TlqRemoteReadWritePacket sendPacket = (TlqRemoteReadWritePacket)InjectorUtil.createReadWritePacket(2);
        ArrayList<LongInfo> midList = new ArrayList<LongInfo>();
        ArrayList<ConsumerId> cidList = new ArrayList<ConsumerId>();
        Consumer consumer = null;
        try {
            while (true) {
                long consumerId = is.readLong();
                consumer = this.connection.interestTable.getConsumer(new Long(consumerId));
                ConsumerId cid = new ConsumerId(new SessionId(this.connectionId, (int)consumer.getSession().getBrokerSessionID()), (int)consumerId);
                MessageId mid = new MessageId(is.readString());
                long seqId = is.readLong();
                midList.add(new LongInfo(seqId));
                cidList.add(cid);
                logger.trace("Redeliver messageId:{},consumerId:{},seqId{}", new Object[]{mid, cid, new Long(seqId)});
            }
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (Exception e) {
            logger.error("", e);
        }
        Redeliver deliverInfo = new Redeliver();
        int startIndex = 0;
        int endIndex = EVER_REDELIVER_NUM;
        int allNum = midList.size();
        while (true) {
            long tid;
            try {
                deliverInfo.setSeqIds(midList.subList(startIndex, endIndex).toArray(new LongInfo[0]));
                deliverInfo.setConsumerId(cidList.subList(startIndex, endIndex).toArray(new ConsumerId[0]));
            }
            catch (IndexOutOfBoundsException ibe) {
                endIndex = allNum % EVER_REDELIVER_NUM + startIndex;
                deliverInfo.setSeqIds(midList.subList(startIndex, endIndex).toArray(new LongInfo[0]));
                deliverInfo.setConsumerId(cidList.subList(startIndex, endIndex).toArray(new ConsumerId[0]));
            }
            deliverInfo.setRedelivered(flag);
            if (isTransacted && (tid = pkt.getTransactionID()) > -1L) {
                deliverInfo.setTransactionId(new LocalTransactionId(this.connectionId, (int)pkt.getTransactionID()));
            }
            sendPacket.setCommand(deliverInfo);
            logger.trace("deliver isTransacted:{}", new Boolean(isTransacted));
            logger.trace("deliver TransactionId :{}", new Long(pkt.getTransactionID()));
            ReadWritePacket ack = this.writePacketWithReply(sendPacket, 30);
            if (logger.isTraceEnabled()) {
                logger.trace("TlqRemoteProtocolHandler: end of deliver");
            }
            if (allNum == endIndex) {
                return;
            }
            startIndex = endIndex;
            endIndex += EVER_REDELIVER_NUM;
        }
    }

    private void writeDeliverParket(int startNum, int endNum, boolean isTransacted, ArrayList midList, ArrayList cidList, ReadWritePacket pkt, TlqRemoteReadWritePacket sendPacket) {
    }

    public void removeInterest(Consumer consumer) throws javax.jms.JMSException {
        TlqRemoteReadWritePacket pkt = (TlqRemoteReadWritePacket)InjectorUtil.createReadWritePacket(2);
        ConsumerId consumerId = new ConsumerId(new SessionId(this.connectionId, (int)consumer.getSession().getBrokerSessionID()), consumer.getInterestId().intValue());
        TlqRemoteReadChannel readMessageChannel = (TlqRemoteReadChannel)this.connection.readChannel;
        RemoveInfo rInfo = new RemoveInfo();
        rInfo.setObjectId(consumerId);
        pkt.setCommand(rInfo);
        logger.trace("removing interest ....{}", consumer.getInterestId());
        ReadWritePacket ack = this.writePacketWithReply(pkt, 32);
        int statusCode = TlqRemoteProtocolHandler.getReplyStatus(ack);
        if (statusCode != 200) {
            this.throwServerErrorException(ack);
        }
        readMessageChannel.readChannel.cleanUpFileMessageReceiver(consumerId);
        logger.trace("interest removed: {}", consumer.getInterestId());
    }

    public void removeProducer(MessageProducerImpl producer, long producerid) throws javax.jms.JMSException {
        TlqRemoteReadWritePacket pkt = (TlqRemoteReadWritePacket)InjectorUtil.createReadWritePacket(2);
        ProducerId producerId = new ProducerId(new SessionId(this.connectionId, (int)producer.getSession().getBrokerSessionID()), (int)producerid);
        RemoveInfo rInfo = new RemoveInfo();
        rInfo.setObjectId(producerId);
        pkt.setCommand(rInfo);
        logger.trace("removing producer ....{}", producerid);
        ReadWritePacket ack = this.writePacketWithReply(pkt, 32);
        int statusCode = TlqRemoteProtocolHandler.getReplyStatus(ack);
        if (statusCode != 200) {
            this.throwServerErrorException(ack);
        }
        logger.trace("producer removed:{}", producerid);
    }

    public void resumeConsumerFlow(Consumer consumer, int maxMessages) throws javax.jms.JMSException {
    }

    public void resumeFlow(int maxMessages) throws javax.jms.JMSException {
    }

    public void setClientID(String clientID) throws javax.jms.JMSException {
        ClientIdInfo cid = new ClientIdInfo();
        cid.setValue(clientID);
        cid.setClientOperate((short)1);
        if (logger.isTraceEnabled()) {
            logger.trace("before sendClientID id is " + clientID);
        }
        Command response = this.sendCommandWithAck(cid, 33);
        this.sentSetClientID = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws javax.jms.JMSException {
        TlqRemoteReadWritePacket pkt = (TlqRemoteReadWritePacket)InjectorUtil.createReadWritePacket(2);
        try {
            Object object = this.incObj;
            synchronized (object) {
                if (this.stoppedCount == 0) {
                    ConnectionControl connectionInfo = new ConnectionControl();
                    connectionInfo.setStart(true);
                    pkt.setCommand(connectionInfo);
                    this.writePacketWithAck(pkt, 30);
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4001", true);
        }
    }

    public long startTransaction(long transactionID, int xaflags, JMQXid xid, boolean setSessionID, long brokerSessionID) throws javax.jms.JMSException {
        logger.trace("startTransaction....");
        TlqRemoteReadWritePacket pkt = (TlqRemoteReadWritePacket)InjectorUtil.createReadWritePacket(2);
        TransactionInfo tInfo = new TransactionInfo();
        tInfo.setConnectionId(this.connectionId);
        tInfo.setType((byte)0);
        if (xid != null) {
            tInfo.setTransactionId(new XATransactionId(xid, (int)transactionID));
        }
        pkt.setCommand(tInfo);
        tInfo.setSessionId((int)brokerSessionID);
        if (this.twoPhaseCommitFlag) {
            // empty if block
        }
        if (xaflags == -1 || xid != null) {
            // empty if block
        }
        int statusCode = 200;
        TlqRemoteReadWritePacket replypkt = (TlqRemoteReadWritePacket)this.writePacketWithReply(pkt, 32);
        DataResponse responseTxid = (DataResponse)replypkt.getCommand();
        TransactionId txid = (TransactionId)responseTxid.getData();
        if (txid.isLocalTransaction()) {
            transactionID = ((LocalTransactionId)txid).getValue();
        }
        if (statusCode == 409) {
            String errorString = AdministeredObject.cr.getKString("C4028", new Long(transactionID)) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new JMSException(errorString, "C4028"));
        }
        if (statusCode != 200) {
            this.throwServerErrorException(replypkt);
        }
        logger.trace("got transactionID:{}", new Long(transactionID));
        return transactionID;
    }

    public void stop() throws javax.jms.JMSException {
        TlqRemoteReadWritePacket pkt = (TlqRemoteReadWritePacket)InjectorUtil.createReadWritePacket(2);
        ConnectionControl connectionInfo = new ConnectionControl();
        connectionInfo.setSuspend(true);
        pkt.setCommand(connectionInfo);
        this.writePacketWithAck(pkt, 30);
    }

    public void throwServerErrorException(ReadOnlyPacket ack) throws javax.jms.JMSException {
    }

    public void unsetClientID() throws javax.jms.JMSException {
    }

    public void unsubscribe(String durableName) throws javax.jms.JMSException {
        RemoveSubscriptionInfo removeInfo = new RemoveSubscriptionInfo();
        removeInfo.setSubName(durableName);
        removeInfo.setClientId(this.connection.clientID);
        if (logger.isTraceEnabled()) {
            logger.trace("before durableName is " + durableName);
        }
        Command command = this.sendCommandWithAck(removeInfo, 33);
        this.sentSetClientID = true;
    }

    public String getConnectinId() throws javax.jms.JMSException {
        return String.valueOf(this.connectionId.getValue());
    }

    public long getConnectionTotalSendCount() {
        if (this.out != null) {
            return this.out.getTotalCount();
        }
        return 0L;
    }

    public long getConnectionTotalRecCount() {
        if (this.in != null) {
            return this.in.getTotalCount();
        }
        return 0L;
    }

    public void forgetTransaction(long transactionID, JMQXid xid) throws javax.jms.JMSException {
        TlqRemoteReadWritePacket pkt = (TlqRemoteReadWritePacket)InjectorUtil.createReadWritePacket(this.connection.getProtocolType());
        TransactionInfo tInfo = new TransactionInfo();
        tInfo.setType((byte)6);
        pkt.setCommand(tInfo);
        tInfo.setTransactionId(new XATransactionId(xid, (int)transactionID));
        ReadWritePacket ack = this.writePacketWithReply(pkt, 30);
        int statusCode = 200;
        if (statusCode == 200) {
            return;
        }
        if (statusCode == 400) {
            ExceptionHandler.throwJMSException(new JMSException(tInfo.toString(), "C4101"));
        }
        this.checkRemoteFailedStatus(statusCode, ack);
        this.throwServerErrorException(ack);
    }

    public void sendServerControl(byte type) throws javax.jms.JMSException {
        TlqRemoteReadWritePacket pkt = (TlqRemoteReadWritePacket)InjectorUtil.createReadWritePacket(this.connection.getProtocolType());
        ServerControl info = new ServerControl();
        info.setType(type);
        pkt.setCommand(info);
        this.writePacketNoAck(pkt);
    }

    public DataOutputStream getDataOutputStream() {
        return this.os;
    }

    public OpenWireFormat getOpenWireFormat() {
        return this.writeWireformat;
    }

    public Command sendCommandWithAck(Command command, int expectedReplyType) throws javax.jms.JMSException {
        int statusCode = 200;
        TlqRemoteReadWritePacket pkt = (TlqRemoteReadWritePacket)InjectorUtil.createReadWritePacket(2);
        pkt.setCommand(command);
        TlqRemoteReadWritePacket replypkt = (TlqRemoteReadWritePacket)this.writePacketWithReply(pkt, expectedReplyType);
        statusCode = TlqRemoteProtocolHandler.getReplyStatus(replypkt);
        if (statusCode != 200) {
            this.throwServerErrorException(replypkt);
        }
        Command response = replypkt.getCommand();
        return response;
    }

    public void sendCommandNoAck(Command command) throws javax.jms.JMSException {
        TlqRemoteReadWritePacket pkt = (TlqRemoteReadWritePacket)InjectorUtil.createReadWritePacket(2);
        pkt.setCommand(command);
        this.writePacketNoAck(pkt);
    }

    public static void handleSendError(Long ackid, TlqRemoteProtocolHandler handler) throws javax.jms.JMSException {
        Map errorMap = handler.partialMessageErrorAckMap;
        Object response = errorMap.get(ackid);
        if (response != null) {
            PartialMessageAck ack = (PartialMessageAck)response;
            errorMap.remove(ackid);
            if (ack.getStatusCode() != 0) {
                throw new javax.jms.JMSException(ack.getReason(), String.valueOf(ack.getStatusCode()));
            }
        }
    }

    public static TlqRemoteReadWritePacket waitForAck(TlqRemoteProtocolHandler handler, Long ackid, AckQueue tmpQ) throws javax.jms.JMSException {
        TlqRemoteReadWritePacket ack = (handler.connection.connectionIsBroken || handler.connection.recoverInProcess) && tmpQ.isEmpty() ? null : (TlqRemoteReadWritePacket)tmpQ.dequeueWait(handler.connection, null, handler.timeout);
        if (ack == null) {
            String errorString = AdministeredObject.cr.getKString("C4000") + handler.getUserBrokerInfo() + " connection id:" + handler.connectionId + "expected ackId:" + ackid + " " + handler.timeout;
            ExceptionHandler.throwJMSException(new JMSException(errorString, "C4000"));
        }
        return ack;
    }

    public void stopSession(SessionImpl session) throws javax.jms.JMSException {
    }

    public void resumeSession(SessionImpl session) throws javax.jms.JMSException {
    }

    public void rollbackSession(SessionImpl session) throws javax.jms.JMSException {
        DataResponse responseMsgid;
        SessionControl sControl = new SessionControl();
        TlqRemoteReadWritePacket pkt = (TlqRemoteReadWritePacket)InjectorUtil.createReadWritePacket(this.connection.getProtocolType());
        sControl.setSessionId(new SessionId(this.connectionId, (int)session.getBrokerSessionID()));
        sControl.setRollback(true);
        sControl.setResume(false);
        sControl.setSuspend(false);
        sControl.setClose(false);
        pkt.setCommand(sControl);
        TlqRemoteReadWritePacket reply = null;
        try {
            reply = (TlqRemoteReadWritePacket)this.writePacketWithReply(pkt, 32);
        }
        catch (javax.jms.JMSException e) {
            logger.error("rollbackSession error {}", sControl.getSessionId());
            throw e;
        }
        int statusCode = TlqRemoteProtocolHandler.getReplyStatus(reply);
        if (statusCode != 200) {
            this.throwServerErrorException(reply);
        }
        if (null != (responseMsgid = (DataResponse)reply.getCommand()).getData()) {
            long seqId = ((LongInfo)responseMsgid.getData()).getInfo();
            Hashtable consumers = session.getAllMessageConsumer();
            Enumeration consumerIds = consumers.keys();
            TlqRemoteReadMessageChannel readMessageChannel = ((TlqRemoteReadChannel)this.connection.readChannel).readChannel;
            readMessageChannel.partialMessageMap.remove(new Long(seqId));
            readMessageChannel.fileInfoMap.remove(new Long(seqId));
            while (consumerIds.hasMoreElements()) {
                Long id = (Long)consumerIds.nextElement();
                readMessageChannel.fileReceiverMap.remove(new ConsumerId(new SessionId(this.connectionId, (int)session.getBrokerSessionID()), id.intValue()));
                MessageConsumerImpl consumer = (MessageConsumerImpl)consumers.get(id);
                String fileNames = consumer.getTranMsgFileName();
                String[] files = fileNames.split(";");
                for (int n = 0; n < files.length; ++n) {
                    File f = new File(files[n]);
                    if (!f.exists() || !f.isFile()) continue;
                    f.delete();
                }
                consumer.deleteFileOfRollbackMsg();
            }
        }
    }

    public void rollbackEnd(Long txId) throws javax.jms.JMSException {
    }

    public void rollbackStart(SessionImpl sessionImpl) {
    }

    public Properties monitor(MonitorInfo monitorInfo) throws Exception {
        TlqRemoteReadWritePacket pkt = (TlqRemoteReadWritePacket)InjectorUtil.createReadWritePacket(this.connection.getProtocolType());
        pkt.setCommand(monitorInfo);
        ReadWritePacket replyPkt = this.writePacketWithReply(pkt, 36);
        MonitorResponse command = (MonitorResponse)((TlqRemoteReadWritePacket)replyPkt).getCommand();
        Properties pro = null;
        byte[] value = command.getValue();
        pro = TlqKnlMessagePropertiesUtil.getProperties(value, value.length);
        return pro;
    }

    public void removeFilemessage(byte[] messageId, ProducerId producerId, boolean force) throws javax.jms.JMSException {
        TlqRemoteReadWritePacket pkt = (TlqRemoteReadWritePacket)InjectorUtil.createReadWritePacket(2);
        RemoveInfo removeInfo = new RemoveInfo();
        RemoveFileMessage removeCommand = new RemoveFileMessage();
        removeCommand.setByteValue(messageId);
        removeCommand.setProducerId(producerId);
        removeCommand.setForce(force);
        removeInfo.setObjectId(removeCommand);
        pkt.setCommand(removeInfo);
        ReadWritePacket replyPkt = this.writePacketWithReply(pkt, 30);
        Response response = (Response)((TlqRemoteReadWritePacket)replyPkt).getCommand();
    }

    static {
        CONNECTION_NUM = 0;
        EVER_REDELIVER_NUM = 650;
        try {
            String homeDir = System.getProperty("user.home");
            FILEMSG_CONF_DIR = homeDir + File.separator + TEMP_FILE_DIRNAME;
            RECV_FILE_DIR = homeDir + File.separator + RECV_FILE_DIRNAME;
            File tempDir = new File(FILEMSG_CONF_DIR);
            File recvDir = new File(RECV_FILE_DIR);
            TlqRemoteProtocolHandler.createDirIfNotExists(tempDir);
            TlqRemoteProtocolHandler.createDirIfNotExists(recvDir);
            TlqRemoteProtocolHandler.cleanTempFilesAndUnCompleteRcvFiles(tempDir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

