/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.protocol;

import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.remote.protocol.command.Command;
import com.tongtech.remote.protocol.command.Message;
import com.tongtech.tmqi.io.JMQByteArrayOutputStream;
import com.tongtech.tmqi.io.PacketProperties;
import com.tongtech.tmqi.io.PacketType;
import com.tongtech.tmqi.io.ReadOnlyPacket;
import com.tongtech.tmqi.io.SysMessageID;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.util.Hashtable;

public class TlqRemoteReadOnlyPacket
implements ReadOnlyPacket {
    static Logger logger = LoggerFactory.getLogger(TlqRemoteReadOnlyPacket.class);
    public static short defaultVersion = (short)301;
    protected static final int HEADER_SIZE = 72;
    protected byte[] headerBuffer = new byte[72];
    protected byte[] ropBuffer = null;
    protected int ropLength = 0;
    protected int version = defaultVersion;
    protected int magic = 469754818;
    protected int packetType = 0;
    protected int packetSize = 0;
    protected long expiration = 0L;
    protected int propertyOffset = 0;
    protected int propertySize = 0;
    protected int encryption = 0;
    protected long transactionID = -1L;
    protected int priority = 5;
    protected int bitFlags = 0;
    protected long consumerID = 0L;
    protected SysMessageID sysMessageID;
    protected String destination = null;
    protected String destinationClass = null;
    protected String messageID = null;
    protected String correlationID = null;
    protected String replyTo = null;
    protected String replyToClass = null;
    protected String messageType = null;
    protected long producerID = 0L;
    protected boolean stringsParsed = false;
    protected Hashtable properties = null;
    protected Command openwireCommand;
    protected JMQByteArrayOutputStream msgContentBuf = null;
    protected JMQByteArrayOutputStream msgPropBuf = null;
    protected long partialMessageLastRecTimestamp;

    public Command getCommand() {
        return this.openwireCommand;
    }

    public TlqRemoteReadOnlyPacket() {
        this.reset();
        this.openwireCommand = new Message();
    }

    public static void setDefaultVersion(short version) {
        defaultVersion = version;
    }

    @Override
    public void readPacket(InputStream is) throws IOException, EOFException, StreamCorruptedException, IllegalArgumentException {
        this.readFixedHeader(is);
        this.readRestOfPacket(is);
    }

    @Override
    public void retryReadPacket(InputStream is) throws IOException, EOFException, StreamCorruptedException, IllegalArgumentException {
        if (this.packetSize == 0) {
            this.readPacket(is);
        } else {
            this.readRestOfPacket(is);
        }
    }

    private void readFixedHeader(InputStream is) throws IOException, EOFException, StreamCorruptedException {
        this.reset();
        this.readFully(is, this.headerBuffer, 0, 72, false);
        this.parseHeader(new ByteArrayInputStream(this.headerBuffer));
    }

    private void readRestOfPacket(InputStream is) throws IOException, EOFException, IllegalArgumentException {
        this.ropLength = this.packetSize - 72;
        if (this.ropBuffer == null || this.ropBuffer.length < this.ropLength || this.ropBuffer.length > 2 * this.ropLength) {
            this.ropBuffer = null;
            this.ropBuffer = new byte[this.ropLength];
        }
        this.readFully(is, this.ropBuffer, 0, this.ropLength, true);
        if (this.version != 103 && this.version != 200 && this.version != 301) {
            throw new IllegalArgumentException("Bad packet version number: " + this.version + ". Expecting: " + 103 + " or " + 200 + " or " + 301);
        }
        if (this.propertyOffset != 72) {
            this.parseVariableFields(new ByteArrayInputStream(this.ropBuffer));
        }
    }

    private void readFully(InputStream in, byte[] b, int off, int len, boolean retry) throws IOException, EOFException, InterruptedIOException {
        int count;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n = 0; n < len; n += count) {
            count = 0;
            try {
                count = in.read(b, off + n, len - n);
            }
            catch (InterruptedIOException e) {
                if (!retry && n == 0 && count == 0 && e.bytesTransferred == 0) {
                    throw new InterruptedIOException("no data available");
                }
                count = e.bytesTransferred;
                Thread.currentThread();
                Thread.yield();
            }
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    private void parseHeader(InputStream is) throws IOException {
        DataInputStream d = new DataInputStream(is);
        this.magic = d.readInt();
        if (this.magic != 469754818) {
            throw new StreamCorruptedException("Bad packet magic number: " + this.magic + ". Expecting: " + 469754818);
        }
        this.version = d.readShort();
        this.packetType = d.readShort();
        this.packetSize = d.readInt();
        if (this.version == 103) {
            this.transactionID = d.readInt();
        }
        this.expiration = d.readLong();
        this.propertyOffset = d.readInt();
        this.propertySize = d.readInt();
        this.priority = d.readByte();
        this.encryption = d.readUnsignedByte();
        this.bitFlags = d.readUnsignedShort();
        this.consumerID = this.version == 103 ? (long)d.readInt() : d.readLong();
    }

    @Override
    public boolean getFlag(int flag) {
        return (this.bitFlags & flag) == flag;
    }

    private void parseVariableFields(InputStream is) throws IOException {
        DataInputStream d = new DataInputStream(is);
        short type = d.readShort();
        while (type != 0) {
            switch (type) {
                case 1: {
                    String s;
                    this.destination = s = d.readUTF();
                    break;
                }
                case 8: {
                    int len = d.readUnsignedShort();
                    this.transactionID = d.readLong();
                    break;
                }
                case 9: {
                    int len = d.readUnsignedShort();
                    this.producerID = d.readLong();
                    break;
                }
                case 2: {
                    String s;
                    this.messageID = s = d.readUTF();
                    break;
                }
                case 3: {
                    String s;
                    this.correlationID = s = d.readUTF();
                    break;
                }
                case 4: {
                    String s;
                    this.replyTo = s = d.readUTF();
                    break;
                }
                case 5: {
                    String s;
                    this.messageType = s = d.readUTF();
                    break;
                }
                case 6: {
                    String s;
                    this.destinationClass = s = d.readUTF();
                    break;
                }
                case 7: {
                    String s;
                    this.replyToClass = s = d.readUTF();
                    break;
                }
                default: {
                    d.skipBytes(d.readUnsignedShort());
                }
            }
            type = d.readShort();
        }
        this.stringsParsed = true;
    }

    private void parseProperties(InputStream is) throws IOException, ClassNotFoundException {
        if (this.version == 301) {
            this.properties = PacketProperties.parseProperties(is);
        } else {
            ObjectInputStream p = new ObjectInputStream(is);
            this.properties = (Hashtable)p.readObject();
        }
    }

    @Override
    public void writePacket(OutputStream os) throws IOException {
        os.write(this.headerBuffer, 0, 72);
        if (this.ropBuffer != null) {
            os.write(this.ropBuffer, 0, this.ropLength);
        }
        os.flush();
    }

    @Override
    public void writePacket(OutputStream os, int new_version) throws IOException {
        if (new_version == this.version) {
            this.writePacket(os);
        } else {
            this.writePacket(os, new_version, this.consumerID, this.getFlag(4), this.getFlag(2), this.getFlag(32));
        }
    }

    @Override
    public void writePacket(OutputStream os, long new_consumerID, boolean new_pauseFlow, boolean new_redelivered, boolean new_lastPkt) throws IOException {
        this.writePacket(os, this.version, new_consumerID, new_pauseFlow, new_redelivered, new_lastPkt);
    }

    @Override
    public void writePacket(OutputStream os, int new_version, long new_consumerID, boolean new_pauseFlow, boolean new_redelivered, boolean new_lastPkt) throws IOException {
        if (this.headerBuffer == null) {
            throw new IOException("No buffer to write");
        }
        DataOutputStream dos = new DataOutputStream(os);
        if (new_version == this.version) {
            if (new_version == 103) {
                dos.write(this.headerBuffer, 0, 66);
            } else {
                dos.write(this.headerBuffer, 0, 62);
            }
        } else {
            this.version = new_version;
            dos.writeInt(469754818);
            dos.writeShort(this.version);
            dos.writeShort(this.packetType);
            dos.writeInt(this.packetSize);
            if (this.version == 103) {
                dos.writeInt((int)this.transactionID);
            }
            dos.writeLong(this.expiration);
            dos.writeInt(this.propertyOffset);
            dos.writeInt(this.propertySize);
            dos.writeByte(this.priority);
            dos.writeByte(this.encryption);
        }
        int flags = this.bitFlags;
        flags = new_redelivered ? (flags |= 2) : (flags &= 0xFFFFFFFD);
        flags = new_lastPkt ? (flags |= 0x20) : (flags &= 0xFFFFFFDF);
        flags = new_pauseFlow ? (flags |= 0x40) : (flags &= 0xFFFFFFBF);
        dos.writeShort(flags);
        if (new_version == 103) {
            dos.writeInt((int)new_consumerID);
        } else {
            dos.writeLong(new_consumerID);
        }
        if (this.ropBuffer != null) {
            dos.write(this.ropBuffer, 0, this.ropLength);
        }
        dos.flush();
    }

    @Override
    public boolean isEqual(SysMessageID id) {
        return false;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public int getMagic() {
        return this.magic;
    }

    @Override
    public int getPacketType() {
        return this.packetType;
    }

    @Override
    public int getPacketSize() {
        return this.packetSize;
    }

    @Override
    public long getTimestamp() {
        Object value = this.operateCommandAsMessage().getProperty("JMSTimestamp");
        if (value != null) {
            return (Long)value;
        }
        return 0L;
    }

    protected Message operateCommandAsMessage() {
        return (Message)this.openwireCommand;
    }

    @Override
    public long getExpiration() {
        Object value = this.operateCommandAsMessage().getProperty("JMSExpiration");
        if (value != null) {
            return (Long)value;
        }
        return 0L;
    }

    @Override
    public int getPort() {
        return 0;
    }

    @Override
    public String getIPString() {
        return "";
    }

    @Override
    public byte[] getIP() {
        return null;
    }

    @Override
    public int getSequence() {
        return 0;
    }

    @Override
    public int getPropertyOffset() {
        return this.propertyOffset;
    }

    @Override
    public int getPropertySize() {
        return this.propertySize;
    }

    @Override
    public int getEncryption() {
        return this.encryption;
    }

    @Override
    public int getPriority() {
        return this.operateCommandAsMessage().getPriority();
    }

    @Override
    public long getTransactionID() {
        return this.transactionID;
    }

    @Override
    public long getProducerID() {
        return this.operateCommandAsMessage().getProducerId().getValue();
    }

    @Override
    public long getConsumerID() {
        return this.operateCommandAsMessage().getTargetConsumerId().getValue();
    }

    @Override
    public int getInterestID() {
        return (int)this.getConsumerID();
    }

    @Override
    public boolean getPersistent() {
        return this.operateCommandAsMessage().isPersistent();
    }

    @Override
    public boolean getRedelivered() {
        return this.operateCommandAsMessage().isRedelivered();
    }

    @Override
    public boolean getIsQueue() {
        return this.getFlag(1);
    }

    @Override
    public boolean getSelectorsProcessed() {
        return this.getFlag(8);
    }

    @Override
    public boolean getSendAcknowledge() {
        return this.getFlag(16);
    }

    @Override
    public boolean getIsLast() {
        return this.operateCommandAsMessage().isBrowseLast();
    }

    @Override
    public boolean getFlowPaused() {
        return this.getFlag(64);
    }

    @Override
    public boolean getIsTransacted() {
        return this.getFlag(128);
    }

    @Override
    public boolean getConsumerFlow() {
        return this.getFlag(256);
    }

    @Override
    public boolean getIndempotent() {
        return this.getFlag(2048);
    }

    @Override
    public String getDestination() {
        return this.operateCommandAsMessage().getDestination().getDestinationName();
    }

    @Override
    public String getDestinationClass() {
        return this.operateCommandAsMessage().getDestination().getDestinationClass();
    }

    @Override
    public String getMessageID() {
        if (this.messageID == null) {
            return "";
        }
        return this.messageID;
    }

    @Override
    public String getCorrelationID() {
        String value = this.operateCommandAsMessage().getCorrelationId();
        if (value != null) {
            return value;
        }
        return null;
    }

    @Override
    public String getReplyTo() {
        Object value = this.operateCommandAsMessage().getProperty("JMSReplyTo");
        if (value != null) {
            return (String)value;
        }
        return null;
    }

    @Override
    public String getReplyToClass() {
        Object value = this.operateCommandAsMessage().getProperty("JMS_TONG_ReplyToClass");
        if (value != null) {
            return (String)value;
        }
        return null;
    }

    @Override
    public String getMessageType() {
        Object value = this.operateCommandAsMessage().getProperty("JMSType");
        if (value != null) {
            return (String)value;
        }
        return null;
    }

    @Override
    public SysMessageID getSysMessageID() {
        return this.sysMessageID;
    }

    @Override
    public int getMessageBodySize() {
        return this.packetSize - this.propertyOffset - this.propertySize;
    }

    @Override
    public InputStream getMessageBodyStream() {
        int offset = this.propertyOffset - 72 + this.propertySize;
        int size = this.ropLength - offset;
        if (this.ropBuffer == null || size <= 0) {
            return null;
        }
        return new ByteArrayInputStream(this.ropBuffer, offset, size);
    }

    @Override
    public Hashtable getProperties() throws IOException, ClassNotFoundException {
        return this.operateCommandAsMessage().getProperties();
    }

    protected void reset() {
        this.version = defaultVersion;
        this.magic = 469754818;
        this.ropLength = 0;
        this.packetType = 0;
        this.packetSize = 0;
        this.expiration = 0L;
        this.propertyOffset = 0;
        this.propertySize = 0;
        this.encryption = 0;
        this.priority = 5;
        this.bitFlags = 0;
        this.consumerID = 0L;
        this.producerID = 0L;
        this.transactionID = -1L;
        this.destination = null;
        this.destinationClass = null;
        this.messageID = null;
        this.correlationID = null;
        this.replyTo = null;
        this.replyToClass = null;
        this.messageType = null;
        this.stringsParsed = false;
        this.properties = null;
    }

    @Override
    public Object cloneShallow() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            System.out.println("ReadOnlyPacket: Could not clone: " + e);
            return null;
        }
    }

    @Override
    public Object clone() {
        TlqRemoteReadOnlyPacket newPkt = (TlqRemoteReadOnlyPacket)this.cloneShallow();
        if (this.headerBuffer != null) {
            newPkt.headerBuffer = (byte[])this.headerBuffer.clone();
        }
        if (this.ropBuffer != null) {
            newPkt.ropBuffer = (byte[])this.ropBuffer.clone();
        }
        if (this.properties != null) {
            newPkt.properties = (Hashtable)this.properties.clone();
        }
        return newPkt;
    }

    @Override
    public String toString() {
        return PacketType.getString(this.packetType) + ":";
    }

    @Override
    public String toVerboseString() {
        this.dump(logger);
        return "";
    }

    @Override
    public void dump(Logger logger) {
    }

    @Override
    public String getFixedMessageID() {
        return null;
    }

    @Override
    public String getSrcNode() {
        return null;
    }

    @Override
    public void setSrcNode(String trim) {
    }

    public Hashtable getPacketProperties() {
        return this.properties;
    }

    public long getPartialMessageLastRecTimestamp() {
        return this.partialMessageLastRecTimestamp;
    }

    @Override
    public String getPubQueue() {
        return null;
    }

    @Override
    public String getSubQueue() {
        return null;
    }
}

