/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.protocol.http;

import com.tongtech.jms.protocol.SocketConnectionHandler;
import com.tongtech.jms.transport.httptunnel.HTTPLongLiveSocket;
import com.tongtech.tmqi.io.MQAddress;
import com.tongtech.tmqi.jmsclient.ConnectionImpl;
import com.tongtech.tmqi.jmsclient.ExceptionHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jms.JMSException;

public class HTTPLongLiveConnectionHandler
extends SocketConnectionHandler {
    private String URLString;
    private HTTPLongLiveSocket socket;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HTTPLongLiveConnectionHandler(MQAddress addr, ConnectionImpl conn) throws JMSException {
        ConnectionImpl connection = conn;
        this.URLString = addr.getURL();
        if (this.URLString == null) {
            throw new JMSException("URL not found.");
        }
        try {
            this.socket = new HTTPLongLiveSocket(this.URLString);
        }
        catch (Exception e) {
            connection.getExceptionHandler();
            ExceptionHandler.handleConnectException(e, this.URLString);
        }
        finally {
            conn.setLastContactedBrokerAddress(this.URLString);
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    @Override
    public int getLocalPort() throws IOException {
        return this.socket.getConnId();
    }

    @Override
    public String getBrokerHostName() {
        return this.URLString;
    }

    @Override
    public String getBrokerAddress() {
        return this.URLString;
    }

    @Override
    protected void closeSocket() throws IOException {
        this.socket.close();
    }
}

