/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.protocol.ssl;

import com.tongtech.jms.protocol.SocketConnectionHandler;
import com.tongtech.jms.protocol.ssl.DefaultTrustManager;
import com.tongtech.tmqi.io.MQAddress;
import com.tongtech.tmqi.jmsclient.ConnectionImpl;
import com.tongtech.tmqi.jmsclient.ExceptionHandler;
import com.tongtech.tmqi.jmsclient.PortMapperClient;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.security.Security;
import javax.jms.JMSException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class SSLConnectionHandler
extends SocketConnectionHandler {
    private static boolean isRegistered = false;
    private static boolean debug = true;
    private SSLSocket sslSocket = null;
    private String host = null;
    private int baseport = 0;
    private int directport = 0;
    private int port = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SSLConnectionHandler(Object conn) throws JMSException {
        ConnectionImpl connection = (ConnectionImpl)conn;
        this.directport = 0;
        try {
            this.doRegister(connection);
            this.host = connection.getProperty("tmqiBrokerHostName");
            this.baseport = Integer.parseInt(connection.getProperty("tmqiBrokerHostPort"));
            this.directport = Integer.parseInt(connection.getProperty("tmqiBrokerServicePort"));
            String namedservice = connection.getProperty("tmqiBrokerServiceName");
            boolean isHostTrusted = Boolean.valueOf(connection.getProperty("tmqiSSLIsHostTrusted"));
            if (this.directport == 0) {
                PortMapperClient pmc = new PortMapperClient(connection);
                this.port = namedservice != null && !"".equals(namedservice) ? pmc.getPortForService("tls", namedservice) : pmc.getPortForProtocol("tls");
            } else {
                this.port = this.directport;
            }
            ConnectionImpl.checkHostPort(this.host, this.port);
            this.sslSocket = this.makeSSLSocket(this.host, this.port, isHostTrusted);
        }
        catch (JMSException jmse) {
            throw jmse;
        }
        catch (Exception e) {
            connection.getExceptionHandler();
            ExceptionHandler.handleConnectException(e, this.host, this.port);
        }
        finally {
            connection.setLastContactedBrokerAddress(this.getBrokerAddress());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SSLConnectionHandler(MQAddress addr, ConnectionImpl conn) throws JMSException {
        ConnectionImpl connection = conn;
        try {
            this.doRegister(connection);
            this.host = addr.getHostName();
            this.directport = 0;
            if (addr.isServicePortFinal()) {
                this.directport = addr.getPort();
            }
            String namedservice = addr.getServiceName();
            boolean isHostTrusted = true;
            isHostTrusted = addr.getIsSSLHostTrustedSet() ? Boolean.valueOf(addr.getProperty("isHostTrusted")).booleanValue() : Boolean.valueOf(connection.getProperty("tmqiSSLIsHostTrusted")).booleanValue();
            if (this.directport == 0) {
                PortMapperClient pmc = new PortMapperClient(addr, connection);
                this.baseport = pmc.getHostPort();
                this.port = namedservice != null && !"".equals(namedservice) ? pmc.getPortForService("tls", namedservice) : pmc.getPortForProtocol("tls");
            } else {
                this.port = this.directport;
            }
            ConnectionImpl.checkHostPort(this.host, this.port);
            this.sslSocket = this.makeSSLSocket(this.host, this.port, isHostTrusted);
        }
        catch (JMSException jmse) {
            throw jmse;
        }
        catch (Exception e) {
            connection.getExceptionHandler();
            ExceptionHandler.handleConnectException(e, this.host, this.port);
        }
        finally {
            connection.setLastContactedBrokerAddress(this.getBrokerAddress());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRegister(ConnectionImpl connection) throws Exception {
        if (Boolean.getBoolean("tmqi.registerSSLProvider") && !isRegistered) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                String name = connection.getProperty("tmqiSSLProviderClassname");
                Provider provider = (Provider)Class.forName(name).newInstance();
                Security.addProvider(provider);
                isRegistered = true;
            }
        }
    }

    private SSLSocket makeSSLSocket(String host, int port, boolean isHostTrusted) throws Exception {
        SSLSocketFactory sslFactory;
        if (isHostTrusted) {
            sslFactory = this.getTrustSocketFactory();
            if (debug) {
                System.out.println("Broker is trusted ...");
            }
        } else {
            sslFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        if (debug) {
            System.out.println("Create connection using SSL protocol ...");
            System.out.println("Broker Host: " + host);
            System.out.println("Broker Port: " + port);
        }
        SSLSocket sslSocket = (SSLSocket)sslFactory.createSocket(host, port);
        boolean tcpNoDelay = true;
        String prop = System.getProperty("tmqiTcpNoDelay", "true");
        if (prop.equals("false")) {
            tcpNoDelay = false;
        } else {
            sslSocket.setTcpNoDelay(tcpNoDelay);
        }
        return sslSocket;
    }

    private SSLSocketFactory getTrustSocketFactory() throws Exception {
        SSLSocketFactory factory = null;
        SSLContext ctx = SSLContext.getInstance("TLS");
        TrustManager[] tm = new TrustManager[]{new DefaultTrustManager()};
        ctx.init(null, tm, null);
        factory = ctx.getSocketFactory();
        return factory;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.sslSocket.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.sslSocket.getOutputStream();
    }

    @Override
    public int getLocalPort() throws IOException {
        return this.sslSocket.getLocalPort();
    }

    @Override
    protected void closeSocket() throws IOException {
        this.sslSocket.close();
    }

    @Override
    public String getBrokerHostName() {
        return this.host;
    }

    public int getBrokerPort() {
        return this.port;
    }

    @Override
    public String getBrokerAddress() {
        if (this.directport == 0) {
            return this.host + ":" + this.baseport + "(" + this.port + ")";
        }
        return this.host + ":" + this.directport;
    }
}

