/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.ra.core;

import com.tongtech.jms.ra.core.Activation;
import com.tongtech.jms.ra.core.CommonMBean;
import com.tongtech.jms.ra.core.EmManagementInterface;
import com.tongtech.jms.ra.core.RAJMSActivationSpec;
import com.tongtech.jms.ra.util.ConnectionUrl;
import com.tongtech.jms.ra.util.UrlParser;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Topic;

public class ActivationMBean
extends CommonMBean
implements EmManagementInterface {
    private Activation mActivation;
    private static final String TYPE = "destination.type";
    private static final String NAME = "destination.name";
    private static final String SUBNAME = "subscriber.name";
    private static final String DURABILITY = "subscriber.durability";
    private static final String CONCURRENCY = "concurrency";
    private static final String SELECTOR = "selector";
    private static final String URL = "url";
    private static final String HOST = "server";
    private static final String PORT = "port";

    public ActivationMBean(Activation a) {
        super(a != null ? a.getObjectFactory() : null, "JMSJCA Activation MBean");
        this.mActivation = a;
    }

    public String getStats() {
        return this.mActivation.getStats().toString();
    }

    public String mbaStats() {
        return "Consistent stats dump";
    }

    public Integer getNMessages() {
        return new Integer(this.mActivation.getStats().getNMessages());
    }

    public String mbaNMessages() {
        return "Number of messages delivered";
    }

    public Boolean getSuspended() {
        return new Boolean(this.mActivation.isStopped());
    }

    public String mbaSuspended() {
        return "Suspended state";
    }

    public String getActivationSpec() {
        return this.mActivation.getActivationSpec().dumpConfiguration();
    }

    public String mbaActivationSpec() {
        return "Printout of the activation spec used";
    }

    public String getResourceAdapter() {
        return this.mActivation.getRA().dumpConfiguration();
    }

    public String mbaResourceAdapter() {
        return "Printout of the resource adapter properties";
    }

    public Integer getNActiveEndpoints() {
        return new Integer(this.mActivation.getStats().getNActiveEndpoints());
    }

    public String mbaNActiveEndpoints() {
        return "Number of active endpoints";
    }

    public Integer getNTotalEndpoints() {
        return new Integer(this.mActivation.getStats().getNTotalEndpoints());
    }

    public String mbaNTotalEndpoints() {
        return "Total number of endpoints";
    }

    public Integer getNHighestActiveEndpoints() {
        return new Integer(this.mActivation.getStats().getNHighestEndpoints());
    }

    public String mbaNHighestActiveEndpoints() {
        return "Highest number of active endpoints reached";
    }

    public Integer getNConfiguredEndpoints() {
        return new Integer(this.mActivation.dumpNumberConfiguredEndpoints());
    }

    public String mbaNConfiguredEndpoints() {
        return "The max number of endpoints the Delivery Object will use";
    }

    public String getDeliveryMode() {
        return this.mActivation.dumpDelivery();
    }

    public String mbaDeliveryMode() {
        return "String representation of the Delivery Object";
    }

    public void resetStats() {
        this.mActivation.getStats().reset();
    }

    public String[] mbmresetStats() {
        return new String[]{"Resets the statistics"};
    }

    public void stopService() throws JMSException {
        this.mActivation.stop();
    }

    public String[] mbmstopService() {
        return new String[]{"Suspends message delivery"};
    }

    public void startService() throws Exception {
        this.mActivation.start();
    }

    public String[] mbmstartService() {
        return new String[]{"Unsuspends message delivery"};
    }

    public int echoPrimitives(int a, long b) {
        return (int)((long)a + b);
    }

    public String[] mbmechoPrimitives(int a, long b) {
        return new String[]{"For testing: returns the sum of (a) and (b)", "a primitive int (a)", "a primitive long (b)"};
    }

    public String[] mbmstart() {
        return new String[]{"Required management method for the EmManagementInterface; starts message delivery if message delivery was stopped"};
    }

    @Override
    public void start() throws Exception {
        this.mActivation.start();
    }

    public String[] mbmrestart() {
        return new String[]{"Required management method for the EmManagementInterface; stops message delivery and then restarts message delivery again"};
    }

    @Override
    public void restart() throws Exception {
        this.mActivation.stop();
        this.mActivation.start();
    }

    public String[] mbmstop() {
        return new String[]{"Required management method for the EmManagementInterface; stops message delivery."};
    }

    @Override
    public void stop() throws Exception {
        this.mActivation.stop();
    }

    public String[] mbmgetStatus() {
        return new String[]{"Required management method for the EmManagementInterface; returns the current status. Possible values are: Down (the connector is not connected to the server); Up (the connector is connected to the server and can receive messages); Connecting (the connector is trying to connect to the server, this may take several seconds/minutes, it may take forever if the connector cannot connect to the server at all); Disconnecting (indicates that the connector is closing down connections to the server and is waiting for all outstanding  work to complete)"};
    }

    @Override
    public String getStatus() throws Exception {
        int state = this.mActivation.getState();
        if (state == 0) {
            return "Down";
        }
        if (state == 3) {
            return "Disconnecting";
        }
        if (state == 2) {
            return "Up";
        }
        if (state == 1) {
            return "Connecting";
        }
        return "UNKNOWN";
    }

    public String[] mbmgetProperties() {
        return new String[]{"Required management method for the EmManagementInterface; returns properties set describing the activation spec. Property names are:destination.type = either " + Queue.class.getName() + " or " + Topic.class.getName() + "; " + NAME + " = name of queue or topic receiving messages from; " + SUBNAME + " = subscriber name; " + DURABILITY + " = either " + "Durable" + " or " + "NonDurable" + "; " + SELECTOR + " = selector; " + URL + " = url of server connected to; " + HOST + " = hostname of server connected to (may be absent for URLs that do not describe a server/url); " + PORT + " = port at server connected to; "};
    }

    private void put(Properties p, String key, String value) {
        if (value != null && value.length() != 0) {
            p.put(key, value);
        }
    }

    @Override
    public Properties getProperties() {
        Properties ret = new Properties();
        this.put(ret, TYPE, this.mActivation.getActivationSpec().getDestinationType());
        this.put(ret, NAME, this.mActivation.getActivationSpec().getDestination());
        this.put(ret, SUBNAME, this.mActivation.getActivationSpec().getSubscriptionName());
        this.put(ret, DURABILITY, this.mActivation.getActivationSpec().getSubscriptionDurability());
        this.put(ret, CONCURRENCY, RAJMSActivationSpec.DELIVERYCONCURRENCY_STRS[this.mActivation.getDeliveryMode()]);
        this.put(ret, URL, this.mActivation.getActivationSpec().getConnectionURL());
        this.put(ret, SELECTOR, this.mActivation.getActivationSpec().getMessageSelector());
        try {
            ConnectionUrl url = this.mActivation.getObjectFactory().getProperties(new Properties(), this.mActivation.getRA(), this.mActivation.getActivationSpec(), null, null);
            if (url instanceof UrlParser) {
                UrlParser parser = (UrlParser)url;
                this.put(ret, HOST, parser.getHost());
                this.put(ret, PORT, Integer.toString(parser.getPort()));
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        return ret;
    }

    public String[] mbmisStartable() {
        return new String[]{"Required management method for the EmManagementInterface; will return false for this MBean"};
    }

    @Override
    public Boolean isStartable() {
        return Boolean.TRUE;
    }

    public String[] mbmisRestartable() {
        return new String[]{"Required management method for the EmManagementInterface; returns false for this MBean."};
    }

    @Override
    public Boolean isRestartable() {
        return Boolean.TRUE;
    }

    public String[] mbmisStoppable() {
        return new String[]{"Required management method for the EmManagementInterface; returns false for this mbean"};
    }

    @Override
    public Boolean isStoppable() {
        return Boolean.TRUE;
    }

    public static void main(String[] args) {
        try {
            new ActivationMBean(null).mbeanTest();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

