/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.ra.core;

import com.tongtech.jms.ra.core.Activation;
import com.tongtech.jms.ra.core.DeliveryStats;
import com.tongtech.jms.ra.core.PseudoXAResource;
import com.tongtech.jms.ra.core.RAJMSActivationSpec;
import com.tongtech.jms.ra.core.RAJMSObjectFactory;
import com.tongtech.jms.ra.core.RedeliveryHandler;
import com.tongtech.jms.ra.core.TxMgr;
import com.tongtech.jms.ra.core.WBytesMessageIn;
import com.tongtech.jms.ra.core.WMapMessageIn;
import com.tongtech.jms.ra.core.WMessageIn;
import com.tongtech.jms.ra.core.WObjectMessageIn;
import com.tongtech.jms.ra.core.WStreamMessageIn;
import com.tongtech.jms.ra.core.WTextMessageIn;
import com.tongtech.jms.ra.core.XConnectionRequestInfo;
import com.tongtech.jms.ra.localization.LocalizedString;
import com.tongtech.jms.ra.localization.Localizer;
import com.tongtech.jms.ra.util.Exc;
import com.tongtech.jms.ra.util.Utility;
import com.tongtech.jms.ra.util.XAssert;
import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import java.lang.reflect.Method;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.TopicSession;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;

public abstract class Delivery {
    Logger sLog = LoggerFactory.getLogger(Delivery.class);
    public static final long DESTROY_RETRY_INTERVAL_MS = 500L;
    public static final long DESTROY_LOG_INTERVAL_MS = 15000L;
    public static final String REDELIVERYCOUNT = "JMS_Sun_JMSJCA_RedeliveryCount";
    public static final String ORIGINALDESTINATIONNAME = "JMS_Sun_JMSJCA_OriginalDestinationName";
    public static final String ORIGINALDESTINATIONTYPE = "JMS_Sun_JMSJCA_OriginalDestinationType";
    public static final String ORIGINALTIMESTAMP = "JMS_Sun_JMSJCA_OriginalTimestamp";
    public static final String SUBSCRIBERNAME = "JMS_Sun_JMSJCA_SubscriberName";
    public static final String CONTEXTNAME = "JMS_Sun_JMSJCA_ContextName";
    protected Activation mActivation;
    protected DeliveryStats mStats;
    protected Method mMethod;
    protected int mBatchSize;
    protected boolean mHoldUntilAck;
    private static final long MAX_CREATE_ENDPOINT_TIME = 20000L;
    private static final long CREATE_ENDPOINT_RETRY_DELAY = 1000L;
    private RedeliveryHandler mRedeliveryChecker;
    private TransactionManager mTxMgr;
    private Object mTxMgrCacheLock = new Object();
    private boolean mTxFailureLoggedOnce;
    private IdentityHashMap mThreadsCurrentlyInOnMessage = new IdentityHashMap();
    private static final Localizer LOCALE = Localizer.get();

    public ConnectionForMove createConnectionForMove() {
        return new ConnectionForMove();
    }

    public Delivery(Activation a, DeliveryStats stats) throws Exception {
        this.mActivation = a;
        this.mStats = stats;
        this.mMethod = this.mActivation.getOnMessageMethod();
        this.mRedeliveryChecker = new DeliveryActions(a.getActivationSpec(), this.mStats, 5000);
        this.mBatchSize = a.getActivationSpec().getBatchSize() == null ? 0 : a.getActivationSpec().getBatchSize();
        String huaMode = a.getActivationSpec().getHoldUntilAck();
        if (huaMode != null && huaMode.length() > 0 && ("TRUE".equalsIgnoreCase(huaMode) || "1".equals(huaMode))) {
            this.mHoldUntilAck = true;
        }
        if (this.mActivation.isCMT()) {
            Properties p = new Properties();
            this.mActivation.getObjectFactory().getProperties(p, this.mActivation.getRA(), this.mActivation.getActivationSpec(), null, null);
            String txMgrLocatorClass = p.getProperty("JMSJCA.LocatorClass", TxMgr.class.getName());
            txMgrLocatorClass = Utility.getSystemProperty("JMSJCA.LocatorClass", txMgrLocatorClass);
            try {
                Class<?> c = Class.forName(txMgrLocatorClass, false, this.getClass().getClassLoader());
                TxMgr txmgr = (TxMgr)c.newInstance();
                txmgr.init(p);
                this.mTxMgr = txmgr.getTransactionManager();
                this.sLog.trace("getTransactionManager txmgr is {}, className is {}, mTxMgr is {}", new Object[]{txmgr, txMgrLocatorClass, this.mTxMgr});
            }
            catch (Exception e) {
                this.sLog.error("", e);
                throw Exc.rsrcExc(LOCALE.x("E057: TxMgr could not be obtained: {0}", e), e);
            }
        }
    }

    protected MessageEndpoint createMessageEndpoint(XAResource xa, Session s) throws Exception {
        MessageEndpoint ret;
        block8: {
            if (this.sLog.isDebugEnabled()) {
                this.sLog.debug("Creating message endpoint");
            }
            ret = null;
            long start = System.currentTimeMillis();
            do {
                if (this.mActivation.isStopping()) {
                    if (!this.sLog.isDebugEnabled()) break block8;
                    this.sLog.debug("Aborting message end point creation: stopping");
                    break block8;
                }
                try {
                    ret = this.mActivation.getMessageEndpointFactory().createEndpoint(xa);
                }
                catch (UnavailableException ex1) {
                    long now = System.currentTimeMillis();
                    if (now - start > 20000L) {
                        throw Exc.rsrcExc(LOCALE.x("E120: Failed to create endpoint... giving up. Last exception: {0}", (Object)ex1), (Exception)((Object)ex1));
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            } while (ret == null);
            this.mStats.addMessageEndpoint();
        }
        return ret;
    }

    protected void release(MessageEndpoint mep) {
        Transaction tx = this.getTransaction(false);
        this.sLog.trace("++++++++tx is {}", tx);
        if (tx == null) {
            try {
                TransactionManager tm = this.getTxMgr();
                if (tm != null) {
                    tm.begin();
                }
            }
            catch (NotSupportedException ex) {
                java.util.logging.Logger.getLogger(Delivery.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (SystemException ex) {
                java.util.logging.Logger.getLogger(Delivery.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (Exception ex) {
                java.util.logging.Logger.getLogger(Delivery.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (mep != null) {
            if (this.sLog.isDebugEnabled()) {
                this.sLog.debug("Releasing endpoint");
            }
            try {
                mep.release();
            }
            catch (RuntimeException e) {
                this.sLog.warn("E197: Release of endpoint failed unexpectedly", e);
            }
            this.mStats.removeMessageEndpoint();
        }
    }

    protected void createDLQDest(Session sess) throws JMSException {
        RedeliveryHandler.ActionInstruction[] a = RedeliveryHandler.parse(this.mActivation.getActivationSpec().getRedeliveryHandling(), this.mActivation.getActivationSpec().getDestination(), this.mActivation.getActivationSpec().getDestinationType());
        for (int i = 0; i < a.length; ++i) {
            if (!(a[i] instanceof RedeliveryHandler.Move)) continue;
            RedeliveryHandler.Move m = (RedeliveryHandler.Move)a[i];
            this.mActivation.getObjectFactory().createDestination(sess, this.mActivation.isCMT() && !this.mActivation.isXAEmulated(), m.isTopic(), this.mActivation.getActivationSpec(), null, this.mActivation.getRA(), m.getDestinationName());
        }
    }

    protected WMessageIn wrapMsg(Message msgToWrap) throws JMSException {
        if (msgToWrap instanceof WMessageIn) {
            return (WMessageIn)msgToWrap;
        }
        WMessageIn ret = null;
        int nItf = 0;
        if (msgToWrap instanceof TextMessage) {
            ++nItf;
            ret = new WTextMessageIn((TextMessage)msgToWrap);
        }
        if (msgToWrap instanceof BytesMessage) {
            ++nItf;
            ret = new WBytesMessageIn((BytesMessage)msgToWrap);
        }
        if (msgToWrap instanceof MapMessage) {
            ++nItf;
            ret = new WMapMessageIn((MapMessage)msgToWrap);
        }
        if (msgToWrap instanceof ObjectMessage) {
            ++nItf;
            ret = new WObjectMessageIn((ObjectMessage)msgToWrap);
        }
        if (msgToWrap instanceof StreamMessage) {
            ++nItf;
            ret = new WStreamMessageIn((StreamMessage)msgToWrap);
        }
        if (ret == null) {
            ++nItf;
            ret = new WMessageIn(msgToWrap);
        }
        if (nItf > 1) {
            throw Exc.jmsExc(LOCALE.x("E032: Cannot determine message type: the message implements multiple interfaces."));
        }
        ret.setActivation(this.mActivation);
        return ret;
    }

    protected void txSetRollbackOnly(DeliveryResults result, boolean rethrow) throws Exception {
        result.setRollbackOnly(true);
        if (this.mActivation.isCMT()) {
            try {
                this.getTransactionNotNull().setRollbackOnly();
            }
            catch (Exception e) {
                result.setShouldDiscardEndpoint(true);
                if (rethrow) {
                    throw e;
                }
                this.sLog.error("E201: Failed to mark transaction for RollbackOnly: ", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeDelivery(DeliveryResults result, MessageEndpoint target, boolean rethrowSystemException) throws Exception {
        if (this.mActivation.isCMT()) {
            try {
                target.beforeDelivery(this.mMethod);
            }
            catch (Exception e) {
                e.printStackTrace();
                result.setBeforeDeliveryFailed(true);
                result.setShouldDiscardEndpoint(true);
                result.setException(e);
                result.setRollbackOnly(true);
                try {
                    if (rethrowSystemException) {
                        throw e;
                    }
                    this.sLog.error("E198: Transaction initialization failed unexpectedly: ", e);
                }
                finally {
                    this.txSetRollbackOnly(result, rethrowSystemException);
                }
            }
        }
    }

    public void afterDelivery(DeliveryResults result, ConnectionForMove connectionForMove, MessageEndpoint target, MDB mdb, boolean rethrowSystemException) throws Exception {
        if (!this.mActivation.isCMT() || result.getBeforeDeliveryFailed()) {
            return;
        }
        if (!result.getOnMessageWasBypassed()) {
            try {
                if (result.getIsRollbackOnly()) {
                    this.getTransactionNotNull().setRollbackOnly();
                }
                target.afterDelivery();
            }
            catch (Exception e) {
                result.setAfterDeliveryFailed(true);
                result.setShouldDiscardEndpoint(true);
                result.setException(e);
                if (rethrowSystemException) {
                    throw e;
                }
                this.sLog.error("E199: Transaction completion unexpectedly failed: ", e);
            }
        } else {
            try {
                result.setShouldDiscardEndpoint(true);
                Transaction tx = this.getTransactionNotNull();
                tx.delistResource(mdb.getXAResource(), 0x4000000);
                if (result.getIsRollbackOnly()) {
                    tx.rollback();
                } else {
                    tx.commit();
                }
            }
            catch (Exception e) {
                result.setAfterDeliveryFailed(true);
                result.setShouldDiscardEndpoint(true);
                result.setException(e);
                if (rethrowSystemException) {
                    throw e;
                }
                this.sLog.error("E200: the transaction could not be committed: ", e);
            }
        }
    }

    public void afterDeliveryNoXA(DeliveryResults result, Session session, ConnectionForMove connectionForMove, MessageEndpoint target) {
        if (this.mActivation.isCMT()) {
            return;
        }
        if (result.getIsRollbackOnly()) {
            try {
                connectionForMove.nonXACommit(false);
            }
            catch (JMSException ex) {
                this.sLog.error("E097: The message sent as part of redelivery handling could not be rolled back: ", ex);
            }
        } else {
            try {
                connectionForMove.nonXACommit(true);
            }
            catch (JMSException ex) {
                result.setRollbackOnly(true);
                this.sLog.error("E098: The message sent as part of redelivery handling could not be committed. The receiving of the message will be rolled back. The error was: ", ex);
            }
        }
        if (!result.getIsRollbackOnly()) {
            try {
                session.commit();
            }
            catch (JMSException ex) {
                this.sLog.error("E065: The message could not be committed: ", ex);
            }
        } else {
            try {
                session.rollback();
            }
            catch (JMSException ex) {
                this.sLog.error("E066: The message could not be rolled back: ", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliverToEndpoint(DeliveryResults result, ConnectionForMove connectionForMove, MessageEndpoint target, Message m, boolean rethrowSystemExceptions) throws Exception {
        boolean mustSetRollback;
        block14: {
            if (this.sLog.isDebugEnabled()) {
                this.sLog.debug("Delivering message to endpoint");
            }
            this.mStats.aboutToDeliverMessage();
            mustSetRollback = false;
            try {
                boolean shouldDeliver;
                if (this.mActivation.shouldWrapAlways()) {
                    m = this.wrapMsg(m);
                }
                if (!(shouldDeliver = this.mRedeliveryChecker.shouldDeliver(new Cookie(result, connectionForMove), m))) {
                    result.setOnMessageWasBypassed(true);
                    break block14;
                }
                try {
                    this.registerThreadAsInOnMessage(true);
                    result.setOnMessageWasCalled(true);
                    ((MessageListener)target).onMessage(m);
                    result.setOnMessageSucceeded(true);
                }
                catch (RuntimeException ex) {
                    Exc.fixup(ex);
                    this.sLog.warn("E031: The entity the message was sent to for processing, threw an exception. The message will be rolled back. Exception:", ex);
                    result.setOnMessageFailed(true);
                    result.setException(ex);
                    result.setShouldDiscardEndpoint(true);
                    this.mRedeliveryChecker.rememberException(ex, m);
                    result.setRollbackOnly(true);
                    mustSetRollback = true;
                }
                finally {
                    this.registerThreadAsInOnMessage(false);
                }
            }
            catch (Exception ex) {
                this.sLog.warn("E030: An unexpected exception was encountered processing a message. Exception: ", ex);
            }
            finally {
                this.mStats.messageDelivered();
            }
        }
        if (mustSetRollback) {
            this.txSetRollbackOnly(result, rethrowSystemExceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerThreadAsInOnMessage(boolean register) {
        IdentityHashMap identityHashMap = this.mThreadsCurrentlyInOnMessage;
        synchronized (identityHashMap) {
            if (register) {
                String verify = this.mThreadsCurrentlyInOnMessage.put(Thread.currentThread(), "");
                XAssert.xassert(verify == null);
            } else {
                Object verify = this.mThreadsCurrentlyInOnMessage.remove(Thread.currentThread());
                XAssert.xassert(verify != null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isThisCalledFromOnMessage() {
        IdentityHashMap identityHashMap = this.mThreadsCurrentlyInOnMessage;
        synchronized (identityHashMap) {
            return this.mThreadsCurrentlyInOnMessage.containsKey(Thread.currentThread());
        }
    }

    public abstract void deactivate();

    public abstract void start() throws Exception;

    public Activation getActivation() {
        return this.mActivation;
    }

    public DeliveryStats getStats() {
        return this.mStats;
    }

    public abstract int getConfiguredEndpoints();

    public TransactionManager getTxMgr() throws Exception {
        return this.mTxMgr;
    }

    protected Transaction getTransactionNotNull() {
        Transaction ret = this.getTransaction(true);
        if (ret == null) {
            throw Exc.rtexc(LOCALE.x("E203: A transaction context was expected, but there is no transaction associated with the current thread."));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Transaction getTransaction(boolean rethrowSystemExceptions) {
        Transaction tx = null;
        try {
            if (this.mTxMgr != null) {
                tx = this.mTxMgr.getTransaction();
            }
        }
        catch (Exception e) {
            this.sLog.warn("getTransaction fail. {}", this.mTxMgr);
            if (rethrowSystemExceptions) {
                throw Exc.rtexc(LOCALE.x("E062: Failed to obtain handle to transaction: {0}", e), e);
            }
            Object object = this.mTxMgrCacheLock;
            synchronized (object) {
                if (!this.mTxFailureLoggedOnce) {
                    this.mTxFailureLoggedOnce = true;
                    this.sLog.error("E062: Failed to obtain handle to transaction: ", e);
                }
            }
        }
        return tx;
    }

    private static class Cookie
    extends RedeliveryHandler.BaseCookie {
        private DeliveryResults mResults;
        private ConnectionForMove mConnectionForMove;

        public Cookie(DeliveryResults results, ConnectionForMove connectionForMove) {
            this.mResults = results;
            this.mConnectionForMove = connectionForMove;
        }

        public final DeliveryResults getResults() {
            return this.mResults;
        }

        public final ConnectionForMove getConnectionForMove() {
            return this.mConnectionForMove;
        }
    }

    public static class DeliveryResults {
        private boolean mShouldDiscardEndpoint;
        private boolean mBeforeDeliveryFailed;
        private boolean mAfterDeliveryFailed;
        private boolean mOnMessageFailed;
        private Exception mException;
        private boolean mOnMessageWasCalled;
        private int mNOnMessageWasCalled;
        private boolean mOnMessageWasBypassed;
        private boolean mOnMessageSucceeded;
        private boolean mIsRollbackOnly;

        public void reset() {
            this.mShouldDiscardEndpoint = false;
            this.mBeforeDeliveryFailed = false;
            this.mAfterDeliveryFailed = false;
            this.mIsRollbackOnly = false;
            this.mOnMessageFailed = false;
            this.mException = null;
            this.mOnMessageSucceeded = false;
            this.mOnMessageWasCalled = false;
            this.mNOnMessageWasCalled = 0;
            this.mOnMessageWasBypassed = false;
        }

        public void resetDeliveryState() {
            this.mOnMessageFailed = false;
            this.mException = null;
            this.mOnMessageSucceeded = false;
            this.mOnMessageWasCalled = false;
            this.mOnMessageWasBypassed = false;
        }

        public boolean getOnMessageSucceeded() {
            return this.mOnMessageSucceeded;
        }

        public void setOnMessageSucceeded(boolean onMessageSucceeded) {
            this.mOnMessageSucceeded = onMessageSucceeded;
        }

        public boolean getAfterDeliveryFailed() {
            return this.mAfterDeliveryFailed;
        }

        public void setAfterDeliveryFailed(boolean afterDeliveryFailed) {
            this.mAfterDeliveryFailed = afterDeliveryFailed;
        }

        public boolean getBeforeDeliveryFailed() {
            return this.mBeforeDeliveryFailed;
        }

        public void setBeforeDeliveryFailed(boolean beforeDeliveryFailed) {
            this.mBeforeDeliveryFailed = beforeDeliveryFailed;
        }

        public Exception getException() {
            return this.mException;
        }

        public void setException(Exception exception) {
            this.mException = exception;
        }

        public boolean getOnMessageFailed() {
            return this.mOnMessageFailed;
        }

        public void setOnMessageFailed(boolean onMessageFailed) {
            this.mOnMessageFailed = onMessageFailed;
        }

        public boolean getShouldDiscardEndpoint() {
            return this.mShouldDiscardEndpoint;
        }

        public void setShouldDiscardEndpoint(boolean shouldDiscardEndpoint) {
            this.mShouldDiscardEndpoint = shouldDiscardEndpoint;
        }

        public boolean getOnMessageWasBypassed() {
            return this.mOnMessageWasBypassed;
        }

        public void setOnMessageWasBypassed(boolean onMessageWasBypassed) {
            this.mOnMessageWasBypassed = onMessageWasBypassed;
        }

        public boolean getOnMessageWasCalled() {
            return this.mOnMessageWasCalled;
        }

        public void setOnMessageWasCalled(boolean onMessageWasCalled) {
            this.mOnMessageWasCalled = onMessageWasCalled;
            if (onMessageWasCalled) {
                ++this.mNOnMessageWasCalled;
            }
        }

        public boolean getIsRollbackOnly() {
            return this.mIsRollbackOnly;
        }

        public void setRollbackOnly(boolean isRollbackOnly) {
            this.mIsRollbackOnly = isRollbackOnly;
        }

        public int getNOnMessageWasCalled() {
            return this.mNOnMessageWasCalled;
        }
    }

    public class MDB {
        private XAResource mXA;

        public MDB(XAResource xa) {
            this.mXA = xa;
        }

        public XAResource getXAResource() {
            return this.mXA;
        }
    }

    private class DeliveryActions
    extends RedeliveryHandler {
        public DeliveryActions(RAJMSActivationSpec spec, DeliveryStats stats, int lookbackSize) {
            super(spec, stats, lookbackSize);
        }

        @Override
        protected void delayMessageDelivery(Message m, RedeliveryHandler.Encounter e, long delay, LocalizedString logmsg, RedeliveryHandler.BaseCookie cookie) {
            if (delay == 0L) {
                return;
            }
            if (logmsg != null) {
                Delivery.this.sLog.info(logmsg == null ? "" : logmsg.toString());
            }
            Delivery.this.mActivation.sleepAndMonitorStatus(delay);
        }

        @Override
        protected void longDelayMessageDelivery(Message m, RedeliveryHandler.Encounter e, long delay, LocalizedString logmsg, RedeliveryHandler.BaseCookie cookie) {
            if (logmsg != null) {
                Delivery.this.sLog.info(logmsg == null ? "" : logmsg.toString());
            }
            Cookie c = (Cookie)cookie;
            c.getResults().setRollbackOnly(true);
            Delivery.this.mActivation.sleepAndMonitorStatus(delay);
        }

        @Override
        protected void deleteMessage(Message m, RedeliveryHandler.Encounter e, RedeliveryHandler.BaseCookie cookie) {
            Delivery.this.sLog.info("E026: Message with msgid=[{}] was seen {} times. It will be acknowledged without being delivered.", (Object)e.getMsgid(), (Object)Integer.toString(e.getNEncountered()));
        }

        @Override
        protected void move(Message m, RedeliveryHandler.Encounter e, boolean isTopic, String destinationName, RedeliveryHandler.BaseCookie cookie) throws Exception {
            ConnectionForMove x = ((Cookie)cookie).getConnectionForMove();
            if (x.isBusy()) {
                x.destroy();
            }
            x.setBusy(true);
            Session s = x.getSession(isTopic);
            XAResource xa = null;
            if (Delivery.this.mActivation.isCMT()) {
                xa = Delivery.this.mActivation.isXAEmulated() ? new PseudoXAResource(s) : Delivery.this.mActivation.getObjectFactory().getXAResource(true, s);
                Delivery.this.getTransactionNotNull().enlistResource(xa);
            }
            Exception copyException = null;
            if (!Delivery.this.mActivation.shouldRedirectRatherThanForward()) {
                try {
                    Message newMsg = Delivery.this.mActivation.getObjectFactory().copyMessage(m, s, Delivery.this.mActivation.isCMT() && !Delivery.this.mActivation.isXAEmulated(), isTopic, Delivery.this.mActivation.getRA());
                    RAJMSActivationSpec spec = Delivery.this.mActivation.getActivationSpec();
                    newMsg.setIntProperty(Delivery.REDELIVERYCOUNT, e.getNEncountered());
                    newMsg.setStringProperty(Delivery.ORIGINALDESTINATIONNAME, spec.getDestination());
                    newMsg.setStringProperty(Delivery.ORIGINALDESTINATIONTYPE, spec.getDestinationType());
                    newMsg.setLongProperty(Delivery.ORIGINALTIMESTAMP, m.getJMSTimestamp());
                    if ("Durable".equals(spec.getSubscriptionDurability())) {
                        newMsg.setStringProperty(Delivery.SUBSCRIBERNAME, Delivery.this.mActivation.getActivationSpec().getSubscriptionName());
                    }
                    if (spec.getContextName() != null && spec.getContextName().length() > 0) {
                        newMsg.setStringProperty(Delivery.CONTEXTNAME, spec.getContextName());
                    }
                    newMsg.setStringProperty("JMS_Sun_JMSJCA_OriginalJMSMessageID", e.getMsgid());
                    String correlationId = null;
                    try {
                        correlationId = m.getJMSCorrelationID();
                    }
                    catch (JMSException jMSException) {
                        // empty catch block
                    }
                    if (correlationId != null) {
                        newMsg.setStringProperty("JMS_Sun_JMSJCA_OriginalJMSCorrelationID", correlationId);
                    }
                    if (spec.getClientId() != null) {
                        newMsg.setStringProperty("JMS_Sun_JMSJCA_OriginalClientID", spec.getClientId());
                    }
                    Map statefulRedeliveryProperties = e.getStatefulRedeliveryProperties();
                    for (Map.Entry kv : statefulRedeliveryProperties.entrySet()) {
                        newMsg.setStringProperty((String)kv.getKey(), (String)kv.getValue());
                    }
                    MessageProducer prod = x.getProducer(isTopic, destinationName);
                    Delivery.this.mActivation.getObjectFactory().send(isTopic, prod, newMsg, m.getJMSPriority(), m.getJMSDeliveryMode());
                    Delivery.this.sLog.info("E027: Message with msgid=[{}] was seen {} times. It will be forwarded (moved) to {} {} with msgid [{}]", new Object[]{e.getMsgid(), Integer.toString(e.getNEncountered()), isTopic ? "topic" : "queue", destinationName, newMsg.getJMSMessageID()});
                }
                catch (Exception ex) {
                    copyException = ex;
                }
            }
            if (Delivery.this.mActivation.shouldRedirectRatherThanForward() || copyException != null) {
                try {
                    MessageProducer prod = x.getProducer(isTopic, destinationName);
                    Delivery.this.mActivation.getObjectFactory().send(isTopic, prod, m, m.getJMSPriority(), m.getJMSDeliveryMode());
                    if (Delivery.this.mActivation.shouldRedirectRatherThanForward()) {
                        Delivery.this.sLog.info("E028: Message with msgid=[{}] was seen {} times. It will be redirected to {} {}.", new Object[]{e.getMsgid(), Integer.toString(e.getNEncountered()), isTopic ? "topic" : "queue", destinationName});
                    } else {
                        Delivery.this.sLog.info("E029: Message with msgid=[{}] was seen {} times. It will be redirected to {} {}. An attempt was made to forward the message with additional information in the message''s properties, but this attempt was unsuccessful due to the following error: [{}].", new Object[]{e.getMsgid(), Integer.toString(e.getNEncountered()), isTopic ? "topic" : "queue", destinationName, copyException});
                    }
                    copyException = null;
                }
                catch (Exception ex) {
                    copyException = new Exception("Redirect failed due to " + ex + "; forward failed due to " + copyException, ex);
                }
            }
            if (xa != null) {
                Delivery.this.getTxMgr().getTransaction().delistResource(xa, 0x4000000);
            } else {
                x.setNeedsNonXACommit();
            }
            if (copyException != null) {
                throw copyException;
            }
            x.setBusy(false);
        }

        @Override
        protected void stopConnector(String s) {
            Delivery.this.mActivation.stopConnectorByMDB(s);
        }
    }

    public class ConnectionForMove {
        private boolean mIsTopic;
        private Connection mConn;
        private Session mSession;
        private Destination mDest;
        private String mDestName;
        private MessageProducer mProducer;
        private boolean mBusy;
        private boolean mDelayedCommit;
        private boolean mNeedsCommit;

        public void destroy() {
            if (this.mSession != null) {
                try {
                    this.mSession.close();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
                this.mSession = null;
            }
            if (this.mConn != null) {
                try {
                    this.mConn.close();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
                this.mConn = null;
            }
            this.mDest = null;
            this.mDestName = null;
            this.mProducer = null;
        }

        private Connection getConnection(boolean isTopic) throws JMSException {
            if (this.mConn != null) {
                if (isTopic != this.mIsTopic) {
                    throw Exc.jmsExc(LOCALE.x("E007: Internal fault: cannot change messaging domain after connection has been created."));
                }
            } else {
                this.mIsTopic = isTopic;
                RAJMSObjectFactory o = Delivery.this.mActivation.getObjectFactory();
                ConnectionFactory fact = o.createConnectionFactory(XConnectionRequestInfo.guessDomain(Delivery.this.mActivation.isCMT() && !Delivery.this.mActivation.isXAEmulated(), this.mIsTopic), Delivery.this.mActivation.getRA(), Delivery.this.mActivation.getActivationSpec(), null, null);
                this.mConn = o.createConnection(fact, XConnectionRequestInfo.guessDomain(Delivery.this.mActivation.isCMT() && !Delivery.this.mActivation.isXAEmulated(), this.mIsTopic), Delivery.this.mActivation.getActivationSpec(), Delivery.this.mActivation.getRA(), Delivery.this.mActivation.getUserName() == null ? Delivery.this.mActivation.getRA().getUserName() : Delivery.this.mActivation.getUserName(), Delivery.this.mActivation.getPassword() == null ? Delivery.this.mActivation.getRA().getClearTextPassword() : Delivery.this.mActivation.getPassword());
            }
            return this.mConn;
        }

        private Session getSession(boolean isTopic) throws JMSException {
            if (this.mSession != null) {
                this.getConnection(isTopic);
            } else {
                RAJMSObjectFactory o = Delivery.this.mActivation.getObjectFactory();
                this.mSession = o.createSession(this.getConnection(isTopic), Delivery.this.mActivation.isCMT() && !Delivery.this.mActivation.isXAEmulated(), this.mIsTopic ? TopicSession.class : QueueSession.class, Delivery.this.mActivation.getRA(), Delivery.this.mActivation.getActivationSpec(), true, 0);
            }
            return this.mSession;
        }

        private Destination getDestination(boolean isTopic, String destname) throws JMSException {
            if (this.mDest != null) {
                this.getConnection(isTopic);
                if (!destname.equals(this.mDestName)) {
                    throw Exc.jmsExc(LOCALE.x("E033:Cannot change destination"));
                }
            } else {
                RAJMSObjectFactory o = Delivery.this.mActivation.getObjectFactory();
                this.mDest = o.createDestination(this.getSession(isTopic), Delivery.this.mActivation.isCMT() && !Delivery.this.mActivation.isXAEmulated(), isTopic, Delivery.this.mActivation.getActivationSpec(), null, Delivery.this.mActivation.getRA(), destname);
                this.mDestName = destname;
            }
            return this.mDest;
        }

        private MessageProducer getProducer(boolean isTopic, String destname) throws JMSException {
            this.getConnection(isTopic);
            if (this.mProducer == null) {
                RAJMSObjectFactory o = Delivery.this.mActivation.getObjectFactory();
                this.mProducer = o.createMessageProducer(this.getSession(isTopic), Delivery.this.mActivation.isCMT() && !Delivery.this.mActivation.isXAEmulated(), isTopic, this.getDestination(isTopic, destname), Delivery.this.mActivation.getRA());
            }
            return this.mProducer;
        }

        public void setBusy(boolean b) {
            this.mBusy = b;
        }

        public boolean isBusy() {
            return this.mBusy;
        }

        public void nonXACommit(boolean commit) throws JMSException {
            if (this.mSession != null && this.mNeedsCommit) {
                if (commit) {
                    this.mSession.commit();
                } else {
                    this.mSession.rollback();
                }
            }
            this.mNeedsCommit = false;
        }

        public void setNeedsNonXACommit() throws JMSException {
            if (!this.mDelayedCommit) {
                this.mSession.commit();
                this.mBusy = false;
                this.mNeedsCommit = false;
            } else {
                this.mNeedsCommit = true;
            }
        }

        public void setDelayedCommit() {
            this.mDelayedCommit = true;
        }
    }
}

