/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.ra.core;

import com.tongtech.jms.ra.core.AdminDestination;
import com.tongtech.jms.ra.core.AdminQueue;
import com.tongtech.jms.ra.core.RAJMSObjectFactory;
import com.tongtech.jms.ra.core.RAJMSResourceAdapter;
import com.tongtech.jms.ra.core.SessionConnection;
import com.tongtech.jms.ra.core.XConnectionRequestInfo;
import com.tongtech.jms.ra.core.XManagedConnection;
import com.tongtech.jms.ra.localization.Localizer;
import com.tongtech.jms.ra.util.Exc;
import javax.jms.Connection;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import javax.transaction.xa.XAResource;

public class GenericSessionConnection
extends SessionConnection {
    private static final Localizer LOCALE = Localizer.get();
    protected Connection mConnection;
    private Session mSession;
    private boolean mIsXA;
    private boolean mIsTransacted;
    private int mAcknowledgMode;
    private Class mSessionClass;
    private XConnectionRequestInfo mDescr;
    private RAJMSResourceAdapter mRA;
    protected XManagedConnection mMC;
    private Object mConFact;
    private RAJMSObjectFactory mObjFact;

    public GenericSessionConnection(Object connectionFactory, RAJMSObjectFactory objfact, RAJMSResourceAdapter ra, XManagedConnection mc, XConnectionRequestInfo descr, boolean isXa, boolean isTransacted, int acknowledgmentMode, Class sessionClass) throws JMSException {
        this.mConFact = connectionFactory;
        this.mObjFact = objfact;
        this.mRA = ra;
        this.mMC = mc;
        this.mDescr = descr;
        this.mSessionClass = sessionClass;
        this.mIsXA = isXa;
        this.mIsTransacted = isTransacted;
        this.mAcknowledgMode = acknowledgmentMode;
        this.mConnection = this.mObjFact.createConnection(this.mConFact, this.mDescr.getDomain(isXa), null, this.mRA, mc.getUserid(), mc.getPassword());
        if (this.mDescr.getClientID() != null) {
            this.mObjFact.setClientID(this.mConnection, this.mDescr.getClientID());
        }
        this.mSession = this.mObjFact.createSession(this.mConnection, isXa, sessionClass, this.mRA, null, isTransacted, acknowledgmentMode);
    }

    @Override
    public Session getJmsSession() throws JMSException {
        return this.mObjFact.getNonXASession(this.mSession, this.mIsXA, this.mSessionClass);
    }

    @Override
    public void start() throws JMSException {
        this.mConnection.start();
    }

    @Override
    public void stop() throws JMSException {
        if (this.mConnection != null) {
            this.mConnection.stop();
        }
    }

    @Override
    public XAResource getXAResource() throws JMSException {
        if (!this.mIsXA) {
            throw Exc.jmsExc(LOCALE.x("E127: Logic fault: cannot return XAResource from non-XA session"));
        }
        return this.mObjFact.getXAResource(true, this.mSession);
    }

    @Override
    public void destroy() throws JMSException {
        try {
            if (this.mSession != null) {
                this.mSession.close();
                this.mSession = null;
            }
        }
        finally {
            if (this.mConnection != null) {
                this.mConnection.close();
                this.mConnection = null;
            }
        }
    }

    @Override
    public ConnectionMetaData getConnectionMetaData() throws JMSException {
        return this.mConnection.getMetaData();
    }

    @Override
    public void setClientID(String clientID) throws JMSException {
        this.mConnection.setClientID(clientID);
    }

    @Override
    public boolean getTransacted() {
        return this.mIsTransacted;
    }

    @Override
    public int getAcknowledgeMode() {
        return this.mAcknowledgMode;
    }

    @Override
    public boolean isXA() {
        return this.mIsXA;
    }

    @Override
    public Queue createQueue(String name) throws JMSException {
        return this.mObjFact.getNonXASession(this.mSession, this.mIsXA, this.mSessionClass).createQueue(name);
    }

    @Override
    public Topic createTopic(String name) throws JMSException {
        return this.mObjFact.getNonXASession(this.mSession, this.mIsXA, this.mSessionClass).createTopic(name);
    }

    @Override
    public Destination checkGeneric(Destination d) throws JMSException {
        return this.mObjFact.checkGeneric(d);
    }

    public RAJMSObjectFactory getObjFact() {
        return this.mObjFact;
    }

    public RAJMSResourceAdapter getRA() {
        return this.mRA;
    }

    @Override
    public Destination createDestination(AdminDestination dest) throws JMSException {
        if (dest instanceof AdminQueue) {
            return this.createQueue(dest.retrieveCheckedName());
        }
        return this.createTopic(dest.retrieveCheckedName());
    }
}

