/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.ra.core;

import com.tongtech.jms.ra.core.IWSession;
import com.tongtech.jms.ra.core.JSession;
import com.tongtech.jms.ra.core.TxMgr;
import com.tongtech.jms.ra.core.WConnection;
import com.tongtech.jms.ra.core.WQueueConnection;
import com.tongtech.jms.ra.core.WTopicConnection;
import com.tongtech.jms.ra.core.XConnectionRequestInfo;
import com.tongtech.jms.ra.core.XManagedConnectionFactory;
import com.tongtech.jms.ra.localization.Localizer;
import com.tongtech.jms.ra.util.Exc;
import com.tongtech.jms.ra.util.NoProxyWrapper;
import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.transaction.Synchronization;

public class JConnection
extends NoProxyWrapper
implements QueueConnection,
TopicConnection,
Connection {
    private static com.tongtech.jms.ra.util.Logger sLog = com.tongtech.jms.ra.util.Logger.getLogger(JConnection.class);
    protected static Logger logger = LoggerFactory.getLogger(JConnection.class);
    private XManagedConnectionFactory mManagedConnectionFactory;
    private ConnectionManager mConnectionManager;
    private Class mConnectionClass;
    private String mUsername;
    private String mPassword;
    private boolean mStarted;
    private List mSessions = new ArrayList();
    private String mClientID;
    private List mTemporaryDestinations = new ArrayList();
    private static final Localizer LOCALE = Localizer.get();

    public JConnection(XManagedConnectionFactory managedConnectionFactory, ConnectionManager connectionManager, Class connectionClass, String username, String password) {
        this.mManagedConnectionFactory = managedConnectionFactory;
        this.mConnectionManager = connectionManager;
        this.mConnectionClass = connectionClass;
        this.mUsername = username;
        this.mPassword = password;
        this.init(this.mConnectionClass, "");
        if (sLog.isDebugEnabled()) {
            sLog.debug("JConnection cont...");
        }
    }

    private Session createSessionByApplication(Class sessionClass, boolean transacted, int acknowledgeMode) throws JMSException {
        int orgAckmode = acknowledgeMode;
        if (sLog.isDebugEnabled()) {
            sLog.debug("createSessionByApplication, transacted: " + transacted);
        }
        if (transacted) {
            acknowledgeMode = 0;
            orgAckmode = 0;
        } else if (acknowledgeMode == 0) {
            acknowledgeMode = 1;
            orgAckmode = 1;
        }
        if (sLog.isDebugEnabled()) {
            sLog.debug("createSessionByApplication, before XConnectionRequestInfo, transacted: " + transacted);
        }
        IWSession w = null;
        try {
            String[] useridpassword = this.mManagedConnectionFactory.getUserIdAndPasswordAndUrl(this.mUsername, this.mPassword);
            XConnectionRequestInfo descr = new XConnectionRequestInfo(this.mConnectionClass, sessionClass, useridpassword[0], useridpassword[1], useridpassword[2], this.mClientID, transacted, acknowledgeMode);
            Object obj = this.mConnectionManager.allocateConnection((ManagedConnectionFactory)this.mManagedConnectionFactory, (ConnectionRequestInfo)descr);
            w = (IWSession)obj;
            w.getReference().setConnection(this);
            w.getReference().getJSession().setSpecifiedAcknowledgeMode(orgAckmode);
            if (this.mStarted) {
                w.getReference().getJSession().start();
            }
            this.mSessions.add(w);
            if (sLog.isDebugEnabled()) {
                sLog.debug("finished createSessionByApplication, transacted: " + transacted);
            }
            return w;
        }
        catch (Exception ex) {
            sLog.errorNoloc("", ex);
            if (w != null) {
                try {
                    w.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            throw Exc.jmsExc(LOCALE.x("E034: Could not create session {0}: {1}", sessionClass.getName(), ex), ex);
        }
    }

    public void addTemporaryDestination(Destination dest) throws JMSException {
        if (!(dest instanceof TemporaryQueue) && !(dest instanceof TemporaryTopic)) {
            throw Exc.jmsExc(LOCALE.x("E128: Destination [{0}] is not a temporary destination.", dest));
        }
        this.mTemporaryDestinations.add(dest);
    }

    public void removeTemporaryDestination(Destination dest) {
        boolean removed = this.mTemporaryDestinations.remove(dest);
        if (!removed) {
            sLog.warn(LOCALE.x("E035: Unexpected: ''.delete()'' was called on a temporary destination that was not known to the connection. Perhaps the temporary destination was already deleted. The temporary destination is: [{0}]", dest));
        }
    }

    private void deferTempDestDeletion() {
        TxMgr txmgr = this.mManagedConnectionFactory.getTxMgr();
        try {
            txmgr.register(new Synchronization(){

                public void beforeCompletion() {
                }

                public void afterCompletion(int status) {
                    if (sLog.isDebugEnabled()) {
                        sLog.debug("afterCompletion(" + status + "); now invoking deferred " + "deletions of temporary destinations");
                    }
                    JConnection.this.deleteTemporaryDestinations();
                }
            });
        }
        catch (Exception e) {
            sLog.warn(LOCALE.x("E036: Could not defer deletion of temporary destinations: {0}", e), e);
        }
    }

    private boolean isContainerTransactionInProgress() {
        if (this.mManagedConnectionFactory.getOptionBypassRA() || this.mManagedConnectionFactory.getOptionClientContainer()) {
            return false;
        }
        TxMgr txmgr = this.mManagedConnectionFactory.getTxMgr();
        if (txmgr == null) {
            return false;
        }
        return txmgr.isInTransaction();
    }

    public void deleteTemporaryDestinations() {
        for (Destination dest : this.mTemporaryDestinations) {
            try {
                if (dest instanceof TemporaryQueue) {
                    ((TemporaryQueue)dest).delete();
                    continue;
                }
                ((TemporaryTopic)dest).delete();
            }
            catch (JMSException e) {
                sLog.warn(LOCALE.x("E037: Temporary destination {0} could not be deleted: {1}", dest, (Object)e), e);
            }
        }
        this.mTemporaryDestinations.clear();
    }

    public void close() throws JMSException {
        if (sLog.isDebugEnabled()) {
            sLog.debug("JConnection.close...");
        }
        while (!this.mSessions.isEmpty()) {
            Session s = (Session)this.mSessions.get(0);
            s.close();
        }
        if (!this.mTemporaryDestinations.isEmpty()) {
            if (this.isContainerTransactionInProgress()) {
                this.deferTempDestDeletion();
            } else {
                this.deleteTemporaryDestinations();
            }
        }
        this.createNewWrapper();
        if (sLog.isDebugEnabled()) {
            sLog.debug("finished JConnection.close...");
        }
    }

    public QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return (QueueSession)this.createSessionByApplication(QueueSession.class, transacted, acknowledgeMode);
    }

    public TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return (TopicSession)this.createSessionByApplication(TopicSession.class, transacted, acknowledgeMode);
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return this.createSessionByApplication(Session.class, transacted, acknowledgeMode);
    }

    public String getClientID() {
        return this.mClientID;
    }

    public void setClientID(String clientID) throws JMSException {
        if (clientID == null || clientID.length() == 0) {
            throw new InvalidClientIDException(LOCALE.x("E121: Client ID should be a non-empty string").toString());
        }
        if (this.mClientID != null) {
            throw new IllegalStateException(LOCALE.x("E122: The client ID already configured").toString());
        }
        this.mClientID = clientID;
        for (IWSession s : this.mSessions) {
            JSession j = s.getReference().getJSession();
            j.setClientID(clientID);
        }
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        ConnectionMetaData ret;
        if (!this.mSessions.isEmpty()) {
            IWSession s = (IWSession)this.mSessions.get(0);
            ret = s.getReference().getJSession().getConnectionMetaData();
        } else {
            IWSession s = (IWSession)this.createSessionByApplication(QueueSession.class, true, 0);
            ret = s.getReference().getJSession().getConnectionMetaData();
            s.close();
        }
        return ret;
    }

    public ExceptionListener getExceptionListener() {
        return null;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        throw Exc.jmsExc(LOCALE.x("E129: ExceptionListeners cannot be set in a JCA 1.5 connection"));
    }

    public void start() throws JMSException {
        this.mStarted = true;
        for (IWSession s : this.mSessions) {
            s.getReference().getJSession().start();
        }
    }

    public void stop() throws JMSException {
        this.mStarted = false;
        for (IWSession s : this.mSessions) {
            s.getReference().getJSession().stop();
        }
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String string, ServerSessionPool serverSessionPool, int int3) throws JMSException {
        throw Exc.jmsExc(LOCALE.x("E130: Connection consumers cannot be used with a JCA 1.5 connection"));
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String string, String string2, ServerSessionPool serverSessionPool, int int4) throws JMSException {
        throw Exc.jmsExc(LOCALE.x("E130: Connection consumers cannot be used with a JCA 1.5 connection"));
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String string, ServerSessionPool serverSessionPool, int int3) throws JMSException {
        throw Exc.jmsExc(LOCALE.x("E130: Connection consumers cannot be used with a JCA 1.5 connection"));
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String string, ServerSessionPool serverSessionPool, int int3) throws JMSException {
        throw Exc.jmsExc(LOCALE.x("E130: Connection consumers cannot be used with a JCA 1.5 connection"));
    }

    public void notifyWSessionClosedByApplication(Object s) {
        Iterator iter = this.mSessions.iterator();
        while (iter.hasNext()) {
            if (((IWSession)iter.next()).getReference() != s) continue;
            iter.remove();
            break;
        }
    }

    @Override
    public void createNewWrapper() {
        if (this.getWrapper() != null) {
            ((WConnection)this.getWrapper()).setClosed();
        }
        if (this.getItfClass() == Connection.class) {
            this.setWrapper(new WConnection(this));
        } else if (this.getItfClass() == QueueConnection.class) {
            this.setWrapper(new WQueueConnection(this));
        } else if (this.getItfClass() == TopicConnection.class) {
            this.setWrapper(new WTopicConnection(this));
        } else {
            throw Exc.rtexc(LOCALE.x("E131: Unknown class: {0}", this.getItfClass()));
        }
    }

    @Override
    public void physicalClose() {
        throw new java.lang.IllegalStateException(LOCALE.x("E132: Invalid call").toString());
    }
}

