/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.ra.core;

import com.tongtech.jms.ra.core.JConnection;
import com.tongtech.jms.ra.core.RAJMSResourceAdapter;
import com.tongtech.jms.ra.core.XDefaultConnectionManager;
import com.tongtech.jms.ra.core.XManagedConnectionFactory;
import com.tongtech.jms.ra.localization.Localizer;
import com.tongtech.jms.ra.util.Exc;
import com.tongtech.jms.ra.util.Logger;
import com.tongtech.jms.ra.util.Str;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.server.UID;
import java.util.Hashtable;
import java.util.Map;
import java.util.WeakHashMap;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.naming.BinaryRefAddr;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.resource.Referenceable;
import javax.resource.spi.ConnectionManager;

public class JConnectionFactory
implements ConnectionFactory,
Serializable,
Referenceable,
ObjectFactory {
    private static Logger sLog = Logger.getLogger(JConnectionFactory.class);
    private static final Localizer LOCALE = Localizer.get();
    private ConnectionManager mConnectionManager;
    private XManagedConnectionFactory mManagedConnectionFactory;
    private Reference mReference;
    private int mUniqueID;
    private static Map sAllFactories = new WeakHashMap();
    private static int sIdGenerator;
    private static String sBaseId;
    static final String REFADDTYPE = "XConnectionFactory";
    static final String REFADDTYPEUSINGID = "XConnectionFactory-using-id";

    public JConnectionFactory() {
    }

    private static final boolean isWebLogic(ConnectionManager cm) {
        if (cm != null) {
            return "weblogic.connector.outbound.ConnectionManagerImpl".equals(cm.getClass().getName());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JConnectionFactory(XManagedConnectionFactory managedConnectionFactory, ConnectionManager connectionManager) {
        this();
        this.mManagedConnectionFactory = managedConnectionFactory;
        this.mConnectionManager = connectionManager;
        if (this.mConnectionManager == null) {
            this.mConnectionManager = new XDefaultConnectionManager(managedConnectionFactory);
        }
        if (JConnectionFactory.isWebLogic(connectionManager)) {
            Map map = sAllFactories;
            synchronized (map) {
                this.mUniqueID = ++sIdGenerator;
                sAllFactories.put(this, null);
            }
        }
    }

    public ConnectionManager getConnectionManager() {
        return this.mConnectionManager;
    }

    public void setReference(Reference reference) {
        this.mReference = reference;
    }

    public Reference getReference() throws NamingException {
        if (this.mReference == null) {
            return this.getInternalReference();
        }
        return this.mReference;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.mConnectionManager);
        out.writeObject(this.mManagedConnectionFactory);
        out.flush();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.mConnectionManager = (ConnectionManager)in.readObject();
        this.mManagedConnectionFactory = (XManagedConnectionFactory)in.readObject();
    }

    private String getUniqueID() {
        return sBaseId + "/" + this.mUniqueID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JConnectionFactory getByID(String id) {
        Map map = sAllFactories;
        synchronized (map) {
            for (JConnectionFactory cand : sAllFactories.keySet()) {
                if (!id.equals(cand.getUniqueID())) continue;
                return cand;
            }
        }
        return null;
    }

    public Reference getInternalReference() throws NamingException {
        Reference ref = null;
        if (JConnectionFactory.isWebLogic(this.mConnectionManager)) {
            ref = new Reference(this.getClass().getName(), new StringRefAddr(REFADDTYPEUSINGID, this.getUniqueID()));
        } else {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream x = new ObjectOutputStream(baos);
                this.writeObject(x);
                byte[] bytes = baos.toByteArray();
                ref = new Reference(this.getClass().getName(), new BinaryRefAddr(REFADDTYPE, bytes), this.getClass().getName(), null);
            }
            catch (IOException ex) {
                NamingException tothrow = new NamingException("Could not obtain an internal reference: " + ex);
                tothrow.initCause(ex);
                throw tothrow;
            }
        }
        return ref;
    }

    public Object getObjectInstance(Object obj, Name name, Context ctx, Hashtable env) throws Exception {
        if (obj instanceof Reference) {
            Reference ref = (Reference)obj;
            RefAddr refAddr = ref.get(REFADDTYPE);
            if (refAddr == null) {
                String id;
                JConnectionFactory f;
                refAddr = ref.get(REFADDTYPEUSINGID);
                if (refAddr != null && (f = this.getByID(id = (String)refAddr.getContent())) != null) {
                    return f;
                }
            } else {
                byte[] bytes = (byte[])refAddr.getContent();
                ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                ObjectInputStream x = new ObjectInputStream(bais);
                this.readObject(x);
                return this;
            }
        }
        return null;
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return this.createQueueConnection(null, null);
    }

    public QueueConnection createQueueConnection(String username, String password) throws JMSException {
        return (QueueConnection)this.createConnection(QueueConnection.class, username, password);
    }

    public TopicConnection createTopicConnection() throws JMSException {
        return this.createTopicConnection(null, null);
    }

    public TopicConnection createTopicConnection(String username, String password) throws JMSException {
        if (sLog.isDebugEnabled()) {
            sLog.debug("Creating topic connection");
        }
        return (TopicConnection)this.createConnection(TopicConnection.class, username, password);
    }

    private Object createConnection(Class c, String username, String password) throws JMSException {
        if (sLog.isDebugEnabled()) {
            sLog.debug("start createConnection..." + this.mManagedConnectionFactory.getOptionBypassRA());
        }
        if (!this.mManagedConnectionFactory.getOptionBypassRA()) {
            return new JConnection(this.mManagedConnectionFactory, this.mConnectionManager, c, username, password).getWrapper();
        }
        if (sLog.isDebugEnabled()) {
            sLog.debug("start createConnection, else ...");
        }
        if (Str.empty(username)) {
            if (!Str.empty(this.mManagedConnectionFactory.getUserName())) {
                username = this.mManagedConnectionFactory.getUserName();
                password = this.mManagedConnectionFactory.getClearTextPassword();
            } else if (!Str.empty(this.getRA().getUserName())) {
                username = this.getRA().getUserName();
                password = this.getRA().getClearTextPassword();
            }
        }
        String[] useridpwurl = this.mManagedConnectionFactory.getUserIdAndPasswordAndUrl(username, password);
        if (c == QueueConnection.class) {
            QueueConnectionFactory f = (QueueConnectionFactory)this.mManagedConnectionFactory.getConnectionFactory(1, useridpwurl[2]);
            if (sLog.isDebugEnabled()) {
                sLog.debug("start createConnection, else 111...");
            }
            return useridpwurl[0] == null ? f.createQueueConnection() : f.createQueueConnection(useridpwurl[0], useridpwurl[1]);
        }
        if (c == TopicConnection.class) {
            TopicConnectionFactory f = (TopicConnectionFactory)this.mManagedConnectionFactory.getConnectionFactory(2, useridpwurl[2]);
            if (sLog.isDebugEnabled()) {
                sLog.debug("start createConnection, else 222...");
            }
            return useridpwurl[0] == null ? f.createTopicConnection() : f.createTopicConnection(useridpwurl[0], useridpwurl[1]);
        }
        if (c == Connection.class) {
            ConnectionFactory f = (ConnectionFactory)this.mManagedConnectionFactory.getConnectionFactory(6, useridpwurl[2]);
            if (sLog.isDebugEnabled()) {
                sLog.debug("start createConnection, else 333...");
            }
            return useridpwurl[0] == null ? f.createConnection() : f.createConnection(useridpwurl[0], useridpwurl[1]);
        }
        throw Exc.jmsExc(LOCALE.x("E133: Unknown domain {0}", c));
    }

    public Connection createConnection() throws JMSException {
        return this.createConnection(null, null);
    }

    public Connection createConnection(String username, String password) throws JMSException {
        if (sLog.isDebugEnabled()) {
            sLog.debug("Creating unified connection");
        }
        return (Connection)this.createConnection(Connection.class, username, password);
    }

    public RAJMSResourceAdapter getRA() {
        return this.mManagedConnectionFactory.getRAJMSResourceAdapter();
    }

    public XManagedConnectionFactory getMCF() {
        return this.mManagedConnectionFactory;
    }

    public XManagedConnectionFactory testGetMCF() {
        return this.mManagedConnectionFactory;
    }

    static {
        sBaseId = new UID().toString();
    }
}

