/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.ra.core;

import com.tongtech.jms.ra.core.JConnection;
import com.tongtech.jms.ra.core.JSession;
import com.tongtech.jms.ra.core.WMessageConsumer;
import com.tongtech.jms.ra.core.WQueueReceiver;
import com.tongtech.jms.ra.core.WTopicSubscriber;
import com.tongtech.jms.ra.localization.Localizer;
import com.tongtech.jms.ra.util.Exc;
import com.tongtech.jms.ra.util.Logger;
import com.tongtech.jms.ra.util.NoProxyWrapper;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.QueueReceiver;
import javax.jms.TopicSubscriber;

public class JConsumer
extends NoProxyWrapper {
    private static Logger sLog = Logger.getLogger(JConsumer.class);
    private JSession mSession;
    private MessageConsumer mDelegate;
    private JConnection mConnection;
    private static final Localizer LOCALE = Localizer.get();

    public JConsumer(Class itf, JSession session, MessageConsumer delegate, String signature, JConnection connection) {
        this.mSession = session;
        this.mDelegate = delegate;
        this.mConnection = connection;
        this.init(itf, signature);
    }

    public JSession getSession() {
        return this.mSession;
    }

    @Override
    public void createNewWrapper() {
        if (this.getWrapper() != null) {
            ((WMessageConsumer)this.getWrapper()).setClosed();
        }
        if (this.getItfClass() == MessageConsumer.class) {
            this.setWrapper(new WMessageConsumer(this, this.mDelegate));
        } else if (this.getItfClass() == TopicSubscriber.class) {
            this.setWrapper(new WTopicSubscriber(this, (TopicSubscriber)this.mDelegate));
        } else if (this.getItfClass() == QueueReceiver.class) {
            this.setWrapper(new WQueueReceiver(this, (QueueReceiver)this.mDelegate));
        } else {
            throw Exc.rtexc(LOCALE.x("E131: Unknown class: {0}", this.getItfClass()));
        }
    }

    @Override
    public void physicalClose() {
        this.createNewWrapper();
        try {
            this.mDelegate.close();
        }
        catch (JMSException ex) {
            sLog.warn(LOCALE.x("E094: This {0} could not be closed properly: {1}", this.getItfClass(), (Object)ex), ex);
        }
    }

    @Override
    public void exceptionOccurred(Throwable ex) {
        super.exceptionOccurred(ex);
        if (this.mSession != null) {
            this.mSession.exceptionOccurred(ex);
        }
    }

    public Message onReceived(Message message) {
        if (this.mSession != null) {
            this.mSession.onReceived(message);
        }
        return message;
    }

    public void close() throws JMSException {
        if (this.mDelegate != null) {
            this.mSession.notifyConsumerClosedByApplication(this);
        }
    }

    public JConnection getConnection() {
        return this.mConnection;
    }
}

