/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.ra.core;

import com.tongtech.jms.ra.core.JConnection;
import com.tongtech.jms.ra.core.JSession;
import com.tongtech.jms.ra.core.WMessageProducer;
import com.tongtech.jms.ra.core.WQueueSender;
import com.tongtech.jms.ra.core.WTopicPublisher;
import com.tongtech.jms.ra.localization.Localizer;
import com.tongtech.jms.ra.util.Exc;
import com.tongtech.jms.ra.util.Logger;
import com.tongtech.jms.ra.util.NoProxyWrapper;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.QueueSender;
import javax.jms.TopicPublisher;

public class JProducer
extends NoProxyWrapper {
    private static Logger sLog = Logger.getLogger(JProducer.class);
    private JSession mSession;
    private MessageProducer mDelegate;
    private boolean mIsTemp;
    private JConnection mConnection;
    private static final Localizer LOCALE = Localizer.get();

    public JProducer(Class itf, JSession session, MessageProducer delegate, String signature, boolean isTemp) {
        this.mSession = session;
        this.mDelegate = delegate;
        this.mIsTemp = isTemp;
        this.init(itf, signature);
    }

    public JSession getSession() {
        return this.mSession;
    }

    @Override
    public void createNewWrapper() {
        if (this.getWrapper() != null) {
            ((WMessageProducer)this.getWrapper()).setClosed();
        }
        if (this.getItfClass() == MessageProducer.class) {
            this.setWrapper(new WMessageProducer(this, this.mDelegate));
        } else if (this.getItfClass() == TopicPublisher.class) {
            this.setWrapper(new WTopicPublisher(this, (TopicPublisher)this.mDelegate));
        } else if (this.getItfClass() == QueueSender.class) {
            this.setWrapper(new WQueueSender(this, (QueueSender)this.mDelegate));
        } else {
            throw Exc.rtexc(LOCALE.x("E131: Unknown class: {0}", this.getItfClass()));
        }
    }

    public void virtualClose() {
        this.createNewWrapper();
        try {
            this.mDelegate.setDeliveryMode(2);
            this.mDelegate.setDisableMessageID(false);
            this.mDelegate.setDisableMessageTimestamp(false);
            this.mDelegate.setPriority(4);
            this.mDelegate.setTimeToLive(0L);
        }
        catch (JMSException ex) {
            sLog.warn(LOCALE.x("E040: An exception occurred resetting the client state of this {0}: {1}", this.getItfClass(), (Object)ex), ex);
        }
    }

    public boolean canBePooled() {
        return !this.mIsTemp && !this.hasExceptionOccurred();
    }

    @Override
    public void exceptionOccurred(Throwable ex) {
        super.exceptionOccurred(ex);
        if (this.mSession != null) {
            this.mSession.exceptionOccurred(ex);
        }
    }

    @Override
    public void physicalClose() {
        this.createNewWrapper();
        try {
            this.mDelegate.close();
        }
        catch (JMSException ex) {
            sLog.warn(LOCALE.x("E094: This {0} could not be closed properly: {1}", this.getItfClass(), (Object)ex), ex);
        }
    }

    public void onSend() {
        if (this.mSession != null) {
            this.mSession.onSend();
        }
    }

    public void close() throws JMSException {
        if (this.mDelegate != null) {
            this.mSession.notifyProducerClosedByApplication(this);
        }
    }

    public void setConnection(JConnection connection) {
        this.mConnection = connection;
    }

    public JConnection getConnection() {
        return this.mConnection;
    }
}

