/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.ra.core;

import com.tongtech.jms.ra.core.AdminDestination;
import com.tongtech.jms.ra.core.JConnection;
import com.tongtech.jms.ra.core.JConsumer;
import com.tongtech.jms.ra.core.JProducer;
import com.tongtech.jms.ra.core.RAJMSObjectFactory;
import com.tongtech.jms.ra.core.RAJMSResourceAdapter;
import com.tongtech.jms.ra.core.SessionConnection;
import com.tongtech.jms.ra.core.WQueueSession;
import com.tongtech.jms.ra.core.WSession;
import com.tongtech.jms.ra.core.WTemporaryQueue;
import com.tongtech.jms.ra.core.WTemporaryTopic;
import com.tongtech.jms.ra.core.WTopicSession;
import com.tongtech.jms.ra.core.XConnectionRequestInfo;
import com.tongtech.jms.ra.core.XManagedConnection;
import com.tongtech.jms.ra.localization.Localizer;
import com.tongtech.jms.ra.util.Exc;
import com.tongtech.jms.ra.util.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.transaction.xa.XAResource;

public class JSession {
    private static Logger sLog = Logger.getLogger(JSession.class);
    private SessionConnection mSessionConnection;
    private List mPooledProducers;
    private List mActiveProducers;
    private List mActiveConsumers;
    private XManagedConnection mManagedConnection;
    private int mCtExceptions;
    private Exception mFirstException;
    private Class mSessionClass;
    private int mSpecifiedAcknowledgeMode;
    private static final Localizer LOCALE = Localizer.get();

    public JSession(boolean xa, boolean isTransacted, int acknowledgeMode, Class sessionClass, XManagedConnection mc) throws JMSException {
        if (sLog.isDebugEnabled()) {
            sLog.debug("JSession.cons...");
        }
        this.mManagedConnection = mc;
        this.mSessionClass = sessionClass;
        RAJMSObjectFactory objfact = mc.getManagedConnectionFactory().getObjFactory();
        XConnectionRequestInfo descr = mc.getDescription();
        RAJMSResourceAdapter ra = (RAJMSResourceAdapter)mc.getManagedConnectionFactory().getResourceAdapter();
        this.mSessionConnection = objfact.createSessionConnection(mc.getManagedConnectionFactory().getConnectionFactory(xa, descr), objfact, ra, mc, descr, xa, isTransacted, acknowledgeMode, sessionClass);
        this.mPooledProducers = new ArrayList();
        this.mActiveProducers = new ArrayList();
        this.mActiveConsumers = new ArrayList();
        if (sLog.isDebugEnabled()) {
            sLog.debug("finished JSession.cons...");
        }
    }

    public void onSend() {
        this.mManagedConnection.onSuccessfulOperation();
    }

    public void onReceived(Message msg) {
        this.mManagedConnection.onSuccessfulOperation();
    }

    public Destination wrap(Destination destination, JConnection connection) {
        if (destination instanceof TemporaryQueue && !(destination instanceof WTemporaryQueue)) {
            return new WTemporaryQueue((TemporaryQueue)destination, connection);
        }
        if (destination instanceof TemporaryTopic && !(destination instanceof WTemporaryTopic)) {
            return new WTemporaryTopic((TemporaryTopic)destination, connection);
        }
        return destination;
    }

    public void onTransactionStateClean() {
    }

    public void cleanup() {
        boolean producersInvalidated = false;
        Iterator it = this.mActiveProducers.iterator();
        while (it.hasNext()) {
            JProducer p = (JProducer)it.next();
            if (this.mManagedConnection.useProducerPooling() && p.canBePooled() && !producersInvalidated) {
                p.virtualClose();
                this.mPooledProducers.add(p);
            } else {
                p.physicalClose();
            }
            it.remove();
        }
        it = this.mActiveConsumers.iterator();
        while (it.hasNext()) {
            JConsumer m = (JConsumer)it.next();
            try {
                m.physicalClose();
            }
            catch (Exception ex) {
                sLog.warn(LOCALE.x("E038: The consumer of type {0} could not be closed properly: {1}", m.getClass().getName(), ex), ex);
            }
            it.remove();
        }
    }

    public void destroy() throws JMSException {
        this.mActiveConsumers.clear();
        this.mActiveProducers.clear();
        this.mPooledProducers.clear();
        if (this.mSessionConnection != null) {
            this.mSessionConnection.destroy();
            this.mSessionConnection = null;
        }
    }

    public Object getDelegate() throws JMSException {
        return this.mSessionConnection.getJmsSession();
    }

    public XAResource getXAResource() throws JMSException {
        this.getDelegate();
        return this.mSessionConnection.getXAResource();
    }

    public void setClientID(String clientID) throws JMSException {
        this.getDelegate();
        this.mSessionConnection.setClientID(clientID);
    }

    public void notifyProducerClosedByApplication(JProducer p) {
        this.mActiveProducers.remove(p);
        if (!this.mManagedConnection.useProducerPooling() || !p.canBePooled()) {
            p.physicalClose();
        } else {
            p.virtualClose();
            this.addToPool(p);
        }
    }

    public void notifyConsumerClosedByApplication(JConsumer p) {
        this.mActiveConsumers.remove(p);
        p.physicalClose();
    }

    public ConnectionMetaData getConnectionMetaData() throws JMSException {
        this.getDelegate();
        return this.mSessionConnection.getConnectionMetaData();
    }

    public void start() throws JMSException {
        this.getDelegate();
        this.mSessionConnection.start();
    }

    public void stop() throws JMSException {
        this.mSessionConnection.stop();
    }

    private JProducer getFromPool(String signature) {
        JProducer ret = null;
        Iterator it = this.mPooledProducers.iterator();
        while (it.hasNext()) {
            JProducer p = (JProducer)it.next();
            if (!p.getSignature().equals(signature)) continue;
            ret = p;
            it.remove();
            break;
        }
        return ret;
    }

    private void addToPool(JProducer p) {
        this.mPooledProducers.add(p);
    }

    public MessageProducer createProducer(String signature, Class producerClass, boolean isTemp, ProducerCreator creator, JConnection connection) throws JMSException {
        JProducer wrapped = null;
        this.getDelegate();
        if (this.mManagedConnection.useProducerPooling()) {
            wrapped = this.getFromPool(signature);
        }
        if (wrapped == null) {
            MessageProducer producer = creator.createProducer();
            wrapped = new JProducer(producerClass, this, producer, signature, isTemp);
        }
        this.mActiveProducers.add(wrapped);
        wrapped.setConnection(connection);
        return (MessageProducer)wrapped.getWrapper();
    }

    public XManagedConnection getManagedConnection() {
        return this.mManagedConnection;
    }

    public void exceptionOccurred(Throwable ex) {
        Exception exception;
        if (ex instanceof Exception) {
            exception = (Exception)ex;
        } else {
            exception = new Exception("Runtime exception: " + ex);
            Exc.setCause(exception, ex);
        }
        if (this.mFirstException == null) {
            this.mFirstException = exception;
        }
        ++this.mCtExceptions;
        this.mManagedConnection.notifyConnectionErrorOccured(exception);
    }

    public boolean hasExceptionOccurred() {
        return this.mCtExceptions > 0;
    }

    public Exception getFirstException() {
        return this.mFirstException;
    }

    public int getExceptionCount() {
        return this.mCtExceptions;
    }

    public WSession createHandle() {
        if (this.mSessionClass == Session.class) {
            return new WSession(this);
        }
        if (this.mSessionClass == QueueSession.class) {
            return new WQueueSession(this);
        }
        if (this.mSessionClass == TopicSession.class) {
            return new WTopicSession(this);
        }
        throw Exc.rtexc(LOCALE.x("E131: Unknown class: {0}", this.mSessionClass));
    }

    public void setSpecifiedAcknowledgeMode(int orgAckmode) {
        this.mSpecifiedAcknowledgeMode = orgAckmode;
    }

    public void close(WSession w) throws JMSException {
        Exception closeException = null;
        if (sLog.isDebugEnabled()) {
            sLog.debug("JSession.close...");
        }
        try {
            this.stop();
        }
        catch (Exception e) {
            closeException = e;
        }
        this.mManagedConnection.notifyClosedByApplicationConnection(w);
        if (closeException != null) {
            throw Exc.jmsExc(LOCALE.x("E094: This {0} could not be closed properly: {1}", w, closeException), closeException);
        }
        if (sLog.isDebugEnabled()) {
            sLog.debug("finished JSession.close...");
        }
    }

    public QueueReceiver createReceiver(Queue queue, JConnection connection) throws JMSException {
        QueueReceiver delegate = ((QueueSession)this.getDelegate()).createReceiver(queue);
        JConsumer wrapped = new JConsumer(QueueReceiver.class, this, (MessageConsumer)delegate, null, connection);
        this.mActiveConsumers.add(wrapped);
        return (QueueReceiver)wrapped.getWrapper();
    }

    public QueueReceiver createReceiver(Queue queue, String messageSelector, JConnection connection) throws JMSException {
        QueueReceiver delegate = ((QueueSession)this.getDelegate()).createReceiver(queue, messageSelector);
        JConsumer wrapped = new JConsumer(QueueReceiver.class, this, (MessageConsumer)delegate, null, connection);
        this.mActiveConsumers.add(wrapped);
        return (QueueReceiver)wrapped.getWrapper();
    }

    public QueueSender createSender(final Queue queue, JConnection connection) throws JMSException {
        return (QueueSender)this.createProducer("QueueSender:" + (queue != null ? queue.getQueueName() : "-"), QueueSender.class, queue != null && queue instanceof TemporaryQueue, new ProducerCreator(){

            @Override
            public MessageProducer createProducer() throws JMSException {
                return ((QueueSession)JSession.this.getDelegate()).createSender(queue);
            }
        }, connection);
    }

    public TopicPublisher createPublisher(final Topic topic, JConnection connection) throws JMSException {
        return (TopicPublisher)this.createProducer("TopicPublisher:" + (topic != null ? topic.getTopicName() : "-"), TopicPublisher.class, topic != null && topic instanceof TemporaryTopic, new ProducerCreator(){

            @Override
            public MessageProducer createProducer() throws JMSException {
                return ((TopicSession)JSession.this.getDelegate()).createPublisher(topic);
            }
        }, connection);
    }

    public TopicSubscriber createSubscriber(Topic topic, JConnection connection) throws JMSException {
        TopicSubscriber delegate = ((TopicSession)this.getDelegate()).createSubscriber(topic);
        JConsumer wrapped = new JConsumer(TopicSubscriber.class, this, (MessageConsumer)delegate, null, connection);
        this.mActiveConsumers.add(wrapped);
        return (TopicSubscriber)wrapped.getWrapper();
    }

    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal, JConnection connection) throws JMSException {
        TopicSubscriber delegate = ((TopicSession)this.getDelegate()).createSubscriber(topic, messageSelector, noLocal);
        JConsumer wrapped = new JConsumer(TopicSubscriber.class, this, (MessageConsumer)delegate, null, connection);
        this.mActiveConsumers.add(wrapped);
        return (TopicSubscriber)wrapped.getWrapper();
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, JConnection connection) throws JMSException {
        TopicSubscriber delegate = ((Session)this.getDelegate()).createDurableSubscriber(topic, name);
        JConsumer wrapped = new JConsumer(TopicSubscriber.class, this, (MessageConsumer)delegate, null, connection);
        this.mActiveConsumers.add(wrapped);
        return (TopicSubscriber)wrapped.getWrapper();
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal, JConnection connection) throws JMSException {
        TopicSubscriber delegate = ((Session)this.getDelegate()).createDurableSubscriber(topic, name, messageSelector, noLocal);
        JConsumer wrapped = new JConsumer(TopicSubscriber.class, this, (MessageConsumer)delegate, null, connection);
        this.mActiveConsumers.add(wrapped);
        return (TopicSubscriber)wrapped.getWrapper();
    }

    public MessageProducer createProducer(final Destination destination, JConnection connection) throws JMSException {
        String name = "-";
        if (destination != null) {
            name = destination instanceof Queue ? ((Queue)destination).getQueueName() : ((Topic)destination).getTopicName();
        }
        return this.createProducer("MessageProducer:" + name, MessageProducer.class, destination != null && (destination instanceof TemporaryQueue || destination instanceof TemporaryTopic), new ProducerCreator(){

            @Override
            public MessageProducer createProducer() throws JMSException {
                return ((Session)JSession.this.getDelegate()).createProducer(destination);
            }
        }, connection);
    }

    public MessageConsumer createConsumer(Destination destination, JConnection connection) throws JMSException {
        MessageConsumer delegate = ((Session)this.getDelegate()).createConsumer(destination);
        JConsumer wrapped = new JConsumer(MessageConsumer.class, this, delegate, null, connection);
        this.mActiveConsumers.add(wrapped);
        return (MessageConsumer)wrapped.getWrapper();
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, JConnection connection) throws JMSException {
        MessageConsumer delegate = ((Session)this.getDelegate()).createConsumer(destination, messageSelector);
        JConsumer wrapped = new JConsumer(MessageConsumer.class, this, delegate, null, connection);
        this.mActiveConsumers.add(wrapped);
        return (MessageConsumer)wrapped.getWrapper();
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal, JConnection connection) throws JMSException {
        MessageConsumer delegate = ((Session)this.getDelegate()).createConsumer(destination, messageSelector, noLocal);
        JConsumer wrapped = new JConsumer(MessageConsumer.class, this, delegate, null, connection);
        this.mActiveConsumers.add(wrapped);
        return (MessageConsumer)wrapped.getWrapper();
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        throw Exc.jmsExc(LOCALE.x("E129: ExceptionListeners cannot be set in a JCA 1.5 connection"));
    }

    public void commit(WSession w) throws JMSException {
        ((Session)this.getDelegate()).commit();
        if (w != null) {
            this.mManagedConnection.notifyCommit(w);
        }
        this.onTransactionStateClean();
    }

    public void rollback(WSession w) throws JMSException {
        ((Session)this.getDelegate()).rollback();
        if (w != null) {
            this.mManagedConnection.notifyRollback(w);
        }
        this.onTransactionStateClean();
    }

    public int getAcknowledgeMode() throws JMSException {
        return this.mSpecifiedAcknowledgeMode;
    }

    public void recover() throws JMSException {
        if (!this.mSessionConnection.isXA()) {
            ((Session)this.getDelegate()).recover();
        }
    }

    public Topic createTopic(String name) throws JMSException {
        Destination ret = this.mManagedConnection.getManagedConnectionFactory().getObjFactory().adminDestinationLookup(name);
        if (ret == null) {
            return this.mSessionConnection.createTopic(name);
        }
        if (ret instanceof AdminDestination) {
            return (Topic)this.createDestination((AdminDestination)ret);
        }
        return (Topic)ret;
    }

    public Queue createQueue(String name) throws JMSException {
        Destination ret = this.mManagedConnection.getManagedConnectionFactory().getObjFactory().adminDestinationLookup(name);
        if (ret == null) {
            return this.mSessionConnection.createQueue(name);
        }
        if (ret instanceof AdminDestination) {
            return (Queue)this.createDestination((AdminDestination)ret);
        }
        return (Queue)ret;
    }

    public Destination createDestination(AdminDestination dest) throws JMSException {
        return this.mSessionConnection.createDestination(dest);
    }

    public Destination checkGeneric(Destination d) throws JMSException {
        return this.mSessionConnection.checkGeneric(d);
    }

    public static interface ProducerCreator {
        public MessageProducer createProducer() throws JMSException;
    }
}

