/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.ra.core;

import com.tongtech.jms.ra.jts.jtsxa.LastAgentResource;
import com.tongtech.jms.ra.localization.Localizer;
import com.tongtech.jms.ra.util.Exc;
import com.tongtech.jms.ra.util.Logger;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class PseudoXAResource
implements LastAgentResource {
    private static Logger sLog = Logger.getLogger(PseudoXAResource.class);
    private Session mSession;
    private static final Localizer LOCALE = Localizer.get();

    public PseudoXAResource(Session s) throws JMSException {
        this.mSession = s;
        if (!this.mSession.getTransacted()) {
            throw Exc.jmsExc(LOCALE.x("E134: The session should be transacted."));
        }
    }

    @Override
    public void commit(Xid arg0, boolean arg1) throws XAException {
        try {
            this.mSession.commit();
        }
        catch (JMSException e) {
            throw Exc.xaExc(-3, (Exception)((Object)e));
        }
    }

    @Override
    public void end(Xid arg0, int arg1) throws XAException {
    }

    @Override
    public void forget(Xid arg0) throws XAException {
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isSameRM(XAResource arg0) throws XAException {
        return false;
    }

    @Override
    public int prepare(Xid arg0) throws XAException {
        return 0;
    }

    @Override
    public Xid[] recover(int arg0) throws XAException {
        return new Xid[0];
    }

    @Override
    public void rollback(Xid arg0) throws XAException {
        try {
            this.mSession.rollback();
        }
        catch (JMSException e) {
            throw Exc.xaExc(-3, (Exception)((Object)e));
        }
    }

    @Override
    public boolean setTransactionTimeout(int arg0) throws XAException {
        return false;
    }

    @Override
    public void start(Xid arg0, int arg1) throws XAException {
    }

    @Override
    public int lastAgentPreferenceLevel() {
        return 1;
    }
}

