/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.ra.core;

import com.tongtech.jms.ra.core.RAJMSResourceAdapter;
import com.tongtech.jms.ra.core.RedeliveryHandler;
import com.tongtech.jms.ra.localization.Localizer;
import com.tongtech.jms.ra.util.Exc;
import com.tongtech.jms.ra.util.Str;
import java.io.Serializable;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.InvalidPropertyException;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;

public abstract class RAJMSActivationSpec
implements ActivationSpec,
ResourceAdapterAssociation,
Serializable {
    private static final String AUTOACKNOWLEDGE = "Auto-acknowledge";
    private static final String DUPSOKACKNOWLEDGE = "Dups-ok-acknowledge";
    public static final String DURABLE = "Durable";
    public static final String NONDURABLE = "NonDurable";
    public static final int DELIVERYCONCURRENCY_SERIAL = 0;
    public static final int DELIVERYCONCURRENCY_CC = 1;
    public static final int DELIVERYCONCURRENCY_MR = 2;
    public static final int DELIVERYCONCURRENCY_SYNC = 3;
    public static final String[] DELIVERYCONCURRENCY_STRS = new String[]{"serial", "cc", "multi-receiver", "sync"};
    protected static final String QUEUE = "javax.jms.Queue";
    protected static final String TOPIC = "javax.jms.Topic";
    private ResourceAdapter mRA = null;
    private String mDestinationType;
    private String mDestination;
    private String mMessageSelector;
    private String mAcknowledgeMode = "Auto-acknowledge";
    private String mSubscriptionDurability = "NonDurable";
    private String mClientId;
    private String mSubscriptionName;
    private String mMBeanName;
    private String mContextName;
    private String mOptionsStr;
    private String mRedeliveryActions = "3:25; 5:50; 10:100; 20:1000; 50:5000";
    private String mFactoryName = "";
    private int mEndpointPoolMaxSize = 15;
    private int mEndpointPoolSteadySize = 10;
    private int mEndpointPoolResizeCount = 1;
    private int mEndpointPoolResizeTimeout = 5;
    private int mEndpointExceptionRedeliveryAttempts = 1;
    private int mEndpointExceptionRedeliveryInterval = 100;
    private transient ClassLoader mContextClassLoader;
    private int mDeliveryConcurrencyMode;
    private String mConnectionURL;
    private String mUsername;
    private String mPassword;
    private int mBatchSize;
    private String mHoldUntilAckMode;
    private static final Localizer LOCALE = Localizer.get();

    public abstract boolean isValidDestinationName(String var1);

    protected boolean empty(String s) {
        return s == null || s.length() == 0;
    }

    private void assertNotEmpty(String name, String toTest) {
        if (this.empty(toTest)) {
            throw Exc.illarg(LOCALE.x("E135: {0} cannot be empty", name));
        }
    }

    public void validate() throws InvalidPropertyException {
        if (!this.isValidDestinationName(this.mDestination)) {
            throw Exc.invprop(LOCALE.x("E136: Invalid destination: {0}", this.mDestination));
        }
        if (TOPIC.equals(this.mDestinationType) && DURABLE.equals(this.mSubscriptionDurability) && this.empty(this.mSubscriptionName)) {
            throw Exc.invprop(LOCALE.x("E137: Missing value for subscription name"));
        }
        if (this.mEndpointExceptionRedeliveryInterval < 1) {
            throw Exc.invprop(LOCALE.x("E138: {0} is not a valid value for ''{1}''", Integer.toString(this.mEndpointExceptionRedeliveryInterval), "endpointExceptionRedeliveryInterval"));
        }
        if (this.mEndpointExceptionRedeliveryAttempts < 0) {
            throw Exc.invprop(LOCALE.x("E138: {0} is not a valid value for ''{1}''", Integer.toString(this.mEndpointExceptionRedeliveryAttempts), "endpointExceptionRedeliveryAttempts"));
        }
        if (this.mEndpointPoolResizeTimeout < 1) {
            throw Exc.invprop(LOCALE.x("E138: {0} is not a valid value for ''{1}''", Integer.toString(this.mEndpointPoolResizeTimeout), "endpointPoolResizeTimeout"));
        }
        if (this.mEndpointPoolResizeCount < 1) {
            throw Exc.invprop(LOCALE.x("E138: {0} is not a valid value for ''{1}''", Integer.toString(this.mEndpointPoolResizeCount), "endpointPoolResizeCount"));
        }
        if (this.mEndpointPoolMaxSize < 1) {
            throw Exc.invprop(LOCALE.x("E138: {0} is not a valid value for ''{1}''", Integer.toString(this.mEndpointPoolMaxSize), "endpointPoolMaxSize"));
        }
        if (this.mEndpointPoolSteadySize < 0) {
            throw Exc.invprop(LOCALE.x("E138: {0} is not a valid value for ''{1}''", Integer.toString(this.mEndpointPoolSteadySize), "endpointPoolSteadySize"));
        }
        try {
            RedeliveryHandler.parse(this.mRedeliveryActions, "", this.mDestinationType);
        }
        catch (Exception e) {
            throw Exc.invprop(LOCALE.x("E144: Invalid value for ''redeliveryHandling'' ({0}): {1}", this.mRedeliveryActions, e), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResourceAdapter(ResourceAdapter ra) throws ResourceException {
        RAJMSActivationSpec rAJMSActivationSpec = this;
        synchronized (rAJMSActivationSpec) {
            if (this.mRA != null) {
                throw Exc.rsrcExc(LOCALE.x("E145: Cannot change resource adaptor association once set."));
            }
            if (!(ra instanceof RAJMSResourceAdapter)) {
                throw Exc.rsrcExc(LOCALE.x("E146: Invalid class {0}; must be instance of {1)", ra.getClass(), RAJMSResourceAdapter.class));
            }
            this.mRA = ra;
        }
    }

    public ResourceAdapter getResourceAdapter() {
        return this.mRA;
    }

    public void setDestinationType(String destinationType) {
        if (this.empty(destinationType)) {
            throw Exc.illarg(LOCALE.x("E147: ''destinationType'' can not be null"));
        }
        if (!QUEUE.equals(destinationType) && !TOPIC.equals(destinationType)) {
            throw Exc.illarg(LOCALE.x("E138: {0} is not a valid value for ''{1}''", destinationType, "destinationType"));
        }
        this.mDestinationType = destinationType;
    }

    public String getDestinationType() {
        return this.mDestinationType;
    }

    public void setDestination(String destination) {
        if (!this.isValidDestinationName(destination)) {
            throw Exc.illarg(LOCALE.x("E138: {0} is not a valid value for ''{1}''", destination, "destinationName"));
        }
        this.mDestination = destination;
    }

    public String getDestination() {
        return this.mDestination;
    }

    public void setMessageSelector(String messageSelector) {
        this.mMessageSelector = messageSelector;
    }

    public String getMessageSelector() {
        return this.mMessageSelector;
    }

    public void setAcknowledgeMode(String acknowledgeMode) {
        this.assertNotEmpty("acknowledgeMode", acknowledgeMode);
        if (!AUTOACKNOWLEDGE.equals(acknowledgeMode) && !DUPSOKACKNOWLEDGE.equals(acknowledgeMode)) {
            throw Exc.illarg(LOCALE.x("E150: Invalid value for ''acknowledgeMode'' ({0}); must be {1} or {2}", acknowledgeMode, AUTOACKNOWLEDGE, DUPSOKACKNOWLEDGE));
        }
        this.mAcknowledgeMode = acknowledgeMode;
    }

    public String getAcknowledgeMode() {
        return this.mAcknowledgeMode;
    }

    public void setSubscriptionDurability(String subscriptionDurability) {
        this.assertNotEmpty("subscriptionDurability", subscriptionDurability);
        if (!DURABLE.equals(subscriptionDurability) && !NONDURABLE.equals(subscriptionDurability)) {
            throw Exc.illarg(LOCALE.x("E151: Invalid value for ''subscriptionDurability'' ({0}); must be {1} or {2}", subscriptionDurability, DURABLE, NONDURABLE));
        }
        this.mSubscriptionDurability = subscriptionDurability;
    }

    public String getSubscriptionDurability() {
        return this.mSubscriptionDurability;
    }

    public void setClientId(String clientId) {
        this.mClientId = clientId;
    }

    public String getClientId() {
        return this.mClientId;
    }

    public void setSubscriptionName(String subscriptionName) {
        this.mSubscriptionName = subscriptionName;
    }

    public String getSubscriptionName() {
        return this.mSubscriptionName;
    }

    public void setEndpointPoolMaxSize(Integer endpointPoolMaxSize) {
        if (endpointPoolMaxSize < 1) {
            throw Exc.illarg(LOCALE.x("E138: {0} is not a valid value for ''{1}''", endpointPoolMaxSize, "endpointPoolMaxSize"));
        }
        this.mEndpointPoolMaxSize = endpointPoolMaxSize;
    }

    public void setEndpointPoolMaxSize(String endpointPoolMaxSize) {
        int iEndpointPoolMaxSize = Integer.parseInt(endpointPoolMaxSize);
        if (iEndpointPoolMaxSize < 1) {
            throw Exc.illarg(LOCALE.x("E138: {0} is not a valid value for ''{1}''", endpointPoolMaxSize, "endpointPoolMaxSize"));
        }
        this.mEndpointPoolMaxSize = iEndpointPoolMaxSize;
    }

    public Integer getEndpointPoolMaxSize() {
        return new Integer(this.mEndpointPoolMaxSize);
    }

    public void setEndpointPoolSteadySize(String endpointPoolSteadySize) {
        int iEndpointPoolSteadySize = Integer.parseInt(endpointPoolSteadySize);
        if (iEndpointPoolSteadySize < 0) {
            throw Exc.illarg(LOCALE.x("E138: {0} is not a valid value for ''{1}''", endpointPoolSteadySize, "endpointPoolSteadySize"));
        }
        this.mEndpointPoolSteadySize = iEndpointPoolSteadySize;
    }

    public int getEndpointPoolSteadySize() {
        return this.mEndpointPoolSteadySize;
    }

    public void setEndpointPoolResizeCount(String endpointPoolResizeCount) {
        int iEndpointPoolResizeCount = Integer.parseInt(endpointPoolResizeCount);
        if (iEndpointPoolResizeCount < 1) {
            throw Exc.illarg(LOCALE.x("E138: {0} is not a valid value for ''{1}''", endpointPoolResizeCount, "endpointPoolResizeCount"));
        }
        this.mEndpointPoolResizeCount = iEndpointPoolResizeCount;
    }

    public int getEndpointPoolResizeCount() {
        return this.mEndpointPoolResizeCount;
    }

    public void setEndpointPoolResizeTimeout(String endpointPoolResizeTimeout) {
        int iEndpointPoolResizeTimeout = Integer.parseInt(endpointPoolResizeTimeout);
        if (iEndpointPoolResizeTimeout < 1) {
            throw Exc.illarg(LOCALE.x("E138: {0} is not a valid value for ''{1}''", endpointPoolResizeTimeout, "endpointPoolResizeTimeout"));
        }
        this.mEndpointPoolResizeTimeout = iEndpointPoolResizeTimeout;
    }

    public int getEndpointPoolResizeTimeout() {
        return this.mEndpointPoolResizeTimeout;
    }

    public void setEndpointExceptionRedeliveryAttempts(int endpointExceptionRedeliveryAttempts) {
        if (endpointExceptionRedeliveryAttempts < 0) {
            throw Exc.illarg(LOCALE.x("E138: {0} is not a valid value for ''{1}''", Integer.toString(endpointExceptionRedeliveryAttempts), "endpointExceptionRedeliveryAttempts"));
        }
        this.mEndpointExceptionRedeliveryAttempts = endpointExceptionRedeliveryAttempts;
    }

    public int getEndpointExceptionRedeliveryAttempts() {
        return this.mEndpointExceptionRedeliveryAttempts;
    }

    public void setEndpointExceptionRedeliveryInterval(int endpointExceptionRedeliveryInterval) {
        if (endpointExceptionRedeliveryInterval < 1) {
            throw Exc.illarg(LOCALE.x("E138: {0} is not a valid value for ''{1}''", Integer.toString(endpointExceptionRedeliveryInterval), "endpointExceptionRedeliveryInterval"));
        }
        this.mEndpointExceptionRedeliveryInterval = endpointExceptionRedeliveryInterval;
    }

    public int getEndpointExceptionRedeliveryInterval() {
        return this.mEndpointExceptionRedeliveryInterval;
    }

    public void setContextClassLoader(ClassLoader contextClassLoader) {
        this.mContextClassLoader = contextClassLoader;
    }

    public ClassLoader getContextClassLoader() {
        return this.mContextClassLoader;
    }

    public void setConcurrencyMode(String mode) {
        for (int i = 0; i < DELIVERYCONCURRENCY_STRS.length; ++i) {
            if (!DELIVERYCONCURRENCY_STRS[i].equalsIgnoreCase(mode)) continue;
            this.mDeliveryConcurrencyMode = i;
            return;
        }
        String values = "";
        for (int i = 0; i < DELIVERYCONCURRENCY_STRS.length; ++i) {
            values = values + (i != 0 ? ", " : "") + DELIVERYCONCURRENCY_STRS[i];
        }
        throw Exc.illarg(LOCALE.x("E139: {0} is not a valid value for ''{1}''; must be one of {2}", mode, "concurrencyMode", values));
    }

    public String getConcurrencyMode() {
        return DELIVERYCONCURRENCY_STRS[this.mDeliveryConcurrencyMode];
    }

    public int getDeliveryConcurrencyMode() {
        return this.mDeliveryConcurrencyMode;
    }

    public void setConnectionURL(String url) {
        this.mConnectionURL = url;
    }

    public String getConnectionURL() {
        return this.mConnectionURL;
    }

    public void setUserName(String username) {
        this.mUsername = username;
    }

    public String getUserName() {
        return this.mUsername;
    }

    public void setPassword(String password) {
        this.mPassword = password;
    }

    public String getClearTextPassword() {
        return Str.pwdecode(this.mPassword);
    }

    public String getPassword() {
        return this.mPassword;
    }

    public String getContextName() {
        return this.mContextName;
    }

    public void setContextName(String name) {
        this.mContextName = name;
    }

    public String getMBeanName() {
        return this.mMBeanName;
    }

    public void setMBeanName(String name) {
        this.mMBeanName = name;
    }

    public void setBatchSize(String size) {
        this.mBatchSize = Integer.parseInt(size);
    }

    public void setBatchSize(Integer size) {
        this.mBatchSize = size;
    }

    public Integer getBatchSize() {
        return new Integer(this.mBatchSize);
    }

    public void setHoldUntilAck(String huaMode) {
        this.mHoldUntilAckMode = huaMode;
    }

    public String getHoldUntilAck() {
        return this.mHoldUntilAckMode;
    }

    public void setOptions(String options) {
        this.mOptionsStr = options;
    }

    public String getOptions() {
        return this.mOptionsStr;
    }

    public String getRedeliveryHandling() {
        return this.mRedeliveryActions;
    }

    public void setRedeliveryHandling(String delays) {
        this.mRedeliveryActions = delays;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public String getFactoryName() {
        return this.mFactoryName;
    }

    public void setFactoryName(String mFactoryName) {
        this.mFactoryName = mFactoryName;
    }

    public String dumpConfiguration() {
        return "ActivationSpec configuration=\n\tDestinationType                     =" + this.mDestinationType + "\n" + "\tDestination                         =" + this.mDestination + "\n" + "\tMessageSelector                     =" + this.mMessageSelector + "\n" + "\tAcknowledgeMode                     =" + this.mAcknowledgeMode + "\n" + "\tDelivery concurrency mode           =" + DELIVERYCONCURRENCY_STRS[this.mDeliveryConcurrencyMode] + "\n" + "\tSubscriptionDurability              =" + this.mSubscriptionDurability + "\n" + "\tClientId                            =" + this.mClientId + "\n" + "\tSubscriptionName                    =" + this.mSubscriptionName + "\n" + "\tEndpointPoolMaxSize                 =" + this.mEndpointPoolMaxSize + "\n" + "\tEndpointPoolSteadySize              =" + this.mEndpointPoolSteadySize + "\n" + "\tEndpointPoolResizeCount             =" + this.mEndpointPoolResizeCount + "\n" + "\tEndpointPoolResizeTimeout           =" + this.mEndpointPoolResizeTimeout + "\n" + "\tEndpointExceptionRedeliveryAttempts =" + this.mEndpointExceptionRedeliveryAttempts + "\n" + "\tEndpointExceptionRedeliveryInterval =" + this.mEndpointExceptionRedeliveryInterval + "\n" + "\tConnectionURL                       =" + this.mConnectionURL + "\n" + "\tUserName                            =" + this.mUsername + "\n" + "\tPassword                            =" + Str.password(this.mPassword) + "\n" + "\tContextName                         =" + this.mContextName + "\n" + "\tMBeanName                           =" + this.mMBeanName + "\n" + "\tOptionsStr                          =" + this.mOptionsStr + "\n" + "\tRedeliveryHandling                  =" + this.mRedeliveryActions;
    }
}

