/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.ra.core;

import com.tongtech.jms.ra.core.Activation;
import com.tongtech.jms.ra.core.ActivationBase;
import com.tongtech.jms.ra.core.ActivationMBean;
import com.tongtech.jms.ra.core.AdminDestination;
import com.tongtech.jms.ra.core.AdminQueue;
import com.tongtech.jms.ra.core.AdminTopic;
import com.tongtech.jms.ra.core.CCDelivery;
import com.tongtech.jms.ra.core.Delivery;
import com.tongtech.jms.ra.core.DeliveryStats;
import com.tongtech.jms.ra.core.GenericSessionConnection;
import com.tongtech.jms.ra.core.RAJMSActivationSpec;
import com.tongtech.jms.ra.core.RAJMSResourceAdapter;
import com.tongtech.jms.ra.core.RAMBean;
import com.tongtech.jms.ra.core.SerialDelivery;
import com.tongtech.jms.ra.core.SessionConnection;
import com.tongtech.jms.ra.core.SyncDelivery;
import com.tongtech.jms.ra.core.TopicToQueueActivation;
import com.tongtech.jms.ra.core.XConnectionRequestInfo;
import com.tongtech.jms.ra.core.XManagedConnection;
import com.tongtech.jms.ra.core.XManagedConnectionFactory;
import com.tongtech.jms.ra.localization.Localizer;
import com.tongtech.jms.ra.util.ConnectionUrl;
import com.tongtech.jms.ra.util.Exc;
import com.tongtech.jms.ra.util.Logger;
import com.tongtech.jms.ra.util.Str;
import com.tongtech.jms.ra.util.UrlParser;
import com.tongtech.tmqi.jmscluster_v2.ClusConnection;
import com.tongtech.tmqi.jmscluster_v2.ClusConnectionFactory;
import com.tongtech.tmqi.jmscluster_v2.ClusSession;
import com.tongtech.tmqi.jmscluster_v2.XaClusConnection;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageEOFException;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.jms.XATopicConnection;
import javax.jms.XATopicConnectionFactory;
import javax.jms.XATopicSession;
import javax.naming.InitialContext;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;

public abstract class RAJMSObjectFactory {
    private static Logger sLog = Logger.getLogger(RAJMSObjectFactory.class);
    public static final int CAP_YES = 1;
    public static final int CAP_NO = 0;
    public static final int CAP_UNKNOWN = -1;
    public static final int CANDO_XA = 0;
    private static final Localizer LOCALE = Localizer.get();

    public int canDo(int what) {
        switch (what) {
            case 0: {
                return 1;
            }
        }
        return -1;
    }

    public int adjustDeliveryMode(int mode, boolean xa) {
        return mode;
    }

    public ActivationBase createActivation(RAJMSResourceAdapter ra, MessageEndpointFactory endpointFactory, RAJMSActivationSpec spec) throws Exception {
        UrlParser u;
        Properties p;
        String subname;
        ActivationBase ret = null;
        if ("javax.jms.Topic".equals(spec.getDestinationType()) && (subname = spec.getSubscriptionName()) != null && subname.startsWith("jmsjca://") && "1".equals((p = (u = new UrlParser(subname)).getQueryProperties()).getProperty("distribution", "0"))) {
            ret = new TopicToQueueActivation(ra, endpointFactory, spec);
        }
        if (ret == null) {
            ret = new Activation(ra, endpointFactory, spec);
        }
        return ret;
    }

    public abstract ConnectionFactory createConnectionFactory(int var1, RAJMSResourceAdapter var2, RAJMSActivationSpec var3, XManagedConnectionFactory var4, String var5) throws JMSException;

    public Connection createConnection(Object fact, int domain, RAJMSActivationSpec activationSpec, RAJMSResourceAdapter ra, String username, String password) throws JMSException {
        String uname = ra.lookUpLDAP(username);
        String pwd = ra.lookUpLDAP(password);
        switch (domain) {
            case 1: {
                return Str.empty(uname) ? ((QueueConnectionFactory)fact).createQueueConnection() : ((QueueConnectionFactory)fact).createQueueConnection(uname, pwd);
            }
            case 3: {
                return Str.empty(uname) ? ((XAQueueConnectionFactory)fact).createXAQueueConnection() : ((XAQueueConnectionFactory)fact).createXAQueueConnection(uname, pwd);
            }
            case 2: {
                return Str.empty(uname) ? ((TopicConnectionFactory)fact).createTopicConnection() : ((TopicConnectionFactory)fact).createTopicConnection(uname, pwd);
            }
            case 4: {
                return Str.empty(uname) ? ((XATopicConnectionFactory)fact).createXATopicConnection() : ((XATopicConnectionFactory)fact).createXATopicConnection(uname, pwd);
            }
            case 6: {
                return Str.empty(uname) ? ((ConnectionFactory)fact).createConnection() : ((ConnectionFactory)fact).createConnection(uname, pwd);
            }
            case 5: {
                return Str.empty(uname) ? ((XAConnectionFactory)fact).createXAConnection() : ((XAConnectionFactory)fact).createXAConnection(uname, pwd);
            }
            case 7: {
                return Str.empty(uname) ? ((ClusConnectionFactory)fact).createConnection() : ((ClusConnectionFactory)fact).createConnection(uname, pwd);
            }
        }
        throw Exc.jmsExc(LOCALE.x("E133: Unknown domain {0}", Integer.toString(domain)));
    }

    public ConnectionUrl createConnectionUrl(String s) {
        return new UrlParser(s);
    }

    public ConnectionUrl getProperties(Properties p, RAJMSResourceAdapter ra, RAJMSActivationSpec spec, XManagedConnectionFactory fact, String overrideUrl) throws JMSException {
        String urlstr = overrideUrl;
        if (urlstr == null && spec != null && !Str.empty(spec.getConnectionURL())) {
            urlstr = spec.getConnectionURL();
        }
        if (urlstr == null && fact != null && !Str.empty(fact.getConnectionURL())) {
            urlstr = fact.getConnectionURL();
        }
        if (urlstr == null) {
            urlstr = ra.getConnectionURL();
        }
        String realUrl = ra.lookUpLDAP(urlstr);
        ConnectionUrl url = this.createConnectionUrl(realUrl);
        this.validateAndAdjustURL(url);
        Str.deserializeProperties(Str.parseProperties("JMSJCA.sep=", ra.getOptions()), p);
        if (spec != null) {
            Str.deserializeProperties(Str.parseProperties("JMSJCA.sep=", spec.getOptions()), p);
        }
        if (fact != null) {
            Str.deserializeProperties(Str.parseProperties("JMSJCA.sep=", fact.getOptions()), p);
        }
        if (!Str.empty(realUrl)) {
            url.getQueryProperties(p);
        }
        return url;
    }

    public boolean validateAndAdjustURL(ConnectionUrl url) throws JMSException {
        return false;
    }

    public Session createSession(Connection conn, boolean isXA, Class sessionClass, RAJMSResourceAdapter ra, RAJMSActivationSpec activationSpec, boolean transacted, int ackmode) throws JMSException {
        if (sLog.isDebugEnabled()) {
            // empty if block
        }
        if (isXA) {
            if (sessionClass == TopicSession.class) {
                if (conn instanceof XaClusConnection) {
                    return ((XaClusConnection)conn).createTopicSession(transacted, ackmode);
                }
                return ((XATopicConnection)conn).createXATopicSession();
            }
            if (sessionClass == QueueSession.class) {
                if (conn instanceof XaClusConnection) {
                    return ((XaClusConnection)conn).createQueueSession(transacted, ackmode);
                }
                return ((XAQueueConnection)conn).createXAQueueSession();
            }
            if (sessionClass == Session.class) {
                if (conn instanceof XaClusConnection) {
                    return ((XaClusConnection)conn).createSession(transacted, ackmode);
                }
                return ((XAConnection)conn).createXASession();
            }
        } else {
            if (sessionClass == TopicSession.class) {
                if (conn instanceof ClusConnection) {
                    return ((ClusConnection)conn).createTopicSession(transacted, ackmode);
                }
                return ((TopicConnection)conn).createTopicSession(transacted, ackmode);
            }
            if (sessionClass == QueueSession.class) {
                if (conn instanceof ClusConnection) {
                    return ((ClusConnection)conn).createQueueSession(transacted, ackmode);
                }
                return ((QueueConnection)conn).createQueueSession(transacted, ackmode);
            }
            if (sessionClass == Session.class) {
                if (conn instanceof ClusConnection) {
                    return ((ClusConnection)conn).createSession(transacted, ackmode);
                }
                return conn.createSession(transacted, ackmode);
            }
        }
        throw Exc.rtexc(LOCALE.x("E131: Unknown class: {0}", sessionClass));
    }

    public Destination adminDestinationLookup(String destName) throws JMSException {
        Destination ret = null;
        if (Str.empty(destName)) {
            throw Exc.jmsExc(LOCALE.x("E095: The destination should not be empty or null"));
        }
        if (destName.startsWith("lookup://")) {
            InitialContext ctx = null;
            String name = destName.substring("lookup://".length());
            if (sLog.isDebugEnabled()) {
                sLog.debug("Lookup in JNDI: " + name);
            }
            try {
                ctx = new InitialContext();
                ret = (Destination)ctx.lookup(name);
                if (sLog.isDebugEnabled()) {
                    sLog.debug("Found in JNDI using [" + name + "]: " + ret);
                }
            }
            catch (Exception e) {
                throw Exc.jmsExc(LOCALE.x("E096: Failed to lookup [{0}] in [{1}]: {2}", name, destName, e), e);
            }
            finally {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        ret = this.checkGeneric(ret);
        return ret;
    }

    public Destination createDestination(Session sess, boolean isXA, boolean isTopic, RAJMSActivationSpec activationSpec, XManagedConnectionFactory fact, RAJMSResourceAdapter ra, String destName) throws JMSException {
        if (sLog.isDebugEnabled()) {
            sLog.debug("createDestination(" + destName + ")");
        }
        Object ret = this.adminDestinationLookup(destName);
        if ((ret = this.checkGeneric((Destination)ret)) != null && ret instanceof AdminDestination) {
            destName = ((AdminDestination)ret).retrieveCheckedName();
            if (sLog.isDebugEnabled()) {
                sLog.debug(ret + " is an admin object: embedded name: " + destName);
            }
            ret = null;
        }
        if (ret == null) {
            if (sLog.isDebugEnabled()) {
                sLog.debug("Creating " + destName + " using createQueue()/createTopic()");
            }
            ret = isXA ? (isTopic ? (sess instanceof ClusSession ? ((ClusSession)sess).createTopic(destName) : ((XATopicSession)sess).getTopicSession().createTopic(destName)) : (sess instanceof ClusSession ? ((ClusSession)sess).createQueue(destName) : ((XAQueueSession)sess).getQueueSession().createQueue(destName))) : (isTopic ? (sess instanceof ClusSession ? ((ClusSession)sess).createTopic(destName) : sess.createTopic(destName)) : (sess instanceof ClusSession ? ((ClusSession)sess).createQueue(destName) : sess.createQueue(destName)));
        }
        return ret;
    }

    public String getMessageSelector(RAJMSResourceAdapter ra, RAJMSActivationSpec spec) throws JMSException {
        try {
            String specsel;
            Properties q = new Properties();
            this.getProperties(q, ra, spec, null, null);
            String ret = q.getProperty("JMSJCA.selector");
            if (Str.empty(ret)) {
                ret = spec.getMessageSelector();
            }
            String string = specsel = spec.getMessageSelector() == null ? "" : spec.getMessageSelector();
            if (!Str.empty(ret)) {
                String subname = spec.getSubscriptionName();
                if (subname != null && subname.startsWith("jmsjca://")) {
                    UrlParser u = new UrlParser(subname);
                    Properties p = u.getQueryProperties();
                    subname = p.getProperty("subscribername");
                }
                final HashMap<String, String> map = new HashMap<String, String>();
                map.put("subscribername", subname == null ? "" : subname);
                map.put("selector", specsel);
                if (Str.empty(spec.getMessageSelector())) {
                    map.put("andselector", "");
                    map.put("selectorand", "");
                } else {
                    map.put("andselector", "and (" + specsel + ")");
                    map.put("selectorand", "(" + specsel + ") and");
                }
                int[] nResolved = new int[1];
                int[] nUnresolved = new int[1];
                Str.Translator t = new Str.Translator(){

                    @Override
                    public String get(String key) {
                        String ret = (String)map.get(key);
                        if (ret == null) {
                            ret = System.getProperty(key);
                        }
                        return ret;
                    }
                };
                ret = Str.substituteAntProperty(ret, t, nResolved, nUnresolved);
                if (sLog.isDebugEnabled()) {
                    sLog.debug("Selector [" + spec.getMessageSelector() + "] --> [" + ret + "]" + " with " + nResolved[0] + " resolved, " + nUnresolved[0] + " unresolved.");
                }
            }
            return ret;
        }
        catch (Exception e) {
            throw Exc.jmsExc(LOCALE.x("E116: Could not compute message selector. Selector in activation spec is [{0}], exception is: {1}", spec.getMessageSelector(), e), e);
        }
    }

    public MessageConsumer createMessageConsumer(Session sess, boolean isXA, boolean isTopic, Destination dest, RAJMSActivationSpec spec, RAJMSResourceAdapter ra) throws JMSException {
        if (isXA) {
            if (isTopic) {
                if ("Durable".equals(spec.getSubscriptionDurability())) {
                    try {
                        if (sess instanceof ClusSession) {
                            return ((ClusSession)sess).createDurableSubscriber((Topic)dest, spec.getSubscriptionName(), this.getMessageSelector(ra, spec), false);
                        }
                        return ((XATopicSession)sess).getTopicSession().createDurableSubscriber((Topic)dest, spec.getSubscriptionName(), this.getMessageSelector(ra, spec), false);
                    }
                    catch (JMSException e) {
                        throw new Exc.ConsumerCreationException(e);
                    }
                }
                if (sess instanceof ClusSession) {
                    return ((ClusSession)sess).createSubscriber((Topic)dest, this.getMessageSelector(ra, spec), false);
                }
                return ((XATopicSession)sess).getTopicSession().createSubscriber((Topic)dest, this.getMessageSelector(ra, spec), false);
            }
            if (sess instanceof ClusSession) {
                return ((ClusSession)sess).createReceiver((Queue)dest, this.getMessageSelector(ra, spec));
            }
            return ((XAQueueSession)sess).getQueueSession().createReceiver((Queue)dest, this.getMessageSelector(ra, spec));
        }
        if (isTopic) {
            if ("Durable".equals(spec.getSubscriptionDurability())) {
                try {
                    return sess.createDurableSubscriber((Topic)dest, spec.getSubscriptionName(), this.getMessageSelector(ra, spec), false);
                }
                catch (JMSException e) {
                    throw new Exc.ConsumerCreationException(e);
                }
            }
            if (sess instanceof ClusSession) {
                return ((TopicSession)sess).createSubscriber((Topic)dest, this.getMessageSelector(ra, spec), false);
            }
            return ((TopicSession)sess).createSubscriber((Topic)dest, this.getMessageSelector(ra, spec), false);
        }
        if (sess instanceof ClusSession) {
            return ((ClusSession)sess).createReceiver((Queue)dest, this.getMessageSelector(ra, spec));
        }
        return ((QueueSession)sess).createReceiver((Queue)dest, this.getMessageSelector(ra, spec));
    }

    public MessageProducer createMessageProducer(Session sess, boolean isXA, boolean isTopic, Destination dest, RAJMSResourceAdapter ra) throws JMSException {
        if (isXA) {
            if (isTopic) {
                return ((XATopicSession)sess).getTopicSession().createPublisher((Topic)dest);
            }
            return ((XAQueueSession)sess).getQueueSession().createSender((Queue)dest);
        }
        if (isTopic) {
            return ((TopicSession)sess).createPublisher((Topic)dest);
        }
        if (sess instanceof QueueSession) {
            return ((QueueSession)sess).createSender((Queue)dest);
        }
        return sess.createProducer(dest);
    }

    public ConnectionConsumer createConnectionConsumer(Connection conn, boolean isXA, boolean isTopic, boolean isDurable, RAJMSActivationSpec activationSpec, RAJMSResourceAdapter ra, Destination dest, String subscriptionName, String selector, ServerSessionPool pool, int batchsize) throws JMSException {
        try {
            if (isXA) {
                if (isTopic) {
                    if (isDurable) {
                        return ((XATopicConnection)conn).createDurableConnectionConsumer((Topic)dest, subscriptionName, selector, pool, batchsize);
                    }
                    return ((XATopicConnection)conn).createConnectionConsumer((Topic)dest, selector, pool, batchsize);
                }
                return ((XAQueueConnection)conn).createConnectionConsumer((Queue)dest, selector, pool, batchsize);
            }
            if (isTopic) {
                if (isDurable) {
                    return ((TopicConnection)conn).createDurableConnectionConsumer((Topic)dest, subscriptionName, selector, pool, batchsize);
                }
                return ((TopicConnection)conn).createConnectionConsumer((Topic)dest, selector, pool, batchsize);
            }
            return ((QueueConnection)conn).createConnectionConsumer((Queue)dest, selector, pool, batchsize);
        }
        catch (JMSException ex) {
            throw new Exc.ConsumerCreationException(ex);
        }
    }

    public XAResource getXAResource(boolean isXA, Session s) throws JMSException {
        if (s instanceof ClusSession) {
            return !isXA ? null : ((ClusSession)s).getXAResource();
        }
        return !isXA ? null : ((XASession)s).getXAResource();
    }

    public SessionConnection createSessionConnection(Object connectionFactory, RAJMSObjectFactory objfact, RAJMSResourceAdapter ra, XManagedConnection mc, XConnectionRequestInfo descr, boolean isXa, boolean isTransacted, int acknowledgmentMode, Class sessionClass) throws JMSException {
        return new GenericSessionConnection(connectionFactory, objfact, ra, mc, descr, isXa, isTransacted, acknowledgmentMode, sessionClass);
    }

    public ActivationMBean createActivationMBean(Activation activation) {
        return new ActivationMBean(activation);
    }

    public abstract boolean isUrl(String var1);

    public void setClientID(Connection connection, String clientID) throws JMSException {
        try {
            connection.setClientID(clientID);
        }
        catch (JMSException e) {
            throw new Exc.ConsumerCreationException(e);
        }
    }

    public void setClientID(Connection connection, boolean isTopic, RAJMSActivationSpec spec, RAJMSResourceAdapter ra) throws JMSException {
        if (isTopic && "Durable".equals(spec.getSubscriptionDurability()) && spec.getClientId() != null && spec.getClientId().length() != 0) {
            String currentClientId = connection.getClientID();
            if (currentClientId == null || currentClientId.length() == 0) {
                this.setClientID(connection, spec.getClientId());
            } else if (!spec.getClientId().equals(currentClientId)) {
                sLog.warn(LOCALE.x("E042: Ignoring ClientID: the ClientID is already set to [{0}]; cannot set to [{1}] as required in activationspec [{2}]", currentClientId, spec.getClientId(), spec));
            }
        }
    }

    protected void setClientIDIfNotSpecified(Connection connection, boolean isTopic, RAJMSActivationSpec spec, RAJMSResourceAdapter ra) throws JMSException {
        if (isTopic && "Durable".equals(spec.getSubscriptionDurability())) {
            String currentClientId;
            String newClientId = spec.getClientId();
            boolean notSpecified = false;
            if (newClientId == null || newClientId.length() == 0) {
                newClientId = "CLIENTID-" + spec.getSubscriptionName();
                notSpecified = true;
            }
            if ((currentClientId = connection.getClientID()) == null || currentClientId.length() == 0) {
                this.setClientID(connection, newClientId);
            } else if (!newClientId.equals(currentClientId) && !notSpecified) {
                sLog.warn(LOCALE.x("E195: ClientID is already set to [{0}]; cannot set to [{1}] as required in activationspec [{2}]", currentClientId, newClientId, spec));
            }
        }
    }

    public Session getNonXASession(Session session, boolean isXA, Class sessionClass) throws JMSException {
        if (!isXA) {
            return session;
        }
        if (sessionClass == TopicSession.class) {
            return ((XATopicSession)session).getTopicSession();
        }
        if (sessionClass == QueueSession.class) {
            return ((XAQueueSession)session).getQueueSession();
        }
        if (sessionClass == Session.class) {
            return ((XASession)session).getSession();
        }
        throw Exc.rtexc(LOCALE.x("E131: Unknown class: {0}", sessionClass));
    }

    public RAMBean createRAMBean(RAJMSResourceAdapter adapter) {
        return new RAMBean(this, adapter);
    }

    public abstract String getJMSServerType();

    public Object getServerMgtMBean(RAJMSResourceAdapter ra, RAJMSActivationSpec spec) throws JMSException {
        return null;
    }

    public void cleanup(XManagedConnection con) {
    }

    public boolean isInvalid(XManagedConnection con) {
        return false;
    }

    public Delivery createDelivery(int mode, Activation activation, DeliveryStats stats) throws Exception {
        Delivery ret = null;
        switch (mode) {
            case 1: {
                ret = new CCDelivery(activation, stats);
                break;
            }
            case 0: {
                ret = new SerialDelivery(activation, stats);
                break;
            }
            case 3: {
                ret = new SyncDelivery(activation, stats);
                break;
            }
            default: {
                throw Exc.exc(LOCALE.x("E140 Invalid concurrency ''{0}''", Integer.toString(activation.getActivationSpec().getDeliveryConcurrencyMode())));
            }
        }
        return ret;
    }

    public MessageListener getMessagePreprocessor(MessageListener target, boolean isXA) {
        return target;
    }

    public Message copyMessage(Message toCopy, Session s, boolean isXA, boolean isTopic, RAJMSResourceAdapter ra) throws JMSException {
        Object o;
        MapMessage out;
        BytesMessage in;
        TextMessage ret = null;
        int nItf = 0;
        if (toCopy instanceof TextMessage) {
            ++nItf;
        } else if (toCopy instanceof BytesMessage) {
            ++nItf;
        } else if (toCopy instanceof MapMessage) {
            ++nItf;
        } else if (toCopy instanceof ObjectMessage) {
            ++nItf;
        } else if (toCopy instanceof StreamMessage) {
            ++nItf;
        }
        if (nItf > 1) {
            throw Exc.jmsExc(LOCALE.x("E188: Cannot determine message type: the message [{0}]implements multiple interfaces ({1}).", toCopy, Integer.toString(nItf)));
        }
        if (toCopy instanceof TextMessage) {
            ret = s.createTextMessage(((TextMessage)toCopy).getText());
        } else if (toCopy instanceof BytesMessage) {
            int n;
            in = (BytesMessage)toCopy;
            BytesMessage b = s.createBytesMessage();
            byte[] buf = new byte[4096];
            while ((n = in.readBytes(buf)) >= 0) {
                b.writeBytes(buf, 0, n);
            }
            ret = b;
        } else if (toCopy instanceof MapMessage) {
            in = (MapMessage)toCopy;
            out = s.createMapMessage();
            Enumeration en = in.getMapNames();
            while (en.hasMoreElements()) {
                String name = (String)en.nextElement();
                Object o2 = in.getObject(name);
                out.setObject(name, o2);
            }
            ret = out;
        } else if (toCopy instanceof ObjectMessage) {
            in = (ObjectMessage)toCopy;
            ret = s.createObjectMessage(in.getObject());
        } else if (toCopy instanceof StreamMessage) {
            in = (StreamMessage)toCopy;
            out = s.createStreamMessage();
            while (true) {
                try {
                    o = in.readObject();
                }
                catch (MessageEOFException stop) {
                    break;
                }
                if (o == null) break;
                out.writeObject(o);
            }
            ret = out;
        } else {
            ret = s.createMessage();
        }
        Enumeration en = toCopy.getPropertyNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            o = toCopy.getObjectProperty(name);
            if (o instanceof Integer) {
                ret.setIntProperty(name, ((Integer)o).intValue());
            } else if (o instanceof Long) {
                ret.setLongProperty(name, ((Long)o).longValue());
            } else if (o instanceof String) {
                ret.setStringProperty(name, ((String)o).toString());
            } else if (o instanceof Boolean) {
                ret.setBooleanProperty(name, ((Boolean)o).booleanValue());
            } else if (o instanceof Byte) {
                ret.setByteProperty(name, ((Byte)o).byteValue());
            } else if (o instanceof Short) {
                ret.setShortProperty(name, ((Short)o).shortValue());
            } else if (o instanceof Float) {
                ret.setFloatProperty(name, ((Float)o).floatValue());
            } else if (o instanceof Double) {
                ret.setDoubleProperty(name, ((Double)o).doubleValue());
            } else {
                throw Exc.jmsExc(LOCALE.x("E189: Unknown property type for {0}: {1}", name, o.getClass().getName()));
            }
            if (toCopy.getJMSCorrelationID() != null) {
                ret.setJMSCorrelationID(toCopy.getJMSCorrelationID());
            }
            if (toCopy.getJMSReplyTo() != null) {
                ret.setJMSReplyTo(toCopy.getJMSReplyTo());
            }
            if (toCopy.getJMSType() == null) continue;
            ret.setJMSType(toCopy.getJMSType());
        }
        return ret;
    }

    public void send(boolean isTopic, MessageProducer producer, Message m, int priority, int deliveryMode) throws JMSException {
        if (isTopic) {
            TopicPublisher publisher = (TopicPublisher)producer;
            publisher.publish(m, deliveryMode, priority, 0L);
        } else if (producer instanceof QueueSender) {
            QueueSender sender = (QueueSender)producer;
            sender.send(m, deliveryMode, priority, 0L);
        } else {
            producer.send(m, deliveryMode, priority, 0L);
        }
    }

    public boolean shouldCacheConnectionFactories() {
        return true;
    }

    public boolean shouldUseProducerPooling() {
        return false;
    }

    public Destination checkGeneric(Destination d) throws JMSException {
        boolean isGenTopic;
        if (d == null) {
            return null;
        }
        Class<?> c = d.getClass();
        String classname = c.getName();
        boolean isGenQueue = classname.equals("com.sun.genericra.outbound.QueueProxy");
        boolean bl = isGenTopic = !isGenQueue && classname.equals("com.sun.genericra.outbound.TopicProxy");
        if (isGenQueue || isGenTopic) {
            try {
                Method m = c.getMethod("getDestinationJndiName", null);
                String jndiname = (String)m.invoke((Object)d, null);
                if (isGenQueue) {
                    AdminQueue ret = new AdminQueue();
                    ret.setName("jndi://" + jndiname);
                    d = ret;
                } else {
                    AdminTopic ret = new AdminTopic();
                    ret.setName("jndi://" + jndiname);
                    d = ret;
                }
            }
            catch (Exception e) {
                throw Exc.jmsExc(LOCALE.x("E117: Could not convert automatically from genericra destination: {0}", e), e);
            }
        }
        return d;
    }
}

