/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.ra.core;

import com.tongtech.jms.ra.core.ActivationBase;
import com.tongtech.jms.ra.core.JConnectionFactory;
import com.tongtech.jms.ra.core.RAJMSActivationSpec;
import com.tongtech.jms.ra.core.RAJMSObjectFactory;
import com.tongtech.jms.ra.core.RAMBean;
import com.tongtech.jms.ra.core.RAStopListener;
import com.tongtech.jms.ra.core.XManagedConnectionFactory;
import com.tongtech.jms.ra.localization.LocalizedString;
import com.tongtech.jms.ra.localization.Localizer;
import com.tongtech.jms.ra.util.ConnectionUrl;
import com.tongtech.jms.ra.util.Exc;
import com.tongtech.jms.ra.util.Logger;
import com.tongtech.jms.ra.util.Str;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.InvalidPropertyException;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;

public abstract class RAJMSResourceAdapter
implements ResourceAdapter,
Serializable {
    private static Logger sLog = Logger.getLogger(RAJMSResourceAdapter.class);
    private static final long RETRY_INTERVAL_MS = 1000L;
    private static final int RETRY_COUNT = 0;
    private String mConnectionURL;
    private String mUserName;
    private String mPassword;
    private String mMBeanServerDomain;
    private String mMBeanObjectName;
    private String mOptionsStr;
    private String mTransformerMBeanName;
    private String mClientIDPrefix;
    private String mConfigurationOverride;
    private String mConfigurationTemplate;
    private String mProjectInfo;
    private transient List mRecoveryConnections;
    protected transient BootstrapContext mBootCtx;
    protected transient List mActivations = new ArrayList();
    private transient RAMBean mAdapterMBean;
    private transient ObjectName mServerMgtMBeanName;
    private transient int mCtMCFCreated;
    private transient Map mMCFCreated = Collections.synchronizedMap(new WeakHashMap());
    private transient MBeanServer mMBeanServer;
    private transient Map mStopListeners;
    private static final Localizer LOCALE = Localizer.get();
    private boolean ldapReady;
    private String mConcurrencyMode = "";
    private String mEndpointPoolMaxSize = "-1";
    private String mFactoryName = "";

    protected RAJMSResourceAdapter() {
    }

    public void start(BootstrapContext ctx) throws ResourceAdapterInternalException {
        this.mBootCtx = ctx;
        this.checkRecoveryConnections();
        if (sLog.isDebugEnabled()) {
            sLog.debug("Starting RA");
        }
        this.overrideRAConfigFromJNDI();
        try {
            if (!Str.empty(this.getMBeanObjectName())) {
                RAJMSObjectFactory fact = this.createObjectFactory(this.getConnectionURL());
                MBeanServer mbeanServer = this.getMBeanServer();
                ObjectName mbeanName = new ObjectName(this.getMBeanObjectName());
                this.mAdapterMBean = fact.createRAMBean(this);
                mbeanServer.registerMBean(this.mAdapterMBean, mbeanName);
                if (sLog.isDebugEnabled()) {
                    sLog.debug("Registered MBean [" + this.mAdapterMBean + "] in server [" + mbeanServer.getDefaultDomain() + "] using name [" + mbeanName + "]");
                }
                Object serverMgtMBean = fact.getServerMgtMBean(this, null);
                if (sLog.isDebugEnabled()) {
                    sLog.debug("Server mgt mbean=" + serverMgtMBean);
                }
                if (serverMgtMBean != null) {
                    if (serverMgtMBean instanceof String) {
                        this.mAdapterMBean.setJmsServerMBean((String)serverMgtMBean);
                    } else {
                        String name = this.getMBeanObjectName() + ",servermgt=true";
                        if (sLog.isDebugEnabled()) {
                            sLog.debug("Registering server mgt mbean with name " + name);
                        }
                        ObjectName mgtmbeanName = new ObjectName(name);
                        mbeanServer.registerMBean(serverMgtMBean, mgtmbeanName);
                        this.mServerMgtMBeanName = mgtmbeanName;
                        this.mAdapterMBean.setJmsServerMBean(name);
                        if (sLog.isDebugEnabled()) {
                            sLog.debug("Registered server mgt mbean with name " + name);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.killMBean();
            sLog.warn(LOCALE.x("E043: MBean with name [{0}] could not be created. The RA will continue to start. The error was: {1}.", this.getMBeanObjectName(), e), e);
        }
    }

    private void killMBean() {
        if (this.mServerMgtMBeanName != null) {
            try {
                this.getMBeanServer().unregisterMBean(this.mServerMgtMBeanName);
            }
            catch (Exception e) {
                sLog.warn(LOCALE.x("E044: Exception on unregistering server mbean: {0}", e), e);
            }
            this.mServerMgtMBeanName = null;
        }
        if (this.mAdapterMBean != null) {
            this.mAdapterMBean.destroy();
            this.mAdapterMBean = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        block14: {
            if (sLog.isDebugEnabled()) {
                sLog.debug("Stopping RA");
            }
            try {
                this.checkRecoveryConnections();
                if (this.mActivations == null) break block14;
                List list = this.mActivations;
                synchronized (list) {
                    Iterator i = this.mActivations.iterator();
                    while (i.hasNext()) {
                        ActivationBase a = (ActivationBase)i.next();
                        if (sLog.isDebugEnabled()) {
                            sLog.debug("Stopping " + a);
                        }
                        a.deactivate();
                        i.remove();
                    }
                }
            }
            finally {
                this.killMBean();
            }
        }
        if (this.mStopListeners != null) {
            RAStopListener[] listeners = this.mStopListeners.keySet().toArray(new RAStopListener[this.mStopListeners.keySet().size()]);
            for (int i = 0; i < listeners.length; ++i) {
                try {
                    listeners[i].stop();
                    continue;
                }
                catch (Exception e) {
                    sLog.warn(LOCALE.x("E045: Failed to process stop-listener {0}: {1}", listeners[i], e), e);
                }
            }
        }
        if (sLog.isDebugEnabled()) {
            sLog.debug("RA is now stopped");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endpointActivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) throws ResourceException {
        ActivationBase a;
        boolean adjusted;
        this.checkRecoveryConnections();
        if (this.mActivations == null) {
            this.mActivations = new ArrayList();
        }
        if (sLog.isDebugEnabled()) {
            sLog.debug("Activating endpoint with endpointFactory [" + endpointFactory + "] and spec [" + spec + "]");
        }
        if (!(spec instanceof RAJMSActivationSpec)) {
            LocalizedString msg = LOCALE.x("E003: EndpointActivation can only be done with an ActivationSpec of class {0}; provided class is [{1}].", RAJMSActivationSpec.class.getName(), spec.getClass().getName());
            sLog.fatal(msg);
            throw new NotSupportedException(msg.toString());
        }
        if (sLog.isDebugEnabled()) {
            sLog.debug("Activation spec configuration is: [" + ((RAJMSActivationSpec)spec).dumpConfiguration() + "]");
        }
        if ((adjusted = this.adjustActivationSpec((RAJMSActivationSpec)spec)) && sLog.isDebugEnabled()) {
            sLog.debug("Activation spec configuration afer adjustment is: [" + ((RAJMSActivationSpec)spec).dumpConfiguration() + "]");
        }
        try {
            spec.validate();
        }
        catch (InvalidPropertyException ex1) {
            if (sLog.isDebugEnabled()) {
                sLog.debug("Validation of Activation Spec failed: " + (Object)((Object)ex1), ex1);
            }
            throw new NotSupportedException(LOCALE.x("E140: ActivationSpec validation error: {0}", (Object)ex1).toString(), (Throwable)ex1);
        }
        try {
            String url = ((RAJMSActivationSpec)spec).getConnectionURL();
            if (url == null || url.length() == 0) {
                url = this.getConnectionURL();
            }
            if (url == null || url.length() == 0) {
                url = "tlqlocal://";
            }
            if (!this.getConcurrencyMode().equals("")) {
                ((RAJMSActivationSpec)spec).setConcurrencyMode(this.getConcurrencyMode());
            }
            if (!this.getEndpointPoolMaxSize().equals("-1")) {
                ((RAJMSActivationSpec)spec).setEndpointPoolMaxSize(this.getEndpointPoolMaxSize());
            }
            RAJMSObjectFactory fact = this.createObjectFactory(url);
            a = fact.createActivation(this, endpointFactory, (RAJMSActivationSpec)spec);
            a.activate();
            List list = this.mActivations;
            synchronized (list) {
                this.mActivations.add(a);
            }
        }
        catch (Throwable ex) {
            LocalizedString msg = LOCALE.x("E010: Could not create Activation for {0} and spec {1}: {2}.", endpointFactory, spec, ex);
            sLog.error(msg, ex);
            throw new NotSupportedException(msg.toString(), ex);
        }
        if (sLog.isDebugEnabled()) {
            sLog.debug("Activation " + a + " succeeded");
        }
    }

    private boolean adjustActivationSpec(RAJMSActivationSpec spec) throws ResourceException {
        boolean changed = false;
        String url = spec.getConnectionURL();
        if (Str.empty(url)) {
            url = this.getConnectionURL();
        }
        if (!Str.empty(url) && url.startsWith("lookup://")) {
            InitialContext ctx = null;
            String name = url.substring("lookup://".length());
            if (sLog.isDebugEnabled()) {
                sLog.debug("Lookup in JNDI: " + name);
            }
            try {
                ctx = new InitialContext();
                Object o = ctx.lookup(name);
                if (sLog.isDebugEnabled()) {
                    sLog.debug("Found in JNDI using [" + name + "]: " + o);
                }
                if (!(o instanceof JConnectionFactory)) {
                    throw Exc.exc(LOCALE.x("E191: Incompatible object specified: the object must of type ''{0}'' but the object bound to ''{1}'' is of type ''{2}''", JConnectionFactory.class.getName(), url, o.getClass().getName()));
                }
                JConnectionFactory fact = (JConnectionFactory)o;
                XManagedConnectionFactory mcf = fact.getMCF();
                String _url = null;
                String _userid = null;
                String _pw = null;
                Properties options = new Properties();
                if (fact.getRA() != this) {
                    if (!Str.empty(fact.getRA().getConnectionURL())) {
                        _url = fact.getRA().getConnectionURL();
                    }
                    if (!Str.empty(fact.getRA().getUserName())) {
                        _userid = fact.getRA().getUserName();
                    }
                    if (!Str.empty(fact.getRA().getClearTextPassword())) {
                        _pw = fact.getRA().getClearTextPassword();
                    }
                    Str.deserializeProperties(Str.parseProperties("JMSJCA.sep=", fact.getRA().getOptions()), options);
                }
                if (!Str.empty(mcf.getConnectionURL())) {
                    _url = mcf.getConnectionURL();
                }
                if (!Str.empty(mcf.getUserName())) {
                    _userid = mcf.getUserName();
                }
                if (!Str.empty(mcf.getClearTextPassword())) {
                    _pw = mcf.getClearTextPassword();
                }
                Str.deserializeProperties(Str.parseProperties("JMSJCA.sep=", mcf.getOptions()), options);
                if (_url == null) {
                    throw Exc.jmsExc(LOCALE.x("E192: A URL is not specified in the connection pool or its resource adapter instance"));
                }
                spec.setConnectionURL(_url);
                if (Str.empty(spec.getUserName())) {
                    spec.setUserName(_userid);
                }
                if (Str.empty(spec.getClearTextPassword())) {
                    spec.setPassword(_pw);
                }
                Str.deserializeProperties(spec.getOptions(), options);
                spec.setOptions(Str.serializeProperties(options));
                changed = true;
            }
            catch (Exception e) {
                throw Exc.rsrcExc(LOCALE.x("E096: Failed to lookup [{0}] in [{1}]: {2}", name, url, e), e);
            }
            finally {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean overrideRAConfigFromJNDI() {
        boolean changed = false;
        if (!Str.empty(this.getConfigurationJNDIName())) {
            InitialContext ctx = null;
            if (sLog.isDebugEnabled()) {
                sLog.debug("Lookup in JNDI: " + this.getConfigurationJNDIName());
            }
            try {
                ctx = new InitialContext();
                Object o = ctx.lookup(this.getConfigurationJNDIName());
                if (sLog.isDebugEnabled()) {
                    sLog.debug("Found in JNDI using [" + this.getConfigurationJNDIName() + "]: " + o);
                }
                if (!(o instanceof Properties)) {
                    throw Exc.exc(LOCALE.x("E191: Incompatible object specified: the object must of type ''{0}'' but the object bound to ''{1}'' is of type ''{2}''", Properties.class.getName(), this.getConfigurationJNDIName(), o.getClass().getName()));
                }
                Properties p = (Properties)o;
                this.setConnectionURL(p.getProperty("MSURL", p.getProperty("ConnectionURL", this.getConnectionURL())));
                this.setUserName(p.getProperty("MSUsername", p.getProperty("UserName", this.getUserName())));
                this.setPassword(p.getProperty("MSPassword", p.getProperty("Password", this.getPassword())));
                this.setOptions(p.getProperty("MSOptions", p.getProperty("Options", this.getOptions())));
                changed = true;
            }
            catch (NamingException e) {
                if (sLog.isDebugEnabled()) {
                    sLog.debug("Could not find " + this.getConfigurationJNDIName() + ": " + e, e);
                }
            }
            catch (Exception e) {
                sLog.warn(LOCALE.x("E193: The configuration overrides bound to JNDI name ''{0}'' could not be applied; the default values will be used instead. The error was: {1}", this.getConfigurationJNDIName(), e), e);
            }
            finally {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        return changed;
    }

    public void endpointDeactivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) {
        ActivationBase a;
        if (sLog.isDebugEnabled()) {
            sLog.debug("Deactivating endpoint for " + endpointFactory + " and spec " + spec);
        }
        if ((a = this.findActivation(endpointFactory, spec, true)) == null) {
            LocalizedString msg = LOCALE.x("E004: EndpointDeactivation was called on an activation of which no record could be found. Endpointfactory=[{0}]; spec=[{1}].", endpointFactory, spec);
            sLog.fatal(msg);
            throw new RuntimeException(msg.toString());
        }
        if (sLog.isDebugEnabled()) {
            sLog.debug("Deactivating activation " + a);
        }
        a.deactivate();
        if (sLog.isDebugEnabled()) {
            sLog.debug("Activation " + a + " deactivated");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActivationBase findActivation(MessageEndpointFactory endpointFactory, ActivationSpec spec, boolean remove) {
        if (this.mActivations == null) {
            this.mActivations = new ArrayList();
        }
        if (!(spec instanceof RAJMSActivationSpec)) {
            LocalizedString msg = LOCALE.x("E005: EndpointDeactivation can only be done with a spec of the class [{0}]; provided class is [{1}].", RAJMSActivationSpec.class.getName(), spec.getClass().getName());
            sLog.fatal(msg);
            throw new RuntimeException(msg.toString());
        }
        ActivationBase a = null;
        List list = this.mActivations;
        synchronized (list) {
            Iterator iter = this.mActivations.iterator();
            while (iter.hasNext()) {
                ActivationBase candidate = (ActivationBase)iter.next();
                if (!candidate.is(endpointFactory, (RAJMSActivationSpec)spec)) continue;
                a = candidate;
                if (!remove) break;
                iter.remove();
                break;
            }
        }
        return a;
    }

    public XAResource[] getXAResources(ActivationSpec[] specs) throws ResourceException {
        ArrayList<RAJMSActivationSpec> uniqueSpecs = new ArrayList<RAJMSActivationSpec>();
        HashSet<String> signatures = new HashSet<String>();
        for (int i = 0; i < specs.length; ++i) {
            RAJMSObjectFactory fact;
            RAJMSActivationSpec spec = (RAJMSActivationSpec)specs[i];
            String urlstr = spec.getConnectionURL();
            if (urlstr == null || urlstr.length() == 0) {
                urlstr = this.getConnectionURL();
            }
            if ((fact = this.createObjectFactory(urlstr)).canDo(0) == 0) continue;
            Properties p = new Properties();
            try {
                ConnectionUrl url = fact.getProperties(p, this, spec, null, null);
                String sig = url.toString() + Str.serializeProperties(p);
                if (!signatures.add(sig)) continue;
                uniqueSpecs.add(spec);
                continue;
            }
            catch (JMSException e) {
                sLog.warn(LOCALE.x("E046: Could not get determine a signature for activationspec [{0}]. This resource will NOT be recovered. The error was: {1}.", spec.dumpConfiguration(), (Object)e), e);
            }
        }
        ArrayList<Connection> connections = new ArrayList<Connection>();
        ArrayList<XAResource> ret = new ArrayList<XAResource>();
        for (int i = 0; i < uniqueSpecs.size(); ++i) {
            RAJMSActivationSpec s = (RAJMSActivationSpec)uniqueSpecs.get(i);
            try {
                String urlstr = s.getConnectionURL();
                RAJMSObjectFactory fact = this.createObjectFactory(urlstr);
                ConnectionFactory qcf = fact.createConnectionFactory(3, this, s, null, null);
                String username = s.getUserName() == null ? this.getUserName() : s.getUserName();
                String password = s.getClearTextPassword() == null ? this.getClearTextPassword() : s.getClearTextPassword();
                Connection con = fact.createConnection(qcf, 3, s, this, username, password);
                connections.add(con);
                Session sess = fact.createSession(con, true, QueueSession.class, this, s, false, 0);
                XAResource xa = fact.getXAResource(true, sess);
                ret.add(xa);
                continue;
            }
            catch (JMSException e) {
                sLog.warn(LOCALE.x("E047: Could not get XAResource for activationspec [{0}]; this resource will NOT be recovered. The error was: {1}.", s.dumpConfiguration(), (Object)e), e);
            }
        }
        if (this.mRecoveryConnections == null) {
            this.mRecoveryConnections = new ArrayList();
        }
        this.mRecoveryConnections.addAll(connections);
        return ret.toArray(new XAResource[ret.size()]);
    }

    private void checkRecoveryConnections() {
        if (this.mRecoveryConnections != null) {
            for (Connection c : this.mRecoveryConnections) {
                try {
                    c.close();
                }
                catch (Exception e) {
                    sLog.warn(LOCALE.x("E048: Failure upon closing recovery connection: {0}", e), e);
                }
            }
            this.mRecoveryConnections = null;
        }
    }

    public String toString() {
        return "[" + this.getClass().getName() + ":with " + (this.mActivations != null ? this.mActivations.size() : 0) + " activations]";
    }

    public BootstrapContext getBootstrapCtx() {
        return this.mBootCtx;
    }

    public final String getConnectionURL() {
        return this.mConnectionURL;
    }

    public void setConnectionURL(String ConnectionURL) {
        this.mConnectionURL = ConnectionURL;
    }

    public final String getUserName() {
        return this.mUserName;
    }

    public final void setUserName(String UserName) {
        this.mUserName = UserName;
    }

    public final String getClearTextPassword() {
        return Str.pwdecode(this.mPassword);
    }

    public final String getPassword() {
        return this.mPassword;
    }

    public final void setPassword(String Password2) {
        this.mPassword = Password2;
    }

    public final void setConfigurationJNDIName(String override) {
        this.mConfigurationOverride = override;
    }

    public final String getConfigurationJNDIName() {
        return this.mConfigurationOverride;
    }

    public final void setConfigurationTemplate(String template) {
        this.mConfigurationTemplate = template;
    }

    public final String getConfigurationTemplate() {
        return this.mConfigurationTemplate;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof RAJMSResourceAdapter)) {
            return false;
        }
        RAJMSResourceAdapter that = (RAJMSResourceAdapter)other;
        return Str.isEqual(this.mConnectionURL, that.mConnectionURL) && Str.isEqual(this.mUserName, that.mUserName) && Str.isEqual(this.mPassword, that.mPassword) && Str.isEqual(this.mOptionsStr, that.mOptionsStr) && Str.isEqual(this.mMBeanServerDomain, that.mMBeanServerDomain);
    }

    public int hashCode() {
        int ret = 37;
        ret = Str.hash(ret, this.mConnectionURL);
        ret = Str.hash(ret, this.mUserName);
        ret = Str.hash(ret, this.mPassword);
        ret = Str.hash(ret, this.mOptionsStr);
        ret = Str.hash(ret, this.mMBeanServerDomain);
        return ret;
    }

    public String dumpConfiguration() {
        return "connectionURL=" + this.mConnectionURL + "; mbeanServerDomain=" + this.mMBeanServerDomain + "; username=" + this.mUserName + "; password=" + Str.password(this.mPassword);
    }

    public void notifyMCFCreated(XManagedConnectionFactory fact) {
        ++this.mCtMCFCreated;
        this.mMCFCreated.put(fact, new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dumpMCFInfo() {
        Object[] factories;
        StringBuffer ret = new StringBuffer();
        ret.append("Managed connection factories created: " + this.mCtMCFCreated + ";\n");
        ret.append("Current managed connection factories:\n");
        Map map = this.mMCFCreated;
        synchronized (map) {
            factories = this.mMCFCreated.keySet().toArray();
        }
        for (int i = 0; i < factories.length; ++i) {
            if (factories[i] == null) continue;
            XManagedConnectionFactory mcf = (XManagedConnectionFactory)factories[i];
            ret.append("[" + mcf.dumpMCFInfo() + "]\n");
        }
        return ret.toString();
    }

    public String getMBeanServerDomain() {
        return this.mMBeanServerDomain;
    }

    public void setMBeanServerDomain(String domain) {
        this.mMBeanServerDomain = domain;
    }

    public void setClientIDPrefix(String prefix) {
        this.mClientIDPrefix = prefix;
    }

    public String getClientIDPrefix() {
        return this.mClientIDPrefix;
    }

    public String getOptions() {
        return this.mOptionsStr;
    }

    public void setOptions(String options) {
        this.mOptionsStr = options;
    }

    public String getMBeanObjectName() {
        return this.mMBeanObjectName;
    }

    public void setMBeanObjectName(String beanObjectName) {
        this.mMBeanObjectName = beanObjectName;
    }

    public String getTransformerMBeanName() {
        return this.mTransformerMBeanName;
    }

    public void setTransformerMBeanName(String beanObjectName) {
        this.mTransformerMBeanName = beanObjectName;
    }

    private void safeClose(Context ctx) {
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MBeanServer getMBeanServer() throws JMSException {
        if (this.mMBeanServer != null) {
            return this.mMBeanServer;
        }
        MBeanServer mbeanServer2 = null;
        try {
            InitialContext ctx = null;
            try {
                ctx = new InitialContext();
                mbeanServer2 = (MBeanServer)ctx.lookup("java:comp/jmx/runtime");
            }
            catch (Exception exception) {
            }
            finally {
                this.safeClose(ctx);
            }
            if (mbeanServer2 == null) {
                for (MBeanServer mbeanServer2 : MBeanServerFactory.findMBeanServer(null)) {
                    if (mbeanServer2.getDefaultDomain().equals(this.getMBeanServerDomain())) break;
                }
            }
            if (mbeanServer2 == null) {
                mbeanServer2 = MBeanServerFactory.createMBeanServer(this.getMBeanServerDomain());
            }
        }
        catch (Exception e) {
            throw Exc.jmsExc(LOCALE.x("E141: No MBeanServer found; specified domain = [{0}]", this.getMBeanServerDomain()));
        }
        if (sLog.isDebugEnabled()) {
            sLog.debug("Found MBeanServer [" + mbeanServer2.getDefaultDomain() + "]; specified domain = [" + this.getMBeanServerDomain() + "]");
        }
        this.mMBeanServer = mbeanServer2;
        return this.mMBeanServer;
    }

    public String lookUpLDAP(String ldapURL) {
        block8: {
            if (ldapURL == null || !ldapURL.startsWith("ldap://") && !ldapURL.startsWith("ldaps://")) {
                return ldapURL;
            }
            try {
                if (this.getTransformerMBeanName() == null || this.getTransformerMBeanName().length() == 0) break block8;
                ObjectName mbeanName = new ObjectName(this.getTransformerMBeanName());
                MBeanServer mbeanServer = this.getMBeanServer();
                Set<ObjectName> objectNames = mbeanServer.queryNames(mbeanName, null);
                int reTryCount = 0;
                while (objectNames.isEmpty() && reTryCount++ < 0) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    objectNames = mbeanServer.queryNames(mbeanName, null);
                }
                String[] signatures = new String[]{"java.lang.String"};
                Object[] parameters = new String[]{ldapURL};
                if (sLog.isDebugEnabled()) {
                    sLog.debug("Transforming " + ldapURL + " using MBean [" + this.getTransformerMBeanName() + "]");
                }
                Object result = mbeanServer.invoke(mbeanName, "attemptTransform", parameters, signatures);
                this.ldapReady = true;
                return (String)result;
            }
            catch (Exception ex) {
                if (this.ldapReady) {
                    sLog.warn(LOCALE.x("E049: Could not look up string [{0}] in ldap using MBean [{1}]: {2}.", ldapURL, this.mTransformerMBeanName, ex), ex);
                }
                if (!sLog.isDebugEnabled()) break block8;
                sLog.debug(LOCALE.x("E049: Could not look up string [{0}] in ldap using MBean [{1}]: {2}.", ldapURL, this.mTransformerMBeanName, ex), ex);
            }
        }
        return ldapURL;
    }

    public synchronized void addStopListener(RAStopListener listener) {
        if (this.mStopListeners == null) {
            this.mStopListeners = Collections.synchronizedMap(new WeakHashMap());
        }
        this.mStopListeners.put(listener, null);
    }

    public abstract RAJMSObjectFactory createObjectFactory(String var1);

    public String getProjectInfo() {
        return this.mProjectInfo;
    }

    public void setProjectInfo(String projectInfo) {
        this.mProjectInfo = projectInfo;
    }

    public String getConcurrencyMode() {
        return this.mConcurrencyMode;
    }

    public void setConcurrencyMode(String mConcurrencyMode) {
        this.mConcurrencyMode = mConcurrencyMode;
    }

    public String getEndpointPoolMaxSize() {
        return this.mEndpointPoolMaxSize;
    }

    public void setEndpointPoolMaxSize(String mEndpointPoolMaxSize) {
        this.mEndpointPoolMaxSize = mEndpointPoolMaxSize;
    }

    public String getFactoryName() {
        return this.mFactoryName;
    }

    public void setFactoryName(String mFactoryName) {
        this.mFactoryName = mFactoryName;
    }
}

