/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.ra.core;

import com.tongtech.jms.ra.core.DeliveryStats;
import com.tongtech.jms.ra.core.RAJMSActivationSpec;
import com.tongtech.jms.ra.core.Unwrappable;
import com.tongtech.jms.ra.core.WMessageIn;
import com.tongtech.jms.ra.localization.LocalizedString;
import com.tongtech.jms.ra.localization.Localizer;
import com.tongtech.jms.ra.util.Exc;
import com.tongtech.jms.ra.util.Logger;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.Topic;

public abstract class RedeliveryHandler {
    private static Logger sLog = Logger.getLogger(RedeliveryHandler.class);
    private DeliveryStats mStats;
    private int mLookbackSize;
    private HashMap mOldMsgs;
    private HashMap mNewMsgs;
    private boolean mLoggedOnce;
    private final ActionInstruction[] mImmutableActions;
    private final ExecutableAction[] mExecutables;
    private String mActionStr;
    private RAJMSActivationSpec mActivationSpec;
    private static final Localizer LOCALE = Localizer.get();

    public static boolean checkValid(String actions) {
        try {
            RedeliveryHandler.parse(actions, "nothing", Queue.class.getName());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected abstract void move(Message var1, Encounter var2, boolean var3, String var4, BaseCookie var5) throws Exception;

    protected abstract void stopConnector(String var1);

    public static ActionInstruction[] parse(String s, String destName, String destType) throws JMSException {
        if (s.trim().length() == 0) {
            return new ActionInstruction[]{new VoidAction()};
        }
        String[] actions = s.split("\\s*;\\s*");
        ActionInstruction[] ret = new ActionInstruction[actions.length];
        int lastAt = 0;
        for (int i = 0; i < actions.length; ++i) {
            if (sLog.isDebugEnabled()) {
                sLog.debug("Now parsing [" + actions[i] + "]");
            }
            try {
                String at;
                boolean last = i == actions.length - 1;
                Matcher m = Delay.sPattern.matcher(actions[i]);
                if (m.matches()) {
                    at = m.group(1);
                    String delay = m.group(2);
                    long delayl = Long.parseLong(delay);
                    ret[i] = delayl <= 5000L || delayl == Integer.MAX_VALUE ? new Delay(Integer.parseInt(at), delayl) : new LongDelay(Integer.parseInt(at), delayl);
                    lastAt = ret[i].checkLast(lastAt);
                    if (sLog.isDebugEnabled()) {
                        sLog.debug(ret[i]);
                    }
                    continue;
                }
                m = Delete.sPattern.matcher(actions[i]);
                if (m.matches()) {
                    at = m.group(1);
                    if (!last) {
                        throw Exc.jmsExc(LOCALE.x("E105: Delete command should be last command"));
                    }
                    ret[i] = new Delete(Integer.parseInt(at));
                    lastAt = ret[i].checkLast(lastAt);
                    if (sLog.isDebugEnabled()) {
                        sLog.debug(ret[i]);
                    }
                    continue;
                }
                m = Move.sPattern.matcher(actions[i]);
                if (m.matches()) {
                    at = m.group(1);
                    String guts = m.group(2);
                    Matcher g = Move.sArgPattern.matcher(guts);
                    if (!g.matches()) {
                        throw Exc.jmsExc(LOCALE.x("E104: Wrong arguments: should match {0}", Move.ARGPATTERN));
                    }
                    String type = g.group(1);
                    String name = g.group(2);
                    if (!last) {
                        throw Exc.jmsExc(LOCALE.x("E103: Move command should be last command"));
                    }
                    if (name.indexOf(36) >= 0) {
                        if (!destName.startsWith("lookup://")) {
                            name = name.replaceAll("\\$", destName);
                        } else {
                            String preDestName = destName.substring(0, destName.lastIndexOf("/") + 1);
                            String postDestName = destName.substring(preDestName.length());
                            name = preDestName + name.replaceAll("\\$", postDestName);
                        }
                    }
                    ret[i] = new Move(Integer.parseInt(at), type, name, destType);
                    lastAt = ret[i].checkLast(lastAt);
                    if (sLog.isDebugEnabled()) {
                        sLog.debug(ret[i]);
                    }
                    continue;
                }
                throw Exc.jmsExc(LOCALE.x("E102: Token not recognized: {0}", actions[i]));
            }
            catch (Exception e) {
                throw Exc.jmsExc(LOCALE.x("E101: Could not parse [{0}]: error [{1}] in element number {2}: [{3}]", s, e, Integer.toString(i), actions[i]), e);
            }
        }
        return ret;
    }

    public RedeliveryHandler(RAJMSActivationSpec spec, DeliveryStats stats, int lookbackSize) {
        this.mStats = stats;
        this.mLookbackSize = lookbackSize;
        this.mActivationSpec = spec;
        this.mOldMsgs = new HashMap();
        this.mNewMsgs = new HashMap(this.mLookbackSize);
        ActionInstruction[] actions = new ActionInstruction[]{};
        try {
            actions = RedeliveryHandler.parse(spec.getRedeliveryHandling(), spec.getDestination(), spec.getDestinationType());
        }
        catch (Exception e) {
            sLog.warn(LOCALE.x("E050: Unexpected exception parsing of redelivery actions: {0}", e), e);
        }
        this.mImmutableActions = RedeliveryHandler.sanitizeActions(actions);
        this.mActionStr = spec.getRedeliveryHandling();
        ExecutableAction[] execuables = new ExecutableAction[this.mImmutableActions.length];
        boolean areThereMutableActions = false;
        for (int i = 0; i < execuables.length; ++i) {
            execuables[i] = this.mImmutableActions[i].getInstance();
            if (execuables[i] == this.mImmutableActions[i]) continue;
            areThereMutableActions = true;
            break;
        }
        this.mExecutables = areThereMutableActions ? null : execuables;
    }

    private static ActionInstruction[] sanitizeActions(ActionInstruction[] actions) {
        ActionInstruction[] ret;
        if (actions.length == 0) {
            ret = new ActionInstruction[]{new VoidAction()};
        } else if (actions[0].getAt() != 1) {
            ret = new ActionInstruction[actions.length + 1];
            ret[0] = new VoidAction();
            for (int i = 0; i < actions.length; ++i) {
                ret[i + 1] = actions[i];
            }
        } else {
            ret = actions;
        }
        return ret;
    }

    private void setActions(String redeliveryString, Encounter enc) throws JMSException {
        ActionInstruction[] a = RedeliveryHandler.parse(redeliveryString, this.mActivationSpec.getDestination(), this.mActivationSpec.getDestinationType());
        a = RedeliveryHandler.sanitizeActions(a);
        int ienc = enc.getNEncountered();
        int newcursor = 0;
        int cursor = 0;
        while (cursor < a.length && a[cursor].getAt() <= ienc) {
            newcursor = cursor++;
        }
        ExecutableAction[] execs = new ExecutableAction[a.length];
        for (int i = 0; i < execs.length; ++i) {
            execs[i] = a[i].getInstance();
        }
        enc.setNewActions(execs, redeliveryString, newcursor);
    }

    public boolean shouldDeliver(BaseCookie cookie, Message m) {
        String msgid;
        WMessageIn wmsg = null;
        if (m instanceof WMessageIn) {
            wmsg = (WMessageIn)m;
        }
        try {
            if (!m.getJMSRedelivered()) {
                if (wmsg != null) {
                    wmsg.setRedeliveryState(new LazyRedeliveryState(wmsg.getDelegate()));
                }
                return true;
            }
            msgid = m.getJMSMessageID();
            if (msgid == null) {
                if (!this.mLoggedOnce) {
                    this.mLoggedOnce = true;
                    sLog.warn(LOCALE.x("E051: Message could not be checked for redelivery: msg id is null. For subsequent similar cases, this warning will not be logged."));
                }
                return true;
            }
        }
        catch (JMSException e) {
            if (!this.mLoggedOnce) {
                this.mLoggedOnce = true;
                sLog.warn(LOCALE.x("E052: Message could not be checked for redelivery: {0}; for subsequent similar cases, this warning will not be logged.", (Object)e), e);
            }
            return true;
        }
        Encounter enc = this.getEncounter(msgid, true);
        if (wmsg != null) {
            wmsg.setRedeliveryState(new ActiveRedeliveryState(enc));
        }
        if (m instanceof Unwrappable) {
            m = (Message)((Unwrappable)m).getWrappedObject();
        }
        return this.shouldDeliver(cookie, enc, m);
    }

    public void rememberException(Exception e, Message m) {
        String msgid = null;
        try {
            msgid = m.getJMSMessageID();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        if (msgid != null) {
            Encounter enc = this.getEncounter(msgid, false);
            enc.getStatefulRedeliveryProperties().put("JMS_Sun_JMSJCA_ExceptionMessage", e.getMessage());
            enc.getStatefulRedeliveryProperties().put("JMS_Sun_JMSJCA_ExceptionClass", e.getClass().getName());
            enc.getStatefulRedeliveryProperties().put("JMS_Sun_JMSJCA_ExceptionStackTrace", Exc.getStackTrace(e));
        }
    }

    private synchronized Encounter getEncounter(String msgid, boolean redelivered) {
        Encounter enc;
        if (redelivered) {
            this.mStats.msgRedelivered();
        }
        if ((enc = (Encounter)this.mNewMsgs.get(msgid)) == null) {
            enc = (Encounter)this.mOldMsgs.get(msgid);
            if (enc == null) {
                ExecutableAction[] actions = this.mExecutables;
                if (this.mExecutables == null) {
                    actions = new ExecutableAction[this.mImmutableActions.length];
                    for (int i = 0; i < this.mImmutableActions.length; ++i) {
                        actions[i] = this.mImmutableActions[i].getInstance();
                    }
                }
                enc = new Encounter(msgid, actions, this.mActionStr);
                if (redelivered) {
                    this.mStats.msgRedeliveredFirstTime();
                }
            }
            this.mNewMsgs.put(msgid, enc);
            if (this.mNewMsgs.size() > this.mLookbackSize) {
                this.mOldMsgs = this.mNewMsgs;
                this.mNewMsgs = new HashMap(this.mLookbackSize);
            }
        }
        return enc;
    }

    private boolean shouldDeliver(BaseCookie cookie, Encounter enc, Message m) {
        int cursor = enc.getActionCursor();
        ExecutableAction action = enc.mEncActions[cursor];
        if (!action.shouldExecuteAgain() || enc.mEncActionsHaveChanged) {
            ExecutableAction next;
            enc.encounteredAgain();
            int ienc = enc.getNEncountered();
            enc.mEncActionsHaveChanged = false;
            if (cursor < enc.mEncActions.length - 1 && (next = enc.mEncActions[cursor + 1]).getInstruction().getAt() == ienc) {
                enc.setActionCursor(cursor + 1);
                action = next;
            }
        }
        try {
            return action.shouldDeliver(this, m, enc, cookie);
        }
        catch (Exception e) {
            sLog.warn(LOCALE.x("E053: Message with msgid {0} was redelivered {1} times; the action [{2}] failed: {3}", enc.getMsgid(), Integer.toString(enc.getNEncountered()), action, e), e);
            return true;
        }
    }

    protected abstract void delayMessageDelivery(Message var1, Encounter var2, long var3, LocalizedString var5, BaseCookie var6);

    protected abstract void longDelayMessageDelivery(Message var1, Encounter var2, long var3, LocalizedString var5, BaseCookie var6);

    protected abstract void deleteMessage(Message var1, Encounter var2, BaseCookie var3);

    private class ActiveRedeliveryState
    implements WMessageIn.RedeliveryStateHandler {
        private Encounter mEncounter;

        public ActiveRedeliveryState(Encounter e) {
            this.mEncounter = e;
        }

        @Override
        public String getProperty(String key) {
            if ("JMS_Sun_JMSJCA_RedeliveryHandling".equals(key)) {
                return this.mEncounter.getEncActionString();
            }
            return (String)this.mEncounter.getStatefulRedeliveryProperties().get(key);
        }

        @Override
        public boolean setProperty(String key, String value) throws JMSException {
            if (key.startsWith("JMS_Sun_JMSJCA_UserRollbackData")) {
                this.mEncounter.getStatefulRedeliveryProperties().put(key, value);
                return true;
            }
            if (key.startsWith("JMS_Sun_JMSJCA_RedeliveryHandling")) {
                RedeliveryHandler.this.setActions(value, this.mEncounter);
                return true;
            }
            if (key.startsWith("JMS_Sun_JMSJCA_StopMessageDelivery")) {
                RedeliveryHandler.this.stopConnector(value);
                return true;
            }
            return false;
        }

        @Override
        public int getRedeliveryCount() {
            return this.mEncounter.getNEncountered();
        }
    }

    private class LazyRedeliveryState
    implements WMessageIn.RedeliveryStateHandler {
        private Message mMsg;
        private WMessageIn.RedeliveryStateHandler mRealHandler;

        public LazyRedeliveryState(Message m) {
            this.mMsg = m;
        }

        private void checkEncounter() throws JMSException {
            if (this.mRealHandler != null) {
                return;
            }
            String msgid = this.mMsg.getJMSMessageID();
            if (msgid == null) {
                throw Exc.jmsExc(LOCALE.x("E033: Cannot retain state for this message: the getJMSMessageID() method of this method returns null."));
            }
            this.mRealHandler = new ActiveRedeliveryState(RedeliveryHandler.this.getEncounter(msgid, false));
        }

        @Override
        public String getProperty(String key) throws JMSException {
            if ("JMS_Sun_JMSJCA_RedeliveryHandling".equals(key)) {
                return RedeliveryHandler.this.mActionStr;
            }
            if (this.mRealHandler == null) {
                return null;
            }
            return this.mRealHandler.getProperty(key);
        }

        @Override
        public boolean setProperty(String key, String value) throws JMSException {
            this.checkEncounter();
            return this.mRealHandler.setProperty(key, value);
        }

        @Override
        public int getRedeliveryCount() {
            return 0;
        }
    }

    public class Encounter {
        private int mNEncountered;
        private int mActionCursor;
        private String mMsgid;
        private Map mStatefulRedeliveryProperties;
        private ExecutableAction[] mEncActions;
        private String mEncActionString;
        private boolean mEncActionsHaveChanged;

        public Encounter(String msgid, ExecutableAction[] actions, String actionString) {
            this.mMsgid = msgid;
            this.mEncActions = actions;
            this.mEncActionString = actionString;
        }

        public final void encounteredAgain() {
            ++this.mNEncountered;
        }

        public final int getNEncountered() {
            return this.mNEncountered;
        }

        public final int getActionCursor() {
            return this.mActionCursor;
        }

        public final void setActionCursor(int actionCursor) {
            this.mActionCursor = actionCursor;
        }

        public String getMsgid() {
            return this.mMsgid;
        }

        public Map getStatefulRedeliveryProperties() {
            if (this.mStatefulRedeliveryProperties == null) {
                this.mStatefulRedeliveryProperties = new HashMap();
            }
            return this.mStatefulRedeliveryProperties;
        }

        public ExecutableAction[] getEncActions() {
            return this.mEncActions;
        }

        public String getEncActionString() {
            return this.mEncActionString;
        }

        public void setNewActions(ExecutableAction[] a, String s, int newcursor) {
            this.mEncActions = a;
            this.mEncActionsHaveChanged = true;
            this.mEncActionString = s;
            this.setActionCursor(newcursor);
        }
    }

    public static class Delete
    extends ActionInstruction
    implements ExecutableAction {
        public static final String PATTERN = "(\\d+):\\s?delete";
        public static Pattern sPattern = Pattern.compile("(\\d+):\\s?delete");

        public Delete(int at) throws Exception {
            super(at);
        }

        public String toString() {
            return "At " + this.getAt() + ": delete";
        }

        @Override
        public boolean shouldDeliver(RedeliveryHandler owner, Message m, Encounter e, BaseCookie cookie) throws Exception {
            owner.deleteMessage(m, e, cookie);
            return false;
        }

        @Override
        public ExecutableAction getInstance() {
            return this;
        }

        @Override
        public boolean shouldExecuteAgain() {
            return false;
        }

        @Override
        public ActionInstruction getInstruction() {
            return this;
        }
    }

    public static class Move
    extends ActionInstruction
    implements ExecutableAction {
        public static final String PATTERN = "(\\d+):\\s?move\\((.*)\\)";
        public static Pattern sPattern = Pattern.compile("(\\d+):\\s?move\\((.*)\\)");
        public static String ARGPATTERN = "(queue|same|topic)\\s?:\\s?(.+)";
        public static Pattern sArgPattern = Pattern.compile(ARGPATTERN);
        private final String mType;
        private final String mName;

        public Move(int at, String type, String name, String destinationType) throws Exception {
            super(at);
            this.mName = name;
            if (!Queue.class.getName().equals(destinationType) && !Topic.class.getName().equals(destinationType)) {
                throw Exc.exc(LOCALE.x("E110: Invalid destination type [{0}]", destinationType));
            }
            if ("same".equals(type)) {
                this.mType = destinationType;
            } else if ("queue".equals(type)) {
                this.mType = Queue.class.getName();
            } else if ("topic".equals(type)) {
                this.mType = Topic.class.getName();
            } else {
                throw Exc.exc(LOCALE.x("E108: Invalid type [{0}]", type));
            }
        }

        public String getDestinationType() {
            return this.mType;
        }

        public boolean isQueue() {
            return this.mType.equals(Queue.class.getName());
        }

        public boolean isTopic() {
            return this.mType.equals(Topic.class.getName());
        }

        public String getDestinationName() {
            return this.mName;
        }

        public String toString() {
            return "At " + this.getAt() + ": move to " + this.mType + " with name [" + this.mName + "]";
        }

        @Override
        public boolean shouldDeliver(RedeliveryHandler owner, Message m, Encounter e, BaseCookie cookie) throws Exception {
            owner.move(m, e, this.isTopic(), this.getDestinationName(), cookie);
            return false;
        }

        @Override
        public ExecutableAction getInstance() {
            return this;
        }

        @Override
        public ActionInstruction getInstruction() {
            return this;
        }

        @Override
        public boolean shouldExecuteAgain() {
            return false;
        }
    }

    public static class LongDelayExecutable
    implements ExecutableAction {
        private final LongDelay mInstruction;
        private long mLeftToSleep;
        private long mStartTime;
        private boolean mIsDone;

        public LongDelayExecutable(LongDelay instr) {
            this.mInstruction = instr;
        }

        @Override
        public ActionInstruction getInstruction() {
            return this.mInstruction;
        }

        @Override
        public boolean shouldDeliver(RedeliveryHandler owner, Message m, Encounter e, BaseCookie cookie) throws Exception {
            LocalizedString logmsg = null;
            if (this.mStartTime == 0L) {
                this.mStartTime = System.currentTimeMillis();
                this.mLeftToSleep = this.mInstruction.getHowLong();
                this.mIsDone = false;
                if (this.mInstruction.getHowLong() % 1000L == 0L) {
                    logmsg = LOCALE.x("E025: Message with msgid=[{0}] was seen {1} times. Message delivery will be delayed for {2} ms.", e.getMsgid(), Integer.toString(e.getNEncountered()), Long.toString(this.mInstruction.getHowLong()));
                }
            }
            long toSleep = Math.min(this.mLeftToSleep, 5000L);
            this.mLeftToSleep -= toSleep;
            long now = System.currentTimeMillis();
            long target = this.mStartTime + this.mInstruction.getHowLong();
            if (this.mLeftToSleep == 0L || now + toSleep > target) {
                if (now + toSleep > target) {
                    toSleep = Math.max(0L, target - now);
                }
                this.mStartTime = 0L;
                owner.delayMessageDelivery(m, e, toSleep, null, cookie);
                this.mIsDone = true;
                return true;
            }
            owner.longDelayMessageDelivery(m, e, toSleep, logmsg, cookie);
            return false;
        }

        @Override
        public boolean shouldExecuteAgain() {
            return !this.mIsDone;
        }

        public String toString() {
            return this.mInstruction + "; isdone=" + this.mIsDone + "; left=" + this.mLeftToSleep;
        }
    }

    public static class LongDelay
    extends ActionInstruction {
        private long mDelay;

        public LongDelay(int at, long delay) throws Exception {
            super(at);
            this.mDelay = delay;
        }

        public long getHowLong() {
            return this.mDelay;
        }

        public String toString() {
            return "At " + this.getAt() + ": long delay for " + this.mDelay + " ms";
        }

        @Override
        public ExecutableAction getInstance() {
            return new LongDelayExecutable(this);
        }
    }

    public static class Delay
    extends ActionInstruction
    implements ExecutableAction {
        public static final String PATTERN = "(\\d+):\\s?(\\d+)";
        public static Pattern sPattern = Pattern.compile("(\\d+):\\s?(\\d+)");
        private final long mDelay;
        private static final long MAX = 5000L;

        public Delay(int at, long delay) throws Exception {
            super(at);
            if (delay > 5000L && delay != Integer.MAX_VALUE) {
                throw Exc.exc(LOCALE.x("E109: Delay of [{0}] exceeds maximum of {1} ms", Long.toString(delay), Long.toString(5000L)));
            }
            this.mDelay = delay;
        }

        public long getHowLong() {
            return this.mDelay;
        }

        public String toString() {
            return "At " + this.getAt() + ": delay for " + this.mDelay + " ms";
        }

        @Override
        public boolean shouldDeliver(RedeliveryHandler owner, Message m, Encounter e, BaseCookie cookie) throws Exception {
            LocalizedString logmsg = null;
            if (this.mDelay % 1000L == 0L) {
                logmsg = LOCALE.x("E025: Message with msgid=[{0}] was seen {1} times. Message delivery will be delayed for {2} ms.", e.getMsgid(), Integer.toString(e.getNEncountered()), Long.toString(this.mDelay));
            }
            owner.delayMessageDelivery(m, e, this.mDelay, logmsg, cookie);
            return true;
        }

        @Override
        public ExecutableAction getInstance() {
            return this;
        }

        @Override
        public boolean shouldExecuteAgain() {
            return false;
        }

        @Override
        public ActionInstruction getInstruction() {
            return this;
        }
    }

    public static class VoidAction
    extends ActionInstruction
    implements ExecutableAction {
        public VoidAction() {
            super(1);
        }

        public String toString() {
            return "Void";
        }

        @Override
        public boolean shouldDeliver(RedeliveryHandler owner, Message m, Encounter e, BaseCookie cookie) throws Exception {
            return true;
        }

        @Override
        public ExecutableAction getInstance() {
            return this;
        }

        @Override
        public boolean shouldExecuteAgain() {
            return false;
        }

        @Override
        public ActionInstruction getInstruction() {
            return this;
        }
    }

    public static interface ExecutableAction {
        public boolean shouldDeliver(RedeliveryHandler var1, Message var2, Encounter var3, BaseCookie var4) throws Exception;

        public boolean shouldExecuteAgain();

        public ActionInstruction getInstruction();
    }

    public static abstract class ActionInstruction {
        private final int mAt;

        public ActionInstruction(int at) {
            if (at <= 0) {
                throw Exc.rtexc(LOCALE.x("E111: Index {0} should be > 0", Integer.toString(at)));
            }
            if (at > 50000000) {
                throw Exc.rtexc(LOCALE.x("E112: Index {0} should be < 50000000", Integer.toString(at)));
            }
            this.mAt = at;
        }

        public int getAt() {
            return this.mAt;
        }

        public int checkLast(int lastAt) throws Exception {
            if (lastAt == this.mAt) {
                throw Exc.exc(LOCALE.x("E107: Duplicate entry at: {0}", Integer.toString(lastAt)));
            }
            if (lastAt >= this.mAt) {
                throw Exc.exc(LOCALE.x("E106: Should be properly ordered: {0} >= {1}", Integer.toString(lastAt), Integer.toString(this.mAt)));
            }
            return this.mAt;
        }

        public abstract ExecutableAction getInstance();
    }

    public static class BaseCookie {
    }
}

