/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.ra.core;

import com.tongtech.jms.ra.core.Activation;
import com.tongtech.jms.ra.core.Delivery;
import com.tongtech.jms.ra.core.DeliveryStats;
import com.tongtech.jms.ra.core.PseudoXAResource;
import com.tongtech.jms.ra.core.RAJMSObjectFactory;
import com.tongtech.jms.ra.core.WorkContainer;
import com.tongtech.jms.ra.core.XConnectionRequestInfo;
import com.tongtech.jms.ra.localization.LocalizedString;
import com.tongtech.jms.ra.localization.Localizer;
import com.tongtech.jms.ra.util.Exc;
import com.tongtech.jms.ra.util.Logger;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TopicSession;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.transaction.xa.XAResource;

public class SerialDelivery
extends Delivery
implements MessageListener,
ExceptionListener {
    private static Logger sLog = Logger.getLogger(SerialDelivery.class);
    private static Logger sContextEnter = Logger.getLogger("com.stc.EnterContext");
    private static Logger sContextExit = Logger.getLogger("com.stc.ExitContext");
    private Connection mConnection;
    private Session mSession;
    private MessageEndpoint mEndpoint;
    private LocalizedString mContextName;
    private XAResource mXA;
    private RAJMSObjectFactory mObjFactory;
    private Delivery.ConnectionForMove mMessageMoveConnection;
    private Delivery.MDB mMDB;
    private Delivery.DeliveryResults mResult = new Delivery.DeliveryResults();
    private static final Localizer LOCALE = Localizer.get();

    public SerialDelivery(Activation a, DeliveryStats stats) throws Exception {
        super(a, stats);
    }

    @Override
    public void start() throws Exception {
        this.mObjFactory = this.mActivation.getObjectFactory();
        int domain = XConnectionRequestInfo.guessDomain(this.mActivation.isCMT() && !this.mActivation.isXAEmulated(), this.mActivation.isTopic());
        ConnectionFactory fact = this.mObjFactory.createConnectionFactory(domain, this.mActivation.getRA(), this.mActivation.getActivationSpec(), null, null);
        this.mConnection = this.mObjFactory.createConnection(fact, domain, this.mActivation.getActivationSpec(), this.mActivation.getRA(), this.mActivation.getUserName() == null ? this.mActivation.getRA().getUserName() : this.mActivation.getUserName(), this.mActivation.getPassword() == null ? this.mActivation.getRA().getClearTextPassword() : this.mActivation.getPassword());
        this.mObjFactory.setClientID(this.mConnection, this.mActivation.isTopic(), this.mActivation.getActivationSpec(), this.mActivation.getRA());
        this.mSession = this.mObjFactory.createSession(this.mConnection, this.mActivation.isCMT() && !this.mActivation.isXAEmulated(), this.mActivation.isTopic() ? TopicSession.class : QueueSession.class, this.mActivation.getRA(), this.mActivation.getActivationSpec(), true, 0);
        this.createDLQDest(this.mSession);
        Destination dest = this.mObjFactory.createDestination(this.mSession, this.mActivation.isCMT() && !this.mActivation.isXAEmulated(), this.mActivation.isTopic(), this.mActivation.getActivationSpec(), null, this.mActivation.getRA(), this.mActivation.getActivationSpec().getDestination());
        MessageConsumer cons = this.mObjFactory.createMessageConsumer(this.mSession, this.mActivation.isCMT() && !this.mActivation.isXAEmulated(), this.mActivation.isTopic(), dest, this.mActivation.getActivationSpec(), this.mActivation.getRA());
        cons.setMessageListener(this.mActivation.getObjectFactory().getMessagePreprocessor(this, this.mActivation.isCMT() && !this.mActivation.isXAEmulated()));
        if (this.mActivation.isCMT()) {
            this.mXA = this.mActivation.isXAEmulated() ? new PseudoXAResource(this.mSession) : this.mActivation.getObjectFactory().getXAResource(true, this.mSession);
        }
        this.mMDB = new Delivery.MDB(this, this.mXA);
        this.mContextName = LocalizedString.valueOf(this.getActivation().getActivationSpec().getContextName());
        this.mConnection.setExceptionListener((ExceptionListener)this);
        this.mMessageMoveConnection = this.createConnectionForMove();
        this.mConnection.start();
    }

    @Override
    public void deactivate() {
        if (sLog.isDebugEnabled()) {
            sLog.debug("SerialDelivery.deactivate() -- begin");
        }
        try {
            if (this.mConnection != null) {
                this.mConnection.stop();
            }
        }
        catch (Exception ex) {
            sLog.warn(LOCALE.x("E054: Unexpected exception stopping JMS connection: {0}.", ex), ex);
        }
        if (this.mEndpoint != null) {
            this.release(this.mEndpoint);
            this.mEndpoint = null;
        }
        try {
            if (this.mSession != null) {
                this.mSession.close();
            }
        }
        catch (Exception ex) {
            sLog.warn(LOCALE.x("E087: Error while closing session: {0}", ex), ex);
        }
        try {
            if (this.mConnection != null) {
                this.mConnection.close();
            }
        }
        catch (Exception ex) {
            sLog.warn(LOCALE.x("E055: Unexpected exception closing JMS connection: {0}", ex), ex);
        }
        if (this.mMessageMoveConnection != null) {
            this.mMessageMoveConnection.destroy();
        }
        if (sLog.isDebugEnabled()) {
            sLog.debug("SerialDelivery.deactivate() -- complete");
        }
    }

    public void onException(JMSException ex) {
        this.mActivation.distress((Exception)((Object)ex));
    }

    public void workDone(WorkContainer w) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message m) {
        try {
            if (this.mContextName != null) {
                sContextEnter.info(this.mContextName);
            }
            if (sLog.isDebugEnabled()) {
                sLog.debug("Delivering message to endpoint");
            }
            if (this.mEndpoint == null) {
                try {
                    this.mEndpoint = this.createMessageEndpoint(this.mXA, this.mSession);
                    if (this.mEndpoint == null) {
                        throw Exc.exc(LOCALE.x("E143: No endpoint was created, possibly because the RA may be shutting down"));
                    }
                }
                catch (Exception ex1) {
                    LocalizedString msg = LOCALE.x("E056: Failure to create an endpoint to deliver message to; delivery attempt aborted. Exception: {0}", ex1);
                    sLog.warn(msg, ex1);
                    throw Exc.rtexc(msg, ex1);
                }
            }
            this.mResult.reset();
            try {
                this.beforeDelivery(this.mResult, this.mEndpoint, true);
                this.deliverToEndpoint(this.mResult, this.mMessageMoveConnection, this.mEndpoint, m, true);
                this.afterDelivery(this.mResult, this.mMessageMoveConnection, this.mEndpoint, this.mMDB, true);
                this.afterDeliveryNoXA(this.mResult, this.mSession, this.mMessageMoveConnection, this.mEndpoint);
            }
            catch (Exception e) {
                this.mActivation.distress(e);
                throw Exc.rtexc(LOCALE.x("E196: An unexpected exception happened in the receiving or processing of a message. The exception will be propagated to the JMS Client Runtime to ensure that the message delivery will be rolled back. The exception was: {0}", e), e);
            }
            finally {
                if (this.mResult.getShouldDiscardEndpoint()) {
                    this.release(this.mEndpoint);
                    this.mEndpoint = null;
                }
            }
        }
        finally {
            if (this.mContextName != null) {
                sContextExit.info(this.mContextName);
            }
        }
    }

    @Override
    public int getConfiguredEndpoints() {
        return 1;
    }
}

