/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.ra.core;

import com.tongtech.jms.ra.core.JProducer;
import com.tongtech.jms.ra.core.Unwrappable;
import com.tongtech.jms.ra.localization.Localizer;
import com.tongtech.jms.ra.util.Exc;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;

public class WMessageProducer
implements MessageProducer {
    protected JProducer mMgr;
    private MessageProducer mDelegate;
    private static final Localizer LOCALE = Localizer.get();

    public WMessageProducer(JProducer mgr, MessageProducer delegate) {
        this.mMgr = mgr;
        this.mDelegate = delegate;
    }

    public void invokeOnClosed() throws IllegalStateException {
        throw Exc.illstate(LOCALE.x("E153: This {0} is closed", "MessageProducer"));
    }

    public void setClosed() {
        this.mMgr = null;
        this.mDelegate = null;
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        if (this.mMgr == null) {
            this.invokeOnClosed();
        }
        try {
            this.mDelegate.setDisableMessageID(value);
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public boolean getDisableMessageID() throws JMSException {
        if (this.mMgr == null) {
            this.invokeOnClosed();
        }
        try {
            return this.mDelegate.getDisableMessageID();
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        if (this.mMgr == null) {
            this.invokeOnClosed();
        }
        try {
            this.mDelegate.setDisableMessageTimestamp(value);
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        if (this.mMgr == null) {
            this.invokeOnClosed();
        }
        try {
            return this.mDelegate.getDisableMessageTimestamp();
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        if (this.mMgr == null) {
            this.invokeOnClosed();
        }
        try {
            this.mDelegate.setDeliveryMode(deliveryMode);
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public int getDeliveryMode() throws JMSException {
        if (this.mMgr == null) {
            this.invokeOnClosed();
        }
        try {
            return this.mDelegate.getDeliveryMode();
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public void setPriority(int defaultPriority) throws JMSException {
        if (this.mMgr == null) {
            this.invokeOnClosed();
        }
        try {
            this.mDelegate.setPriority(defaultPriority);
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public int getPriority() throws JMSException {
        if (this.mMgr == null) {
            this.invokeOnClosed();
        }
        try {
            return this.mDelegate.getPriority();
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        if (this.mMgr == null) {
            this.invokeOnClosed();
        }
        try {
            this.mDelegate.setTimeToLive(timeToLive);
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public long getTimeToLive() throws JMSException {
        if (this.mMgr == null) {
            this.invokeOnClosed();
        }
        try {
            return this.mDelegate.getTimeToLive();
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public Destination getDestination() throws JMSException {
        if (this.mMgr == null) {
            this.invokeOnClosed();
        }
        try {
            Destination ret = this.mDelegate.getDestination();
            ret = this.mMgr.getSession().wrap(ret, this.mMgr.getConnection());
            return ret;
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public void send(Message message) throws JMSException {
        if (this.mMgr == null) {
            this.invokeOnClosed();
        }
        try {
            if (message instanceof Unwrappable) {
                message = (Message)((Unwrappable)message).getWrappedObject();
            }
            this.mDelegate.send(message);
            this.mMgr.onSend();
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (this.mMgr == null) {
            this.invokeOnClosed();
        }
        try {
            if (message instanceof Unwrappable) {
                message = (Message)((Unwrappable)message).getWrappedObject();
            }
            this.mDelegate.send(message, deliveryMode, priority, timeToLive);
            this.mMgr.onSend();
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public void send(Destination destination, Message message) throws JMSException {
        if (this.mMgr == null) {
            this.invokeOnClosed();
        }
        if (destination instanceof Unwrappable) {
            destination = (Destination)((Unwrappable)destination).getWrappedObject();
        }
        if (message instanceof Unwrappable) {
            message = (Message)((Unwrappable)message).getWrappedObject();
        }
        try {
            this.mDelegate.send(destination, message);
            this.mMgr.onSend();
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (this.mMgr == null) {
            this.invokeOnClosed();
        }
        if (destination instanceof Unwrappable) {
            destination = (Destination)((Unwrappable)destination).getWrappedObject();
        }
        if (message instanceof Unwrappable) {
            message = (Message)((Unwrappable)message).getWrappedObject();
        }
        try {
            this.mDelegate.send(destination, message, deliveryMode, priority, timeToLive);
            this.mMgr.onSend();
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public void close() throws JMSException {
        if (this.mMgr != null) {
            this.mMgr.close();
            this.mMgr = null;
            this.mDelegate = null;
        }
    }
}

