/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.ra.core;

import com.tongtech.jms.ra.core.AdminDestination;
import com.tongtech.jms.ra.core.AdminQueue;
import com.tongtech.jms.ra.core.JProducer;
import com.tongtech.jms.ra.core.Unwrappable;
import com.tongtech.jms.ra.core.WMessageProducer;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueSender;

public class WQueueSender
extends WMessageProducer
implements QueueSender {
    private QueueSender mDelegate;

    public WQueueSender(JProducer mgr, QueueSender delegate) {
        super(mgr, (MessageProducer)delegate);
        this.mDelegate = delegate;
    }

    @Override
    public void close() throws JMSException {
        super.close();
        this.mDelegate = null;
    }

    public Queue getQueue() throws JMSException {
        if (this.mMgr == null) {
            this.invokeOnClosed();
        }
        try {
            Queue ret = this.mDelegate.getQueue();
            ret = (Queue)this.mMgr.getSession().wrap((Destination)ret, this.mMgr.getConnection());
            return ret;
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public void send(Queue queue, Message message) throws JMSException {
        if (this.mMgr == null) {
            this.invokeOnClosed();
        }
        if ((queue = (Queue)this.mMgr.getSession().checkGeneric((Destination)queue)) instanceof AdminQueue) {
            queue = (Queue)this.mMgr.getSession().createDestination((AdminDestination)queue);
        }
        if (queue instanceof Unwrappable) {
            queue = (Queue)((Unwrappable)queue).getWrappedObject();
        }
        if (message instanceof Unwrappable) {
            message = (Message)((Unwrappable)message).getWrappedObject();
        }
        try {
            this.mDelegate.send(queue, message);
            this.mMgr.onSend();
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public void send(Queue queue, Message message, int int2, int int3, long long4) throws JMSException {
        if (this.mMgr == null) {
            this.invokeOnClosed();
        }
        if ((queue = (Queue)this.mMgr.getSession().checkGeneric((Destination)queue)) instanceof AdminQueue) {
            queue = (Queue)this.mMgr.getSession().createDestination((AdminDestination)queue);
        }
        if (queue instanceof Unwrappable) {
            queue = (Queue)((Unwrappable)queue).getWrappedObject();
        }
        if (message instanceof Unwrappable) {
            message = (Message)((Unwrappable)message).getWrappedObject();
        }
        try {
            this.mDelegate.send(queue, message, int2, int3, long4);
            this.mMgr.onSend();
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }
}

