/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.ra.core;

import com.tongtech.jms.ra.core.AdminDestination;
import com.tongtech.jms.ra.core.AdminQueue;
import com.tongtech.jms.ra.core.AdminTopic;
import com.tongtech.jms.ra.core.IWSession;
import com.tongtech.jms.ra.core.JConnection;
import com.tongtech.jms.ra.core.JSession;
import com.tongtech.jms.ra.core.LimitationJConnection;
import com.tongtech.jms.ra.core.Unwrappable;
import com.tongtech.jms.ra.core.WBytesMessageOut;
import com.tongtech.jms.ra.core.WMapMessageOut;
import com.tongtech.jms.ra.core.WMessageOut;
import com.tongtech.jms.ra.core.WObjectMessageOut;
import com.tongtech.jms.ra.core.WStreamMessageOut;
import com.tongtech.jms.ra.core.WTemporaryQueue;
import com.tongtech.jms.ra.core.WTemporaryTopic;
import com.tongtech.jms.ra.core.WTextMessageOut;
import com.tongtech.jms.ra.localization.Localizer;
import com.tongtech.jms.ra.util.Exc;
import com.tongtech.jms.ra.util.Logger;
import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;

public class WSession
implements IWSession {
    private static final Localizer LOCALE = Localizer.get();
    private static Logger sLog = Logger.getLogger(WSession.class);
    protected JSession mMgr;
    private JSession mOwner;
    private JConnection mCon;

    public WSession(JSession mgr) {
        this.mMgr = mgr;
        this.mOwner = mgr;
    }

    public JSession getJSession() {
        return this.mOwner;
    }

    public void setJSession(JSession j) {
        this.mOwner = j;
        this.mMgr = j;
    }

    public void setConnection(JConnection c) {
        this.mCon = c;
    }

    public JConnection getConnection() {
        return this.mCon;
    }

    public void checkTemporaryDestinationOwnership(Destination dest) throws JMSException {
        LimitationJConnection limited;
        if (dest instanceof LimitationJConnection && (limited = (LimitationJConnection)dest).getConnection() != this.getConnection()) {
            throw Exc.jmsExc(LOCALE.x("E154: Temporary destination can only be used in the same connection"));
        }
    }

    public void invokeOnClosed() throws IllegalStateException {
        throw Exc.illstate(LOCALE.x("E153: This {0} is closed", "Session"));
    }

    public void setClosed() {
        this.mMgr = null;
    }

    protected void checkClosed() throws IllegalStateException {
        if (this.mMgr == null) {
            this.invokeOnClosed();
        }
    }

    public BytesMessage createBytesMessage() throws JMSException {
        this.checkClosed();
        try {
            return new WBytesMessageOut(((Session)this.mMgr.getDelegate()).createBytesMessage());
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public MapMessage createMapMessage() throws JMSException {
        this.checkClosed();
        try {
            return new WMapMessageOut(((Session)this.mMgr.getDelegate()).createMapMessage());
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public Message createMessage() throws JMSException {
        this.checkClosed();
        try {
            return new WMessageOut(((Session)this.mMgr.getDelegate()).createMessage());
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        this.checkClosed();
        try {
            return new WObjectMessageOut(((Session)this.mMgr.getDelegate()).createObjectMessage());
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public ObjectMessage createObjectMessage(Serializable serializable) throws JMSException {
        this.checkClosed();
        try {
            return new WObjectMessageOut(((Session)this.mMgr.getDelegate()).createObjectMessage(serializable));
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public StreamMessage createStreamMessage() throws JMSException {
        this.checkClosed();
        try {
            return new WStreamMessageOut(((Session)this.mMgr.getDelegate()).createStreamMessage());
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public TextMessage createTextMessage() throws JMSException {
        this.checkClosed();
        try {
            return new WTextMessageOut(((Session)this.mMgr.getDelegate()).createTextMessage());
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public TextMessage createTextMessage(String string) throws JMSException {
        this.checkClosed();
        try {
            return new WTextMessageOut(((Session)this.mMgr.getDelegate()).createTextMessage(string));
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public boolean getTransacted() throws JMSException {
        this.checkClosed();
        try {
            return ((Session)this.mMgr.getDelegate()).getTransacted();
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public int getAcknowledgeMode() throws JMSException {
        this.checkClosed();
        try {
            return this.mMgr.getAcknowledgeMode();
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public void commit() throws JMSException {
        this.checkClosed();
        try {
            this.mMgr.commit(this);
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public void rollback() throws JMSException {
        this.checkClosed();
        try {
            this.mMgr.rollback(this);
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public void close() throws JMSException {
        Exception closeException = null;
        if (sLog.isDebugEnabled()) {
            sLog.debug("WSession.close...");
        }
        if (this.mMgr != null) {
            if (sLog.isDebugEnabled()) {
                sLog.debug("mMgr.close...");
            }
            try {
                this.mMgr.close(this);
            }
            catch (Exception e) {
                closeException = e;
            }
            this.mMgr = null;
        }
        this.mCon.notifyWSessionClosedByApplication(this);
        if (closeException != null) {
            throw Exc.jmsExc(LOCALE.x("E094: This {0} could not be closed properly: {1}", Session.class.getName(), closeException), closeException);
        }
    }

    public void recover() throws JMSException {
        this.checkClosed();
        try {
            this.mMgr.recover();
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public MessageListener getMessageListener() throws JMSException {
        this.checkClosed();
        try {
            return ((Session)this.mMgr.getDelegate()).getMessageListener();
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        this.checkClosed();
        try {
            ((Session)this.mMgr.getDelegate()).setMessageListener(messageListener);
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public void run() {
        if (this.mMgr == null) {
            throw Exc.rtexc(LOCALE.x("E160: Illegal call: run() is not supported"));
        }
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        this.checkClosed();
        destination = this.mMgr.checkGeneric(destination);
        if (destination instanceof AdminDestination) {
            destination = this.mMgr.createDestination((AdminDestination)destination);
        }
        if (destination instanceof Unwrappable) {
            destination = (Destination)((Unwrappable)destination).getWrappedObject();
        }
        try {
            return this.mMgr.createProducer(destination, this.mCon);
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        this.checkClosed();
        this.checkTemporaryDestinationOwnership(destination);
        destination = this.mMgr.checkGeneric(destination);
        if (destination instanceof AdminDestination) {
            destination = this.mMgr.createDestination((AdminDestination)destination);
        }
        if (destination instanceof Unwrappable) {
            destination = (Destination)((Unwrappable)destination).getWrappedObject();
        }
        try {
            return this.mMgr.createConsumer(destination, this.getConnection());
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public MessageConsumer createConsumer(Destination destination, String string) throws JMSException {
        this.checkClosed();
        this.checkTemporaryDestinationOwnership(destination);
        destination = this.mMgr.checkGeneric(destination);
        if (destination instanceof AdminDestination) {
            destination = this.mMgr.createDestination((AdminDestination)destination);
        }
        if (destination instanceof Unwrappable) {
            destination = (Destination)((Unwrappable)destination).getWrappedObject();
        }
        try {
            return ((Session)this.mMgr.getDelegate()).createConsumer(destination, string);
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public MessageConsumer createConsumer(Destination destination, String string, boolean boolean2) throws JMSException {
        this.checkClosed();
        this.checkTemporaryDestinationOwnership(destination);
        destination = this.mMgr.checkGeneric(destination);
        if (destination instanceof AdminDestination) {
            destination = this.mMgr.createDestination((AdminDestination)destination);
        }
        if (destination instanceof Unwrappable) {
            destination = (Destination)((Unwrappable)destination).getWrappedObject();
        }
        try {
            return this.mMgr.createConsumer(destination, string, boolean2, this.getConnection());
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public Queue createQueue(String string) throws JMSException {
        this.checkClosed();
        try {
            return this.mMgr.createQueue(string);
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public Topic createTopic(String string) throws JMSException {
        this.checkClosed();
        try {
            return this.mMgr.createTopic(string);
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String string) throws JMSException {
        this.checkClosed();
        this.checkTemporaryDestinationOwnership((Destination)topic);
        if (topic instanceof AdminTopic) {
            topic = (Topic)this.mMgr.createDestination((AdminTopic)topic);
        }
        if (topic instanceof Unwrappable) {
            topic = (Topic)((Unwrappable)topic).getWrappedObject();
        }
        try {
            return this.mMgr.createDurableSubscriber(topic, string, this.getConnection());
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String string, String string2, boolean boolean3) throws JMSException {
        this.checkClosed();
        this.checkTemporaryDestinationOwnership((Destination)topic);
        if (topic instanceof AdminTopic) {
            topic = (Topic)this.mMgr.createDestination((AdminTopic)topic);
        }
        if (topic instanceof Unwrappable) {
            topic = (Topic)((Unwrappable)topic).getWrappedObject();
        }
        try {
            return this.mMgr.createDurableSubscriber(topic, string, string2, boolean3, this.getConnection());
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        this.checkClosed();
        if (queue instanceof AdminQueue) {
            queue = (Queue)this.mMgr.createDestination((AdminQueue)queue);
        }
        if (queue instanceof Unwrappable) {
            queue = (Queue)((Unwrappable)queue).getWrappedObject();
        }
        try {
            return ((Session)this.mMgr.getDelegate()).createBrowser(queue);
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public QueueBrowser createBrowser(Queue queue, String string) throws JMSException {
        this.checkClosed();
        if (queue instanceof AdminQueue) {
            queue = (Queue)this.mMgr.createDestination((AdminQueue)queue);
        }
        if (queue instanceof Unwrappable) {
            queue = (Queue)((Unwrappable)queue).getWrappedObject();
        }
        try {
            return ((Session)this.mMgr.getDelegate()).createBrowser(queue, string);
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        this.checkClosed();
        try {
            TemporaryQueue ret = ((Session)this.mMgr.getDelegate()).createTemporaryQueue();
            this.getConnection().addTemporaryDestination((Destination)ret);
            ret = new WTemporaryQueue(ret, this.getConnection());
            return ret;
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        this.checkClosed();
        try {
            TemporaryTopic ret = ((Session)this.mMgr.getDelegate()).createTemporaryTopic();
            this.getConnection().addTemporaryDestination((Destination)ret);
            ret = new WTemporaryTopic(ret, this.getConnection());
            return ret;
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public void unsubscribe(String string) throws JMSException {
        this.checkClosed();
        try {
            ((Session)this.mMgr.getDelegate()).unsubscribe(string);
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public WSession getReference() {
        return this;
    }
}

