/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.jms.ra.core;

import com.tongtech.jms.ra.core.AdminTopic;
import com.tongtech.jms.ra.core.JProducer;
import com.tongtech.jms.ra.core.Unwrappable;
import com.tongtech.jms.ra.core.WMessageProducer;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Topic;
import javax.jms.TopicPublisher;

public class WTopicPublisher
extends WMessageProducer
implements TopicPublisher {
    private TopicPublisher mDelegate;

    public WTopicPublisher(JProducer mgr, TopicPublisher delegate) {
        super(mgr, (MessageProducer)delegate);
        this.mDelegate = delegate;
    }

    @Override
    public void close() throws JMSException {
        super.close();
        this.mDelegate = null;
    }

    public Topic getTopic() throws JMSException {
        if (this.mMgr == null) {
            this.invokeOnClosed();
        }
        try {
            Topic ret = this.mDelegate.getTopic();
            ret = (Topic)this.mMgr.getSession().wrap((Destination)ret, this.mMgr.getConnection());
            return ret;
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public void publish(Message message) throws JMSException {
        if (this.mMgr == null) {
            this.invokeOnClosed();
        }
        try {
            if (message instanceof Unwrappable) {
                message = (Message)((Unwrappable)message).getWrappedObject();
            }
            this.mDelegate.publish(message);
            this.mMgr.onSend();
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public void publish(Message message, int int1, int int2, long long3) throws JMSException {
        if (this.mMgr == null) {
            this.invokeOnClosed();
            this.mMgr.onSend();
        }
        try {
            if (message instanceof Unwrappable) {
                message = (Message)((Unwrappable)message).getWrappedObject();
            }
            this.mDelegate.publish(message, int1, int2, long3);
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public void publish(Topic topic, Message message) throws JMSException {
        if (this.mMgr == null) {
            this.invokeOnClosed();
        }
        try {
            if (topic instanceof AdminTopic) {
                topic = (Topic)this.mMgr.getSession().createDestination((AdminTopic)topic);
            }
            if (topic instanceof Unwrappable) {
                topic = (Topic)((Unwrappable)topic).getWrappedObject();
            }
            if (message instanceof Unwrappable) {
                message = (Message)((Unwrappable)message).getWrappedObject();
            }
            this.mDelegate.publish(topic, message);
            this.mMgr.onSend();
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }

    public void publish(Topic topic, Message message, int int2, int int3, long long4) throws JMSException {
        if (this.mMgr == null) {
            this.invokeOnClosed();
        }
        if (topic instanceof AdminTopic) {
            topic = (Topic)this.mMgr.getSession().createDestination((AdminTopic)topic);
        }
        if (topic instanceof Unwrappable) {
            topic = (Topic)((Unwrappable)topic).getWrappedObject();
        }
        if (message instanceof Unwrappable) {
            message = (Message)((Unwrappable)message).getWrappedObject();
        }
        try {
            this.mDelegate.publish(topic, message, int2, int3, long4);
            this.mMgr.onSend();
        }
        catch (JMSException e) {
            this.mMgr.exceptionOccurred(e);
            throw e;
        }
    }
}

